/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ModIUtils;

public class ModIValidazioneSemanticaProfiloSicurezza {
    private Busta busta;
    private String securityMessageProfileNonFiltratoPDND;
    private boolean sicurezzaTokenOauth;
    private String securityMessageProfileSorgenteTokenIdAuth;
    private boolean sicurezzaMessaggio;
    private boolean sicurezzaMessaggioIDAR04 = false;
    private String securityMessageProfile;
    private boolean sicurezzaAudit;
    private String securityAuditPattern;

    public ModIValidazioneSemanticaProfiloSicurezza(Busta bustaParam, boolean isRichiesta) throws ProtocolException {
        this.busta = bustaParam;
        this.securityMessageProfileNonFiltratoPDND = this.busta.getProperty("ProfiloSicurezzaMessaggio");
        if (this.securityMessageProfileNonFiltratoPDND != null) {
            this.securityMessageProfileNonFiltratoPDND = ModIUtils.convertProfiloSicurezzaToConfigurationValue(this.securityMessageProfileNonFiltratoPDND);
        }
        this.securityMessageProfileSorgenteTokenIdAuth = this.busta.getProperty("GenerazioneTokenIDAuth");
        if (this.securityMessageProfileSorgenteTokenIdAuth != null) {
            this.securityMessageProfileSorgenteTokenIdAuth = ModIUtils.convertProfiloSicurezzaSorgenteTokenToConfigurationValue(this.securityMessageProfileSorgenteTokenIdAuth);
        }
        this.securityMessageProfile = this.securityMessageProfileNonFiltratoPDND;
        if (this.securityMessageProfileSorgenteTokenIdAuth != null && ("idam01".equals(this.securityMessageProfileNonFiltratoPDND) || "idam02".equals(this.securityMessageProfileNonFiltratoPDND)) && ("pdnd".equals(this.securityMessageProfileSorgenteTokenIdAuth) || "oauth".equals(this.securityMessageProfileSorgenteTokenIdAuth))) {
            this.securityMessageProfile = null;
        }
        this.sicurezzaTokenOauth = "pdnd".equals(this.securityMessageProfileSorgenteTokenIdAuth) || "oauth".equals(this.securityMessageProfileSorgenteTokenIdAuth);
        this.sicurezzaMessaggio = this.securityMessageProfile != null && !"-".equals(this.securityMessageProfile);
        this.sicurezzaMessaggioIDAR04 = false;
        if (this.sicurezzaMessaggio) {
            this.sicurezzaMessaggioIDAR04 = "idam0401".equals(this.securityMessageProfile) || "idam0402".equals(this.securityMessageProfile);
        }
        this.securityAuditPattern = this.busta.getProperty("ProfiloSicurezzaAudit");
        if (this.securityAuditPattern != null) {
            this.securityAuditPattern = ModIUtils.convertProfiloAuditToConfigurationValue(this.securityAuditPattern);
        }
        this.sicurezzaAudit = isRichiesta && this.securityAuditPattern != null && !"old".equals(this.securityAuditPattern);
    }

    public Busta getBusta() {
        return this.busta;
    }

    public String getSecurityMessageProfileNonFiltratoPDND() {
        return this.securityMessageProfileNonFiltratoPDND;
    }

    public boolean isSicurezzaTokenOauth() {
        return this.sicurezzaTokenOauth;
    }

    public String getSecurityMessageProfileSorgenteTokenIdAuth() {
        return this.securityMessageProfileSorgenteTokenIdAuth;
    }

    public boolean isSicurezzaMessaggio() {
        return this.sicurezzaMessaggio;
    }

    public boolean isSicurezzaMessaggioIDAR04() {
        return this.sicurezzaMessaggioIDAR04;
    }

    public String getSecurityMessageProfile() {
        return this.securityMessageProfile;
    }

    public boolean isSicurezzaAudit() {
        return this.sicurezzaAudit;
    }

    public String getSecurityAuditPattern() {
        return this.securityAuditPattern;
    }
}

