/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.CostantiLabel;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.EsitoTransazione;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiInstanceProperties;
import org.openspcoop2.protocol.utils.EsitoIdentificationMode;
import org.openspcoop2.protocol.utils.EsitoIdentificationModeContextProperty;
import org.openspcoop2.protocol.utils.EsitoIdentificationModeSoapFault;
import org.openspcoop2.protocol.utils.EsitoTransportContextIdentification;
import org.openspcoop2.protocol.utils.EsitoTransportContextIdentificationMode;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.resources.MapReader;
import org.slf4j.Logger;

public class EsitiProperties {
    private Logger log = null;
    private static Map<EsitiProperties> esitiPropertiesMap = null;
    private EsitiInstanceProperties reader;
    private boolean erroreProtocollo = false;
    private boolean envelopeErroreProtocollo = false;
    private String labelErroreProtocollo = null;
    private boolean faultEsterno = false;
    private String labelFaultEsterno = null;
    private String protocollo = null;
    protected static final MapKey<String> NO_PROTOCOL_CONFIG = CostantiLabel.NO_PROTOCOL_MAP_KEY;
    private Map<EsitoTransazione> mapEsitoTransazione = new Map();
    private List<Integer> esitiCodeSenzaFiltri = null;
    private List<Integer> esitiCode = null;
    private List<Integer> esitiCodeOk = null;
    private List<Integer> esitiCodeOk_senzaFaultApplicativo = null;
    private List<Integer> esitiCodeKo = null;
    private List<Integer> esitiCodeKo_senzaFaultApplicativo = null;
    private List<Integer> esitiCodeFaultApplicativo = null;
    private List<Integer> esitiCodeRichiestaScartate = null;
    private List<Integer> esitiCodeErroriConsegna = null;
    private List<Integer> esitiCodeAutorizzazioneNegata = null;
    private List<Integer> esitiCodeControlloTrafficoPolicyViolate = null;
    private List<Integer> esitiCodeServizioIntegrationManager = null;
    private List<Integer> esitiCodeErroriProcessamentoRichiesta = null;
    private List<Integer> esitiCodeErroriProcessamentoRisposta = null;
    private List<Integer> esitiCodeErroriClientNonDisponibile = null;
    private List<Integer> esitiCodeErroriGenerici = null;
    private List<Integer> esitiCodeForSoapFaultIdentificationMode = null;
    private List<Integer> esitiCodeForContextPropertyIdentificationMode = null;
    private List<Integer> esitiCodeOrderLabel = null;
    private List<String> esitiOrderLabel = null;
    private java.util.Map<String, String> esitoName = null;
    private java.util.Map<String, String> esitoDescription = null;
    private java.util.Map<String, String> esitoLabel = null;
    private java.util.Map<String, String> esitoLabelSyntetic = null;
    private java.util.Map<String, EsitoIdentificationMode> esitoIdentificationMode = null;
    private java.util.Map<String, List<EsitoIdentificationModeSoapFault>> esitoIdentificationModeSoapFaultList = null;
    private java.util.Map<String, List<EsitoIdentificationModeContextProperty>> esitoIdentificationModeContextPropertyList = null;
    private List<String> esitiTransactionContextCode = null;
    private Boolean isSingleTransactionContextCode = null;
    private List<String> esitiTransactionContextCodeOrderLabel = null;
    private List<String> esitiTransactionContextOrderLabel = null;
    private java.util.Map<String, String> esitoTransactionContextLabel = null;
    private String esitoTransactionContextDefault = null;
    private Boolean esitoTransactionContextDefault_read = null;
    private String esitoTransactionContextHeaderTrasportoName = null;
    private String esitoTransactionContextFormBasedPropertyName = null;
    private List<EsitoTransportContextIdentification> esitoTransactionContextHeaderTrasportoDynamicIdentification = null;
    private List<EsitoTransportContextIdentification> esitoTransactionContextHeaderFormBasedDynamicIdentification = null;

    public boolean isErroreProtocollo() {
        return this.erroreProtocollo;
    }

    public boolean isEnvelopeErroreProtocollo() {
        return this.envelopeErroreProtocollo;
    }

    public boolean isFaultEsterno() {
        return this.faultEsterno;
    }

    private EsitiProperties(String confDir, Logger log, IProtocolFactory<?> pf) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(EsitiProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = EsitiProperties.class.getResourceAsStream("/org/openspcoop2/protocol/utils/esiti.properties");
            if (properties == null) {
                throw new Exception("File '/org/openspcoop2/protocol/utils/esiti.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'org/openspcoop2/protocol/utils/esiti.properties': " + e.getMessage());
            throw new ProtocolException("EsitiProperties initialize error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.reader = new EsitiInstanceProperties(confDir, propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        if (pf == null) {
            this.erroreProtocollo = true;
            this.envelopeErroreProtocollo = true;
            this.faultEsterno = true;
        } else if (pf.getInformazioniProtocol() != null) {
            this.erroreProtocollo = pf.getInformazioniProtocol().isErrorProtocol();
            this.envelopeErroreProtocollo = pf.getInformazioniProtocol().isEnvelopeErrorProtocol();
            this.labelErroreProtocollo = pf.getInformazioniProtocol().getLabelErrorProtocol();
            this.faultEsterno = pf.getInformazioniProtocol().isExternalFault();
            this.labelFaultEsterno = pf.getInformazioniProtocol().getLabelExternalFault();
            this.protocollo = pf.getProtocol();
        }
    }

    public static synchronized void initialize(String confDir, Logger log, Loader loader, MapReader<String, IProtocolFactory<?>> protocols) throws ProtocolException {
        if (esitiPropertiesMap == null) {
            esitiPropertiesMap = new Map();
            EsitiProperties esitiProperties = new EsitiProperties(confDir, log, null);
            esitiProperties.validaConfigurazione(loader);
            esitiPropertiesMap.put(CostantiLabel.NO_PROTOCOL_MAP_KEY, (Object)esitiProperties);
            if (protocols == null) {
                return;
            }
            Enumeration enP = protocols.keys();
            while (enP.hasMoreElements()) {
                EsitoTransazioneName[] esiti;
                String protocol = (String)enP.nextElement();
                IProtocolFactory pf = (IProtocolFactory)protocols.get((Object)protocol);
                EsitiProperties esitiPropertiesByProtocol = new EsitiProperties(confDir, log, pf);
                esitiPropertiesByProtocol.initEsitiCodeSenzaFiltri();
                esitiPropertiesByProtocol.initEsitiCode();
                esitiPropertiesByProtocol.initEsitiCodeOk();
                esitiPropertiesByProtocol.initEsitiCodeOk_senzaFaultApplicativo();
                esitiPropertiesByProtocol.initEsitiCodeKo();
                esitiPropertiesByProtocol.initEsitiCodeKo_senzaFaultApplicativo();
                esitiPropertiesByProtocol.initEsitiCodeFaultApplicativo();
                esitiPropertiesByProtocol.initEsitiCodeRichiestaScartate();
                esitiPropertiesByProtocol.initEsitiCodeErroriConsegna();
                esitiPropertiesByProtocol.initEsitiCodeAutorizzazioneNegata();
                esitiPropertiesByProtocol.initEsitiCodeControlloTrafficoPolicyViolate();
                esitiPropertiesByProtocol.initEsitiCodeServizioIntegrationManager();
                esitiPropertiesByProtocol.initEsitiCodeErroriProcessamentoRichiesta();
                esitiPropertiesByProtocol.initEsitiCodeErroriProcessamentoRisposta();
                esitiPropertiesByProtocol.initEsitiCodeErroriClientNonDisponibile();
                esitiPropertiesByProtocol.initEsitiCodeErroriGenerici();
                esitiPropertiesByProtocol.initEsitiCodeForSoapFaultIdentificationMode();
                esitiPropertiesByProtocol.initEsitiCodeForContextPropertyIdentificationMode();
                esitiPropertiesByProtocol.initEsitiCodeOrderLabel();
                esitiPropertiesByProtocol.initEsitiOrderLabel();
                esitiPropertiesByProtocol.initEsitoName();
                esitiPropertiesByProtocol.initEsitoDescription();
                esitiPropertiesByProtocol.initEsitoLabel();
                esitiPropertiesByProtocol.initEsitoLabelSyntetic();
                esitiPropertiesByProtocol.initEsitoIdentificationMode();
                esitiPropertiesByProtocol.initEsitoIdentificationModeSoapFaultList();
                esitiPropertiesByProtocol.initEsitoIdentificationModeContextPropertyList();
                for (EsitoTransazioneName esitoTransazioneName : esiti = EsitoTransazioneName.values()) {
                    if (EsitoTransazioneName.ERRORE_PROTOCOLLO.equals(esitoTransazioneName) && !esitiPropertiesByProtocol.erroreProtocollo || EsitoTransazioneName.ERRORE_SERVER.equals(esitoTransazioneName) && !esitiPropertiesByProtocol.faultEsterno || EsitoTransazioneName.CUSTOM.equals(esitoTransazioneName)) continue;
                    int code = esitiPropertiesByProtocol.convertoToCode(esitoTransazioneName);
                    esitiPropertiesByProtocol.initMapEsitoTransazione(esitoTransazioneName, code, "standard");
                }
                esitiPropertiesByProtocol.initEsitiTransactionContextCode();
                esitiPropertiesByProtocol.initEsitiTransactionContextCodeOrderLabel();
                esitiPropertiesByProtocol.initEsitiTransactionContextOrderLabel();
                esitiPropertiesByProtocol.initEsitoTransactionContextLabel();
                esitiPropertiesByProtocol.initEsitoTransactionContextDefault();
                esitiPropertiesByProtocol.initEsitoTransactionContextHeaderTrasportoName();
                esitiPropertiesByProtocol.initEsitoTransactionContextFormBasedPropertyName();
                esitiPropertiesByProtocol.initEsitoTransactionContextHeaderTrasportoDynamicIdentification();
                esitiPropertiesByProtocol.initEsitoTransactionContextHeaderFormBasedDynamicIdentification();
                esitiPropertiesMap.put(ProtocolUtils.protocolToMapKey(protocol), (Object)esitiPropertiesByProtocol);
            }
        }
    }

    public static boolean isInitializedProtocol(MapKey<String> protocol) {
        return esitiPropertiesMap != null && esitiPropertiesMap.containsKey(protocol);
    }

    public static EsitiProperties getInstanceFromProtocolName(Logger log, String protocol) throws ProtocolException {
        return EsitiProperties.getInstance(log, ProtocolUtils.protocolToMapKey(protocol));
    }

    public static EsitiProperties getInstance(Logger log, IProtocolFactory<?> protocol) throws ProtocolException {
        return EsitiProperties.getInstance(log, protocol.getProtocolMapKey());
    }

    public static EsitiProperties getInstance(Logger log, MapKey<String> protocol) throws ProtocolException {
        if (esitiPropertiesMap == null) {
            throw new ProtocolException("EsitiProperties not initialized (use init method in factory)");
        }
        return (EsitiProperties)esitiPropertiesMap.get(protocol);
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            List<Integer> codes = this.getEsitiCode();
            this.getEsitiCodeOrderLabel();
            ArrayList<String> labelCheck = new ArrayList<String>();
            ArrayList<String> nameCheck = new ArrayList<String>();
            for (Integer n : codes) {
                String string = this.getEsitoName(n);
                if (nameCheck.contains(string)) {
                    throw new ProtocolException("Esito name [" + string + "] already defined");
                }
                nameCheck.add(string);
                this.getEsitoDescription(n);
                String esitoLabel = this.getEsitoLabel(n);
                if (labelCheck.contains(esitoLabel)) {
                    throw new ProtocolException("Esito label [" + esitoLabel + "] already defined");
                }
                labelCheck.add(esitoLabel);
                Object mode = this.getEsitoIdentificationMode(n);
                if (EsitoIdentificationMode.SOAP_FAULT.equals(mode)) {
                    this.getEsitoIdentificationModeSoapFaultList(n);
                    continue;
                }
                if (!EsitoIdentificationMode.CONTEXT_PROPERTY.equals(mode)) continue;
                this.getEsitoIdentificationModeContextPropertyList(n);
            }
            List<Integer> codesOk = this.getEsitiCodeOk();
            this.getEsitiCodeKo();
            for (Integer n : codesOk) {
                boolean found = false;
                for (Integer codeEsito : codes) {
                    if (n.intValue() != codeEsito.intValue()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ProtocolException("Code 'ok' [" + n + "] not defined in codes");
            }
            List<String> list = this.getEsitiTransactionContextCode();
            this.getEsitiTransactionContextCodeOrderLabel();
            labelCheck = new ArrayList();
            for (String tipo : list) {
                String tipoLabel = this.getEsitoTransactionContextLabel(tipo);
                if (labelCheck.contains(tipoLabel)) {
                    throw new ProtocolException("Transaction Context Label [" + tipoLabel + "] already defined");
                }
                labelCheck.add(tipoLabel);
            }
            EsitoTransazioneName[] esitoTransazioneNameArray = EsitoTransazioneName.values();
            for (int i = 0; i < esitoTransazioneNameArray.length; ++i) {
                if (EsitoTransazioneName.CUSTOM.equals(esitoTransazioneNameArray[i])) continue;
                this.convertoToCode(esitoTransazioneNameArray[i]);
            }
            if (!this.getEsitiTransactionContextCode().contains("standard")) {
                throw new ProtocolException("Required TipoContext [standard] undefined");
            }
            this.getEsitiOrderLabel();
            this.getEsitiTransactionContextOrderLabel();
            this.getEsitoTransactionContextDefault();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' degli esiti, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public EsitoTransazioneName getEsitoTransazioneName(Integer cod) throws ProtocolException {
        return EsitoTransazioneName.convertoTo(this.getEsitoName(cod));
    }

    public List<EsitoTransazione> getListEsitoTransazioneFromFilter(Integer codeParam, String tipoContextParam) throws ProtocolException {
        ArrayList<EsitoTransazione> list = new ArrayList<EsitoTransazione>();
        if (codeParam == null) {
            List<Integer> codes = this.getEsitiCode();
            for (Integer codeEsito : codes) {
                if (tipoContextParam == null) {
                    List<String> tipiContext = this.getEsitiTransactionContextCode();
                    for (String tipo : tipiContext) {
                        list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeEsito), codeEsito, tipo));
                    }
                    continue;
                }
                list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeEsito), codeEsito, tipoContextParam));
            }
        } else if (tipoContextParam == null) {
            List<String> tipiContext = this.getEsitiTransactionContextCode();
            for (String tipo : tipiContext) {
                list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeParam), codeParam, tipo));
            }
        } else {
            list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeParam), codeParam, tipoContextParam));
        }
        return list;
    }

    public EsitoTransazione convertToEsitoTransazione(Integer code, String tipoContext) throws ProtocolException {
        if (code == null) {
            throw new ProtocolException("Code [" + code + "] undefined");
        }
        if (!this.existsEsitoCode(code)) {
            throw new ProtocolException("Code [" + tipoContext + "] unsupported");
        }
        String name = this.getEsitoName(code);
        if (name == null) {
            throw new ProtocolException("Name for esito code [" + code + "] undefined");
        }
        EsitoTransazioneName nameEnum = EsitoTransazioneName.convertoTo(name);
        return this.convertToEsitoTransazione(nameEnum, code, tipoContext);
    }

    private synchronized void initMapEsitoTransazione(EsitoTransazioneName esito, Integer code, String tipoContext) throws ProtocolException {
        if (!this.mapEsitoTransazione.containsKey(esito.getMapKey())) {
            EsitoTransazione et = this._convertToEsitoTransazione(esito, code, tipoContext);
            this.mapEsitoTransazione.put(esito.getMapKey(), (Object)et);
        }
    }

    public EsitoTransazione convertToEsitoTransazione(EsitoTransazioneName esito, String tipoContext) throws ProtocolException {
        if (!EsitoTransazioneName.CUSTOM.equals(esito) && (this.isSingleTransactionContextCode() || "standard".equals(tipoContext))) {
            if (!this.mapEsitoTransazione.containsKey(esito.getMapKey())) {
                this.initMapEsitoTransazione(esito, this.convertoToCode(esito), tipoContext);
            }
            return (EsitoTransazione)this.mapEsitoTransazione.get(esito.getMapKey());
        }
        return this._convertToEsitoTransazione(esito, tipoContext);
    }

    public EsitoTransazione convertToEsitoTransazione(EsitoTransazioneName esito, Integer code, String tipoContext) throws ProtocolException {
        if (!EsitoTransazioneName.CUSTOM.equals(esito) && (this.isSingleTransactionContextCode() || "standard".equals(tipoContext))) {
            if (!this.mapEsitoTransazione.containsKey(esito.getMapKey())) {
                this.initMapEsitoTransazione(esito, code, tipoContext);
            }
            return (EsitoTransazione)this.mapEsitoTransazione.get(esito.getMapKey());
        }
        return this._convertToEsitoTransazione(esito, code, tipoContext);
    }

    private EsitoTransazione _convertToEsitoTransazione(EsitoTransazioneName esito, String tipoContext) throws ProtocolException {
        return this.convertToEsitoTransazione(esito, this.convertoToCode(esito), tipoContext);
    }

    private EsitoTransazione _convertToEsitoTransazione(EsitoTransazioneName esito, Integer code, String tipoContext) throws ProtocolException {
        if (esito == null) {
            throw new ProtocolException("EsitoTransazioneName [" + code + "] undefined");
        }
        if (code == null) {
            throw new ProtocolException("Code [" + code + "] undefined");
        }
        if (!this.existsEsitoCode(code)) {
            throw new ProtocolException("Code [" + tipoContext + "] unsupported");
        }
        if (tipoContext == null) {
            throw new ProtocolException("TipoContext [" + code + "] undefined");
        }
        if (!this.getEsitiTransactionContextCode().contains(tipoContext)) {
            throw new ProtocolException("TipoContext [" + tipoContext + "] unsupported");
        }
        return new EsitoTransazione(esito, code, tipoContext);
    }

    public Integer convertoToCode(EsitoTransazioneName esito) throws ProtocolException {
        Integer code = null;
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            String name = this.getEsitoName(codeEsito);
            if (!name.equals(esito.name())) continue;
            code = codeEsito;
            break;
        }
        if (code == null) {
            throw new ProtocolException("Code [" + String.valueOf(esito) + "] undefined");
        }
        return code;
    }

    public Integer convertLabelToCode(String label) throws ProtocolException {
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            String labelCheck = this.getEsitoLabel(codeEsito);
            if (!labelCheck.equals(label)) continue;
            return codeEsito;
        }
        throw new ProtocolException("Not exists esito code with label [" + label + "]");
    }

    public Integer convertNameToCode(String name) throws ProtocolException {
        List<Integer> codes = this.getEsitiCodeSenzaFiltri();
        for (Integer codeEsito : codes) {
            String nameCheck = this.getEsitoName(codeEsito);
            if (!nameCheck.equals(name)) continue;
            return codeEsito;
        }
        throw new ProtocolException("Not exists esito code with name [" + name + "]");
    }

    public boolean existsEsitoCode(Integer code) throws ProtocolException {
        if (code == null) {
            return false;
        }
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            if (codeEsito.intValue() != code.intValue()) continue;
            return true;
        }
        return false;
    }

    public String convertLabelToContextTypeCode(String label) throws ProtocolException {
        List<String> codes = this.getEsitiTransactionContextCode();
        for (String codeTransactionContext : codes) {
            String labelCheck = this.getEsitoTransactionContextLabel(codeTransactionContext);
            if (!labelCheck.equals(label)) continue;
            return codeTransactionContext;
        }
        throw new ProtocolException("Not exists context type with label [" + label + "]");
    }

    private List<Integer> filterByProtocol(List<Integer> esitiCode) throws ProtocolException {
        ArrayList<Integer> esitiCodeNew = new ArrayList<Integer>();
        int codeErroreProtocollo = this.convertNameToCode(EsitoTransazioneName.ERRORE_PROTOCOLLO.name());
        int codeFaultPdd = this.convertNameToCode(EsitoTransazioneName.ERRORE_SERVER.name());
        for (Integer esito : esitiCode) {
            if (esito == codeErroreProtocollo && !this.erroreProtocollo || esito == codeFaultPdd && !this.faultEsterno) continue;
            esitiCodeNew.add(esito);
        }
        return esitiCodeNew;
    }

    private String filterByProtocol(String label, int code) throws ProtocolException {
        int codeErroreProtocollo = this.convertNameToCode(EsitoTransazioneName.ERRORE_PROTOCOLLO.name());
        int codeFaultPdd = this.convertNameToCode(EsitoTransazioneName.ERRORE_SERVER.name());
        if (code == codeErroreProtocollo && this.erroreProtocollo && this.labelErroreProtocollo != null) {
            return this.labelErroreProtocollo;
        }
        if (code == codeFaultPdd && this.faultEsterno && this.labelFaultEsterno != null) {
            return this.labelFaultEsterno;
        }
        return label;
    }

    public List<Integer> getEsitiCodeSenzaFiltri() throws ProtocolException {
        if (this.esitiCodeSenzaFiltri == null) {
            this.initEsitiCodeSenzaFiltri();
        }
        return this.esitiCodeSenzaFiltri;
    }

    private synchronized void initEsitiCodeSenzaFiltri() throws ProtocolException {
        if (this.esitiCode == null) {
            this.esitiCodeSenzaFiltri = this.getListaInteger("esiti.codes");
        }
    }

    public List<Integer> getEsitiCode() throws ProtocolException {
        if (this.esitiCode == null) {
            this.initEsitiCode();
        }
        return this.esitiCode;
    }

    private synchronized void initEsitiCode() throws ProtocolException {
        if (this.esitiCode == null) {
            this.esitiCode = this.filterByProtocol(this.getListaInteger("esiti.codes"));
        }
    }

    public List<Integer> getEsitiCodeOk() throws ProtocolException {
        if (this.esitiCodeOk == null) {
            this.initEsitiCodeOk();
        }
        return this.esitiCodeOk;
    }

    private synchronized void initEsitiCodeOk() throws ProtocolException {
        if (this.esitiCodeOk == null) {
            this.esitiCodeOk = this.filterByProtocol(this.getListaInteger("esiti.codes.ok"));
        }
    }

    public List<Integer> getEsitiCodeOk_senzaFaultApplicativo() throws ProtocolException {
        if (this.esitiCodeOk_senzaFaultApplicativo == null) {
            this.initEsitiCodeOk_senzaFaultApplicativo();
        }
        return this.esitiCodeOk_senzaFaultApplicativo;
    }

    private synchronized void initEsitiCodeOk_senzaFaultApplicativo() throws ProtocolException {
        if (this.esitiCodeOk_senzaFaultApplicativo == null) {
            List<Integer> tmp = this.getEsitiCodeOk();
            int codeFaultApplicativo = this.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
            ArrayList<Integer> esitiOk = new ArrayList<Integer>();
            for (Integer e : tmp) {
                if (e == codeFaultApplicativo) continue;
                esitiOk.add(e);
            }
            this.esitiCodeOk_senzaFaultApplicativo = this.filterByProtocol(esitiOk);
        }
    }

    public List<Integer> getEsitiCodeKo() throws ProtocolException {
        if (this.esitiCodeKo == null) {
            this.initEsitiCodeKo();
        }
        return this.esitiCodeKo;
    }

    private synchronized void initEsitiCodeKo() throws ProtocolException {
        if (this.esitiCodeKo == null) {
            ArrayList<Integer> esitiCodeKo = new ArrayList<Integer>();
            List<Integer> esiti = this.getEsitiCodeOrderLabel();
            for (Integer esito : esiti) {
                boolean found = false;
                List<Integer> oks = this.getEsitiCodeOk();
                for (Integer ok : oks) {
                    if (ok.intValue() != esito.intValue()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                esitiCodeKo.add(esito);
            }
            this.esitiCodeKo = this.filterByProtocol(esitiCodeKo);
        }
    }

    public List<Integer> getEsitiCodeKo_senzaFaultApplicativo() throws ProtocolException {
        if (this.esitiCodeKo_senzaFaultApplicativo == null) {
            this.initEsitiCodeKo_senzaFaultApplicativo();
        }
        return this.esitiCodeKo_senzaFaultApplicativo;
    }

    private synchronized void initEsitiCodeKo_senzaFaultApplicativo() throws ProtocolException {
        if (this.esitiCodeKo_senzaFaultApplicativo == null) {
            List<Integer> tmp = this.getEsitiCodeKo();
            int codeFaultApplicativo = this.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
            ArrayList<Integer> esitiKo = new ArrayList<Integer>();
            for (Integer e : tmp) {
                if (e == codeFaultApplicativo) continue;
                esitiKo.add(e);
            }
            this.esitiCodeKo_senzaFaultApplicativo = this.filterByProtocol(esitiKo);
        }
    }

    public List<Integer> getEsitiCodeFaultApplicativo() throws ProtocolException {
        if (this.esitiCodeFaultApplicativo == null) {
            this.initEsitiCodeFaultApplicativo();
        }
        return this.esitiCodeFaultApplicativo;
    }

    private synchronized void initEsitiCodeFaultApplicativo() throws ProtocolException {
        if (this.esitiCodeFaultApplicativo == null) {
            int codeFaultApplicativo = this.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
            ArrayList<Integer> esitiCodeFaultApplicativo = new ArrayList<Integer>();
            esitiCodeFaultApplicativo.add(codeFaultApplicativo);
            this.esitiCodeFaultApplicativo = esitiCodeFaultApplicativo;
        }
    }

    public List<Integer> getEsitiCodeRichiestaScartate() throws ProtocolException {
        if (this.esitiCodeRichiestaScartate == null) {
            this.initEsitiCodeRichiestaScartate();
        }
        return this.esitiCodeRichiestaScartate;
    }

    private synchronized void initEsitiCodeRichiestaScartate() throws ProtocolException {
        if (this.esitiCodeRichiestaScartate == null) {
            this.esitiCodeRichiestaScartate = this.filterByProtocol(this.getListaInteger("esiti.codes.richiestaScartate"));
        }
    }

    public List<Integer> getEsitiCodeErroriConsegna() throws ProtocolException {
        if (this.esitiCodeErroriConsegna == null) {
            this.initEsitiCodeErroriConsegna();
        }
        return this.esitiCodeErroriConsegna;
    }

    private synchronized void initEsitiCodeErroriConsegna() throws ProtocolException {
        if (this.esitiCodeErroriConsegna == null) {
            this.esitiCodeErroriConsegna = this.filterByProtocol(this.getListaInteger("esiti.codes.erroriConsegna"));
        }
    }

    public List<Integer> getEsitiCodeAutorizzazioneNegata() throws ProtocolException {
        if (this.esitiCodeAutorizzazioneNegata == null) {
            this.initEsitiCodeAutorizzazioneNegata();
        }
        return this.esitiCodeAutorizzazioneNegata;
    }

    private synchronized void initEsitiCodeAutorizzazioneNegata() throws ProtocolException {
        if (this.esitiCodeAutorizzazioneNegata == null) {
            this.esitiCodeAutorizzazioneNegata = this.filterByProtocol(this.getListaInteger("esiti.codes.autorizzazioneNegata"));
        }
    }

    public List<Integer> getEsitiCodeControlloTrafficoPolicyViolate() throws ProtocolException {
        if (this.esitiCodeControlloTrafficoPolicyViolate == null) {
            this.initEsitiCodeControlloTrafficoPolicyViolate();
        }
        return this.esitiCodeControlloTrafficoPolicyViolate;
    }

    private synchronized void initEsitiCodeControlloTrafficoPolicyViolate() throws ProtocolException {
        if (this.esitiCodeControlloTrafficoPolicyViolate == null) {
            this.esitiCodeControlloTrafficoPolicyViolate = this.filterByProtocol(this.getListaInteger("esiti.codes.controlloTrafficoPolicyViolate"));
        }
    }

    public List<Integer> getEsitiCodeServizioIntegrationManager() throws ProtocolException {
        if (this.esitiCodeServizioIntegrationManager == null) {
            this.initEsitiCodeServizioIntegrationManager();
        }
        return this.esitiCodeServizioIntegrationManager;
    }

    private synchronized void initEsitiCodeServizioIntegrationManager() throws ProtocolException {
        if (this.esitiCodeServizioIntegrationManager == null) {
            this.esitiCodeServizioIntegrationManager = this.filterByProtocol(this.getListaInteger("esiti.codes.servizioIntegrationManager"));
        }
    }

    public List<Integer> getEsitiCodeErroriProcessamentoRichiesta() throws ProtocolException {
        if (this.esitiCodeErroriProcessamentoRichiesta == null) {
            this.initEsitiCodeErroriProcessamentoRichiesta();
        }
        return this.esitiCodeErroriProcessamentoRichiesta;
    }

    private synchronized void initEsitiCodeErroriProcessamentoRichiesta() throws ProtocolException {
        if (this.esitiCodeErroriProcessamentoRichiesta == null) {
            this.esitiCodeErroriProcessamentoRichiesta = this.filterByProtocol(this.getListaInteger("esiti.codes.erroriProcessamentoRichiesta"));
        }
    }

    public List<Integer> getEsitiCodeErroriProcessamentoRisposta() throws ProtocolException {
        if (this.esitiCodeErroriProcessamentoRisposta == null) {
            this.initEsitiCodeErroriProcessamentoRisposta();
        }
        return this.esitiCodeErroriProcessamentoRisposta;
    }

    private synchronized void initEsitiCodeErroriProcessamentoRisposta() throws ProtocolException {
        if (this.esitiCodeErroriProcessamentoRisposta == null) {
            this.esitiCodeErroriProcessamentoRisposta = this.filterByProtocol(this.getListaInteger("esiti.codes.erroriProcessamentoRisposta"));
        }
    }

    public List<Integer> getEsitiCodeErroriClientNonDisponibile() throws ProtocolException {
        if (this.esitiCodeErroriClientNonDisponibile == null) {
            this.initEsitiCodeErroriClientNonDisponibile();
        }
        return this.esitiCodeErroriClientNonDisponibile;
    }

    private synchronized void initEsitiCodeErroriClientNonDisponibile() throws ProtocolException {
        if (this.esitiCodeErroriClientNonDisponibile == null) {
            this.esitiCodeErroriClientNonDisponibile = this.filterByProtocol(this.getListaInteger("esiti.codes.erroriClientIndisponibile"));
        }
    }

    public List<Integer> getEsitiCodeErroriGenerici() throws ProtocolException {
        if (this.esitiCodeErroriGenerici == null) {
            this.initEsitiCodeErroriGenerici();
        }
        return this.esitiCodeErroriGenerici;
    }

    private synchronized void initEsitiCodeErroriGenerici() throws ProtocolException {
        if (this.esitiCodeErroriGenerici == null) {
            this.esitiCodeErroriGenerici = this.filterByProtocol(this.getListaInteger("esiti.codes.erroriGenerici"));
        }
    }

    public List<Integer> getEsitiCodeForSoapFaultIdentificationMode() throws ProtocolException {
        if (this.esitiCodeForSoapFaultIdentificationMode == null) {
            this.initEsitiCodeForSoapFaultIdentificationMode();
        }
        return this.esitiCodeForSoapFaultIdentificationMode;
    }

    private synchronized void initEsitiCodeForSoapFaultIdentificationMode() throws ProtocolException {
        if (this.esitiCodeForSoapFaultIdentificationMode == null) {
            ArrayList<Integer> esitiCodeForSoapFaultIdentificationMode = new ArrayList<Integer>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer codeEsito : codes) {
                if (!EsitoIdentificationMode.SOAP_FAULT.equals((Object)this.getEsitoIdentificationMode(codeEsito))) continue;
                esitiCodeForSoapFaultIdentificationMode.add(codeEsito);
            }
            this.esitiCodeForSoapFaultIdentificationMode = this.filterByProtocol(esitiCodeForSoapFaultIdentificationMode);
        }
    }

    public List<Integer> getEsitiCodeForContextPropertyIdentificationMode() throws ProtocolException {
        if (this.esitiCodeForContextPropertyIdentificationMode == null) {
            this.initEsitiCodeForContextPropertyIdentificationMode();
        }
        return this.esitiCodeForContextPropertyIdentificationMode;
    }

    private synchronized void initEsitiCodeForContextPropertyIdentificationMode() throws ProtocolException {
        if (this.esitiCodeForContextPropertyIdentificationMode == null) {
            ArrayList<Integer> esitiCodeForContextPropertyIdentificationMode = new ArrayList<Integer>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer codeEsito : codes) {
                if (!EsitoIdentificationMode.CONTEXT_PROPERTY.equals((Object)this.getEsitoIdentificationMode(codeEsito))) continue;
                esitiCodeForContextPropertyIdentificationMode.add(codeEsito);
            }
            this.esitiCodeForContextPropertyIdentificationMode = this.filterByProtocol(esitiCodeForContextPropertyIdentificationMode);
        }
    }

    public List<Integer> getEsitiCodeOrderLabel() throws ProtocolException {
        if (this.esitiCodeOrderLabel == null) {
            this.initEsitiCodeOrderLabel();
        }
        return this.esitiCodeOrderLabel;
    }

    private synchronized void initEsitiCodeOrderLabel() throws ProtocolException {
        if (this.esitiCodeOrderLabel == null) {
            this.esitiCodeOrderLabel = this.filterByProtocol(this.getListaInteger("esiti.codes.labelOrder"));
        }
    }

    public List<String> getEsitiOrderLabel() throws ProtocolException {
        if (this.esitiOrderLabel == null) {
            this.initEsitiOrderLabel();
        }
        return this.esitiOrderLabel;
    }

    private synchronized void initEsitiOrderLabel() throws ProtocolException {
        if (this.esitiOrderLabel == null) {
            List<Integer> codes = this.getEsitiCode();
            ArrayList<String> esitiOrderLabel = new ArrayList<String>();
            for (Integer codeEsito : codes) {
                esitiOrderLabel.add(this.getEsitoLabel(codeEsito));
            }
            this.esitiOrderLabel = esitiOrderLabel;
        }
    }

    public String getEsitoName(Integer codeEsito) throws ProtocolException {
        if (this.esitoName == null) {
            this.initEsitoName();
        }
        if (!this.esitoName.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoName for code [" + codeEsito + "] not found");
        }
        return this.esitoName.get("" + codeEsito);
    }

    private synchronized void initEsitoName() throws ProtocolException {
        if (this.esitoName == null) {
            HashMap<String, String> esitoName = new HashMap<String, String>();
            List<Integer> codes = this.getEsitiCodeSenzaFiltri();
            for (Integer code : codes) {
                esitoName.put("" + code, this.getProperty("esito." + code + ".name"));
            }
            this.esitoName = esitoName;
        }
    }

    public String getEsitoDescription(Integer codeEsito) throws ProtocolException {
        if (this.esitoDescription == null) {
            this.initEsitoDescription();
        }
        if (!this.esitoDescription.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoDescription for code [" + codeEsito + "] not found");
        }
        return this.esitoDescription.get("" + codeEsito);
    }

    private synchronized void initEsitoDescription() throws ProtocolException {
        if (this.esitoDescription == null) {
            HashMap<String, String> esitoDescription = new HashMap<String, String>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                esitoDescription.put("" + code, this.getProperty("esito." + code + ".description"));
            }
            this.esitoDescription = esitoDescription;
        }
    }

    public String getEsitoLabel(Integer codeEsito) throws ProtocolException {
        if (this.esitoLabel == null) {
            this.initEsitoLabel();
        }
        if (!this.esitoLabel.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoLabel for code [" + codeEsito + "] not found");
        }
        return this.esitoLabel.get("" + codeEsito);
    }

    private synchronized void initEsitoLabel() throws ProtocolException {
        if (this.esitoLabel == null) {
            HashMap<String, String> esitoLabel = new HashMap<String, String>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                String label = this.getProperty("esito." + code + ".label");
                label = this.filterByProtocol(label, code);
                esitoLabel.put("" + code, label);
            }
            this.esitoLabel = esitoLabel;
        }
    }

    public String getEsitoLabelSyntetic(Integer codeEsito) throws ProtocolException {
        if (this.esitoLabelSyntetic == null) {
            this.initEsitoLabelSyntetic();
        }
        if (!this.esitoLabelSyntetic.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoLabelSyntetic for code [" + codeEsito + "] not found");
        }
        return this.esitoLabelSyntetic.get("" + codeEsito);
    }

    private synchronized void initEsitoLabelSyntetic() throws ProtocolException {
        if (this.esitoLabelSyntetic == null) {
            HashMap<String, String> esitoLabelSyntetic = new HashMap<String, String>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                String label = this.getProperty("esito." + code + ".label.syntetic");
                label = this.filterByProtocol(label, code);
                esitoLabelSyntetic.put("" + code, label);
            }
            this.esitoLabelSyntetic = esitoLabelSyntetic;
        }
    }

    public EsitoIdentificationMode getEsitoIdentificationMode(Integer codeEsito) throws ProtocolException {
        if (this.esitoIdentificationMode == null) {
            this.initEsitoIdentificationMode();
        }
        if (!this.esitoIdentificationMode.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoIdentificationMode for code [" + codeEsito + "] not found");
        }
        return this.esitoIdentificationMode.get("" + codeEsito);
    }

    private synchronized void initEsitoIdentificationMode() throws ProtocolException {
        if (this.esitoIdentificationMode == null) {
            HashMap<String, EsitoIdentificationMode> esitoIdentificationMode = new HashMap<String, EsitoIdentificationMode>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                String prop = "esito." + code + ".mode";
                String tmp = this.getProperty(prop);
                try {
                    EsitoIdentificationMode e = EsitoIdentificationMode.toEnumConstant(tmp);
                    if (e == null) {
                        throw new Exception("proprieta con valore non supportato");
                    }
                    esitoIdentificationMode.put("" + code, e);
                }
                catch (Exception e) {
                    String msg = "Riscontrato errore durante la lettura della proprieta' '" + prop + "': " + e.getMessage();
                    this.log.error(msg, (Throwable)e);
                    throw new ProtocolException(msg, e);
                }
            }
            this.esitoIdentificationMode = esitoIdentificationMode;
        }
    }

    public List<EsitoIdentificationModeSoapFault> getEsitoIdentificationModeSoapFaultList(Integer codeEsito) throws ProtocolException {
        if (this.esitoIdentificationModeSoapFaultList == null) {
            this.initEsitoIdentificationModeSoapFaultList();
        }
        return this.esitoIdentificationModeSoapFaultList.get("" + codeEsito);
    }

    private synchronized void initEsitoIdentificationModeSoapFaultList() throws ProtocolException {
        if (this.esitoIdentificationModeSoapFaultList == null) {
            HashMap<String, List<EsitoIdentificationModeSoapFault>> esitoIdentificationModeSoapFaultList = new HashMap<String, List<EsitoIdentificationModeSoapFault>>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                try {
                    EsitoIdentificationMode mode = this.getEsitoIdentificationMode(code);
                    if (!EsitoIdentificationMode.SOAP_FAULT.equals((Object)mode)) continue;
                    esitoIdentificationModeSoapFaultList.put("" + code, this._getEsitoIdentificationModeSoapFaultList(code));
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + code + "]: " + e.getMessage(), e);
                }
            }
            this.esitoIdentificationModeSoapFaultList = esitoIdentificationModeSoapFaultList;
        }
    }

    private List<EsitoIdentificationModeSoapFault> _getEsitoIdentificationModeSoapFaultList(Integer codeEsito) throws ProtocolException {
        ArrayList<EsitoIdentificationModeSoapFault> l = null;
        String prefix = "esito." + codeEsito + ".mode.soapFault.";
        for (int index = 0; index < 1000; ++index) {
            EsitoIdentificationModeSoapFault esito = new EsitoIdentificationModeSoapFault();
            esito.setFaultCode(this.getOptionalProperty(prefix + index + ".code"));
            esito.setFaultNamespaceCode(this.getOptionalProperty(prefix + index + ".namespaceCode"));
            esito.setFaultReason(this.getOptionalProperty(prefix + index + ".reason"));
            BooleanNullable bn = this.getOptionalBooleanProperty(prefix + index + ".reason.contains");
            if (bn != null && bn.getValue() != null) {
                esito.setFaultReasonContains(bn.getValue());
            } else {
                esito.setFaultReasonContains(null);
            }
            esito.setFaultActor(this.getOptionalProperty(prefix + index + ".actor"));
            bn = this.getOptionalBooleanProperty(prefix + index + ".actorNotDefined");
            if (bn != null && bn.getValue() != null) {
                esito.setFaultActorNotDefined(bn.getValue());
            } else {
                esito.setFaultActorNotDefined(null);
            }
            if (esito.getFaultReasonContains() != null && esito.getFaultReason() == null) {
                throw new ProtocolException("Per il codice [" + codeEsito + "] esiste un mapping rispetto alla modalit\u00e0 soapFault in cui \u00e8 stato definita la propriet\u00e0 '*.reason.contains' senza la propriet\u00e0 '*.reason'");
            }
            if (esito.getFaultActor() != null && esito.getFaultActorNotDefined() != null) {
                throw new ProtocolException("Per il codice [" + codeEsito + "] esiste un mapping rispetto alla modalit\u00e0 soapFault in cui sono state definite entrambe le modalit\u00e0 di indenficazione dell'actor");
            }
            if (esito.getFaultActor() == null && esito.getFaultActorNotDefined() == null && esito.getFaultCode() == null && esito.getFaultNamespaceCode() == null && esito.getFaultReason() == null) {
                if (index != 0) break;
                throw new ProtocolException("Per il codice [" + codeEsito + "] non esiste alcun mapping rispetto alla modalit\u00e0 soapFault");
            }
            if (l == null) {
                l = new ArrayList<EsitoIdentificationModeSoapFault>();
            }
            l.add(esito);
        }
        return l;
    }

    public List<EsitoIdentificationModeContextProperty> getEsitoIdentificationModeContextPropertyList(Integer codeEsito) throws ProtocolException {
        if (this.esitoIdentificationModeContextPropertyList == null) {
            this.initEsitoIdentificationModeContextPropertyList();
        }
        return this.esitoIdentificationModeContextPropertyList.get("" + codeEsito);
    }

    private synchronized void initEsitoIdentificationModeContextPropertyList() throws ProtocolException {
        if (this.esitoIdentificationModeContextPropertyList == null) {
            HashMap<String, List<EsitoIdentificationModeContextProperty>> esitoIdentificationModeContextPropertyList = new HashMap<String, List<EsitoIdentificationModeContextProperty>>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                try {
                    EsitoIdentificationMode mode = this.getEsitoIdentificationMode(code);
                    if (!EsitoIdentificationMode.CONTEXT_PROPERTY.equals((Object)mode)) continue;
                    esitoIdentificationModeContextPropertyList.put("" + code, this._getEsitoIdentificationModeContextPropertyList(code));
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + code + "]: " + e.getMessage(), e);
                }
            }
            this.esitoIdentificationModeContextPropertyList = esitoIdentificationModeContextPropertyList;
        }
    }

    private List<EsitoIdentificationModeContextProperty> _getEsitoIdentificationModeContextPropertyList(Integer codeEsito) throws ProtocolException {
        ArrayList<EsitoIdentificationModeContextProperty> l = null;
        String prefix = "esito." + codeEsito + ".mode.contextProperty.";
        for (int index = 0; index < 1000; ++index) {
            EsitoIdentificationModeContextProperty esito = new EsitoIdentificationModeContextProperty();
            EsitoTransazioneName esitoTransazioneName = null;
            try {
                esitoTransazioneName = this.getEsitoTransazioneName(codeEsito);
                esito.setEsito(esitoTransazioneName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            esito.setName(this.getOptionalProperty(prefix + index + ".name"));
            if (esito.getName() != null) {
                esito.setMapKey((MapKey<String>)Map.newMapKey((String)esito.getName()));
            }
            esito.setValue(this.getOptionalProperty(prefix + index + ".value"));
            if (esito.getName() == null && esito.getValue() == null) {
                if (index != 0) break;
                throw new ProtocolException("Per il codice [" + codeEsito + "] non esiste alcun mapping rispetto alla modalit\u00e0 contextProperty");
            }
            if (esito.getName() == null) {
                throw new ProtocolException("Per il codice [" + codeEsito + "] non esiste il mapping rispetto al nome, obbligtorio per la modalit\u00e0 contextProperty");
            }
            if (l == null) {
                l = new ArrayList<EsitoIdentificationModeContextProperty>();
            }
            l.add(esito);
        }
        return l;
    }

    public List<String> getEsitiTransactionContextCode() throws ProtocolException {
        if (this.esitiTransactionContextCode == null) {
            this.initEsitiTransactionContextCode();
        }
        return this.esitiTransactionContextCode;
    }

    public boolean isSingleTransactionContextCode() throws ProtocolException {
        if (this.isSingleTransactionContextCode == null) {
            this.initEsitiTransactionContextCode();
        }
        return this.isSingleTransactionContextCode;
    }

    private synchronized void initEsitiTransactionContextCode() throws ProtocolException {
        if (this.esitiTransactionContextCode == null) {
            this.esitiTransactionContextCode = this.getLista("esiti.transactionContext");
            for (String context : this.esitiTransactionContextCode) {
                if (context.length() <= 255) continue;
                throw new ProtocolException("Context id [" + context + "] length must be less then 255 characters");
            }
            this.isSingleTransactionContextCode = this.esitiTransactionContextCode.size() <= 1;
        }
    }

    public List<String> getEsitiTransactionContextCodeOrderLabel() throws ProtocolException {
        if (this.esitiTransactionContextCodeOrderLabel == null) {
            this.initEsitiTransactionContextCodeOrderLabel();
        }
        return this.esitiTransactionContextCodeOrderLabel;
    }

    private synchronized void initEsitiTransactionContextCodeOrderLabel() throws ProtocolException {
        if (this.esitiTransactionContextCodeOrderLabel == null) {
            this.esitiTransactionContextCodeOrderLabel = this.getLista("esiti.transactionContext.labelOrder");
        }
    }

    public List<String> getEsitiTransactionContextOrderLabel() throws ProtocolException {
        if (this.esitiTransactionContextOrderLabel == null) {
            this.initEsitiTransactionContextOrderLabel();
        }
        return this.esitiTransactionContextOrderLabel;
    }

    private synchronized void initEsitiTransactionContextOrderLabel() throws ProtocolException {
        if (this.esitiTransactionContextOrderLabel == null) {
            List<String> codes = this.getEsitiTransactionContextCode();
            ArrayList<String> esitiTransactionContextOrderLabel = new ArrayList<String>();
            for (String codeTransactionContext : codes) {
                esitiTransactionContextOrderLabel.add(this.getEsitoTransactionContextLabel(codeTransactionContext));
            }
            this.esitiTransactionContextOrderLabel = esitiTransactionContextOrderLabel;
        }
    }

    public String getEsitoTransactionContextLabel(String tipo) throws ProtocolException {
        if (this.esitoTransactionContextLabel == null) {
            this.initEsitoTransactionContextLabel();
        }
        if (!this.esitoTransactionContextLabel.containsKey(tipo)) {
            throw new ProtocolException("EsitoTransactionContextLabel for code [" + tipo + "] not found");
        }
        return this.esitoTransactionContextLabel.get(tipo);
    }

    private synchronized void initEsitoTransactionContextLabel() throws ProtocolException {
        if (this.esitoTransactionContextLabel == null) {
            HashMap<String, String> esitoTransactionContextLabel = new HashMap<String, String>();
            List<String> codes = this.getEsitiTransactionContextCode();
            for (String code : codes) {
                esitoTransactionContextLabel.put(code, this.getProperty("esiti.transactionContext." + code + ".label"));
            }
            this.esitoTransactionContextLabel = esitoTransactionContextLabel;
        }
    }

    public String getEsitoTransactionContextDefault() throws ProtocolException {
        if (this.esitoTransactionContextDefault_read == null) {
            this.initEsitoTransactionContextDefault();
        }
        return this.esitoTransactionContextDefault;
    }

    private synchronized void initEsitoTransactionContextDefault() throws ProtocolException {
        if (this.esitoTransactionContextDefault_read == null) {
            this.esitoTransactionContextDefault = this.getOptionalProperty("esiti.transactionContext.default");
            this.esitoTransactionContextDefault_read = true;
            if (this.esitoTransactionContextDefault != null && !this.getEsitiTransactionContextCode().contains(this.esitoTransactionContextDefault)) {
                throw new ProtocolException("Indicato nella propriet\u00e0 'esiti.transactionContext.default' un codice di contesto non registrato");
            }
        }
    }

    public String getEsitoTransactionContextHeaderTrasportoName() throws ProtocolException {
        if (this.esitoTransactionContextHeaderTrasportoName == null) {
            this.initEsitoTransactionContextHeaderTrasportoName();
        }
        return this.esitoTransactionContextHeaderTrasportoName;
    }

    private synchronized void initEsitoTransactionContextHeaderTrasportoName() throws ProtocolException {
        if (this.esitoTransactionContextHeaderTrasportoName == null) {
            this.esitoTransactionContextHeaderTrasportoName = this.getProperty("esiti.transactionContext.trasporto.headerName");
        }
    }

    public String getEsitoTransactionContextFormBasedPropertyName() throws ProtocolException {
        if (this.esitoTransactionContextFormBasedPropertyName == null) {
            this.initEsitoTransactionContextFormBasedPropertyName();
        }
        return this.esitoTransactionContextFormBasedPropertyName;
    }

    private synchronized void initEsitoTransactionContextFormBasedPropertyName() throws ProtocolException {
        if (this.esitoTransactionContextFormBasedPropertyName == null) {
            this.esitoTransactionContextFormBasedPropertyName = this.getProperty("esiti.transactionContext.urlFormBased.propertyName");
        }
    }

    public List<EsitoTransportContextIdentification> getEsitoTransactionContextHeaderTrasportoDynamicIdentification() throws ProtocolException {
        if (this.esitoTransactionContextHeaderTrasportoDynamicIdentification == null) {
            this.initEsitoTransactionContextHeaderTrasportoDynamicIdentification();
        }
        return this.esitoTransactionContextHeaderTrasportoDynamicIdentification;
    }

    private synchronized void initEsitoTransactionContextHeaderTrasportoDynamicIdentification() throws ProtocolException {
        if (this.esitoTransactionContextHeaderTrasportoDynamicIdentification == null) {
            this.esitoTransactionContextHeaderTrasportoDynamicIdentification = this.readEsitoTransportContextIdentification("esiti.transactionContext.trasporto.dynamic.");
        }
    }

    public List<EsitoTransportContextIdentification> getEsitoTransactionContextHeaderFormBasedDynamicIdentification() throws ProtocolException {
        if (this.esitoTransactionContextHeaderFormBasedDynamicIdentification == null) {
            this.initEsitoTransactionContextHeaderFormBasedDynamicIdentification();
        }
        return this.esitoTransactionContextHeaderFormBasedDynamicIdentification;
    }

    private synchronized void initEsitoTransactionContextHeaderFormBasedDynamicIdentification() throws ProtocolException {
        if (this.esitoTransactionContextHeaderFormBasedDynamicIdentification == null) {
            this.esitoTransactionContextHeaderFormBasedDynamicIdentification = this.readEsitoTransportContextIdentification("esiti.transactionContext.urlFormBased.dynamic.");
        }
    }

    private List<EsitoTransportContextIdentification> readEsitoTransportContextIdentification(String pName) throws ProtocolException {
        try {
            ArrayList<EsitoTransportContextIdentification> l = new ArrayList<EsitoTransportContextIdentification>();
            Properties p = this.reader.readPropertiesConvertEnvProperties(pName);
            if (p.size() > 0) {
                ArrayList<String> keys = new ArrayList<String>();
                Enumeration<Object> enKeys = p.keys();
                while (enKeys.hasMoreElements()) {
                    String key = (String)enKeys.nextElement();
                    if (!key.endsWith(".headerName")) continue;
                    keys.add(key.substring(0, key.length() - ".headerName".length()));
                }
                for (String key : keys) {
                    EsitoTransportContextIdentification etci = new EsitoTransportContextIdentification();
                    etci.setName(p.getProperty(key + ".headerName"));
                    etci.setValue(p.getProperty(key + ".value"));
                    String mode = p.getProperty(key + ".mode");
                    etci.setMode(EsitoTransportContextIdentificationMode.toEnumConstant(mode));
                    if (etci.getMode() == null) {
                        throw new ProtocolException("Modalit\u00e0 indicata [" + mode + "] per chiave [" + key + "] sconosciuta");
                    }
                    etci.setRegularExpr(p.getProperty(key + ".regularExpr"));
                    if (EsitoTransportContextIdentificationMode.MATCH.equals((Object)etci.getMode())) {
                        if (etci.getRegularExpr() == null) {
                            throw new ProtocolException("Modalit\u00e0 indicata [" + mode + "] per la chiave [" + key + "] richiede obbligatoriamente la definizione di una espressione regolare");
                        }
                    } else if ((EsitoTransportContextIdentificationMode.EQUALS.equals((Object)etci.getMode()) || EsitoTransportContextIdentificationMode.CONTAINS.equals((Object)etci.getMode())) && etci.getValue() == null) {
                        throw new ProtocolException("Modalit\u00e0 indicata [" + mode + "] per la chiave [" + key + "] richiede obbligatoriamente la definizione di un valore su cui basare il confronto");
                    }
                    etci.setType(p.getProperty(key + ".type"));
                    if (!this.getEsitiTransactionContextCode().contains(etci.getType())) {
                        throw new ProtocolException("Tipo di contesto indicato [" + etci.getType() + "] per la chiave [" + key + "] non risulta tra le tipologie di contesto supportate: " + String.valueOf(this.getEsitiTransactionContextCode()));
                    }
                    l.add(etci);
                }
            }
            return l;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public String getProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValueConvertEnvProperties(property);
            if (name == null) {
                throw new Exception("proprieta non definita");
            }
            return name.trim();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public String getOptionalProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValueConvertEnvProperties(property);
            if (name == null) {
                return null;
            }
            return name.trim();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public BooleanNullable getOptionalBooleanProperty(String property) throws ProtocolException {
        String p = this.getOptionalProperty(property);
        if (p != null) {
            try {
                return Boolean.parseBoolean(p) ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, e);
            }
        }
        return BooleanNullable.NULL();
    }

    private List<String> getLista(String property) throws ProtocolException {
        ArrayList<String> lista = null;
        String name = null;
        try {
            name = this.reader.getValueConvertEnvProperties(property);
            if (name == null) {
                throw new Exception("proprieta non definita");
            }
            name = name.trim();
            lista = new ArrayList<String>();
            String[] split = name.split(",");
            if (split == null || split.length <= 0) {
                throw new Exception("proprieta non definita (dopo split?)");
            }
            for (int i = 0; i < split.length; ++i) {
                String p = split[i];
                if (p == null) {
                    throw new Exception("valore alla posizione " + (i + 1) + " della proprieta non definita");
                }
                if ((p = p.trim()).equals("")) {
                    throw new Exception("valore alla posizione " + (i + 1) + " della proprieta \u00e8 vuoto");
                }
                if (lista.contains(p)) {
                    throw new Exception("valore '" + p + "' alla posizione " + (i + 1) + " della proprieta \u00e8 definito pi\u00f9 di una volta");
                }
                lista.add(p);
            }
        }
        catch (Exception e) {
            Object listaDebug = "";
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                listaDebug = " (lista: " + name + ")";
            }
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "'" + (String)listaDebug + ": " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
        return lista;
    }

    private List<Integer> getListaInteger(String property) throws ProtocolException {
        List<String> lista = this.getLista(property);
        ArrayList<Integer> listaInteger = null;
        if (lista != null && lista.size() > 0) {
            listaInteger = new ArrayList<Integer>();
            for (String s : lista) {
                try {
                    listaInteger.add(Integer.parseInt(s));
                }
                catch (Exception e) {
                    throw new ProtocolException("Property [" + property + "] with wrong value (not integer) [" + s + "]");
                }
            }
        }
        return listaInteger;
    }
}

