/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.utils;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.slf4j.Logger;

public class EsitiConfigUtils {
    public static int TUTTI_ESITI_DISABILITATI = -2;
    private static int esitoMaxThreads = -1;
    private static int esitoViolazionePolicyRateLimiting = -1;
    private static int esitoCorsGateway = -1;
    private static int esitoCorsTrasparente = -1;

    private EsitiConfigUtils() {
    }

    public static EsitiProperties getEsitiPropertiesForConfiguration(Logger log) throws ProtocolException {
        return EsitiProperties.getInstance(log, EsitiProperties.NO_PROTOCOL_CONFIG);
    }

    public static EsitiProperties getEsitiPropertiesForContext(Logger log) throws ProtocolException {
        return EsitiProperties.getInstance(log, EsitiProperties.NO_PROTOCOL_CONFIG);
    }

    private static void checkInitEsiti(EsitiProperties esiti) throws ProtocolException {
        if (esitoMaxThreads < 0) {
            EsitiConfigUtils.initEsiti(esiti);
        }
    }

    private static synchronized void initEsiti(EsitiProperties esiti) throws ProtocolException {
        if (esitoMaxThreads < 0) {
            esitoMaxThreads = esiti.convertNameToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_MAX_THREADS.name());
            esitoViolazionePolicyRateLimiting = esiti.convertNameToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA.name());
            esitoCorsGateway = esiti.convertNameToCode(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_VIA_GATEWAY.name());
            esitoCorsTrasparente = esiti.convertNameToCode(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_TRASPARENTE.name());
        }
    }

    public static List<String> getRegistrazioneEsiti(String esitiConfig, Logger log, StringBuilder bf) throws ProtocolException {
        return EsitiConfigUtils.getRegistrazioneEsiti(esitiConfig, log, bf, EsitiConfigUtils.getEsitiPropertiesForConfiguration(log));
    }

    public static List<String> getRegistrazioneEsiti(String esitiConfig, Logger log, StringBuilder bf, EsitiProperties esiti) throws ProtocolException {
        if (log != null) {
            // empty if block
        }
        List<String> listNull = null;
        if (esitiConfig == null || "".equals(esitiConfig.trim())) {
            List<Integer> esitiCodes = esiti.getEsitiCode();
            if (esitiCodes != null && !esitiCodes.isEmpty()) {
                ArrayList<String> esitiDaRegistrare = new ArrayList<String>();
                for (Integer esito : esitiCodes) {
                    EsitiConfigUtils.checkInitEsiti(esiti);
                    if (esito == esitoMaxThreads || esito == esitoViolazionePolicyRateLimiting || esito == esitoCorsGateway || esito == esitoCorsTrasparente) continue;
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    bf.append(esito);
                    esitiDaRegistrare.add("" + esito);
                }
                if (!esitiDaRegistrare.isEmpty()) {
                    return esitiDaRegistrare;
                }
            }
            return listNull;
        }
        String[] tmp = esitiConfig.split(",");
        if (tmp != null && tmp.length > 0) {
            ArrayList<String> esitiDaRegistrare = new ArrayList<String>();
            for (int i = 0; i < tmp.length; ++i) {
                String t = tmp[i];
                if (t == null || "".equals(t = t.trim())) continue;
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(t);
                esitiDaRegistrare.add(t);
            }
            if (!esitiDaRegistrare.isEmpty()) {
                return esitiDaRegistrare;
            }
        }
        return listNull;
    }
}

