/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IPositionArchiveObject;

public class ArchiveActivePolicy
implements IPositionArchiveObject {
    private RuoloPolicy ruoloPorta;
    private String nomePorta;
    private String aliasPolicy;
    private AttivazionePolicy policy;
    private boolean policyGlobale;
    private int posizione;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(RuoloPolicy ruoloPorta, String nomePorta, String aliasPolicy) throws ProtocolException {
        if (aliasPolicy == null) {
            throw new ProtocolException("aliasPolicy non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("ControlloTraffico_ActivePolicy_");
        bf.append(aliasPolicy);
        if (ruoloPorta != null && nomePorta != null) {
            bf.append("#");
            bf.append(ruoloPorta.toString());
            bf.append("_");
            bf.append(nomePorta);
        }
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveActivePolicy.buildKey(this.ruoloPorta, this.nomePorta, this.aliasPolicy);
    }

    @Override
    public int position() throws ProtocolException {
        return this.posizione;
    }

    public ArchiveActivePolicy(AttivazionePolicy policy, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (policy == null) {
            throw new ProtocolException("Policy non fornito");
        }
        if (policy.getAlias() == null) {
            throw new ProtocolException("Policy.alias non definito");
        }
        this.aliasPolicy = policy.getAlias();
        if (policy != null && policy.getFiltro() != null) {
            this.ruoloPorta = policy.getFiltro().getRuoloPorta();
            this.nomePorta = policy.getFiltro().getNomePorta();
        }
        this.policy = policy;
        this.posizione = policy.getPosizione();
        this.policyGlobale = policy.getFiltro() == null || policy.getFiltro().getNomePorta() == null || "".equals(policy.getFiltro().getNomePorta());
        this.idCorrelazione = idCorrelazione;
    }

    public String getAliasPolicy() {
        return this.aliasPolicy;
    }

    public RuoloPolicy getRuoloPorta() {
        return this.ruoloPorta;
    }

    public String getNomePorta() {
        return this.nomePorta;
    }

    public AttivazionePolicy getPolicy() {
        return this.policy;
    }

    public boolean isPolicyGlobale() {
        return this.policyGlobale;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

