/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk;

import java.lang.reflect.Method;
import java.util.List;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.sdk.ModIPDNDClientConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDOrganizationConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.slf4j.Logger;

public class ModIPropertiesUtils {
    public static final String CLASS_MODIPA_PROPERTIES = "org.openspcoop2.protocol.modipa.config.ModIProperties";
    public static final String CLASS_MODIPA_PROPERTIES_GET_INSTANCE_METHOD = "getInstance";
    private static final String API_PDND_CLIENT_CONFIG_METHOD = "getAPIPDNDClientConfig";
    private static final String API_PDND_ORGANIZATION_CONFIG_METHOD = "getAPIPDNDOrganizationConfig";

    private ModIPropertiesUtils() {
    }

    public static Object getModiProperties() throws ProtocolException {
        try {
            Class<?> modiPropertiesClass = Class.forName(CLASS_MODIPA_PROPERTIES);
            Method mGetInstance = modiPropertiesClass.getMethod(CLASS_MODIPA_PROPERTIES_GET_INSTANCE_METHOD, new Class[0]);
            return mGetInstance.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static String getHeaderModI() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetRestSecurityTokenHeaderModI = instance.getClass().getMethod("getRestSecurityTokenHeaderModI", new Class[0]);
            return (String)mGetRestSecurityTokenHeaderModI.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static boolean isTokenOAuthUseJtiIntegrityAsMessageId() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetIsTokenOAuthUseJtiIntegrityAsMessageId = instance.getClass().getMethod("isTokenOAuthUseJtiIntegrityAsMessageId", new Class[0]);
            return (Boolean)mGetIsTokenOAuthUseJtiIntegrityAsMessageId.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDClientConfig = instance.getClass().getMethod(API_PDND_CLIENT_CONFIG_METHOD, new Class[0]);
            return (ModIPDNDClientConfig)mGetAPIPDNDClientConfig.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig(Logger log) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDClientConfig = instance.getClass().getMethod(API_PDND_CLIENT_CONFIG_METHOD, Logger.class);
            return (ModIPDNDClientConfig)mGetAPIPDNDClientConfig.invoke(instance, log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig(String details) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDClientConfig = instance.getClass().getMethod(API_PDND_CLIENT_CONFIG_METHOD, String.class);
            return (ModIPDNDClientConfig)mGetAPIPDNDClientConfig.invoke(instance, details);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDClientConfig getAPIPDNDClientConfig(String details, Logger log) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDClientConfig = instance.getClass().getMethod(API_PDND_CLIENT_CONFIG_METHOD, String.class, Logger.class);
            return (ModIPDNDClientConfig)mGetAPIPDNDClientConfig.invoke(instance, details, log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDOrganizationConfig = instance.getClass().getMethod(API_PDND_ORGANIZATION_CONFIG_METHOD, new Class[0]);
            return (ModIPDNDOrganizationConfig)mGetAPIPDNDOrganizationConfig.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(Logger log) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDOrganizationConfig = instance.getClass().getMethod(API_PDND_ORGANIZATION_CONFIG_METHOD, Logger.class);
            return (ModIPDNDOrganizationConfig)mGetAPIPDNDOrganizationConfig.invoke(instance, log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(String details) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDOrganizationConfig = instance.getClass().getMethod(API_PDND_ORGANIZATION_CONFIG_METHOD, String.class);
            return (ModIPDNDOrganizationConfig)mGetAPIPDNDOrganizationConfig.invoke(instance, details);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static ModIPDNDOrganizationConfig getAPIPDNDOrganizationConfig(String details, Logger log) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetAPIPDNDOrganizationConfig = instance.getClass().getMethod(API_PDND_ORGANIZATION_CONFIG_METHOD, String.class, Logger.class);
            return (ModIPDNDOrganizationConfig)mGetAPIPDNDOrganizationConfig.invoke(instance, details, log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static IDAccordo buildSignalHubPushIdAPI(IDSoggetto idSoggettoDefault) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetSignalHubApiName = instance.getClass().getMethod("getSignalHubApiName", new Class[0]);
            Method mGetSignalHubApiVersion = instance.getClass().getMethod("getSignalHubApiVersion", new Class[0]);
            return IDAccordoFactory.getInstance().getIDAccordoFromValues((String)mGetSignalHubApiName.invoke(instance, new Object[0]), idSoggettoDefault, (Integer)mGetSignalHubApiVersion.invoke(instance, new Object[0]));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static boolean isSignalHubEnabled() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mIsSignalHubEnabled = instance.getClass().getMethod("isSignalHubEnabled", new Class[0]);
            return (Boolean)mIsSignalHubEnabled.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static boolean isTracingPDNDEnabled() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mIsTracingPDNDEnabled = instance.getClass().getMethod("isTracingPDNDEnabled", new Class[0]);
            return (Boolean)mIsTracingPDNDEnabled.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static boolean isTracingPDNDEnabledSafe() {
        try {
            return ModIPropertiesUtils.isTracingPDNDEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<RemoteStoreConfig> getRemoteStoreConfig() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetRemoteStoreConfig = instance.getClass().getMethod("getRemoteStoreConfig", new Class[0]);
            return (List)mGetRemoteStoreConfig.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static RemoteKeyType getRemoteKeyType(String name) throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGetRemoteKey = instance.getClass().getMethod("getRemoteKeyType", String.class);
            return (RemoteKeyType)mGetRemoteKey.invoke(instance, name);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static KeystoreParams getSicurezzaMessaggioCertificatiTrustStore() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGet = instance.getClass().getMethod("getSicurezzaMessaggioCertificatiTrustStore", new Class[0]);
            return (KeystoreParams)mGet.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static KeystoreParams getSicurezzaMessaggioSslTrustStore() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGet = instance.getClass().getMethod("getSicurezzaMessaggioSslTrustStore", new Class[0]);
            return (KeystoreParams)mGet.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static KeystoreParams getSicurezzaMessaggioCertificatiKeyStore() throws ProtocolException {
        try {
            Object instance = ModIPropertiesUtils.getModiProperties();
            Method mGet = instance.getClass().getMethod("getSicurezzaMessaggioCertificatiKeyStore", new Class[0]);
            return (KeystoreParams)mGet.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

