/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.registry;

import com.nimbusds.jose.jwk.JWK;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.StatoCheck;
import org.openspcoop2.protocol.registry.CertificateCheck;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.CRLCertstore;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeyUtils;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPValidatorImpl;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapManager;
import org.slf4j.Logger;

public class CertificateUtils {
    private static final String FORMAT_DATE_CERTIFICATE = "dd/MM/yyyy HH:mm";
    private static final String NOT_EXISTS_STRING = " not exists";
    private static final String CANNOT_READ_STRING = " cannot read";
    private static final String READING_PREFIX_STRING = "Reading ";
    private static final String SERIAL_NUMBER_STRING = " serialNumber:";

    private CertificateUtils() {
    }

    public static String toString(org.openspcoop2.utils.certificate.Certificate certificate, String separator, String newLine) throws UtilsException {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_CERTIFICATE);
        String certificatoSubject = certificate.getCertificate().getSubject().getNameNormalized();
        boolean certificatoSelfSigned = certificate.getCertificate().isSelfSigned();
        String certificatoIssuer = null;
        if (!certificatoSelfSigned) {
            certificatoIssuer = certificate.getCertificate().getIssuer().getNameNormalized();
        }
        sb.append("Subject").append(separator).append(certificatoSubject);
        if (certificatoSelfSigned) {
            sb.append(newLine).append("Self Signed");
        } else {
            sb.append(newLine).append("Issuer").append(separator).append(certificatoIssuer);
        }
        String notBefore = null;
        if (certificate.getCertificate().getNotBefore() != null) {
            notBefore = sdf.format(certificate.getCertificate().getNotBefore());
        }
        String notAfter = null;
        if (certificate.getCertificate().getNotAfter() != null) {
            notAfter = sdf.format(certificate.getCertificate().getNotAfter());
        }
        if (notBefore != null) {
            sb.append(newLine).append("Not Before").append(separator).append(notBefore);
        }
        if (notAfter != null) {
            sb.append(newLine).append("Not After").append(separator).append(notAfter);
        }
        String serialNumberHex = certificate.getCertificate().getSerialNumberHex();
        sb.append(newLine).append("Serial Number").append(separator).append(serialNumberHex);
        return sb.toString();
    }

    public static String toStringKeyStore(KeystoreParams params, String separator, String newLine) {
        return CertificateUtils.toStringEngine(true, params.getKeyAlias(), null, params.getByokPolicy(), params.getPath(), params.getType(), separator, newLine);
    }

    public static String toStringKeyStore(String storePath, String storeType, String byokPolicy, String keyAlias, String separator, String newLine) {
        return CertificateUtils.toStringEngine(true, keyAlias, null, byokPolicy, storePath, storeType, separator, newLine);
    }

    public static String toStringTrustStore(KeystoreParams params, String separator, String newLine) {
        return CertificateUtils.toStringEngine(false, params.getKeyAlias(), params.getCrls(), params.getOcspPolicy(), params.getPath(), params.getType(), separator, newLine);
    }

    public static String toStringTrustStore(String storePath, String storeType, String trustCRL, String ocspPolicy, String separator, String newLine) {
        return CertificateUtils.toStringTrustStore(storePath, storeType, trustCRL, ocspPolicy, null, separator, newLine);
    }

    public static String toStringTrustStore(String storePath, String storeType, String trustCRL, String ocspPolicy, String certAlias, String separator, String newLine) {
        return CertificateUtils.toStringEngine(false, certAlias, trustCRL, ocspPolicy, storePath, storeType, separator, newLine);
    }

    private static String toStringEngine(boolean keystore, String keyAlias, String trustCRL, String policy, String storePath, String storeType, String separator, String newLine) {
        StringBuilder sb = new StringBuilder();
        sb.append(keystore ? "KeyStore" : "TrustStore");
        sb.append(separator);
        boolean hsm = HSMUtils.isKeystoreHSM((String)separator);
        String location = storePath;
        if (hsm) {
            location = "HSM";
        }
        sb.append("(").append(storeType).append(") ").append(location);
        if (!keystore && trustCRL != null) {
            sb.append(newLine);
            sb.append("CRLs");
            sb.append(separator);
            sb.append(trustCRL);
        }
        if (policy != null) {
            sb.append(newLine);
            sb.append(keystore ? "BYOK Policy" : "OCSP Policy");
            sb.append(separator);
            sb.append(policy);
        }
        if (keyAlias != null) {
            sb.append(newLine);
            if (keystore) {
                sb.append("Key Alias");
            } else {
                sb.append("Certificate Alias");
            }
            sb.append(separator);
            sb.append(keyAlias);
        }
        return sb.toString();
    }

    public static KeystoreParams readKeyStoreParamsJVM() {
        KeystoreParams params = null;
        String keyStoreLocation = System.getProperty("javax.net.ssl.keyStore");
        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        if (keyStoreLocation != null || keyStoreType != null) {
            if (keyStoreLocation == null) {
                keyStoreLocation = "NONE";
            }
            if (keyStoreType == null) {
                keyStoreType = KeystoreType.JKS.getNome();
            }
            params = new KeystoreParams();
            params.setPath(keyStoreLocation);
            params.setType(keyStoreType);
            params.setPassword(keyStorePassword);
            params.setKeyPassword(keyStorePassword);
        }
        return params;
    }

    public static KeystoreParams readTrustStoreParamsJVM() {
        KeystoreParams params = null;
        String trustStoreLocation = System.getProperty("javax.net.ssl.trustStore");
        String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        if (trustStoreLocation != null) {
            if (trustStoreType == null) {
                trustStoreType = KeystoreType.JKS.getNome();
            }
            params = new KeystoreParams();
            params.setPath(trustStoreLocation);
            params.setType(trustStoreType);
            params.setPassword(trustStorePassword);
        }
        return params;
    }

    private static String getSuffixCertificateNotValid(Exception t) {
        return " non risulta valido: " + t.getMessage();
    }

    private static String getSuffixFailed(Exception t) {
        return " failed: " + t.getMessage();
    }

    public static CertificateCheck checkCertificateClient(List<byte[]> certs, List<Boolean> strictValidation, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_CERTIFICATE);
        if (certs == null || certs.isEmpty()) {
            throw new UtilsException("Nessun certificato individuato");
        }
        if (strictValidation == null || strictValidation.isEmpty()) {
            throw new UtilsException("Nessuna informazione sul tipo di validazione fornita");
        }
        if (strictValidation.size() != certs.size()) {
            throw new UtilsException("Rilevata inconsistenza tra le informazioni fornite sul tipo di validazione e i certificati");
        }
        CertificateCheck esito = new CertificateCheck();
        boolean error = false;
        boolean warning = false;
        boolean almostOneValid = false;
        for (int i = 0; i < certs.size(); ++i) {
            block21: {
                boolean principale = i == 0;
                org.openspcoop2.utils.certificate.Certificate certificate = null;
                String identitaCertificato = "Certificato " + (String)(principale ? "principale" : "n." + (i + 1));
                Object credenziale = "Certificato";
                if (principale && certs.size() > 1) {
                    credenziale = (String)credenziale + " principale";
                }
                try {
                    long soglia;
                    long now;
                    long expire;
                    long diff;
                    byte[] bytesCert = certs.get(i);
                    boolean strictValidationCert = strictValidation.get(i);
                    certificate = ArchiveLoader.load((byte[])bytesCert);
                    String hex = certificate.getCertificate().getSerialNumberHex();
                    String certificateDetails = null;
                    if (addCertificateDetails) {
                        certificateDetails = CertificateUtils.toString(certificate, separator, newLine);
                    } else {
                        credenziale = (String)credenziale + " (CN:" + certificate.getCertificate().getSubject().getCN() + SERIAL_NUMBER_STRING + hex + ")";
                    }
                    boolean check = true;
                    try {
                        certificate.getCertificate().checkValid();
                    }
                    catch (Exception t) {
                        String msgErrore;
                        check = false;
                        if (strictValidationCert) {
                            msgErrore = (String)credenziale + " non valido: " + t.getMessage();
                            error = true;
                            esito.addError(identitaCertificato, msgErrore, certificateDetails);
                            continue;
                        }
                        msgErrore = (String)credenziale + " utilizzato per attivare la validazione tramite Subject e Issuer non risulta valido: " + t.getMessage();
                        warning = true;
                        esito.addWarning(identitaCertificato, msgErrore, certificateDetails);
                    }
                    if (check && certificate.getCertificateChain() != null && !certificate.getCertificateChain().isEmpty()) {
                        for (CertificateInfo caChain : certificate.getCertificateChain()) {
                            String hexCaChain = caChain.getSerialNumberHex();
                            String credenzialeCaChain = "(CN:" + caChain.getSubject().getCN() + SERIAL_NUMBER_STRING + hexCaChain + ")";
                            try {
                                caChain.checkValid();
                            }
                            catch (Exception t) {
                                check = false;
                                String msgErrore = (String)credenziale + "; un certificato della catena " + credenzialeCaChain + CertificateUtils.getSuffixCertificateNotValid(t);
                                if (strictValidationCert) {
                                    error = true;
                                    esito.addError(identitaCertificato, msgErrore, certificateDetails);
                                    continue;
                                }
                                warning = true;
                                esito.addWarning(identitaCertificato, msgErrore, certificateDetails);
                            }
                        }
                    }
                    if (!check || sogliaWarningGiorni <= 0 || certificate.getCertificate().getNotAfter() == null || (diff = (expire = certificate.getCertificate().getNotAfter().getTime()) - (now = DateManager.getTimeMillis())) >= (soglia = 86400000L * (long)sogliaWarningGiorni)) break block21;
                    String msgErrore = (String)credenziale + " prossima alla scadenza (" + sogliaWarningGiorni + " giorni): " + sdf.format(certificate.getCertificate().getNotAfter());
                    warning = true;
                    esito.addWarning(identitaCertificato, msgErrore, certificateDetails);
                }
                catch (Exception t) {
                    String msgError = "L'analisi del certificato ha prodotto un errore non atteso: " + t.getMessage();
                    esito.addError(identitaCertificato, msgError, null);
                    log.error(msgError, (Throwable)t);
                    error = true;
                    continue;
                }
            }
            almostOneValid = true;
        }
        if (almostOneValid) {
            if (error || warning) {
                esito.setStatoCheck(StatoCheck.WARN);
            } else {
                esito.setStatoCheck(StatoCheck.OK);
            }
        } else {
            esito.setStatoCheck(StatoCheck.ERROR);
        }
        return esito;
    }

    public static CertificateCheck checkTrustStore(String trustStore, boolean classpathSupported, String type, String password, String trustStoreCrls, String ocspPolicy, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        return CertificateUtils.checkTrustStore(trustStore, classpathSupported, type, password, trustStoreCrls, ocspPolicy, null, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
    }

    public static CertificateCheck checkTrustStore(String trustStore, boolean classpathSupported, String type, String password, String trustStoreCrls, String ocspPolicy, String certAlias, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        boolean hsm = HSMUtils.isKeystoreHSM((String)type);
        byte[] keystoreBytes = null;
        if (!hsm) {
            File f = new File(trustStore);
            boolean exists = f.exists();
            boolean inClasspath = false;
            if (!exists && classpathSupported) {
                Object uri = trustStore;
                if (!trustStore.startsWith("/")) {
                    uri = "/" + (String)uri;
                }
                try (InputStream is = CertificateUtils.class.getResourceAsStream((String)uri);){
                    boolean bl = exists = is != null;
                    if (exists) {
                        inClasspath = true;
                        keystoreBytes = Utilities.getAsByteArray((InputStream)is);
                    }
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
            if (!exists || !inClasspath && !f.canRead()) {
                String storeDetails = null;
                if (addCertificateDetails) {
                    storeDetails = CertificateUtils.toStringTrustStore(trustStore, type, trustStoreCrls, ocspPolicy, certAlias, separator, newLine);
                }
                Object errorDetails = "TrustStore";
                if (!addCertificateDetails) {
                    errorDetails = (String)errorDetails + " '" + trustStore + "'";
                }
                errorDetails = (String)errorDetails + (!exists ? NOT_EXISTS_STRING : CANNOT_READ_STRING);
                CertificateCheck esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError(trustStore, (String)errorDetails, storeDetails);
                return esito;
            }
            if (!inClasspath) {
                try {
                    keystoreBytes = FileSystemUtilities.readBytesFromFile((File)f);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return CertificateUtils.checkStore(false, certAlias, null, trustStoreCrls, ocspPolicy, null, trustStore, keystoreBytes, type, password, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
    }

    public static CertificateCheck checkTrustStore(String trustStorePath, byte[] trustStore, String type, String password, String trustStoreCrls, String ocspPolicy, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        return CertificateUtils.checkStore(false, null, null, trustStoreCrls, ocspPolicy, null, trustStorePath != null ? trustStorePath : "Archivio caricato", trustStore, type, password, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
    }

    public static CertificateCheck checkTrustStore(String trustStorePath, byte[] trustStore, String type, String password, String trustStoreCrls, String ocspPolicy, String alias, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        return CertificateUtils.checkStore(false, alias, null, trustStoreCrls, ocspPolicy, null, trustStorePath != null ? trustStorePath : "Archivio caricato", trustStore, type, password, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
    }

    public static CertificateCheck checkKeyStore(String keyStore, boolean classpathSupported, String type, String password, IBYOKUnwrapManager byokUnwrapManager, String aliasKey, String passwordKey, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        boolean hsm = HSMUtils.isKeystoreHSM((String)type);
        byte[] keystoreBytes = null;
        if (!hsm) {
            File f = new File(keyStore);
            boolean exists = f.exists();
            boolean inClasspath = false;
            if (!exists && classpathSupported) {
                Object uri = keyStore;
                if (!keyStore.startsWith("/")) {
                    uri = "/" + (String)uri;
                }
                try (InputStream is = CertificateUtils.class.getResourceAsStream((String)uri);){
                    boolean bl = exists = is != null;
                    if (exists) {
                        inClasspath = true;
                        keystoreBytes = Utilities.getAsByteArray((InputStream)is);
                    }
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
            if (!exists || !inClasspath && !f.canRead()) {
                String storeDetails = null;
                if (addCertificateDetails) {
                    storeDetails = CertificateUtils.toStringKeyStore(keyStore, type, byokUnwrapManager != null ? byokUnwrapManager.getPolicy() : null, aliasKey, separator, newLine);
                }
                Object errorDetails = "KeyStore";
                if (!addCertificateDetails) {
                    errorDetails = (String)errorDetails + " '" + keyStore + "'";
                }
                errorDetails = (String)errorDetails + (!exists ? NOT_EXISTS_STRING : CANNOT_READ_STRING);
                CertificateCheck esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError(keyStore, (String)errorDetails, storeDetails);
                return esito;
            }
            if (!inClasspath) {
                try {
                    keystoreBytes = FileSystemUtilities.readBytesFromFile((File)f);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return CertificateUtils.checkStore(true, aliasKey, passwordKey, null, null, byokUnwrapManager, keyStore, keystoreBytes, type, password, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
    }

    public static CertificateCheck checkKeyStore(String keyStorePath, byte[] keyStore, String type, String password, IBYOKUnwrapManager byokUnwrapManager, String aliasKey, String passwordKey, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        return CertificateUtils.checkStore(true, aliasKey, passwordKey, null, null, byokUnwrapManager, keyStorePath != null ? keyStorePath : "Archivio caricato", keyStore, type, password, sogliaWarningGiorni, addCertificateDetails, separator, newLine, log);
    }

    private static CertificateCheck checkStore(boolean keystore, String aliasKey, String passwordKey, String trustStoreCrls, String ocspPolicy, IBYOKUnwrapManager byokUnwrapManager, String storePath, byte[] storeBytes, String type, String password, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine, Logger log) throws UtilsException {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_CERTIFICATE);
        String storeDetails = "";
        if (addCertificateDetails) {
            storeDetails = keystore ? CertificateUtils.toStringKeyStore(storePath, type, byokUnwrapManager != null ? byokUnwrapManager.getPolicy() : null, aliasKey, separator, newLine) : CertificateUtils.toStringTrustStore(storePath, type, trustStoreCrls, ocspPolicy, aliasKey, separator, newLine);
        }
        KeyStore store = null;
        try {
            if (HSMUtils.isKeystoreHSM((String)type)) {
                store = HSMManager.getInstance().getKeystore(type);
            } else {
                if (keystore && byokUnwrapManager != null) {
                    storeBytes = byokUnwrapManager.unwrap(storeBytes);
                }
                store = new KeyStore(storeBytes, type, password);
            }
        }
        catch (Exception t) {
            CertificateCheck esito = new CertificateCheck();
            esito.setStatoCheck(StatoCheck.ERROR);
            esito.addError(storePath, "Non \u00e8 possibile accedere al " + (keystore ? "KeyStore" : "TrustStore") + ": " + t.getMessage(), storeDetails);
            return esito;
        }
        OCSPValidatorImpl ocspValidator = null;
        CRLCertstore crls = null;
        if (!keystore && (trustStoreCrls != null && StringUtils.isNotEmpty((CharSequence)trustStoreCrls) || ocspPolicy != null && StringUtils.isNotEmpty((CharSequence)ocspPolicy))) {
            boolean crlByOcsp = false;
            if (ocspPolicy != null && StringUtils.isNotEmpty((CharSequence)ocspPolicy)) {
                OCSPValidatorImpl gOcspValidator;
                LoggerBuffer lb = new LoggerBuffer();
                lb.setLogDebug(log);
                lb.setLogError(log);
                OCSPResourceReader ocspResourceReader = new OCSPResourceReader();
                ocspValidator = new OCSPValidatorImpl(lb, store, trustStoreCrls, ocspPolicy, (IOCSPResourceReader)ocspResourceReader);
                if (ocspValidator != null && (gOcspValidator = ocspValidator).getOcspConfig() != null) {
                    crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                }
            }
            List crlList = null;
            if (trustStoreCrls != null && StringUtils.isNotEmpty((CharSequence)trustStoreCrls)) {
                crlList = CRLCertstore.readCrlPaths((String)trustStoreCrls);
            }
            if (crlList != null && !crlList.isEmpty()) {
                for (String path : crlList) {
                    File f = new File(path);
                    if (f.exists() && f.canRead()) continue;
                    Object identita = "CRL";
                    if (addCertificateDetails) {
                        identita = "CRL '" + path + "'";
                    }
                    Object errorDetails = identita;
                    if (!addCertificateDetails) {
                        errorDetails = (String)errorDetails + " '" + path + "'";
                    }
                    errorDetails = (String)errorDetails + (!f.exists() ? NOT_EXISTS_STRING : CANNOT_READ_STRING);
                    CertificateCheck esito = new CertificateCheck();
                    esito.setStatoCheck(StatoCheck.ERROR);
                    esito.addError((String)identita, (String)errorDetails, storeDetails);
                    return esito;
                }
                if (!crlByOcsp) {
                    crls = new CRLCertstore(trustStoreCrls);
                }
            }
        }
        CertificateCheck esito = new CertificateCheck();
        boolean error = false;
        boolean warning = false;
        ArrayList<String> aliasesForCheck = null;
        if (keystore) {
            alias = new ArrayList<String>();
            if (aliasKey != null) {
                alias.add(aliasKey);
            } else {
                try {
                    aliases = store.aliases();
                    while (aliases.hasMoreElements()) {
                        aliasCheck = (String)aliases.nextElement();
                        if (!store.getKeystore().isKeyEntry(aliasCheck)) continue;
                        alias.add(aliasCheck);
                    }
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
            if (alias.isEmpty()) {
                esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError(storePath, "Nel KeyStore non sono presenti chiavi private", storeDetails);
                return esito;
            }
            aliasesForCheck = alias;
        } else {
            alias = new ArrayList();
            if (aliasKey != null) {
                alias.add(aliasKey);
            } else {
                aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    aliasCheck = (String)aliases.nextElement();
                    alias.add(aliasCheck);
                }
            }
            if (alias.isEmpty()) {
                esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError(storePath, "Nel TrustStore non sono presenti certificati", storeDetails);
                return esito;
            }
            aliasesForCheck = alias;
        }
        ArrayList<org.openspcoop2.utils.certificate.Certificate> listCertificate = new ArrayList<org.openspcoop2.utils.certificate.Certificate>();
        if (aliasesForCheck != null && !aliasesForCheck.isEmpty()) {
            for (String aliasVerify : aliasesForCheck) {
                boolean secret = KeystoreType.JCEKS.getNome().equalsIgnoreCase(store.getKeystoreType());
                X509Certificate cert = (X509Certificate)store.getCertificate(aliasVerify);
                SecretKey secretKey = null;
                if (cert == null && secret && store.existsAlias(aliasKey)) {
                    String errorKey = null;
                    try {
                        secretKey = store.getSecretKey(aliasVerify, passwordKey);
                    }
                    catch (Exception e) {
                        errorKey = e.getMessage();
                    }
                    if (secretKey == null) {
                        esito = new CertificateCheck();
                        esito.setStatoCheck(StatoCheck.ERROR);
                        esito.addError(storePath, "Nel KeyStore la chiave segreta  con alias '" + aliasVerify + "' non \u00e8 accessibile" + (String)(errorKey != null ? ": " + errorKey : ""), storeDetails);
                        return esito;
                    }
                }
                if (cert == null && secretKey == null) {
                    esito = new CertificateCheck();
                    esito.setStatoCheck(StatoCheck.ERROR);
                    esito.addError(storePath, "Nel " + (keystore ? "KeyStore" : "TrustStore") + " non \u00e8 presente " + (keystore ? "una coppia di chiavi" : "un certificato") + " con alias '" + aliasVerify + "'", storeDetails);
                    return esito;
                }
                if (keystore && secretKey == null) {
                    PrivateKey privateKey = null;
                    String errorKey = null;
                    try {
                        privateKey = store.getPrivateKey(aliasVerify, passwordKey);
                    }
                    catch (Exception e) {
                        errorKey = e.getMessage();
                    }
                    if (privateKey == null) {
                        esito = new CertificateCheck();
                        esito.setStatoCheck(StatoCheck.ERROR);
                        esito.addError(storePath, "Nel KeyStore la chiave  con alias '" + aliasVerify + "' non \u00e8 accessibile" + (String)(errorKey != null ? ": " + errorKey : ""), storeDetails);
                        return esito;
                    }
                }
                if (secretKey != null) continue;
                Certificate[] baseCertChain = store.getCertificateChain(aliasVerify);
                ArrayList<X509Certificate> certChain = null;
                if (baseCertChain != null && baseCertChain.length > 0) {
                    for (int i = 0; i < baseCertChain.length; ++i) {
                        Certificate check = baseCertChain[i];
                        if (!(check instanceof X509Certificate)) continue;
                        if (certChain == null) {
                            certChain = new ArrayList<X509Certificate>();
                        }
                        certChain.add((X509Certificate)check);
                    }
                }
                org.openspcoop2.utils.certificate.Certificate certificate = new org.openspcoop2.utils.certificate.Certificate(aliasVerify, cert, certChain);
                listCertificate.add(certificate);
            }
        }
        if (listCertificate != null && !listCertificate.isEmpty()) {
            for (org.openspcoop2.utils.certificate.Certificate certificate : listCertificate) {
                long soglia;
                long now;
                long expire;
                long diff;
                boolean check;
                Object certificateDetails;
                String identita;
                block57: {
                    String aliasVerify = certificate.getCertificate().getName();
                    identita = "Certificato '" + aliasVerify + "'";
                    Object aliasDetails = "";
                    if (!storeDetails.contains("Key Alias" + separator + aliasVerify)) {
                        aliasDetails = (addCertificateDetails ? newLine : "") + "Alias" + separator + aliasVerify;
                    }
                    certificateDetails = CertificateUtils.toString(certificate, separator, newLine);
                    certificateDetails = storeDetails + (String)aliasDetails + newLine + (String)certificateDetails;
                    check = true;
                    try {
                        if (keystore || crls == null) {
                            certificate.getCertificate().checkValid();
                        } else {
                            certificate.getCertificate().checkValid(crls.getCertStore(), store);
                        }
                        if (ocspValidator == null) break block57;
                        ocspValidator.valid(certificate.getCertificate().getCertificate());
                    }
                    catch (Exception t) {
                        String msgErrore = "Certificato non valido: " + t.getMessage();
                        error = true;
                        esito.addError(identita, msgErrore, (String)certificateDetails);
                        continue;
                    }
                }
                if (check && certificate.getCertificateChain() != null && !certificate.getCertificateChain().isEmpty()) {
                    for (CertificateInfo caChain : certificate.getCertificateChain()) {
                        String hexCaChain = caChain.getSerialNumberHex();
                        String credenzialeCaChain = "(CN:" + caChain.getSubject().getCN() + SERIAL_NUMBER_STRING + hexCaChain + ")";
                        try {
                            if (keystore || crls == null) {
                                caChain.checkValid();
                                continue;
                            }
                            caChain.checkValid(crls.getCertStore(), store);
                        }
                        catch (Exception t) {
                            check = false;
                            String msgErrore = "Un certificato della catena " + credenzialeCaChain + CertificateUtils.getSuffixCertificateNotValid(t);
                            error = true;
                            esito.addError(identita, msgErrore, (String)certificateDetails);
                        }
                    }
                }
                if (!check || sogliaWarningGiorni <= 0 || certificate.getCertificate().getNotAfter() == null || (diff = (expire = certificate.getCertificate().getNotAfter().getTime()) - (now = DateManager.getTimeMillis())) >= (soglia = 86400000L * (long)sogliaWarningGiorni)) continue;
                String msgErrore = "Certificato prossima alla scadenza (" + sogliaWarningGiorni + " giorni): " + sdf.format(certificate.getCertificate().getNotAfter());
                warning = true;
                esito.addWarning(identita, msgErrore, (String)certificateDetails);
            }
        }
        if (error) {
            esito.setStatoCheck(StatoCheck.ERROR);
        } else if (warning) {
            esito.setStatoCheck(StatoCheck.WARN);
        } else {
            esito.setStatoCheck(StatoCheck.OK);
        }
        return esito;
    }

    public static CertificateCheck checkSingleCertificate(String storeDetails, byte[] bytesCert, int sogliaWarningGiorni, String separator, String newLine) throws UtilsException {
        long soglia;
        long now;
        long expire;
        long diff;
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_CERTIFICATE);
        CertificateCheck esito = new CertificateCheck();
        boolean error = false;
        boolean warning = false;
        org.openspcoop2.utils.certificate.Certificate certificate = ArchiveLoader.load((byte[])bytesCert);
        String identita = "Certificato";
        String certificateDetails = storeDetails + newLine + CertificateUtils.toString(certificate, separator, newLine);
        boolean check = true;
        try {
            certificate.getCertificate().checkValid();
        }
        catch (Exception t) {
            check = false;
            String msgErrore = "Certificato non valido: " + t.getMessage();
            error = true;
            esito.addError(identita, msgErrore, certificateDetails);
        }
        if (check && certificate.getCertificateChain() != null && !certificate.getCertificateChain().isEmpty()) {
            for (CertificateInfo caChain : certificate.getCertificateChain()) {
                String hexCaChain = caChain.getSerialNumberHex();
                String credenzialeCaChain = "(CN:" + caChain.getSubject().getCN() + SERIAL_NUMBER_STRING + hexCaChain + ")";
                try {
                    caChain.checkValid();
                }
                catch (Exception t) {
                    check = false;
                    String msgErrore = "Un certificato della catena " + credenzialeCaChain + CertificateUtils.getSuffixCertificateNotValid(t);
                    error = true;
                    esito.addError(identita, msgErrore, certificateDetails);
                }
            }
        }
        if (check && sogliaWarningGiorni > 0 && certificate.getCertificate().getNotAfter() != null && (diff = (expire = certificate.getCertificate().getNotAfter().getTime()) - (now = DateManager.getTimeMillis())) < (soglia = 86400000L * (long)sogliaWarningGiorni)) {
            String msgErrore = "Certificato prossima alla scadenza (" + sogliaWarningGiorni + " giorni): " + sdf.format(certificate.getCertificate().getNotAfter());
            warning = true;
            esito.addWarning(identita, msgErrore, certificateDetails);
        }
        if (error) {
            esito.setStatoCheck(StatoCheck.ERROR);
        } else if (warning) {
            esito.setStatoCheck(StatoCheck.WARN);
        } else {
            esito.setStatoCheck(StatoCheck.OK);
        }
        return esito;
    }

    public static CertificateCheck checkKeyPair(String privateKeyPath, byte[] privateKey, String publicKeyPath, byte[] publicKey, String passwordKey, String algorithm, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        String storeDetails = null;
        if (addCertificateDetails) {
            storeDetails = CertificateUtils.toStringKeyPair(privateKeyPath, publicKeyPath, byokUnwrapManager != null ? byokUnwrapManager.getPolicy() : null, separator, newLine);
        }
        return CertificateUtils.checkKeyPairEngine(true, storeDetails, privateKey, publicKey, passwordKey, algorithm, byokUnwrapManager, addCertificateDetails);
    }

    public static CertificateCheck checkKeyPair(boolean classpathSupported, String privateKey, String publicKey, String passwordKey, String algorithm, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        return CertificateUtils.checkKeyPairEngine(true, classpathSupported, privateKey, publicKey, passwordKey, algorithm, byokUnwrapManager, addCertificateDetails, separator, newLine);
    }

    public static String toStringKeyPair(KeystoreParams params, String separator, String newLine) {
        return CertificateUtils.toStringKeyPair(params.getPath(), params.getKeyPairPublicKeyPath(), params.getByokPolicy(), separator, newLine);
    }

    private static String toStringKeyPair(String privateKey, String publicKey, String byokPolicy, String separator, String newLine) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key Pair");
        sb.append(separator);
        sb.append("private:");
        sb.append(privateKey);
        sb.append(" ");
        sb.append("public:");
        sb.append(publicKey);
        if (byokPolicy != null) {
            sb.append(newLine);
            sb.append("BYOK Policy");
            sb.append(separator);
            sb.append(byokPolicy);
        }
        return sb.toString();
    }

    public static CertificateCheck checkPublicKey(String publicKeyPath, byte[] publicKey, String algorithm, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        String storeDetails = null;
        if (addCertificateDetails) {
            storeDetails = CertificateUtils.toStringPublicKey(publicKeyPath, separator, newLine);
        }
        return CertificateUtils.checkKeyPairEngine(false, storeDetails, null, publicKey, null, algorithm, null, addCertificateDetails);
    }

    public static CertificateCheck checkPublicKey(boolean classpathSupported, String publicKey, String algorithm, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        return CertificateUtils.checkKeyPairEngine(false, classpathSupported, null, publicKey, null, algorithm, null, addCertificateDetails, separator, newLine);
    }

    public static String toStringPublicKey(KeystoreParams params, String separator, String newLine) {
        return CertificateUtils.toStringPublicKey(params.getPath(), separator, newLine);
    }

    private static String toStringPublicKey(String publicKey, String separator, String newLine) {
        if (newLine != null) {
            // empty if block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Public Key");
        sb.append(separator);
        sb.append(publicKey);
        return sb.toString();
    }

    private static CertificateCheck checkKeyPairEngine(boolean isKeyPair, boolean classpathSupported, String privateKey, String publicKey, String passwordKey, String algorithm, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        String storeDetails = null;
        if (addCertificateDetails) {
            storeDetails = isKeyPair ? CertificateUtils.toStringKeyPair(privateKey, publicKey, byokUnwrapManager != null ? byokUnwrapManager.getPolicy() : null, separator, newLine) : CertificateUtils.toStringPublicKey(publicKey, separator, newLine);
        }
        byte[] privateKeyBytes = null;
        if (isKeyPair) {
            File f = new File(privateKey);
            boolean exists = f.exists();
            boolean inClasspath = false;
            if (!exists && classpathSupported) {
                Object uri = privateKey;
                if (!privateKey.startsWith("/")) {
                    uri = "/" + (String)uri;
                }
                try (InputStream is = CertificateUtils.class.getResourceAsStream((String)uri);){
                    boolean bl = exists = is != null;
                    if (exists) {
                        inClasspath = true;
                        privateKeyBytes = Utilities.getAsByteArray((InputStream)is);
                    }
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
            if (!exists || !inClasspath && !f.canRead()) {
                Object errorDetails = "Private Key";
                if (!addCertificateDetails) {
                    errorDetails = (String)errorDetails + " '" + privateKey + "'";
                }
                errorDetails = (String)errorDetails + (!exists ? NOT_EXISTS_STRING : CANNOT_READ_STRING);
                CertificateCheck esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError(privateKey, (String)errorDetails, storeDetails);
                return esito;
            }
            if (!inClasspath) {
                try {
                    privateKeyBytes = FileSystemUtilities.readBytesFromFile((File)f);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), (Throwable)e);
                }
            }
        }
        byte[] publicKeyBytes = null;
        File f = new File(publicKey);
        boolean exists = f.exists();
        boolean inClasspath = false;
        if (!exists && classpathSupported) {
            Object uri = publicKey;
            if (!publicKey.startsWith("/")) {
                uri = "/" + (String)uri;
            }
            try (InputStream is = CertificateUtils.class.getResourceAsStream((String)uri);){
                boolean bl = exists = is != null;
                if (exists) {
                    inClasspath = true;
                    publicKeyBytes = Utilities.getAsByteArray((InputStream)is);
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        if (!exists || !inClasspath && !f.canRead()) {
            Object errorDetails = "Public Key";
            if (!addCertificateDetails) {
                errorDetails = (String)errorDetails + " '" + publicKey + "'";
            }
            errorDetails = (String)errorDetails + (!exists ? NOT_EXISTS_STRING : CANNOT_READ_STRING);
            CertificateCheck esito = new CertificateCheck();
            esito.setStatoCheck(StatoCheck.ERROR);
            esito.addError(publicKey, (String)errorDetails, storeDetails);
            return esito;
        }
        if (!inClasspath) {
            try {
                publicKeyBytes = FileSystemUtilities.readBytesFromFile((File)f);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        return CertificateUtils.checkKeyPairEngine(isKeyPair, storeDetails, privateKeyBytes, publicKeyBytes, passwordKey, algorithm, byokUnwrapManager, addCertificateDetails);
    }

    private static CertificateCheck checkKeyPairEngine(boolean isKeyPair, String storeDetails, byte[] privateKey, byte[] publicKey, String passwordKey, String algorithm, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails) throws UtilsException {
        KeyUtils keyUtils = null;
        try {
            keyUtils = KeyUtils.getInstance((String)algorithm);
        }
        catch (Exception t) {
            Object errorDetails = "KeyAlgorithm";
            if (!addCertificateDetails) {
                errorDetails = (String)errorDetails + " '" + algorithm + "'";
            }
            errorDetails = (String)errorDetails + " unknown: " + t.getMessage();
            CertificateCheck esito = new CertificateCheck();
            esito.setStatoCheck(StatoCheck.ERROR);
            esito.addError(algorithm, (String)errorDetails, storeDetails);
            return esito;
        }
        if (isKeyPair) {
            try {
                if (byokUnwrapManager != null) {
                    privateKey = byokUnwrapManager.unwrap(privateKey);
                }
                if (passwordKey != null) {
                    keyUtils.getPrivateKey(privateKey, passwordKey);
                } else {
                    keyUtils.getPrivateKey(privateKey);
                }
            }
            catch (Exception t) {
                String errorDetails = "Reading Private Key" + CertificateUtils.getSuffixFailed(t);
                CertificateCheck esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError("Private Key", errorDetails, storeDetails);
                return esito;
            }
        }
        try {
            keyUtils.getPublicKey(publicKey);
        }
        catch (Exception t) {
            String errorDetails = "Reading Public Key" + CertificateUtils.getSuffixFailed(t);
            CertificateCheck esito = new CertificateCheck();
            esito.setStatoCheck(StatoCheck.ERROR);
            esito.addError("Public Key", errorDetails, storeDetails);
            return esito;
        }
        CertificateCheck esito = new CertificateCheck();
        esito.setStatoCheck(StatoCheck.OK);
        return esito;
    }

    public static CertificateCheck checkKeystoreJWKs(boolean classpathSupported, String jwksPath, String keyAlias, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        return CertificateUtils.checkJWKsEngine(true, classpathSupported, jwksPath, keyAlias, byokUnwrapManager, addCertificateDetails, separator, newLine);
    }

    public static CertificateCheck checkKeystoreJWKs(String jwksPath, String jwks, String keyAlias, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        String storeDetails = null;
        if (addCertificateDetails) {
            storeDetails = CertificateUtils.toStringJWKs(true, jwksPath, keyAlias, byokUnwrapManager != null ? byokUnwrapManager.getPolicy() : null, separator, newLine);
        }
        return CertificateUtils.checkJWKsEngine(false, storeDetails, jwks, keyAlias, byokUnwrapManager);
    }

    public static CertificateCheck checkTruststoreJWKs(boolean classpathSupported, String jwksPath, String keyAlias, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        return CertificateUtils.checkJWKsEngine(false, classpathSupported, jwksPath, keyAlias, null, addCertificateDetails, separator, newLine);
    }

    public static CertificateCheck checkTruststoreJWKs(String jwksPath, String jwks, String keyAlias, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        String storeDetails = null;
        if (addCertificateDetails) {
            storeDetails = CertificateUtils.toStringJWKs(false, jwksPath, keyAlias, null, separator, newLine);
        }
        return CertificateUtils.checkJWKsEngine(false, storeDetails, jwks, keyAlias, null);
    }

    private static CertificateCheck checkJWKsEngine(boolean keystore, boolean classpathSupported, String jwksPath, String keyAlias, IBYOKUnwrapManager byokUnwrapManager, boolean addCertificateDetails, String separator, String newLine) throws UtilsException {
        String storeDetails = null;
        if (addCertificateDetails) {
            storeDetails = CertificateUtils.toStringJWKs(keystore, jwksPath, keyAlias, byokUnwrapManager != null ? byokUnwrapManager.getPolicy() : null, separator, newLine);
        }
        String jwks = null;
        File f = new File(jwksPath);
        boolean exists = f.exists();
        boolean inClasspath = false;
        if (!exists && classpathSupported) {
            Object uri = jwksPath;
            if (!jwksPath.startsWith("/")) {
                uri = "/" + (String)uri;
            }
            try (InputStream is = CertificateUtils.class.getResourceAsStream((String)uri);){
                boolean bl = exists = is != null;
                if (exists) {
                    inClasspath = true;
                    jwks = Utilities.getAsString((InputStream)is, (String)Charset.UTF_8.getValue());
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        if (!exists || !inClasspath && !f.canRead()) {
            Object errorDetails;
            Object object = errorDetails = keystore ? "KeyStore" : "TrustStore";
            if (!addCertificateDetails) {
                errorDetails = (String)errorDetails + " '" + jwksPath + "'";
            }
            errorDetails = (String)errorDetails + (!exists ? NOT_EXISTS_STRING : CANNOT_READ_STRING);
            CertificateCheck esito = new CertificateCheck();
            esito.setStatoCheck(StatoCheck.ERROR);
            esito.addError(jwksPath, (String)errorDetails, storeDetails);
            return esito;
        }
        if (!inClasspath) {
            try {
                jwks = FileSystemUtilities.readFile((File)f);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        return CertificateUtils.checkJWKsEngine(keystore, storeDetails, jwks, keyAlias, byokUnwrapManager);
    }

    private static CertificateCheck checkJWKsEngine(boolean keystore, String storeDetails, String jwks, String keyAlias, IBYOKUnwrapManager byokUnwrapManager) throws UtilsException {
        com.nimbusds.jose.jwk.JWKSet set = null;
        try {
            if (keystore && byokUnwrapManager != null) {
                jwks = new String(byokUnwrapManager.unwrap(jwks.getBytes()));
            }
            JWKSet jwkset = new JWKSet(jwks);
            set = jwkset.getJWKSet();
        }
        catch (Exception t) {
            String errorDetails = READING_PREFIX_STRING + (keystore ? "KeyStore" : "TrustStore") + CertificateUtils.getSuffixFailed(t);
            CertificateCheck esito = new CertificateCheck();
            esito.setStatoCheck(StatoCheck.ERROR);
            esito.addError(keystore ? "KeyStore" : "TrustStore", errorDetails, storeDetails);
            return esito;
        }
        CertificateCheck checkAlias = CertificateUtils.checkJWKsEngineKeyAlias(keyAlias, set, keystore, storeDetails);
        if (checkAlias != null) {
            return checkAlias;
        }
        CertificateCheck esito = new CertificateCheck();
        esito.setStatoCheck(StatoCheck.OK);
        return esito;
    }

    private static CertificateCheck checkJWKsEngineKeyAlias(String keyAlias, com.nimbusds.jose.jwk.JWKSet set, boolean keystore, String storeDetails) {
        if (keyAlias != null && StringUtils.isNotEmpty((CharSequence)keyAlias) && !"*".equals(keyAlias)) {
            try {
                JWK jwk = set.getKeyByKeyId(keyAlias);
                if (jwk == null) {
                    throw new UtilsException("kid not exists");
                }
            }
            catch (Exception t) {
                String errorDetails = (keystore ? "Key Alias" : "Certificate Alias") + " unknown: " + t.getMessage();
                CertificateCheck esito = new CertificateCheck();
                esito.setStatoCheck(StatoCheck.ERROR);
                esito.addError(keystore ? "KeyStore" : "TrustStore", errorDetails, storeDetails);
                return esito;
            }
        }
        return null;
    }

    public static String toStringKeystoreJWKs(KeystoreParams params, String separator, String newLine) {
        return CertificateUtils.toStringJWKs(true, params.getPath(), params.getKeyAlias(), params.getByokPolicy(), separator, newLine);
    }

    public static String toStringTruststoreJWKs(KeystoreParams params, String separator, String newLine) {
        return CertificateUtils.toStringJWKs(false, params.getPath(), params.getKeyAlias(), null, separator, newLine);
    }

    private static String toStringJWKs(boolean keystore, String jwksPath, String keyAlias, String byokPolicy, String separator, String newLine) {
        StringBuilder sb = new StringBuilder();
        sb.append(keystore ? "KeyStore" : "TrustStore");
        sb.append(separator);
        sb.append("JWKs");
        sb.append(" ");
        sb.append(jwksPath);
        if (keyAlias != null) {
            sb.append(newLine);
            if (keystore) {
                sb.append("Key Alias");
            } else {
                sb.append("Certificate Alias");
            }
            sb.append(separator);
            sb.append(keyAlias);
        }
        if (byokPolicy != null) {
            sb.append(newLine);
            sb.append("BYOK Policy");
            sb.append(separator);
            sb.append(byokPolicy);
        }
        return sb.toString();
    }
}

