/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.tracciamento;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openspcoop2.core.tracciamento.Eccezione;
import org.openspcoop2.core.tracciamento.Proprieta;
import org.openspcoop2.core.tracciamento.Riscontro;
import org.openspcoop2.core.tracciamento.Traccia;
import org.openspcoop2.core.tracciamento.Trasmissione;
import org.openspcoop2.core.tracciamento.constants.TipoCodificaEccezione;
import org.openspcoop2.core.tracciamento.constants.TipoInoltro;
import org.openspcoop2.core.tracciamento.constants.TipoProfiloCollaborazione;
import org.openspcoop2.core.tracciamento.constants.TipoRilevanzaEccezione;
import org.openspcoop2.core.tracciamento.constants.TipoTempo;
import org.openspcoop2.core.tracciamento.utils.XMLUtils;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.tracciamento.TracciaXMLRootElement;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.XMLRootElement;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ContestoCodificaEccezione;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.SubCodiceErrore;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.TracciaExtInfo;
import org.openspcoop2.protocol.sdk.tracciamento.TracciaExtInfoDefinition;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.w3c.dom.Element;

public class TracciaSerializer
extends BasicComponentFactory
implements ITracciaSerializer {
    protected AbstractXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
    private boolean prettyDocument = false;
    private boolean omitXmlDeclaration = false;

    public TracciaSerializer(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    @Override
    public void setPrettyDocument(boolean v) {
        this.prettyDocument = v;
    }

    @Override
    public boolean isPrettyDocument() {
        return this.prettyDocument;
    }

    @Override
    public void setOmitXmlDeclaration(boolean v) {
        this.omitXmlDeclaration = v;
    }

    @Override
    public boolean isOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Traccia toTraccia(org.openspcoop2.protocol.sdk.tracciamento.Traccia tracciaObject) throws ProtocolException {
        String tmpId = null;
        Traccia tracciaBase = null;
        try {
            if (tracciaObject.sizeProperties() > 0) {
                tmpId = tracciaObject.removeProperty("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@");
            }
            if ((tracciaBase = tracciaObject.getTraccia()) != null && tracciaBase.getBustaRaw() == null) {
                if (tracciaObject.getBustaAsByteArray() != null) {
                    tracciaBase.setBustaRaw(new String(tracciaObject.getBustaAsByteArray()));
                } else if (tracciaObject.getBustaAsRawContent() != null) {
                    try {
                        tracciaBase.setBustaRaw(tracciaObject.getBustaAsRawContent().toString(TipoSerializzazione.DEFAULT));
                    }
                    catch (Exception e) {
                        throw new ProtocolException("Serializzazione RawContent non riuscita: " + e.getMessage(), e);
                    }
                }
            }
            ITraduttore protocolTraduttore = this.protocolFactory.createTraduttore();
            if (tracciaBase != null && tracciaBase.getBusta() != null) {
                if (tracciaBase.getBusta().getProfiloCollaborazione() != null && tracciaBase.getBusta().getProfiloCollaborazione().getBase() == null && tracciaBase.getBusta().getProfiloCollaborazione().getTipo() != null) {
                    tracciaBase.getBusta().getProfiloCollaborazione().setBase(this.getBaseValueProfiloCollaborazione(protocolTraduttore, tracciaBase.getBusta().getProfiloCollaborazione().getTipo()));
                }
                if (tracciaBase.getBusta().getProfiloTrasmissione() != null && tracciaBase.getBusta().getProfiloTrasmissione().getInoltro() != null && tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().getBase() == null && tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().getTipo() != null) {
                    tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().setBase(this.getBaseValueInoltro(protocolTraduttore, tracciaBase.getBusta().getProfiloTrasmissione().getInoltro().getTipo()));
                }
                if (tracciaBase.getBusta().getOraRegistrazione() != null && tracciaBase.getBusta().getOraRegistrazione().getSorgente() != null && tracciaBase.getBusta().getOraRegistrazione().getSorgente().getBase() == null && tracciaBase.getBusta().getOraRegistrazione().getSorgente().getTipo() != null) {
                    tracciaBase.getBusta().getOraRegistrazione().getSorgente().setBase(this.getBaseValueTipoTempo(protocolTraduttore, tracciaBase.getBusta().getOraRegistrazione().getSorgente().getTipo()));
                }
                if (tracciaBase.getBusta().getTrasmissioni() != null && tracciaBase.getBusta().getTrasmissioni().sizeTrasmissioneList() > 0) {
                    for (Trasmissione trasmissione : tracciaBase.getBusta().getTrasmissioni().getTrasmissioneList()) {
                        if (trasmissione.getOraRegistrazione() == null || trasmissione.getOraRegistrazione().getSorgente() == null || trasmissione.getOraRegistrazione().getSorgente().getBase() != null || trasmissione.getOraRegistrazione().getSorgente().getTipo() == null) continue;
                        trasmissione.getOraRegistrazione().getSorgente().setBase(this.getBaseValueTipoTempo(protocolTraduttore, trasmissione.getOraRegistrazione().getSorgente().getTipo()));
                    }
                }
                if (tracciaBase.getBusta().getRiscontri() != null && tracciaBase.getBusta().getRiscontri().sizeRiscontroList() > 0) {
                    for (Riscontro riscontro : tracciaBase.getBusta().getRiscontri().getRiscontroList()) {
                        if (riscontro.getOraRegistrazione() == null || riscontro.getOraRegistrazione().getSorgente() == null || riscontro.getOraRegistrazione().getSorgente().getBase() != null || riscontro.getOraRegistrazione().getSorgente().getTipo() == null) continue;
                        riscontro.getOraRegistrazione().getSorgente().setBase(this.getBaseValueTipoTempo(protocolTraduttore, riscontro.getOraRegistrazione().getSorgente().getTipo()));
                    }
                }
                if (tracciaBase.getBusta().getEccezioni() != null && tracciaBase.getBusta().getEccezioni().sizeEccezioneList() > 0) {
                    for (Eccezione eccezione : tracciaBase.getBusta().getEccezioni().getEccezioneList()) {
                        if (eccezione.getCodice() != null && eccezione.getCodice().getBase() == null && eccezione.getCodice().getTipo() != null) {
                            eccezione.getCodice().setBase(this.getBaseValueCodiceEccezione(protocolTraduttore, eccezione.getCodice().getTipo(), eccezione.getCodice().getSottotipo()));
                        }
                        if (eccezione.getContestoCodifica() != null && eccezione.getContestoCodifica().getBase() == null && eccezione.getContestoCodifica().getTipo() != null) {
                            eccezione.getContestoCodifica().setBase(this.getBaseValueContestoCodifica(protocolTraduttore, eccezione.getContestoCodifica().getTipo()));
                        }
                        if (eccezione.getRilevanza() == null || eccezione.getRilevanza().getBase() != null || eccezione.getRilevanza().getTipo() == null) continue;
                        eccezione.getRilevanza().setBase(this.getBaseValueRilevanzaEccezione(protocolTraduttore, eccezione.getRilevanza().getTipo()));
                    }
                }
            }
        }
        catch (Exception e) {
            this.logAndThrowError(e, "XMLBuilder.buildElement_Tracciamento error");
        }
        finally {
            if (tmpId != null && tracciaObject != null) {
                tracciaObject.addProperty("@@@@@-----@@@@-----IDTRACCIA-DB----@@@@@-----@@@@", tmpId);
            }
        }
        return tracciaBase;
    }

    private void logAndThrowError(Exception e, String msg) throws ProtocolException {
        String er = msg + ": " + e.getMessage();
        this.log.error(er, (Throwable)e);
        throw new ProtocolException(er, e);
    }

    @Override
    public Element toElement(org.openspcoop2.protocol.sdk.tracciamento.Traccia tracciaObject) throws ProtocolException {
        byte[] traccia = this.toByteArray(tracciaObject, TipoSerializzazione.XML);
        Element el = null;
        try {
            el = this.xmlUtils.newElement(traccia);
        }
        catch (Exception e) {
            this.logAndThrowError(e, "TracciaSerializer.toElement error");
        }
        return el;
    }

    @Override
    public String toString(org.openspcoop2.protocol.sdk.tracciamento.Traccia traccia, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.toByteArrayOutputStream(traccia, tipoSerializzazione).toString();
    }

    @Override
    public byte[] toByteArray(org.openspcoop2.protocol.sdk.tracciamento.Traccia traccia, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        return this.toByteArrayOutputStream(traccia, tipoSerializzazione).toByteArray();
    }

    protected ByteArrayOutputStream toByteArrayOutputStream(org.openspcoop2.protocol.sdk.tracciamento.Traccia traccia, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        ByteArrayOutputStream ret = null;
        try {
            Traccia tracciaBase = this.toTraccia(traccia);
            if (TipoSerializzazione.JSON.equals(tipoSerializzazione)) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                String s = XMLUtils.generateTracciaAsJson((Traccia)tracciaBase, (boolean)this.prettyDocument);
                bout.write(s.getBytes());
                bout.flush();
                bout.close();
                ret = bout;
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                XMLUtils.generateTraccia((Traccia)tracciaBase, (OutputStream)bout, (boolean)this.prettyDocument, (boolean)this.omitXmlDeclaration);
                bout.flush();
                bout.close();
                ret = bout;
            }
        }
        catch (Exception e) {
            this.logAndThrowError(e, "TracciaSerializer.toString error");
        }
        return ret;
    }

    public org.openspcoop2.protocol.sdk.tracciamento.Traccia toTraccia(String msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        try {
            if (TipoSerializzazione.JSON.equals(tipoSerializzazione)) {
                return new org.openspcoop2.protocol.sdk.tracciamento.Traccia(XMLUtils.toTracciaFromJson((String)msgDiag));
            }
            return new org.openspcoop2.protocol.sdk.tracciamento.Traccia(XMLUtils.toTracciaFromXml((String)msgDiag));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public org.openspcoop2.protocol.sdk.tracciamento.Traccia toTraccia(byte[] msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        try {
            if (TipoSerializzazione.JSON.equals(tipoSerializzazione)) {
                return new org.openspcoop2.protocol.sdk.tracciamento.Traccia(XMLUtils.toTracciaFromJson((byte[])msgDiag));
            }
            return new org.openspcoop2.protocol.sdk.tracciamento.Traccia(XMLUtils.toTracciaFromXml((byte[])msgDiag));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    private String getBaseValueProfiloCollaborazione(ITraduttore protocolTraduttore, TipoProfiloCollaborazione tipoProfiloCollaborazione) {
        switch (tipoProfiloCollaborazione) {
            case ONEWAY: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.ONEWAY);
            }
            case SINCRONO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.SINCRONO);
            }
            case ASINCRONO_ASIMMETRICO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
            }
            case ASINCRONO_SIMMETRICO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(ProfiloDiCollaborazione.UNKNOWN);
            }
        }
        return null;
    }

    private String getBaseValueInoltro(ITraduttore protocolTraduttore, TipoInoltro tipoInoltro) {
        switch (tipoInoltro) {
            case INOLTRO_CON_DUPLICATI: {
                return protocolTraduttore.toString(Inoltro.CON_DUPLICATI);
            }
            case INOLTRO_SENZA_DUPLICATI: {
                return protocolTraduttore.toString(Inoltro.SENZA_DUPLICATI);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(Inoltro.UNKNOWN);
            }
        }
        return null;
    }

    private String getBaseValueTipoTempo(ITraduttore protocolTraduttore, TipoTempo tipoTempo) {
        switch (tipoTempo) {
            case LOCALE: {
                return protocolTraduttore.toString(TipoOraRegistrazione.LOCALE);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(TipoOraRegistrazione.UNKNOWN);
            }
            case SINCRONIZZATO: {
                return protocolTraduttore.toString(TipoOraRegistrazione.SINCRONIZZATO);
            }
        }
        return null;
    }

    private String getBaseValueCodiceEccezione(ITraduttore protocolTraduttore, Integer codice, Integer subCodice) {
        CodiceErroreCooperazione errore = CodiceErroreCooperazione.toCodiceErroreCooperazione(codice);
        if (subCodice == null) {
            return protocolTraduttore.toString(errore);
        }
        SubCodiceErrore sub = new SubCodiceErrore();
        sub.setSubCodice(subCodice);
        return protocolTraduttore.toString(errore, sub);
    }

    private String getBaseValueContestoCodifica(ITraduttore protocolTraduttore, TipoCodificaEccezione codifica) {
        switch (codifica) {
            case ECCEZIONE_PROCESSAMENTO: {
                return protocolTraduttore.toString(ContestoCodificaEccezione.PROCESSAMENTO);
            }
            case ECCEZIONE_VALIDAZIONE_PROTOCOLLO: {
                return protocolTraduttore.toString(ContestoCodificaEccezione.INTESTAZIONE);
            }
            case SCONOSCIUTO: {
                return null;
            }
        }
        return null;
    }

    private String getBaseValueRilevanzaEccezione(ITraduttore protocolTraduttore, TipoRilevanzaEccezione codifica) {
        switch (codifica) {
            case DEBUG: {
                return protocolTraduttore.toString(LivelloRilevanza.DEBUG);
            }
            case ERROR: {
                return protocolTraduttore.toString(LivelloRilevanza.ERROR);
            }
            case FATAL: {
                return protocolTraduttore.toString(LivelloRilevanza.FATAL);
            }
            case INFO: {
                return protocolTraduttore.toString(LivelloRilevanza.INFO);
            }
            case WARN: {
                return protocolTraduttore.toString(LivelloRilevanza.WARN);
            }
            case SCONOSCIUTO: {
                return protocolTraduttore.toString(LivelloRilevanza.UNKNOWN);
            }
        }
        return null;
    }

    @Override
    public XMLRootElement getXMLRootElement() throws ProtocolException {
        return new TracciaXMLRootElement();
    }

    @Override
    public List<TracciaExtInfoDefinition> getExtInfoDefinition() {
        return null;
    }

    @Override
    public List<TracciaExtInfo> extractExtInfo(Busta busta, ServiceBinding tipoApi) {
        List<TracciaExtInfoDefinition> extInfoDefinitionList = this.getExtInfoDefinition();
        ArrayList<TracciaExtInfo> list = null;
        if (extInfoDefinitionList != null && !extInfoDefinitionList.isEmpty()) {
            list = new ArrayList<TracciaExtInfo>();
            TracciaExtInfo extInfoNoPrefix = new TracciaExtInfo();
            extInfoNoPrefix.setEmpty(true);
            list.add(extInfoNoPrefix);
            ArrayList<String> propertyNamesEsistentiNellaBusta = new ArrayList<String>();
            for (String pName : busta.getPropertiesNames()) {
                propertyNamesEsistentiNellaBusta.add(pName);
            }
            for (TracciaExtInfoDefinition tracciaExtInfoDefinition : extInfoDefinitionList) {
                TracciaExtInfo extInfo = new TracciaExtInfo();
                extInfo.setLabel(tracciaExtInfoDefinition.getLabel());
                ArrayList<String> proprietaDaRimuovere = new ArrayList<String>();
                if (!propertyNamesEsistentiNellaBusta.isEmpty()) {
                    for (String string : propertyNamesEsistentiNellaBusta) {
                        if (!string.startsWith(tracciaExtInfoDefinition.getPrefixId())) continue;
                        String pValue = busta.getProperty(string);
                        String pNameWithoutPrefix = string.substring(tracciaExtInfoDefinition.getPrefixId().length());
                        Proprieta proprieta = new Proprieta();
                        proprieta.setNome(pNameWithoutPrefix);
                        proprieta.setValore(pValue);
                        extInfo.getProprieta().add(proprieta);
                        proprietaDaRimuovere.add(string);
                    }
                }
                if (!proprietaDaRimuovere.isEmpty()) {
                    for (String string : proprietaDaRimuovere) {
                        propertyNamesEsistentiNellaBusta.remove(string);
                    }
                }
                if (extInfo.getProprieta().isEmpty()) continue;
                if (tracciaExtInfoDefinition.isOrder()) {
                    ArrayList<String> listKeys = new ArrayList<String>();
                    for (Proprieta proprieta : extInfo.getProprieta()) {
                        listKeys.add(proprieta.getNome());
                    }
                    Collections.sort(listKeys);
                    ArrayList<Proprieta> arrayList = new ArrayList<Proprieta>();
                    for (String key : listKeys) {
                        Proprieta p = extInfo.getProprieta(key);
                        arrayList.add(p);
                    }
                    extInfo.setProprieta(arrayList);
                }
                list.add(extInfo);
            }
            if (!propertyNamesEsistentiNellaBusta.isEmpty()) {
                for (String pName : propertyNamesEsistentiNellaBusta) {
                    Proprieta proprieta = new Proprieta();
                    proprieta.setNome(pName);
                    proprieta.setValore(busta.getProperty(pName));
                    extInfoNoPrefix.getProprieta().add(proprieta);
                }
            }
            if (((TracciaExtInfo)list.get(0)).getProprieta().isEmpty()) {
                list.remove(0);
            }
        }
        return list;
    }
}

