/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.archive;

import java.util.ArrayList;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class APIUtils {
    public static String normalizeResourceName(HttpMethod requestMethod, String path) {
        if (requestMethod == null || path == null) {
            return null;
        }
        HttpRequestMethod httpMethodCheck = HttpRequestMethod.valueOf((String)requestMethod.getValue());
        return APIUtils.normalizeResourceName(httpMethodCheck, path);
    }

    public static String normalizeResourceName(HttpRequestMethod requestMethod, String path) {
        if (requestMethod == null || path == null) {
            return null;
        }
        ArrayList<Character> permit = new ArrayList<Character>();
        permit.add(Character.valueOf('.'));
        permit.add(Character.valueOf('_'));
        permit.add(Character.valueOf('-'));
        Character cJolly = Character.valueOf('.');
        String nome = Utilities.convertNameToSistemaOperativoCompatible((String)path, (boolean)true, (Character)cJolly, permit, (boolean)false);
        while (nome.startsWith("" + cJolly) && nome.length() > 1) {
            nome = nome.substring(1);
        }
        while (nome.endsWith("" + cJolly) && nome.length() > 1) {
            nome = nome.substring(0, nome.length() - 1);
        }
        int count = 0;
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < nome.length(); ++i) {
            char c = nome.charAt(i);
            if (c == cJolly.charValue()) {
                if (++count != 1) continue;
                bf.append(c);
                continue;
            }
            count = 0;
            bf.append(c);
        }
        Object nomeAzione = requestMethod.name() + "_" + bf.toString();
        if (((String)nomeAzione).length() > 255) {
            nomeAzione = ((String)nomeAzione).substring(0, 255);
        }
        return nomeAzione;
    }
}

