/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.BasicConnectionResult;
import org.openspcoop2.protocol.basic.BasicProducerType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class BasicProducer
extends BasicComponentFactory
implements IMonitoraggioRisorsa {
    protected Properties appenderProperties;
    protected DataSource ds = null;
    protected String datasource = null;
    protected String connectionViaJDBCUrl = null;
    protected String connectionViaJDBCDriverJDBC = null;
    protected String connectionViaJDBCUsername = null;
    protected String connectionViaJDBCPassword = null;
    protected boolean singleConnection = false;
    protected HashMap<BasicProducerType, Connection> singleConnectionConnectionMap = new HashMap();
    protected HashMap<BasicProducerType, String> singleConnectionSourceMap = new HashMap();
    protected String tipoDatabase = null;
    protected boolean openspcoopConnection = false;
    protected boolean debug = false;
    protected boolean forceIndex = false;
    protected IProtocolConfiguration protocolConfiguration;
    protected boolean isAlive = true;
    private BasicProducerType producerType;

    public void setForceIndex(boolean forceIndex) {
        this.forceIndex = forceIndex;
    }

    public BasicProducer(IProtocolFactory<?> factory, BasicProducerType producerType) throws ProtocolException {
        super(factory);
        this.producerType = producerType;
    }

    protected synchronized void initConnection(DataSource dsA, String dataSourceS) throws ProtocolException {
        Connection singleConnectionConnection = this.singleConnectionConnectionMap.get((Object)this.producerType);
        if (singleConnectionConnection == null) {
            try {
                String singleConnectionSource = dataSourceS;
                singleConnectionConnection = dsA.getConnection();
                this.singleConnectionConnectionMap.put(this.producerType, singleConnectionConnection);
                this.singleConnectionSourceMap.put(this.producerType, singleConnectionSource);
            }
            catch (Exception e) {
                throw new ProtocolException("Inizializzazione single connection (via datasource) non riuscita", e);
            }
        }
    }

    protected synchronized void initConnection(String jdbcUrl, String jdbcDriver, String username, String password) throws ProtocolException {
        Connection singleConnectionConnection = this.singleConnectionConnectionMap.get((Object)this.producerType);
        if (singleConnectionConnection == null) {
            try {
                String singleConnectionSource = "url:" + jdbcUrl + " driver:" + jdbcDriver + " username:" + username + " password:" + password;
                singleConnectionConnection = username == null ? DriverManager.getConnection(jdbcUrl) : DriverManager.getConnection(jdbcUrl, username, password);
                this.singleConnectionConnectionMap.put(this.producerType, singleConnectionConnection);
                this.singleConnectionSourceMap.put(this.producerType, singleConnectionSource);
            }
            catch (Exception e) {
                throw new ProtocolException("Inizializzazione single connection (via jdbc connection) non riuscita", e);
            }
        }
    }

    protected Connection getConnectionViaJDBC() throws SQLException {
        if (this.connectionViaJDBCUsername == null) {
            return DriverManager.getConnection(this.connectionViaJDBCUrl);
        }
        return DriverManager.getConnection(this.connectionViaJDBCUrl, this.connectionViaJDBCUsername, this.connectionViaJDBCPassword);
    }

    /*
     * Unable to fully structure code
     */
    protected BasicConnectionResult getConnection(Connection conOpenSPCoopPdD, String methodName) throws ProtocolException {
        con = null;
        cr = new BasicConnectionResult();
        cr.setReleaseConnection(false);
        if (this.debug) {
            this.logInfo("@@ [" + methodName + "] SINGLE CONNECTION[" + this.singleConnection + "] OPEN[" + this.openspcoopConnection + "]");
        }
        if (!this.singleConnection) {
            if (this.openspcoopConnection && conOpenSPCoopPdD != null) {
                if (this.debug) {
                    this.logInfo("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION OPENSPCOOP");
                }
                con = conOpenSPCoopPdD;
            } else if (this.ds != null) {
                try {
                    con = this.ds.getConnection();
                    cr.setReleaseConnection(true);
                    if (!this.debug) ** GOTO lbl36
                    this.logInfo("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION FROM DATASOURCE");
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante il recupero di una connessione dal datasource [" + this.datasource + "]: " + e.getMessage());
                }
            } else {
                try {
                    con = this.getConnectionViaJDBC();
                    if (con == null) {
                        throw new ProtocolException("Connessione non fornita");
                    }
                    cr.setReleaseConnection(true);
                    if (!this.debug) ** GOTO lbl36
                    this.logInfo("@@ [" + methodName + "] GET_CONNECTION, USE CONNECTION VIA JDBC");
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante il recupero di una connessione via jdbc url[" + this.connectionViaJDBCUrl + "] driver[" + this.connectionViaJDBCDriverJDBC + "] username[" + this.connectionViaJDBCUsername + "] password[" + this.connectionViaJDBCPassword + "]: " + e.getMessage());
                }
            }
        } else {
            con = this.singleConnectionConnectionMap.get((Object)this.producerType);
            if (con == null) {
                throw new ProtocolException("Connessione (singleConnection enabled) non fornita dalla sorgente [" + this.singleConnectionSourceMap.get((Object)this.producerType) + "]");
            }
            if (this.debug) {
                this.logInfo("@@ [" + methodName + "] GET_CONNECTION, SINGLE CONNECTION");
            }
        }
lbl36:
        // 8 sources

        cr.setConnection(con);
        return cr;
    }

    protected void releaseConnection(BasicConnectionResult connectionResult, String methodName) throws SQLException {
        if (this.debug) {
            this.logInfo("@@ [" + methodName + "] RELEASE_CONNECTION [" + connectionResult.isReleaseConnection() + "]?");
        }
        if (connectionResult.isReleaseConnection()) {
            if (this.debug) {
                this.logInfo("@@ [" + methodName + "] RELEASE_CONNECTION effettuato");
            }
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionResult.getConnection(), (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
        }
    }

    public void initializeAppender(OpenspcoopAppender appenderProperties, boolean tipoDatabaseRequired) throws ProtocolException {
        try {
            String debugS;
            this.appenderProperties = new Properties();
            if (appenderProperties.sizePropertyList() > 0) {
                String openspcoopConnectionString;
                for (int i = 0; i < appenderProperties.sizePropertyList(); ++i) {
                    this.appenderProperties.put(appenderProperties.getProperty(i).getNome(), appenderProperties.getProperty(i).getValore());
                }
                this.datasource = this.appenderProperties.getProperty("datasource");
                if (this.datasource == null) {
                    this.connectionViaJDBCUrl = this.appenderProperties.getProperty("connectionUrl");
                    if (this.connectionViaJDBCUrl == null) {
                        String tmp = this.appenderProperties.getProperty("checkProperties");
                        if (tmp == null || Boolean.valueOf(tmp.trim()).booleanValue()) {
                            throw new ProtocolException("Propriet\u00e0 'datasource' e 'connectionUrl' non definite (almeno una delle due \u00e8 obbligatoria)");
                        }
                        this.isAlive = false;
                    }
                }
                this.tipoDatabase = this.appenderProperties.getProperty("tipoDatabase");
                if (this.tipoDatabase == null && tipoDatabaseRequired) {
                    throw new ProtocolException("Proprieta' 'tipoDatabase' non definita");
                }
                if (this.tipoDatabase != null && !TipiDatabase.isAMember((String)this.tipoDatabase)) {
                    throw new ProtocolException("Proprieta' 'tipoDatabase' presenta un tipo [" + this.tipoDatabase + "] non supportato");
                }
                String singleConnectionString = this.appenderProperties.getProperty("singleConnection");
                if (singleConnectionString != null && "true".equals(singleConnectionString = singleConnectionString.trim())) {
                    this.singleConnection = true;
                }
                if ((openspcoopConnectionString = this.appenderProperties.getProperty("usePdDConnection")) != null && "true".equals(openspcoopConnectionString = openspcoopConnectionString.trim())) {
                    this.openspcoopConnection = true;
                }
            } else {
                throw new ProtocolException("Propriet\u00e0 'datasource' e 'connectionUrl' non definite (almeno una delle due \u00e8 obbligatoria)");
            }
            if (this.datasource != null) {
                Properties ctx = Utilities.readProperties((String)"context-", (Properties)this.appenderProperties);
                GestoreJNDI jndi = new GestoreJNDI(ctx);
                if (this.singleConnection) {
                    if (this.singleConnectionConnectionMap.get((Object)this.producerType) == null) {
                        DataSource dsL = (DataSource)jndi.lookup(this.datasource);
                        this.initConnection(dsL, this.datasource);
                    }
                } else {
                    this.ds = (DataSource)jndi.lookup(this.datasource);
                }
            }
            if (this.connectionViaJDBCUrl != null) {
                this.connectionViaJDBCDriverJDBC = this.appenderProperties.getProperty("connectionDriver");
                if (this.connectionViaJDBCDriverJDBC == null) {
                    throw new ProtocolException("Propriet\u00e0 'connectionDriver' non definita (obbligatoria nella modalita' 'connection via jdbc')");
                }
                this.connectionViaJDBCUsername = this.appenderProperties.getProperty("connectionUsername");
                if (this.connectionViaJDBCUsername != null) {
                    this.connectionViaJDBCPassword = this.appenderProperties.getProperty("connectionPassword");
                    if (this.connectionViaJDBCPassword == null) {
                        throw new ProtocolException("Propriet\u00e0 'connectionPassword' non definita (obbligatoria nella modalita' 'connection via jdbc' se viene definita la proprieta' 'connectionUsername')");
                    }
                }
                Class.forName(this.connectionViaJDBCDriverJDBC);
                if (this.singleConnection && this.singleConnectionConnectionMap.get((Object)this.producerType) == null) {
                    this.initConnection(this.connectionViaJDBCUrl, this.connectionViaJDBCDriverJDBC, this.connectionViaJDBCUsername, this.connectionViaJDBCPassword);
                }
            }
            if ((debugS = this.appenderProperties.getProperty("debug")) != null && "true".equals(debugS = debugS.trim())) {
                this.debug = true;
            }
            this.protocolConfiguration = this.protocolFactory.createProtocolConfiguration();
        }
        catch (Exception e) {
            throw new ProtocolException("Errore durante l'inizializzazione dell'appender: " + e.getMessage(), e);
        }
    }

    protected String getSQLStringValue(String value) {
        if (value != null && !"".equals(value)) {
            return value;
        }
        return null;
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }

    public void setTipoDatabase(String tipoDatabase) {
        this.tipoDatabase = tipoDatabase;
    }

    public void isAlive() throws CoreException {
        if (!this.isAlive) {
            return;
        }
        Connection con = null;
        Statement stmtTest = null;
        BasicConnectionResult cr = null;
        try {
            cr = this.getConnection(null, "isAlive");
            con = cr.getConnection();
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
        }
        catch (Exception e) {
            throw new CoreException("Connessione al database '" + String.valueOf((Object)this.producerType) + "' non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.releaseConnection(cr, "isAlive");
            }
            catch (Exception exception) {}
        }
    }
}

