/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.diagnostica;

import java.io.ByteArrayOutputStream;
import java.util.Date;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticSerializer;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.spcoop.utils.SPCoopUtils;
import org.openspcoop2.utils.date.DateManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPCoopDiagnosticSerializer
extends DiagnosticSerializer
implements IDiagnosticSerializer {
    public SPCoopDiagnosticSerializer(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        super(protocolFactory);
    }

    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        try {
            Document doc = this.xmlUtils.newDocument();
            Element diagnostico = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:MessaggioDiagnostico");
            Element gdoMsgDiag = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:OraRegistrazione");
            Date gdoD = null;
            gdoD = msgDiag.getGdo() == null ? new Date(DateManager.getTimeMillis()) : new Date(msgDiag.getGdo().getTime());
            gdoMsgDiag.setTextContent(SPCoopUtils.getDate_eGovFormat(gdoD));
            diagnostico.appendChild(gdoMsgDiag);
            Element identificativoPorta = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:IdentificativoPorta");
            identificativoPorta.setTextContent(msgDiag.getIdSoggetto().getCodicePorta());
            diagnostico.appendChild(identificativoPorta);
            Element identificativoFunzione = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:IdentificativoFunzione");
            identificativoFunzione.setTextContent(msgDiag.getIdFunzione());
            diagnostico.appendChild(identificativoFunzione);
            Element livelloSev = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:LivelloDiSeverita");
            String liv = "" + msgDiag.getSeverita();
            livelloSev.setTextContent(liv);
            diagnostico.appendChild(livelloSev);
            Element testo = doc.createElementNS("http://www.ctrupa.it/schemas/2003/eGovIT/Diag1_0/", "eGov_IT_Diag:TestoDiagnostico");
            testo.setTextContent(msgDiag.getMessaggio());
            diagnostico.appendChild(testo);
            return diagnostico;
        }
        catch (Exception e) {
            this.log.error("DiagnosticSerializer.toElement error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("DiagnosticSerializer.toElement error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected ByteArrayOutputStream toByteArrayOutputStream(MsgDiagnostico msgDiag, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        try {
            switch (tipoSerializzazione) {
                case XML: 
                case DEFAULT: {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    bout.write(MessageXMLUtils.DEFAULT.toByteArray(this.toElement(msgDiag)));
                    bout.flush();
                    bout.close();
                    return bout;
                }
            }
            throw new Exception("Tipo Serializzazione [" + String.valueOf(tipoSerializzazione) + "] Non gestito");
        }
        catch (Exception e) {
            this.log.error("DiagnosticSerializer.toString error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("DiagnosticSerializer.toString error: " + e.getMessage(), (Throwable)e);
        }
    }
}

