/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.builder;

import jakarta.activation.DataHandler;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.DumpSoapMessageUtils;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.spcoop.SPCoopBustaRawContent;
import org.openspcoop2.protocol.spcoop.config.SPCoopProperties;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneSintattica;
import org.openspcoop2.utils.UtilsMultiException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SPCoopSbustamento {
    private Logger log;
    private IProtocolFactory<?> protocolFactory;
    private SPCoopValidazioneSintattica validazioneSintattica = null;
    private SPCoopProperties spcoopProperties = null;
    private IState state;

    public SPCoopSbustamento(IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.log = protocolFactory.getLogger();
        this.spcoopProperties = SPCoopProperties.getInstance(this.log);
        this.state = state;
        this.validazioneSintattica = (SPCoopValidazioneSintattica)this.protocolFactory.createValidazioneSintattica(this.state);
    }

    public SOAPHeaderElement sbustamentoEGov(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        SOAPHeader headerSOAP = null;
        SOAPHeaderElement header = null;
        try {
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            this.validazioneSintattica.setMsg(soapMsg);
            this.validazioneSintattica.setReadQualifiedAttribute(proprietaManifestAttachments.isReadQualifiedAttribute());
            headerSOAP = soapMsg.getSOAPHeader();
            SPCoopBustaRawContent bustaElement = this.validazioneSintattica.getHeaderEGov(msg.getFactory(), headerSOAP);
            if (bustaElement == null) {
                throw new Exception("Header eGov non presente");
            }
            header = (SOAPHeaderElement)bustaElement.getElement();
            if (header == null) {
                throw new Exception("Header eGov non presente");
            }
            soapMsg.removeHeaderElement(headerSOAP, header);
            if (proprietaManifestAttachments.isGestioneManifest() && soapMsg.countAttachments() > 0) {
                this.remove_eGovManifest(msg, proprietaManifestAttachments);
            }
            SOAPHeaderElement sOAPHeaderElement = header;
            return sOAPHeaderElement;
        }
        catch (Exception e) {
            this.log.error("SbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("SbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.validazioneSintattica != null) {
                this.validazioneSintattica.setHeaderSOAP(null);
            }
            headerSOAP = null;
            header = null;
        }
    }

    public OpenSPCoop2Message remove_eGovManifest(OpenSPCoop2Message msgParam, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            SOAPElement e;
            OpenSPCoop2SoapMessage msg = msgParam.castAsSoap();
            MessageXMLUtils xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)msg.getFactory());
            SOAPBody body = msg.getSOAPBody();
            SOAPElement descrizione = e = SoapUtils.getFirstSOAPElement((SOAPElement)body);
            Iterator it = descrizione.getChildElements();
            String idMsg = null;
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof SOAPElement)) continue;
                SOAPElement descrizioneMessaggio = (SOAPElement)element;
                SOAPElement riferimento = SoapUtils.getFirstSOAPElement((SOAPElement)descrizioneMessaggio);
                if (riferimento.getAttribute("role").equalsIgnoreCase(this.spcoopProperties.getRoleRichiestaManifest())) {
                    idMsg = riferimento.getAttribute("href");
                    break;
                }
                if (!riferimento.getAttribute("role").equalsIgnoreCase(this.spcoopProperties.getRoleRispostaManifest())) continue;
                idMsg = riferimento.getAttribute("href");
                break;
            }
            if (idMsg == null) {
                throw new Exception("DescrizioneMessaggio con ruolo " + this.spcoopProperties.getRoleRichiestaManifest() + " o " + this.spcoopProperties.getRoleRispostaManifest() + " non trovato.");
            }
            if (idMsg.startsWith("cid:")) {
                idMsg = idMsg.substring("cid:".length());
            }
            MimeHeaders mhs = new MimeHeaders();
            mhs.addHeader("Content-ID", idMsg);
            AttachmentPart ap = (AttachmentPart)msg.getAttachments(mhs).next();
            msg.removeAttachments(mhs);
            InputStream inputDH = this.getInputStream(msg, ap);
            msg.getSOAPBody().removeContents();
            byte[] bytePotenzialiXML = new byte[5];
            int readByte = inputDH.read(bytePotenzialiXML);
            boolean xmlContentPresente = false;
            if (readByte == 5 && (char)bytePotenzialiXML[0] == '<' && (char)bytePotenzialiXML[1] == '?' && (char)bytePotenzialiXML[2] == 'x' && (char)bytePotenzialiXML[3] == 'm' && (char)bytePotenzialiXML[4] == 'l') {
                readByte = inputDH.read();
                while ((char)readByte != '>' && readByte != -1) {
                    readByte = inputDH.read();
                }
                if ((char)readByte == '>') {
                    xmlContentPresente = true;
                }
            }
            if (readByte == -1) {
                return msg;
            }
            InputStream isBody = null;
            isBody = !xmlContentPresente ? this.getInputStream(msg, ap) : inputDH;
            ArrayList<InputStream> iss = new ArrayList<InputStream>();
            iss.add(new ByteArrayInputStream("<OpenSPCoopWrapper>".getBytes()));
            iss.add(isBody);
            iss.add(new ByteArrayInputStream("</OpenSPCoopWrapper>".getBytes()));
            SequenceInputStream is = new SequenceInputStream(Collections.enumeration(iss));
            Document doc = xmlUtils.newDocument((InputStream)is);
            NodeList nl = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n instanceof Element) {
                    Element element = (Element)n;
                    if ("SoapBodyEmpty".equals(element.getLocalName()) && "http://www.openspcoop2.org/spcoop/manifest/body".equals(element.getNamespaceURI())) continue;
                    msg.getSOAPBody().addChildElement(SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)msg.getFactory(), (MessageType)MessageType.SOAP_11).createElement(element));
                }
                if (!(n instanceof Text)) continue;
                msg.getSOAPBody().addTextNode(n.getTextContent());
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error("Rimozione Manifest degli Attachments non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Rimozione Manifest degli Attachments non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    private InputStream getInputStream(OpenSPCoop2SoapMessage msg, AttachmentPart ap) throws Exception {
        InputStream inputDH = null;
        try {
            DataHandler dh = ap.getDataHandler();
            inputDH = dh.getInputStream();
        }
        catch (Exception e) {
            try {
                inputDH = new ByteArrayInputStream(DumpSoapMessageUtils.dumpAttachmentAsByteArray((OpenSPCoop2SoapMessage)msg, (AttachmentPart)ap));
            }
            catch (Exception eInternal) {
                throw new UtilsMultiException(new Throwable[]{e, eInternal});
            }
        }
        return inputDH;
    }

    @Deprecated
    public byte[] removeSPCoop(byte[] header) throws ProtocolException {
        ByteArrayOutputStream reqByteSbustata = null;
        try {
            int indexOfEGov;
            String headerSTR = new String(header);
            int endIntestazione = 0;
            int start = 0;
            while ((indexOfEGov = headerSTR.indexOf("http://www.cnipa.it/eGov_it/portadominio", start)) != -1) {
                StringBuilder rovesciata = new StringBuilder();
                for (int i = indexOfEGov - 1; i > 0; --i) {
                    rovesciata.append((char)header[i]);
                    if ((char)header[i] != '<') continue;
                    start = i;
                    break;
                }
                StringBuilder rigaCompleta = new StringBuilder();
                rovesciata.reverse();
                rigaCompleta.append(rovesciata.toString());
                rigaCompleta.append("http://www.cnipa.it/eGov_it/portadominio");
                for (int i = indexOfEGov + "http://www.cnipa.it/eGov_it/portadominio".length(); i < header.length; ++i) {
                    rigaCompleta.append((char)header[i]);
                    if ((char)header[i] == '>') break;
                }
                if (rigaCompleta.toString().indexOf("Intestazione") != -1) {
                    endIntestazione = start - 1 + rigaCompleta.length();
                    break;
                }
                start = start - 1 + rigaCompleta.length();
            }
            if (start == 0) {
                return null;
            }
            int end = headerSTR.indexOf("Intestazione>", endIntestazione) + "Intestazione>".length();
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            reqByteSbustata = new ByteArrayOutputStream();
            for (int i = 0; i < start; ++i) {
                reqByteSbustata.write(header[i]);
            }
            boolean eraserSpaziDopoEGov = false;
            for (int i = end; i < header.length; ++i) {
                if (!eraserSpaziDopoEGov && (char)header[i] == '<') {
                    eraserSpaziDopoEGov = true;
                    reqByteSbustata.write(header[i]);
                    continue;
                }
                if (!eraserSpaziDopoEGov) continue;
                reqByteSbustata.write(header[i]);
            }
            byte[] bustaSenzaEGov = reqByteSbustata.toByteArray();
            reqByteSbustata.close();
            return bustaSenzaEGov;
        }
        catch (Exception e) {
            try {
                if (reqByteSbustata != null) {
                    reqByteSbustata.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error("RimozioneHeaderSPCoop non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("RimozioneHeaderSPCoop non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public SOAPHeaderElement sbustamento(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        return this.sbustamentoEGov(msg, proprietaManifestAttachments);
    }
}

