/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.builder;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.Inoltro;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.spcoop.SPCoopBustaRawContent;
import org.openspcoop2.protocol.spcoop.builder.SPCoopStaticCounter;
import org.openspcoop2.protocol.spcoop.config.SPCoopProperties;
import org.openspcoop2.protocol.spcoop.constants.SPCoopCostanti;
import org.openspcoop2.protocol.spcoop.utils.SPCoopUtils;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneSemantica;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneSintattica;
import org.openspcoop2.protocol.utils.IDSerialGenerator;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.dch.InputStreamDataSource;
import org.openspcoop2.utils.dch.MailcapActivationReader;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorType;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class SPCoopImbustamento {
    private IProtocolFactory<SOAPHeaderElement> factory;
    private Logger log;
    private SPCoopProperties spcoopProperties = null;
    private SPCoopValidazioneSemantica validazioneSemantica = null;
    private SPCoopValidazioneSintattica validazioneSintattica = null;
    private ITraduttore traduttore = null;
    private IProtocolManager protocolManager = null;
    private IState state;
    protected static int maxSeriale = 0;
    private static int prefixLenght = 0;

    public SPCoopImbustamento(IProtocolFactory<SOAPHeaderElement> factory, IState state) throws ProtocolException {
        this.factory = factory;
        this.log = factory.getLogger();
        this.spcoopProperties = SPCoopProperties.getInstance(this.log);
        this.state = state;
        this.validazioneSemantica = (SPCoopValidazioneSemantica)this.factory.createValidazioneSemantica(this.state);
        this.validazioneSintattica = (SPCoopValidazioneSintattica)this.factory.createValidazioneSintattica(this.state);
        this.traduttore = this.factory.createTraduttore();
        this.protocolManager = this.factory.createProtocolManager();
    }

    public IProtocolFactory<SOAPHeaderElement> getProtocolFactory() {
        return this.factory;
    }

    private void initSerialCounter(int prefixSeriale, int cifre) {
        if (maxSeriale == 0) {
            SPCoopImbustamento._initSerialCounter(prefixSeriale, cifre);
        }
    }

    private static synchronized void _initSerialCounter(int prefixSeriale, int cifre) {
        if (maxSeriale == 0) {
            if (prefixSeriale == -1) {
                maxSeriale = 9999999;
                prefixLenght = 0;
            } else if (prefixSeriale < 10 && cifre < 2) {
                maxSeriale = 999999;
                prefixLenght = 1;
            } else {
                maxSeriale = 99999;
                prefixLenght = 2;
            }
        }
    }

    public String buildID(IDSoggetto idSoggetto, String idTransazione, RuoloMessaggio ruoloMessaggio) throws ProtocolException {
        String idPD = idSoggetto.getCodicePorta();
        String codAmm = idSoggetto.getNome();
        if (idPD == null || codAmm == null) {
            this.log.error("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]");
            throw new ProtocolException("Creazione ID eGov non riuscita: alcuni parametri di creazione null idPD[" + idPD + "] codAmm[" + codAmm + "]");
        }
        Integer prefix = null;
        DynamicClusterManager dynamicClusterManager = null;
        OpenSPCoop2Properties openSPCoop2Properties = OpenSPCoop2Properties.getInstance();
        if (openSPCoop2Properties.isClusterDinamico()) {
            try {
                dynamicClusterManager = DynamicClusterManager.getInstance();
                prefix = dynamicClusterManager.getIdentificativoNumerico();
            }
            catch (Exception e) {
                throw new ProtocolException("Creazione ID eGov non riuscita; identificativo numerico del cluster dinamico non ottenibile: " + e.getMessage(), (Throwable)e);
            }
        } else {
            String prefixS = openSPCoop2Properties.getClusterIdNumerico();
            if (prefixS != null) {
                prefix = Integer.valueOf(prefixS);
            }
        }
        int cifre = -1;
        if (prefix != null) {
            if (openSPCoop2Properties.isClusterDinamico()) {
                try {
                    cifre = openSPCoop2Properties.getClusterDinamicoIdNumericoCifre(dynamicClusterManager.isRateLimitingGestioneCluster());
                }
                catch (Exception e) {
                    msg = "Comprensione numero cifre per id non riuscita (DynamicClusterManager-RL:" + dynamicClusterManager.isRateLimitingGestioneCluster() + "): " + e.getMessage();
                    this.log.debug(msg);
                    cifre = ("" + prefix).length();
                }
            } else {
                try {
                    cifre = openSPCoop2Properties.getClusterDinamicoIdNumericoCifre(false);
                }
                catch (Exception e) {
                    msg = "Comprensione numero cifre per id non riuscita: " + e.getMessage();
                    this.log.debug(msg);
                    cifre = ("" + prefix).length();
                }
            }
        }
        this.initSerialCounter(prefix == null ? -1 : prefix, cifre);
        IDSerialGenerator serialGenerator = null;
        IDSerialGeneratorParameter serialGeneratorParameter = null;
        if (!"static".equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta())) {
            ConfigurazionePdD config = this.factory.getConfigurazionePdD();
            serialGenerator = new IDSerialGenerator(config.getLog(), this.state, config.getTipoDatabase());
            serialGeneratorParameter = new IDSerialGeneratorParameter(this.factory.getProtocol());
            serialGeneratorParameter.setSerializableTimeWaitMs(config.getAttesaAttivaJDBC());
            serialGeneratorParameter.setSerializableNextIntervalTimeMs(config.getCheckIntervalJDBC());
            serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
            serialGeneratorParameter.setMaxValue(Long.valueOf(maxSeriale));
            serialGeneratorParameter.setWrap(true);
        }
        try {
            long counter = -1L;
            Date now = DateManager.getDate();
            SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMinute();
            String dataIdentificativo = dateformat.format(now);
            StringBuilder bf = new StringBuilder();
            bf.append(codAmm);
            bf.append('_');
            bf.append(idPD);
            bf.append('_');
            if (SPCoopCostanti.IDENTIFICATIVO_EGOV_SERIALE_MYSQL.equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta())) {
                if (serialGeneratorParameter != null) {
                    serialGeneratorParameter.setTipo(IDSerialGeneratorType.MYSQL);
                }
                if (serialGenerator == null) {
                    throw new Exception("SerialGenerator undefined");
                }
                counter = serialGenerator.buildIDAsNumber(serialGeneratorParameter);
            } else if ("static".equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta()) || "dynamic".equals(this.spcoopProperties.getTipoSeriale_IdentificativoBusta())) {
                counter = SPCoopStaticCounter.getNextSerialCounter(now, dataIdentificativo, codAmm, idPD);
            } else {
                if (serialGenerator == null) {
                    throw new Exception("SerialGenerator undefined");
                }
                counter = serialGenerator.buildIDAsNumber(serialGeneratorParameter);
            }
            if (prefix != null) {
                int paddingPrefix = prefixLenght - ("" + prefix).length();
                for (int iP = 0; iP < paddingPrefix; ++iP) {
                    bf.append('0');
                }
                bf.append(prefix);
            }
            String c = Long.toString(counter);
            int padding = 7 - prefixLenght - c.length();
            for (int i = 0; i < padding; ++i) {
                bf.append('0');
            }
            bf.append(c);
            bf.append('_');
            bf.append(dataIdentificativo);
            return bf.toString();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public SOAPHeaderElement build_eGovHeader(OpenSPCoop2Message msg, Busta eGov) throws ProtocolException {
        return this.build_eGovHeader(msg, eGov, true, false);
    }

    public SOAPHeaderElement build_eGovHeader(OpenSPCoop2Message msg, Busta eGov, boolean verificaPresenzaElementiObbligatori) throws ProtocolException {
        return this.build_eGovHeader(msg, eGov, verificaPresenzaElementiObbligatori, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SOAPHeaderElement build_eGovHeader(OpenSPCoop2Message msg, Busta eGov, boolean verificaPresenzaElementiObbligatori, boolean forzaValidazioneXSDElementiDisabilitata) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage soapMsg = null;
            if (msg == null) {
                OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
                soapMsg = mf.createEmptyMessage(MessageType.SOAP_11, MessageRole.NONE).castAsSoap();
            } else {
                soapMsg = msg.castAsSoap();
            }
            SOAPHeader hdr = soapMsg.getSOAPHeader();
            if (hdr == null) {
                hdr = soapMsg.getSOAPPart().getEnvelope().addHeader();
            }
            QName name = new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Intestazione", "eGov_IT");
            SOAPHeaderElement eGovHeader = soapMsg.newSOAPHeaderElement(hdr, name);
            eGovHeader.setActor("http://www.cnipa.it/eGov_it/portadominio");
            eGovHeader.setMustUnderstand(true);
            if (this.spcoopProperties.isAddPrefixSOAPENV().booleanValue()) {
                eGovHeader.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            }
            SOAPElement eGovIntestazioneMsg = eGovHeader.addChildElement("IntestazioneMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (verificaPresenzaElementiObbligatori) {
                if (eGov.getMittente() == null) {
                    throw new ProtocolException("Mittente e' un elemento obbligatorio, e non e' stato definito");
                }
                if (eGov.getTipoMittente() == null) {
                    throw new ProtocolException("TipoMittente e' un attributo obbligatorio, e non e' stato definito");
                }
            }
            SOAPElement eGovMitt = eGovIntestazioneMsg.addChildElement("Mittente", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement eGovIDParteMitt = eGovMitt.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getMittente() != null) {
                eGovIDParteMitt.setValue(eGov.getMittente());
            }
            if (eGov.getTipoMittente() != null) {
                String tipoMittenteProtocollo = null;
                try {
                    tipoMittenteProtocollo = this.traduttore.toProtocolOrganizationType(eGov.getTipoMittente());
                }
                catch (Exception e) {
                    if (!this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        throw e;
                    }
                    tipoMittenteProtocollo = eGov.getTipoMittente();
                    this.log.warn("Produco busta con un tipo mittente non corretto: '" + tipoMittenteProtocollo + "'");
                }
                eGovIDParteMitt.setAttribute("tipo", tipoMittenteProtocollo);
            }
            if (eGov.getIndirizzoMittente() != null) {
                eGovIDParteMitt.setAttribute("indirizzoTelematico", eGov.getIndirizzoMittente());
            }
            if (verificaPresenzaElementiObbligatori) {
                if (eGov.getDestinatario() == null) {
                    throw new ProtocolException("Destinatario e' un elemento obbligatorio, e non e' stato definito");
                }
                if (eGov.getTipoDestinatario() == null) {
                    throw new ProtocolException("TipoDestinatario e' un attributo obbligatorio, e non e' stato definito");
                }
            }
            SOAPElement eGovDest = eGovIntestazioneMsg.addChildElement("Destinatario", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement eGovIDParteDest = eGovDest.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getDestinatario() != null) {
                eGovIDParteDest.setValue(eGov.getDestinatario());
            }
            if (eGov.getTipoDestinatario() != null) {
                String tipoDestinatarioProtocollo = null;
                try {
                    tipoDestinatarioProtocollo = this.traduttore.toProtocolOrganizationType(eGov.getTipoDestinatario());
                }
                catch (Exception e) {
                    if (!this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        throw e;
                    }
                    tipoDestinatarioProtocollo = eGov.getTipoDestinatario();
                    this.log.warn("Produco busta con un tipo destinatario non corretto: '" + tipoDestinatarioProtocollo + "'");
                }
                eGovIDParteDest.setAttribute("tipo", tipoDestinatarioProtocollo);
            }
            if (eGov.getIndirizzoDestinatario() != null) {
                eGovIDParteDest.setAttribute("indirizzoTelematico", eGov.getIndirizzoDestinatario());
            }
            if (eGov.getProfiloDiCollaborazione() != null) {
                boolean generazioneElemento = true;
                if (!(forzaValidazioneXSDElementiDisabilitata || this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD() || ProfiloDiCollaborazione.ONEWAY.equals((Object)eGov.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals((Object)eGov.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)eGov.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)eGov.getProfiloDiCollaborazione()))) {
                    generazioneElemento = false;
                }
                if (generazioneElemento) {
                    SOAPElement eGovProfCollaborazione = eGovIntestazioneMsg.addChildElement("ProfiloCollaborazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    switch (eGov.getProfiloDiCollaborazione()) {
                        case ONEWAY: {
                            eGovProfCollaborazione.setValue("EGOV_IT_MessaggioSingoloOneWay");
                            break;
                        }
                        case SINCRONO: {
                            eGovProfCollaborazione.setValue("EGOV_IT_ServizioSincrono");
                            break;
                        }
                        case ASINCRONO_SIMMETRICO: {
                            eGovProfCollaborazione.setValue("EGOV_IT_ServizioAsincronoSimmetrico");
                            break;
                        }
                        case ASINCRONO_ASIMMETRICO: {
                            eGovProfCollaborazione.setValue("EGOV_IT_ServizioAsincronoAsimmetrico");
                            break;
                        }
                        default: {
                            eGovProfCollaborazione.setValue(eGov.getProfiloDiCollaborazioneValue());
                        }
                    }
                    if (eGov.getServizioCorrelato() != null) {
                        eGovProfCollaborazione.setAttribute("servizioCorrelato", eGov.getServizioCorrelato());
                    }
                    if (eGov.getTipoServizioCorrelato() != null) {
                        boolean generazioneAttributo = true;
                        if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            try {
                                this.traduttore.toProtocolServiceType(eGov.getTipoServizioCorrelato());
                            }
                            catch (Exception e) {
                                generazioneAttributo = false;
                            }
                        }
                        if (generazioneAttributo) {
                            eGovProfCollaborazione.setAttribute("tipo", this.traduttore.toProtocolServiceType(eGov.getTipoServizioCorrelato()));
                        }
                    }
                }
            }
            if (eGov.getCollaborazione() != null) {
                boolean generazioneElemento = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    ProprietaValidazione proprietaValidazione = new ProprietaValidazione();
                    proprietaValidazione.setValidazioneIDCompleta(false);
                    generazioneElemento = this.validazioneSemantica.validazioneID(eGov.getCollaborazione(), null, proprietaValidazione);
                }
                if (generazioneElemento) {
                    SOAPElement eGovCollaborazione = eGovIntestazioneMsg.addChildElement("Collaborazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    eGovCollaborazione.setValue(eGov.getCollaborazione());
                }
            }
            if (eGov.getServizio() != null) {
                SOAPElement eGovServizio = eGovIntestazioneMsg.addChildElement("Servizio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                eGovServizio.setValue(eGov.getServizio());
                if (eGov.getTipoServizio() != null) {
                    String tipoServizio = null;
                    try {
                        tipoServizio = this.traduttore.toProtocolServiceType(eGov.getTipoServizio());
                    }
                    catch (Exception e) {
                        if (!this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            throw e;
                        }
                        tipoServizio = eGov.getTipoServizio();
                        this.log.warn("Produco busta con un tipo servizio non corretto: '" + tipoServizio + "'");
                    }
                    eGovServizio.setAttribute("tipo", tipoServizio);
                }
            }
            if (eGov.getAzione() != null) {
                SOAPElement eGovAzione = eGovIntestazioneMsg.addChildElement("Azione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                eGovAzione.setValue(eGov.getAzione());
            }
            SOAPElement eGovMessaggio = eGovIntestazioneMsg.addChildElement("Messaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getID() != null) {
                boolean generazioneElemento = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento = this.validazioneSemantica.validazioneID_engine(eGov.getID());
                }
                if (!generazioneElemento) throw new ProtocolException("Identificatore e' un elemento obbligatorio, e il valore non e' utilizzabile rispetto all'xsd (" + eGov.getID() + ")");
                SOAPElement eGovIDMsg = eGovMessaggio.addChildElement("Identificatore", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                if (eGov.getID() != null) {
                    eGovIDMsg.setValue(eGov.getID());
                }
            } else if (verificaPresenzaElementiObbligatori) {
                throw new ProtocolException("Identificatore e' un elemento obbligatorio, e non e' stato definito");
            }
            SOAPElement eGovOraRegistrazione = eGovMessaggio.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getOraRegistrazione() == null && verificaPresenzaElementiObbligatori) {
                throw new ProtocolException("OraRegistrazione e' un elemento obbligatorio, e non e' stato definito");
            }
            if (eGov.getOraRegistrazione() != null) {
                eGovOraRegistrazione.setValue(SPCoopUtils.getDate_eGovFormat(eGov.getOraRegistrazione()));
            }
            if (eGov.getTipoOraRegistrazione() != null) {
                boolean generazioneAttributo = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    boolean bl = generazioneAttributo = TipoOraRegistrazione.LOCALE.equals((Object)eGov.getTipoOraRegistrazione()) || TipoOraRegistrazione.SINCRONIZZATO.equals((Object)eGov.getTipoOraRegistrazione());
                }
                if (!generazioneAttributo) throw new ProtocolException("TipoOraRegistrazione e' un elemento obbligatorio, e il valore non e' utilizzabile rispetto all'xsd (" + eGov.getTipoOraRegistrazioneValue() + ")");
                if (TipoOraRegistrazione.LOCALE.equals((Object)eGov.getTipoOraRegistrazione())) {
                    eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_Locale");
                } else if (TipoOraRegistrazione.SINCRONIZZATO.equals((Object)eGov.getTipoOraRegistrazione())) {
                    eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_SPC");
                } else {
                    eGovOraRegistrazione.setAttribute("tempo", eGov.getTipoOraRegistrazioneValue());
                }
            } else {
                eGovOraRegistrazione.setAttribute("tempo", "EGOV_IT_SPC");
            }
            if (eGov.getRiferimentoMessaggio() != null) {
                boolean generazioneElemento = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    generazioneElemento = this.validazioneSemantica.validazioneID_engine(eGov.getRiferimentoMessaggio());
                }
                if (generazioneElemento) {
                    SOAPElement eGovRifMsg = eGovMessaggio.addChildElement("RiferimentoMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    eGovRifMsg.setValue(eGov.getRiferimentoMessaggio());
                }
            }
            if (eGov.getScadenza() != null) {
                SOAPElement eGovScadenza = eGovMessaggio.addChildElement("Scadenza", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                eGovScadenza.setValue(SPCoopUtils.getDate_eGovFormat(eGov.getScadenza()));
            }
            SOAPElement eGovProfTrasmissione = eGovIntestazioneMsg.addChildElement("ProfiloTrasmissione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            if (eGov.getInoltro() != null) {
                boolean generazioneElemento = true;
                if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                    boolean bl = generazioneElemento = Inoltro.CON_DUPLICATI.equals((Object)eGov.getInoltro()) || Inoltro.SENZA_DUPLICATI.equals((Object)eGov.getInoltro());
                }
                if (generazioneElemento) {
                    if (Inoltro.CON_DUPLICATI.equals((Object)eGov.getInoltro())) {
                        eGovProfTrasmissione.setAttribute("inoltro", "EGOV_IT_PIUDIUNAVOLTA");
                    } else if (Inoltro.SENZA_DUPLICATI.equals((Object)eGov.getInoltro())) {
                        eGovProfTrasmissione.setAttribute("inoltro", "EGOV_IT_ALPIUUNAVOLTA");
                    } else {
                        eGovProfTrasmissione.setAttribute("inoltro", eGov.getInoltroValue());
                    }
                }
            }
            String crValue = "false";
            if (eGov.isConfermaRicezione()) {
                crValue = "true";
            }
            eGovProfTrasmissione.setAttribute("confermaRicezione", crValue);
            if (eGov.getSequenza() != -1L) {
                SOAPElement eGovSequenza = eGovIntestazioneMsg.addChildElement("Sequenza", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                StringBuilder bf = new StringBuilder();
                String sequenza = Long.toString(eGov.getSequenza());
                int padding = 7 - sequenza.length();
                for (int i = 0; i < padding; ++i) {
                    bf.append('0');
                }
                bf.append(sequenza);
                eGovSequenza.setAttribute("numeroProgressivo", bf.toString());
            }
            if (eGov.sizeListaRiscontri() > 0) {
                SOAPElement eGovListaRiscontri = eGovHeader.addChildElement("ListaRiscontri", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                for (int i = 0; i < eGov.sizeListaRiscontri(); ++i) {
                    Riscontro ris = eGov.getRiscontro(i);
                    SOAPElement Riscontro2 = eGovListaRiscontri.addChildElement("Riscontro", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    if (ris.getID() != null) {
                        boolean generazioneElemento = true;
                        if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            generazioneElemento = this.validazioneSemantica.validazioneID_engine(ris.getID());
                        }
                        if (!generazioneElemento) throw new ProtocolException("Identificatore e' un elemento obbligatorio in un Riscontro, e il valore non e' utilizzabile rispetto all'xsd (" + ris.getID() + ")");
                        SOAPElement id = Riscontro2.addChildElement("Identificatore", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                        id.setValue(ris.getID());
                    } else if (verificaPresenzaElementiObbligatori) {
                        throw new ProtocolException("Identificatore e' un elemento obbligatorio in un Riscontro, e non e' stato definito");
                    }
                    if (ris.getOraRegistrazione() != null) {
                        SOAPElement ora = Riscontro2.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                        ora.setValue(SPCoopUtils.getDate_eGovFormat(ris.getOraRegistrazione()));
                        if (ris.getTipoOraRegistrazione() != null) {
                            boolean generazioneAttributo = true;
                            if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                                boolean bl = generazioneAttributo = TipoOraRegistrazione.LOCALE.equals((Object)ris.getTipoOraRegistrazione()) || TipoOraRegistrazione.SINCRONIZZATO.equals((Object)ris.getTipoOraRegistrazione());
                            }
                            if (!generazioneAttributo) throw new ProtocolException("TipoOraRegistrazione e' un attributo obbligatorio in un Riscontro, e il valore non e' utilizzabile rispetto all'xsd (" + ris.getTipoOraRegistrazioneValue(this.factory) + ")");
                            if (TipoOraRegistrazione.LOCALE.equals((Object)ris.getTipoOraRegistrazione())) {
                                ora.setAttribute("tempo", "EGOV_IT_Locale");
                                continue;
                            }
                            ora.setAttribute("tempo", "EGOV_IT_SPC");
                            continue;
                        }
                        ora.setAttribute("tempo", "EGOV_IT_SPC");
                        continue;
                    }
                    if (!verificaPresenzaElementiObbligatori) continue;
                    throw new ProtocolException("OraRegistrazione e' un elemento obbligatorio in un Riscontro, e non e' stato definito");
                }
            }
            if (eGov.sizeListaTrasmissioni() > 0) {
                boolean addFirstElement = false;
                SOAPElement eGovListaTrasmissioni = null;
                for (int i = 0; i < eGov.sizeListaTrasmissioni(); ++i) {
                    Trasmissione tr = eGov.getTrasmissione(i);
                    if (tr.getOrigine() == null || tr.getTipoOrigine() == null || tr.getDestinazione() == null || tr.getTipoDestinazione() == null || tr.getOraRegistrazione() == null || tr.getTempo() == null) continue;
                    if (!addFirstElement) {
                        eGovListaTrasmissioni = eGovHeader.addChildElement("ListaTrasmissioni", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                        addFirstElement = true;
                    }
                    SOAPElement Trasmissione2 = eGovListaTrasmissioni.addChildElement("Trasmissione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    SOAPElement orig = Trasmissione2.addChildElement("Origine", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    SOAPElement IDParteOrigine = orig.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    IDParteOrigine.setValue(tr.getOrigine());
                    String tipoOrigine = null;
                    try {
                        tipoOrigine = this.traduttore.toProtocolOrganizationType(tr.getTipoOrigine());
                    }
                    catch (Exception e) {
                        if (!this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            throw e;
                        }
                        tipoOrigine = tr.getTipoOrigine();
                        this.log.warn("Produco busta con un tipo origine nella lista trasmissione non corretto: '" + tipoOrigine + "'");
                    }
                    IDParteOrigine.setAttribute("tipo", tipoOrigine);
                    if (tr.getIndirizzoOrigine() != null) {
                        IDParteOrigine.setAttribute("indirizzoTelematico", tr.getIndirizzoOrigine());
                    }
                    SOAPElement dest = Trasmissione2.addChildElement("Destinazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    SOAPElement IDParteDest = dest.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    IDParteDest.setValue(tr.getDestinazione());
                    String tipoDestinazione = null;
                    try {
                        tipoDestinazione = this.traduttore.toProtocolOrganizationType(tr.getTipoDestinazione());
                    }
                    catch (Exception e) {
                        if (!this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                            throw e;
                        }
                        tipoDestinazione = tr.getTipoDestinazione();
                        this.log.warn("Produco busta con un tipo destinazione nella lista trasmissione non corretto: '" + tipoDestinazione + "'");
                    }
                    IDParteDest.setAttribute("tipo", tipoDestinazione);
                    if (tr.getIndirizzoDestinazione() != null) {
                        IDParteDest.setAttribute("indirizzoTelematico", tr.getIndirizzoDestinazione());
                    }
                    SOAPElement ora = Trasmissione2.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                    ora.setValue(SPCoopUtils.getDate_eGovFormat(tr.getOraRegistrazione()));
                    boolean generazioneAttributo = true;
                    if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        boolean bl = generazioneAttributo = TipoOraRegistrazione.LOCALE.equals((Object)tr.getTempo()) || TipoOraRegistrazione.SINCRONIZZATO.equals((Object)tr.getTempo());
                    }
                    if (!generazioneAttributo) throw new ProtocolException("Tempo e' un attributo obbligatorio in una trasmissione, e il valore non e' utilizzabile rispetto all'xsd (" + tr.getTempoValue(this.factory) + ")");
                    if (TipoOraRegistrazione.LOCALE.equals((Object)tr.getTempo())) {
                        ora.setAttribute("tempo", "EGOV_IT_Locale");
                        continue;
                    }
                    ora.setAttribute("tempo", "EGOV_IT_SPC");
                }
            }
            if (eGov.sizeListaEccezioni() <= 0) return eGovHeader;
            SOAPElement eGovListaEccezioni = eGovHeader.addChildElement("ListaEccezioni", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            for (int i = 0; i < eGov.sizeListaEccezioni(); ++i) {
                boolean generazioneAttributo;
                Eccezione ecc = eGov.getEccezione(i);
                SOAPElement eccezione = eGovListaEccezioni.addChildElement("Eccezione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                if (ecc.getContestoCodifica() != null) {
                    eccezione.setAttribute("contestoCodifica", ecc.getContestoCodificaValue(this.factory));
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new ProtocolException("ContestoCodifica e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getCodiceEccezione() != null) {
                    generazioneAttributo = true;
                    if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        generazioneAttributo = this.validazioneSintattica.validazioneCodiceEccezione(ecc.getCodiceEccezione());
                    }
                    if (!generazioneAttributo) throw new ProtocolException("CodiceEccezione e' un attributo obbligatorio in una eccezione, e il valore non e' utilizzabile rispetto all'xsd (" + String.valueOf(ecc.getCodiceEccezione()) + ")");
                    eccezione.setAttribute("codiceEccezione", ecc.getCodiceEccezioneValue(this.factory));
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new ProtocolException("CodiceEccezione e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getRilevanza() != null) {
                    generazioneAttributo = true;
                    if (!forzaValidazioneXSDElementiDisabilitata && !this.protocolManager.isGenerazioneElementiNonValidabiliRispettoXSD()) {
                        boolean bl = generazioneAttributo = LivelloRilevanza.DEBUG.equals((Object)ecc.getRilevanza()) || LivelloRilevanza.ERROR.equals((Object)ecc.getRilevanza()) || LivelloRilevanza.FATAL.equals((Object)ecc.getRilevanza()) || LivelloRilevanza.INFO.equals((Object)ecc.getRilevanza()) || LivelloRilevanza.WARN.equals((Object)ecc.getRilevanza());
                    }
                    if (!generazioneAttributo) throw new ProtocolException("Rilevanza e' un attributo obbligatorio in una eccezione, e il valore non e' utilizzabile rispetto all'xsd (" + String.valueOf(ecc.getRilevanza()) + ")");
                    eccezione.setAttribute("rilevanza", this.traduttore.toString(ecc.getRilevanza()));
                } else if (verificaPresenzaElementiObbligatori) {
                    throw new ProtocolException("Rilevanza e' un attributo obbligatorio in una eccezione, e non e' stato definito");
                }
                if (ecc.getDescrizione(this.factory) != null) {
                    eccezione.setAttribute("posizione", ecc.getDescrizione(this.factory));
                    continue;
                }
                if (!verificaPresenzaElementiObbligatori) continue;
                throw new ProtocolException("Posizione e' un attributo obbligatorio in una eccezione, e non e' stato definito");
            }
            return eGovHeader;
        }
        catch (Exception e) {
            this.log.error("Creazione busta eGov non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Creazione busta eGov non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    private String normalizeIdRefManifest(String contentId) {
        StringBuilder bf = new StringBuilder();
        if (this.spcoopProperties.isGenerateManifestAttachmentsIdWithBrackets()) {
            if (!contentId.startsWith("<")) {
                bf.append("<");
            }
            bf.append(contentId);
            if (!contentId.endsWith(">")) {
                bf.append(">");
            }
        } else {
            int start = 0;
            int end = contentId.length();
            if (contentId.startsWith("<")) {
                start = 1;
            }
            if (contentId.endsWith(">")) {
                end = contentId.length() - 1;
            }
            bf.append(contentId.substring(start, end));
        }
        return bf.toString();
    }

    public OpenSPCoop2Message build_eGovManifest(OpenSPCoop2Message msg, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            SOAPElement descrizione = msg.getFactory().createEmptyMessage(MessageType.SOAP_11, MessageRole.NONE).castAsSoap().getSOAPBody().addChildElement(new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "Descrizione", "eGov_IT"));
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            Iterator iter = soapMsg.getAttachments();
            int attach = 1;
            while (iter.hasNext()) {
                Utilities.printFreeMemory((String)("Imbustamento - Costruzione manifest att " + attach));
                AttachmentPart p = (AttachmentPart)iter.next();
                String contentID = p.getContentId();
                String contentLocation = p.getContentLocation();
                String contentType = p.getContentType();
                SOAPElement descrizioneMessaggio = descrizione.addChildElement("DescrizioneMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                SOAPElement riferimento = descrizioneMessaggio.addChildElement("Riferimento", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                if (contentID != null) {
                    riferimento.setAttribute("href", "cid:" + this.normalizeIdRefManifest(contentID));
                } else {
                    riferimento.setAttribute("href", contentLocation);
                }
                if (attach == 1 && proprietaManifestAttachments.isScartaBody()) {
                    if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                        riferimento.setAttribute("role", this.spcoopProperties.getRoleRichiestaManifest());
                    } else {
                        riferimento.setAttribute("role", this.spcoopProperties.getRoleRispostaManifest());
                    }
                } else {
                    riferimento.setAttribute("role", this.spcoopProperties.getRoleAllegatoManifest());
                }
                QName id = new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "eGov_IT");
                riferimento.addAttribute(id, "attachment" + attach);
                SOAPElement schema = riferimento.addChildElement("Schema", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                schema.setAttribute("posizione", contentType);
                SOAPElement titolo = riferimento.addChildElement("Titolo", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                titolo.setAttribute("Lingua", "it");
                if (attach == 1 && proprietaManifestAttachments.isScartaBody()) {
                    if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                        titolo.setValue(this.spcoopProperties.getRoleRichiestaManifest());
                    } else {
                        titolo.setValue(this.spcoopProperties.getRoleRispostaManifest());
                    }
                } else {
                    titolo.setValue("attachment" + attach);
                }
                ++attach;
            }
            if (!proprietaManifestAttachments.isScartaBody()) {
                Utilities.printFreeMemory((String)"Imbustamento - Scarta Body");
                byte[] body = TunnelSoapUtils.sbustamentoSOAPEnvelope((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (SOAPEnvelope)soapMsg.getSOAPPart().getEnvelope());
                AttachmentPart ap = null;
                boolean bodyWithMultiRootElement = false;
                if (body == null || body.length == 0) {
                    body = "<eGov_IT:SoapBodyEmpty xmlns:eGov_IT=\"http://www.openspcoop2.org/spcoop/manifest/body\" />".getBytes();
                } else {
                    List listNode = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)soapMsg.getFactory(), (Node)soapMsg.getSOAPPart().getEnvelope().getBody(), (boolean)false);
                    if (listNode != null && listNode.size() > 1) {
                        bodyWithMultiRootElement = true;
                    }
                }
                if (bodyWithMultiRootElement) {
                    isSource = new InputStreamDataSource("ManifestEGov", "application/octet-stream", body);
                    ap = soapMsg.createAttachmentPart(new DataHandler((DataSource)isSource));
                } else if (MailcapActivationReader.existsDataContentHandler((String)"text/xml")) {
                    ap = soapMsg.createAttachmentPart();
                    soapMsg.updateAttachmentPart(ap, body, "text/xml");
                } else {
                    isSource = new InputStreamDataSource("ManifestEGov", "text/xml", body);
                    ap = soapMsg.createAttachmentPart(new DataHandler((DataSource)isSource));
                }
                ap.setContentId(soapMsg.createContentID("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/"));
                soapMsg.addAttachmentPart(ap);
                SOAPElement descrizioneMessaggio = descrizione.addChildElement("DescrizioneMessaggio", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                SOAPElement riferimento = descrizioneMessaggio.addChildElement("Riferimento", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                riferimento.setAttribute("href", "cid:" + this.normalizeIdRefManifest(ap.getContentId()));
                if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                    riferimento.setAttribute("role", this.spcoopProperties.getRoleRichiestaManifest());
                } else {
                    riferimento.setAttribute("role", this.spcoopProperties.getRoleRispostaManifest());
                }
                QName id = new QName("http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/", "id", "eGov_IT");
                riferimento.addAttribute(id, "attachment" + attach);
                SOAPElement schema = riferimento.addChildElement("Schema", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                schema.setAttribute("posizione", ap.getContentType());
                SOAPElement titolo = riferimento.addChildElement("Titolo", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
                titolo.setAttribute("Lingua", "it");
                if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                    titolo.setValue(this.spcoopProperties.getRoleRichiestaManifest());
                } else {
                    titolo.setValue(this.spcoopProperties.getRoleRispostaManifest());
                }
            }
            Utilities.printFreeMemory((String)"Imbustamento - Add Manifest in Body");
            soapMsg.getSOAPBody().removeContents();
            soapMsg.getSOAPBody().addChildElement(descrizione);
            return msg;
        }
        catch (Exception e) {
            this.log.error("Creazione Manifest degli attachments non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Creazione Manifest degli attachments non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public void imbustamentoEGov(OpenSPCoop2Message msg, Busta busta, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        this.imbustamentoEGov(msg, busta, RuoloMessaggio.RISPOSTA, proprietaManifestAttachments);
    }

    public SOAPHeaderElement imbustamentoEGov(OpenSPCoop2Message msg, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            Utilities.printFreeMemory((String)"Imbustamento - Creazione header eGov");
            SOAPHeaderElement headerEGovElement = this.build_eGovHeader(msg, busta);
            Utilities.printFreeMemory((String)"Imbustamento - imbustamento");
            this.imbustamentoEGov(msg, headerEGovElement, ruoloMessaggio, proprietaManifestAttachments);
            return headerEGovElement;
        }
        catch (Exception e) {
            this.log.error("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPHeaderElement imbustamentoEGov(OpenSPCoop2Message msg, SOAPHeaderElement headerEGovElement, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        try {
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            SOAPHeader hdr = soapMsg.getSOAPHeader();
            if (hdr == null) {
                hdr = soapMsg.getSOAPPart().getEnvelope().addHeader();
            }
            soapMsg.addHeaderElement(hdr, headerEGovElement);
            Utilities.printFreeMemory((String)"Imbustamento -Header Aggiunto");
            if (proprietaManifestAttachments != null && proprietaManifestAttachments.isGestioneManifest() && soapMsg.countAttachments() > 0) {
                Utilities.printFreeMemory((String)"Imbustamento - Gestione Manifest");
                this.build_eGovManifest(msg, ruoloMessaggio, proprietaManifestAttachments);
            }
            return headerEGovElement;
        }
        catch (Exception e) {
            this.log.error("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("ImbustamentoEGov non riuscito: " + e.getMessage(), (Throwable)e);
        }
    }

    public void build_trasmissione(Trasmissione trasmissione, SOAPElement listaTrasmissioni) throws ProtocolException {
        try {
            SOAPElement trasmissioneNode = listaTrasmissioni.addChildElement("Trasmissione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement orig = trasmissioneNode.addChildElement("Origine", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement IDParteOrigine = orig.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            IDParteOrigine.setValue(trasmissione.getOrigine());
            IDParteOrigine.setAttribute("tipo", trasmissione.getTipoOrigine());
            if (trasmissione.getIndirizzoOrigine() != null) {
                IDParteOrigine.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoOrigine());
            }
            SOAPElement dest = trasmissioneNode.addChildElement("Destinazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            SOAPElement IDParteDest = dest.addChildElement("IdentificativoParte", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            IDParteDest.setValue(trasmissione.getDestinazione());
            IDParteDest.setAttribute("tipo", trasmissione.getTipoDestinazione());
            if (trasmissione.getIndirizzoDestinazione() != null) {
                IDParteDest.setAttribute("indirizzoTelematico", trasmissione.getIndirizzoDestinazione());
            }
            SOAPElement ora = trasmissioneNode.addChildElement("OraRegistrazione", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            ora.setValue(SPCoopUtils.getDate_eGovFormat(trasmissione.getOraRegistrazione()));
            if (TipoOraRegistrazione.LOCALE.equals((Object)trasmissione.getTempo())) {
                ora.setAttribute("tempo", "EGOV_IT_Locale");
            } else if (TipoOraRegistrazione.SINCRONIZZATO.equals((Object)trasmissione.getTempo())) {
                ora.setAttribute("tempo", "EGOV_IT_SPC");
            } else {
                ora.setAttribute("tempo", trasmissione.getTempoValue(this.factory));
            }
        }
        catch (Exception e) {
            this.log.error("Creazione trasmissione non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Creazione trasmissione non riuscita: " + e.getMessage(), (Throwable)e);
        }
    }

    public SOAPHeaderElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione, boolean readQualifiedAttribute) throws ProtocolException {
        SOAPHeaderElement eGovHeaderOLD = null;
        SOAPHeaderElement eGovHeaderNEW = null;
        try {
            SOAPElement mChild;
            SPCoopBustaRawContent bustaElement = this.validazioneSintattica.getHeaderEGov(message.castAsSoap(), readQualifiedAttribute);
            if (bustaElement == null) {
                throw new ProtocolException("Header eGov non esistente");
            }
            eGovHeaderOLD = (SOAPHeaderElement)bustaElement.getElement();
            if (eGovHeaderOLD == null) {
                throw new ProtocolException("Header eGov non esistente");
            }
            OpenSPCoop2SoapMessage soapMsg = message.castAsSoap();
            eGovHeaderNEW = message.getFactory().createEmptyMessage(MessageType.SOAP_11, MessageRole.NONE).castAsSoap().getSOAPHeader().addHeaderElement(new QName(eGovHeaderOLD.getNamespaceURI(), eGovHeaderOLD.getLocalName(), eGovHeaderOLD.getPrefix()));
            eGovHeaderNEW.setActor(eGovHeaderOLD.getActor());
            eGovHeaderNEW.setMustUnderstand(eGovHeaderOLD.getMustUnderstand());
            Iterator namespaces = eGovHeaderOLD.getNamespacePrefixes();
            while (namespaces.hasNext()) {
                String mNamespace = (String)namespaces.next();
                eGovHeaderNEW.addNamespaceDeclaration(mNamespace, eGovHeaderOLD.getNamespaceURI(mNamespace));
            }
            Iterator attributes = eGovHeaderOLD.getAllAttributes();
            while (attributes.hasNext()) {
                Name mAttribute = (Name)attributes.next();
                eGovHeaderNEW.addAttribute(mAttribute, eGovHeaderOLD.getAttributeValue(mAttribute));
            }
            Iterator child = eGovHeaderOLD.getChildElements();
            while (child.hasNext()) {
                Object oChild = child.next();
                if (!(oChild instanceof SOAPElement)) continue;
                mChild = (SOAPElement)oChild;
                eGovHeaderNEW.addChildElement(mChild);
            }
            child = eGovHeaderNEW.getChildElements();
            SOAPElement listaTrasmissioni = null;
            while (child.hasNext()) {
                mChild = (SOAPElement)child.next();
                if (!"ListaTrasmissioni".equals(mChild.getLocalName())) continue;
                listaTrasmissioni = mChild;
                break;
            }
            if (listaTrasmissioni == null) {
                listaTrasmissioni = eGovHeaderNEW.addChildElement("ListaTrasmissioni", "eGov_IT", "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/");
            }
            this.build_trasmissione(trasmissione, listaTrasmissioni);
            soapMsg.getSOAPHeader().removeChild((Node)eGovHeaderOLD);
            SOAPHeaderElement sOAPHeaderElement = this.imbustamentoEGov(message, eGovHeaderNEW, RuoloMessaggio.RISPOSTA, null);
            return sOAPHeaderElement;
        }
        catch (Exception e) {
            this.log.error("addTrasmissione non riuscita: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("addTrasmissione non riuscita: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.validazioneSintattica != null) {
                this.validazioneSintattica.setHeaderSOAP(null);
            }
            eGovHeaderOLD = null;
            eGovHeaderNEW = null;
        }
    }

    public SOAPHeaderElement imbustamento(OpenSPCoop2Message msg, Busta busta, RuoloMessaggio ruoloMessaggio, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        if (busta.getProfiloDiCollaborazione() != null) {
            switch (busta.getProfiloDiCollaborazione()) {
                case ONEWAY: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY, "EGOV_IT_MessaggioSingoloOneWay");
                    break;
                }
                case SINCRONO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO, "EGOV_IT_ServizioSincrono");
                    break;
                }
                case ASINCRONO_ASIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO, "EGOV_IT_ServizioAsincronoAsimmetrico");
                    break;
                }
                case ASINCRONO_SIMMETRICO: {
                    busta.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO, "EGOV_IT_ServizioAsincronoSimmetrico");
                    break;
                }
            }
        }
        if (busta.getTipoOraRegistrazione() != null) {
            switch (busta.getTipoOraRegistrazione()) {
                case LOCALE: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE, "EGOV_IT_Locale");
                    break;
                }
                case SINCRONIZZATO: {
                    busta.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO, "EGOV_IT_SPC");
                    break;
                }
            }
        }
        if (busta.getInoltro() != null) {
            switch (busta.getInoltro()) {
                case CON_DUPLICATI: {
                    busta.setInoltro(Inoltro.CON_DUPLICATI, "EGOV_IT_PIUDIUNAVOLTA");
                    break;
                }
                case SENZA_DUPLICATI: {
                    busta.setInoltro(Inoltro.SENZA_DUPLICATI, "EGOV_IT_ALPIUUNAVOLTA");
                    break;
                }
            }
        }
        for (Riscontro riscontro : busta.getListaRiscontri()) {
            if (riscontro.getTipoOraRegistrazione() == null) continue;
            if (riscontro.getTipoOraRegistrazione().equals((Object)TipoOraRegistrazione.LOCALE)) {
                riscontro.setTipoOraRegistrazioneValue("EGOV_IT_Locale");
            }
            if (!riscontro.getTipoOraRegistrazione().equals((Object)TipoOraRegistrazione.SINCRONIZZATO)) continue;
            riscontro.setTipoOraRegistrazioneValue("EGOV_IT_SPC");
        }
        for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
            if (trasmissione.getTempo() == null) continue;
            if (trasmissione.getTempo().equals((Object)TipoOraRegistrazione.LOCALE)) {
                trasmissione.setTempoValue("EGOV_IT_Locale");
                continue;
            }
            trasmissione.setTempoValue("EGOV_IT_SPC");
        }
        return this.imbustamentoEGov(msg, busta, ruoloMessaggio, proprietaManifestAttachments);
    }

    public SOAPHeaderElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione) throws ProtocolException {
        return this.addTrasmissione(message, trasmissione, false);
    }
}

