/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.builder;

import it.cnipa.schemas._2003.egovit.exception1_0.Eccezione;
import it.cnipa.schemas._2003.egovit.exception1_0.EccezioneBusta;
import it.cnipa.schemas._2003.egovit.exception1_0.EccezioneProcessamento;
import it.cnipa.schemas._2003.egovit.exception1_0.MessaggioDiErroreApplicativo;
import it.cnipa.schemas._2003.egovit.exception1_0.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.util.Date;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.builder.CodeDetailsError;
import org.openspcoop2.protocol.basic.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.basic.builder.ErroreApplicativoMessageUtils;
import org.openspcoop2.protocol.sdk.AbstractEccezioneBuilderParameter;
import org.openspcoop2.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import org.openspcoop2.protocol.sdk.EccezioneProtocolloBuilderParameters;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.KeyValueObject;
import org.openspcoop2.protocol.sdk.constants.TipoErroreApplicativo;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class SPCoopErroreApplicativoBuilder
extends ErroreApplicativoBuilder
implements IErroreApplicativoBuilder {
    public SPCoopErroreApplicativoBuilder(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public String getNamespaceEccezioneProtocollo(String defaultNamespace) {
        return "http://www.cnipa.it/schemas/2003/eGovIT/Busta1_0/";
    }

    public boolean isErroreApplicativo(String namespace, String localName) {
        return "MessaggioDiErroreApplicativo".equals(localName) && "http://www.cnipa.it/schemas/2003/eGovIT/Exception1_0/".equals(namespace);
    }

    protected Element _buildErroreApplicativo_Element(CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        MessaggioDiErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
        try {
            byte[] xmlErroreApplicativo = XMLUtils.generateErroreApplicativo(erroreApplicativo);
            Element elementErroreApplicativo = this.xmlUtils.newElement(xmlErroreApplicativo);
            ErroreApplicativoMessageUtils.addPrefixToElement((Element)elementErroreApplicativo, (String)"cnipaErrAppl");
            return elementErroreApplicativo;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("buildErroreApplicativoElement failed: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String _buildErroreApplicativo_String(TipoErroreApplicativo tipoErroreApplicativo, boolean omitXMLDeclaration, CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            if (TipoErroreApplicativo.JSON.equals((Object)tipoErroreApplicativo)) {
                MessaggioDiErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                return XMLUtils.generateErroreApplicativoAsJson(erroreApplicativo);
            }
            Element element = this._buildErroreApplicativo_Element(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
            return this.xmlUtils.toString(element, omitXMLDeclaration);
        }
        catch (Exception e) {
            throw new ProtocolException("toString failed: " + e.getMessage());
        }
    }

    protected byte[] _buildErroreApplicativo_ByteArray(TipoErroreApplicativo tipoErroreApplicativo, boolean omitXMLDeclaration, CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            if (TipoErroreApplicativo.JSON.equals((Object)tipoErroreApplicativo)) {
                MessaggioDiErroreApplicativo erroreApplicativo = this._buildErroreApplicativo_engine(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
                return XMLUtils.generateErroreApplicativoAsJson(erroreApplicativo).getBytes();
            }
            Element element = this._buildErroreApplicativo_Element(codeDetailsErrorWrapper, eccezioneProtocollo, eccezioneIntegrazione);
            return this.xmlUtils.toByteArray(element, omitXMLDeclaration);
        }
        catch (Exception e) {
            throw new ProtocolException("toByteArray failed: " + e.getMessage());
        }
    }

    private MessaggioDiErroreApplicativo _buildErroreApplicativo_engine(CodeDetailsError codeDetailsErrorWrapper, EccezioneProtocolloBuilderParameters eccezioneProtocollo, EccezioneIntegrazioneBuilderParameters eccezioneIntegrazione) throws ProtocolException {
        try {
            ErroriProperties erroriProperties = ErroriProperties.getInstance((Logger)this.log);
            MessaggioDiErroreApplicativo erroreApplicativo = new MessaggioDiErroreApplicativo();
            String idPorta = null;
            String idFunzione = null;
            String codiceEccezione = null;
            String descrizioneEccezione = null;
            Date oraRegistrazione = null;
            IntegrationFunctionError functionError = null;
            boolean genericDetails = true;
            if (eccezioneProtocollo != null) {
                idPorta = eccezioneProtocollo.getDominioPorta().getCodicePorta();
                idFunzione = eccezioneProtocollo.getIdFunzione();
                codiceEccezione = this.traduttore.toString(eccezioneProtocollo.getEccezioneProtocollo().getCodiceEccezione(), eccezioneProtocollo.getEccezioneProtocollo().getSubCodiceEccezione());
                descrizioneEccezione = eccezioneProtocollo.getEccezioneProtocollo().getDescrizione(this.protocolFactory);
                oraRegistrazione = eccezioneProtocollo.getOraRegistrazione();
                functionError = eccezioneProtocollo.getFunctionError();
                if (eccezioneProtocollo.getReturnConfig() != null) {
                    genericDetails = eccezioneProtocollo.getReturnConfig().isGenericDetails();
                }
                codeDetailsErrorWrapper.setPrefixCode("protocol:");
                codeDetailsErrorWrapper.setCode(codiceEccezione);
                codeDetailsErrorWrapper.setDetails(descrizioneEccezione);
            } else {
                idPorta = eccezioneIntegrazione.getDominioPorta().getCodicePorta();
                idFunzione = eccezioneIntegrazione.getIdFunzione();
                codiceEccezione = this.traduttore.toCodiceErroreIntegrazioneAsString(eccezioneIntegrazione.getErroreIntegrazione(), eccezioneIntegrazione.getProprieta().getFaultPrefixCode(), eccezioneIntegrazione.getProprieta().isFaultAsGenericCode());
                descrizioneEccezione = eccezioneIntegrazione.getProprieta().transformFaultMsg(eccezioneIntegrazione.getErroreIntegrazione(), this.protocolFactory);
                oraRegistrazione = eccezioneIntegrazione.getOraRegistrazione();
                functionError = eccezioneIntegrazione.getFunctionError();
                if (eccezioneIntegrazione.getReturnConfig() != null) {
                    genericDetails = eccezioneIntegrazione.getReturnConfig().isGenericDetails();
                }
                codeDetailsErrorWrapper.setPrefixCode("integration:");
                codeDetailsErrorWrapper.setCode(codiceEccezione);
                codeDetailsErrorWrapper.setDetails(descrizioneEccezione);
            }
            if (!genericDetails && erroriProperties.isForceGenericDetails(functionError).booleanValue()) {
                genericDetails = true;
            }
            if (Costanti.isTRANSACTION_FORCE_SPECIFIC_ERROR_DETAILS()) {
                genericDetails = false;
            }
            if (oraRegistrazione == null) {
                oraRegistrazione = DateManager.getDate();
            }
            erroreApplicativo.setOraRegistrazione(oraRegistrazione);
            erroreApplicativo.setIdentificativoPorta(idPorta);
            erroreApplicativo.setIdentificativoFunzione(idFunzione);
            Eccezione eccezione = new Eccezione();
            if (eccezioneProtocollo != null) {
                EccezioneBusta eccezioneBusta = new EccezioneBusta();
                eccezioneBusta.setCodiceEccezione(codiceEccezione);
                if (!genericDetails) {
                    eccezioneBusta.setDescrizioneEccezione(descrizioneEccezione);
                } else {
                    eccezioneBusta.setDescrizioneEccezione(erroriProperties.getGenericDetails(functionError));
                }
                eccezione.setEccezioneBusta(eccezioneBusta);
            } else {
                EccezioneProcessamento eccezioneProcessamento = new EccezioneProcessamento();
                if (Costanti.isTRANSACTION_ERROR_STATUS_ABILITATO()) {
                    eccezioneProcessamento.setCodiceEccezione(codiceEccezione);
                } else {
                    String govwayType = erroriProperties.getErrorType(functionError);
                    eccezioneProcessamento.setCodiceEccezione(govwayType);
                }
                if (!genericDetails) {
                    eccezioneProcessamento.setDescrizioneEccezione(descrizioneEccezione);
                } else {
                    eccezioneProcessamento.setDescrizioneEccezione(erroriProperties.getGenericDetails(functionError));
                }
                eccezione.setEccezioneProcessamento(eccezioneProcessamento);
            }
            erroreApplicativo.setEccezione(eccezione);
            return erroreApplicativo;
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildElement_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("buildErroreApplicativoElement failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public AbstractEccezioneBuilderParameter readErroreApplicativo(TipoErroreApplicativo tipoErroreApplicativo, byte[] erroreApplicativo, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        MessaggioDiErroreApplicativo erroreApplicativoObject = null;
        switch (tipoErroreApplicativo) {
            case JSON: {
                try {
                    erroreApplicativoObject = XMLUtils.getErroreApplicativoFromJson(this.log, new ByteArrayInputStream(erroreApplicativo));
                    break;
                }
                catch (Exception e) {
                    throw new ProtocolException("JSon fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol() + ": " + e.getMessage(), (Throwable)e);
                }
            }
            default: {
                if (!XMLUtils.isErroreApplicativo(erroreApplicativo)) {
                    throw new ProtocolException("XML fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol());
                }
                try {
                    erroreApplicativoObject = XMLUtils.getErroreApplicativo(this.log, erroreApplicativo);
                    break;
                }
                catch (Exception e) {
                    throw new ProtocolException("Xml fornito non contiene un errore applicativo per il protocollo " + this.getProtocolFactory().getProtocol() + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return this._parseErroreApplicativo(erroreApplicativoObject, prefixCodiceErroreApplicativoIntegrazione);
    }

    private AbstractEccezioneBuilderParameter _parseErroreApplicativo(MessaggioDiErroreApplicativo erroreApplicativo, String prefixCodiceErroreApplicativoIntegrazione) throws ProtocolException {
        try {
            String identificativoPorta = erroreApplicativo.getIdentificativoPorta();
            String identificativoFunzione = erroreApplicativo.getIdentificativoFunzione();
            EccezioneProtocolloBuilderParameters eccezione = null;
            if (erroreApplicativo.getEccezione().getEccezioneBusta() != null) {
                eccezione = new EccezioneProtocolloBuilderParameters();
                codice = this.protocolFactory.createTraduttore().toCodiceErroreCooperazione(erroreApplicativo.getEccezione().getEccezioneBusta().getCodiceEccezione());
                ErroreCooperazione erroreCooperazione = new ErroreCooperazione(erroreApplicativo.getEccezione().getEccezioneBusta().getDescrizioneEccezione(), codice);
                org.openspcoop2.protocol.sdk.Eccezione eccezioneProtocollo = new org.openspcoop2.protocol.sdk.Eccezione(erroreCooperazione, true, identificativoFunzione, this.protocolFactory);
                eccezione.setEccezioneProtocollo(eccezioneProtocollo);
            } else {
                eccezione = new EccezioneIntegrazioneBuilderParameters();
                codice = this.protocolFactory.createTraduttore().toCodiceErroreIntegrazione(erroreApplicativo.getEccezione().getEccezioneProcessamento().getCodiceEccezione(), prefixCodiceErroreApplicativoIntegrazione);
                ErroreIntegrazione erroreIntegrazione = new ErroreIntegrazione(erroreApplicativo.getEccezione().getEccezioneProcessamento().getDescrizioneEccezione(), (CodiceErroreIntegrazione)codice, new KeyValueObject[0]);
                ((EccezioneIntegrazioneBuilderParameters)eccezione).setErroreIntegrazione(erroreIntegrazione);
            }
            IDSoggetto dominio = new IDSoggetto();
            dominio.setCodicePorta(identificativoPorta);
            eccezione.setDominioPorta(dominio);
            eccezione.setOraRegistrazione(erroreApplicativo.getOraRegistrazione());
            eccezione.setIdFunzione(identificativoFunzione);
            return eccezione;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }
}

