/*
 * Decompiled with CFR 0.152.
 */
package it.cnipa.schemas._2003.egovit.exception1_0.utils;

import it.cnipa.schemas._2003.egovit.exception1_0.Eccezione;
import it.cnipa.schemas._2003.egovit.exception1_0.EccezioneBusta;
import it.cnipa.schemas._2003.egovit.exception1_0.EccezioneProcessamento;
import it.cnipa.schemas._2003.egovit.exception1_0.MessaggioDiErroreApplicativo;
import it.cnipa.schemas._2003.egovit.exception1_0.utils.ProjectInfo;
import it.cnipa.schemas._2003.egovit.exception1_0.utils.XMLUtilsException;
import it.cnipa.schemas._2003.egovit.exception1_0.utils.XSDValidator;
import it.cnipa.schemas._2003.egovit.exception1_0.utils.serializer.JsonJacksonDeserializer;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPFault;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    public static boolean validate(MessaggioDiErroreApplicativo erroreApplicativo, StringBuilder motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (erroreApplicativo.getOraRegistrazione() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (erroreApplicativo.getIdentificativoPorta() == null) {
            motivoErroreValidazione.append("IdentificativoPorta non definito\n");
        }
        if (erroreApplicativo.getIdentificativoFunzione() == null) {
            motivoErroreValidazione.append("IdentificativoFunzione non definito\n");
        }
        XMLUtils.validate(erroreApplicativo.getEccezione(), motivoErroreValidazione);
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Eccezione eccezione, StringBuilder motivoErroreValidazione) {
        if (eccezione == null) {
            motivoErroreValidazione.append("Eccezione non definita\n");
        } else if (eccezione.getEccezioneBusta() == null && eccezione.getEccezioneProcessamento() == null) {
            motivoErroreValidazione.append("Nessuna eccezione (busta o processamento) definita\n");
        } else if (eccezione.getEccezioneBusta() != null && eccezione.getEccezioneProcessamento() != null) {
            motivoErroreValidazione.append("Entrambe le eccezioni (busta o processamento) sono definite\n");
        } else if (eccezione.getEccezioneBusta() != null) {
            XMLUtils.validate(eccezione.getEccezioneBusta(), motivoErroreValidazione);
        } else {
            XMLUtils.validate(eccezione.getEccezioneProcessamento(), motivoErroreValidazione);
        }
    }

    private static void validate(EccezioneBusta eccezione, StringBuilder motivoErroreValidazione) {
        if (eccezione == null) {
            motivoErroreValidazione.append("EccezioneBusta non definita\n");
        } else {
            if (eccezione.getCodiceEccezione() == null) {
                motivoErroreValidazione.append("EccezioneBusta.codiceEccezione non definito\n");
            }
            if (eccezione.getDescrizioneEccezione() == null) {
                motivoErroreValidazione.append("EccezioneBusta.descrizioneEccezione non definito\n");
            }
        }
    }

    private static void validate(EccezioneProcessamento eccezione, StringBuilder motivoErroreValidazione) {
        if (eccezione == null) {
            motivoErroreValidazione.append("EccezioneProcessamento non definita\n");
        } else {
            if (eccezione.getCodiceEccezione() == null) {
                motivoErroreValidazione.append("EccezioneProcessamento.codiceEccezione non definito\n");
            }
            if (eccezione.getDescrizioneEccezione() == null) {
                motivoErroreValidazione.append("EccezioneProcessamento.descrizioneEccezione non definito\n");
            }
        }
    }

    public static MessaggioDiErroreApplicativo getErroreApplicativo(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            MessaggioDiErroreApplicativo messaggioDiErroreApplicativo = XMLUtils.getErroreApplicativo(log, bin);
            return messaggioDiErroreApplicativo;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static MessaggioDiErroreApplicativo getErroreApplicativo(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            MessaggioDiErroreApplicativo messaggioDiErroreApplicativo = XMLUtils.getErroreApplicativo(log, fin);
            return messaggioDiErroreApplicativo;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static MessaggioDiErroreApplicativo getErroreApplicativo(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getErroreApplicativo(log, m.getBytes());
    }

    public static MessaggioDiErroreApplicativo getErroreApplicativo(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            AbstractValidatoreXSD validatoreXSD = XSDValidator.getXSDValidator(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (MessaggioDiErroreApplicativo)JaxbUtils.xmlToObj((InputStream)binTrasformazione, MessaggioDiErroreApplicativo.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static MessaggioDiErroreApplicativo getErroreApplicativoFromJson(Logger log, InputStream is) throws XMLUtilsException {
        try {
            JsonJacksonDeserializer deserializer = new JsonJacksonDeserializer();
            return deserializer.readMessaggioDiErroreApplicativo(is);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(MessaggioDiErroreApplicativo eccezione, File out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateErroreApplicativo_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(MessaggioDiErroreApplicativo eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateErroreApplicativo_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateErroreApplicativo(MessaggioDiErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateErroreApplicativo_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static String generateErroreApplicativoAsJson(MessaggioDiErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateErroreApplicativoAsJson_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(MessaggioDiErroreApplicativo eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateErroreApplicativo_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateErroreApplicativo_engine(MessaggioDiErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, MessaggioDiErroreApplicativo.class, (Object)eccezione);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static String generateErroreApplicativoAsJson_engine(MessaggioDiErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            eccezione.writeTo(bout, WriteToSerializerType.JSON_JACKSON);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static MessaggioDiErroreApplicativo getErroreApplicativo(Logger log, OpenSPCoop2SoapMessage msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            Iterator itSF = faultOriginale.getChildElements(nameDetail);
            SOAPElement detailsFaultOriginale = null;
            if (itSF.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itSF.next();
            }
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isErroreApplicativo((Element)elem)) continue;
                        MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
                        byte[] xml = xmlUtils.toByteArray((Element)elem);
                        MessaggioDiErroreApplicativo de = XMLUtils.getErroreApplicativo(log, xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isErroreApplicativo(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isErroreApplicativo_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isErroreApplicativo(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isErroreApplicativo_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isErroreApplicativo(Element elemXML) {
        return XMLUtils.isErroreApplicativo_engine(elemXML);
    }

    public static boolean isErroreApplicativo(Node nodeXml) {
        return XMLUtils.isErroreApplicativo_engine(nodeXml);
    }

    private static boolean isErroreApplicativo_engine(Node nodeXml) {
        try {
            return "MessaggioDiErroreApplicativo".equals(nodeXml.getLocalName()) && ProjectInfo.getInstance().getProjectNamespace().equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

