/*
 * Decompiled with CFR 0.152.
 */
package it.cnipa.collprofiles.driver;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationListType;
import it.cnipa.collprofiles.OperationType;
import it.cnipa.collprofiles.constants.ProfiloDiCollaborazioneType;
import it.cnipa.collprofiles.driver.XMLUtilsException;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteComune;
import it.gov.spcoop.sica.dao.Documento;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(log, XMLUtils.class.getResourceAsStream("/SpecificaSemiformaleEGov.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(EgovDecllElement egov, StringBuilder motivoErroreValidazione) {
        OperationListType operations;
        int size = motivoErroreValidazione.length();
        if (egov.getEGovVersion() == null) {
            motivoErroreValidazione.append("VersioneEGov non definita\n");
        }
        if (egov.getRifDefinizioneInterfaccia() == null) {
            motivoErroreValidazione.append("RifInterfaccia non definita\n");
        }
        if ((operations = egov.getOperationList()) == null) {
            motivoErroreValidazione.append("OperationListType non presente\n");
        } else {
            if (operations.sizeOperationList() <= 0) {
                motivoErroreValidazione.append("OperationListType vuota\n");
            }
            for (int i = 0; i < operations.sizeOperationList(); ++i) {
                OperationType op = operations.getOperation(i);
                if (op.getServizio() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza il servizio\n");
                }
                if (op.getOperazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza l'operation\n");
                }
                if (op.getProfiloDiCollaborazione() == null) {
                    motivoErroreValidazione.append("OperationList[" + i + "] senza un profilo di collaborazione\n");
                }
                if (ProfiloDiCollaborazioneType.ONE_WAY.equals(op.getProfiloDiCollaborazione()) || ProfiloDiCollaborazioneType.SINCRONO.equals(op.getProfiloDiCollaborazione()) || ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO.equals(op.getProfiloDiCollaborazione()) || ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO.equals(op.getProfiloDiCollaborazione())) continue;
                motivoErroreValidazione.append("OperationList[" + i + "] con un profilo di collaborazione non conosciuto (" + String.valueOf(op.getProfiloDiCollaborazione()) + ")\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    public static EgovDecllElement getDichiarazioneEGov(Logger log, byte[] m, boolean acceptChildUnqualified) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            EgovDecllElement egovDecllElement = XMLUtils.getDichiarazioneEGov(log, bin, acceptChildUnqualified);
            return egovDecllElement;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static EgovDecllElement getDichiarazioneEGov(Logger log, File m, boolean acceptChildUnqualified) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            EgovDecllElement egovDecllElement = XMLUtils.getDichiarazioneEGov(log, fin, acceptChildUnqualified);
            return egovDecllElement;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static EgovDecllElement getDichiarazioneEGov(Logger log, String m, boolean acceptChildUnqualified) throws XMLUtilsException {
        return XMLUtils.getDichiarazioneEGov(log, m.getBytes(), acceptChildUnqualified);
    }

    public static EgovDecllElement getDichiarazioneEGov(Logger log, InputStream m, boolean acceptChildUnqualified) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            if (XMLUtils.isProfiloCollaborazioneEGOV_NamespaceSPCoopGovIT(xml)) {
                xml = bout.toString().replaceAll("spcoop\\.gov\\.it", "www.cnipa.it").getBytes();
            }
            if (acceptChildUnqualified) {
                xml = XMLUtils.unescapeXMLMalformatoChildElements(xml);
            }
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (EgovDecllElement)JaxbUtils.xmlToObj((InputStream)binTrasformazione, EgovDecllElement.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] unescapeXMLMalformatoChildElements(byte[] xml) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(xml);
            Element elemXML = docXML.getDocumentElement();
            String prefixRootElement = elemXML.getPrefix();
            String prefixChildElementEgovVersione = null;
            for (int i = 0; i < elemXML.getChildNodes().getLength(); ++i) {
                Node child = elemXML.getChildNodes().item(i);
                if (!"e-govVersion".equals(child.getLocalName())) continue;
                prefixChildElementEgovVersione = child.getPrefix();
            }
            if (prefixRootElement != null && prefixChildElementEgovVersione == null) {
                String xmlS = new String(xml);
                xmlS = xmlS.replace("<" + prefixRootElement + ":egovDecllElement", "<egovDecllElement");
                xmlS = xmlS.replace("xmlns:" + prefixRootElement, "xmlns");
                xmlS = xmlS.replace("</" + prefixRootElement + ":egovDecllElement", "</egovDecllElement");
                xml = xmlS.getBytes();
            }
            return xml;
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, File out, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, String fileName, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateDichiarazioneEGov(EgovDecllElement manifest, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateDichiarazioneEGov(EgovDecllElement manifest, OutputStream out, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateDichiarazioneEGov_engine(manifest, namespaceCnipa));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateDichiarazioneEGov_engine(EgovDecllElement manifest, boolean namespaceCnipa) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, EgovDecllElement.class, (Object)manifest);
            byte[] dichiarazione = bout.toByteArray();
            if (!namespaceCnipa) {
                dichiarazione = bout.toString().replaceAll("www\\.cnipa\\.it", "spcoop.gov.it").getBytes();
            }
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isProfiloCollaborazioneEGOV(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return "egovDecllElement".equals(elemXML.getLocalName()) && ("http://www.cnipa.it/collProfiles".equals(elemXML.getNamespaceURI()) || "http://spcoop.gov.it/collProfiles".equals(elemXML.getNamespaceURI()));
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isProfiloCollaborazioneEGOV_NamespaceSPCoopGovIT(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return "egovDecllElement".equals(elemXML.getLocalName()) && "http://spcoop.gov.it/collProfiles".equals(elemXML.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String readNomeSPCoop(String QName2, Map<String, String> mapPrefixNamespaces) throws XMLUtilsException {
        if (QName2 == null) {
            return null;
        }
        if (QName2.contains(":")) {
            String[] split = QName2.split(":");
            if (split.length != 2) {
                throw new XMLUtilsException("QName [" + QName2 + "] non valido");
            }
            String prefix = split[0].trim();
            String nomeSPCoop = split[1].trim();
            if (mapPrefixNamespaces.containsKey(prefix)) {
                return nomeSPCoop;
            }
            throw new XMLUtilsException("QName [" + QName2 + "] non valido, prefix [" + prefix + "] non associato a nessun namespace");
        }
        return QName2;
    }

    public static void mapProfiloCollaborazioneEGOVIntoAS(Logger log, byte[] doc, org.openspcoop2.core.registry.AccordoServizioParteComune as, boolean acceptChildUnqualified) throws XMLUtilsException {
        EgovDecllElement egov = null;
        try {
            egov = XMLUtils.getDichiarazioneEGov(log, doc, acceptChildUnqualified);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Documento con informazione egov non leggibile: " + e.getMessage(), e);
        }
        HashMap<String, String> mapPrefixNamespaces = new HashMap<String, String>();
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            NamedNodeMap map = elemXML.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Node o = map.item(i);
                if (!(o instanceof Attr)) continue;
                Attr attr = (Attr)o;
                String prefix = "";
                if (attr.getPrefix() != null) {
                    prefix = attr.getLocalName();
                }
                mapPrefixNamespaces.put(prefix, attr.getValue());
            }
        }
        catch (Exception e) {
            throw new XMLUtilsException("Documento XML con informazione egov non leggibile: " + e.getMessage(), e);
        }
        HashMap<String, PortType> servizi = new HashMap<String, PortType>();
        OperationListType list = egov.getOperationList();
        for (int h = 0; h < list.sizeOperationList(); ++h) {
            OperationType operationType = list.getOperation(h);
            String nomeAzione = XMLUtils.readNomeSPCoop(operationType.getOperazione(), mapPrefixNamespaces);
            String nomeServizio = XMLUtils.readNomeSPCoop(operationType.getServizio(), mapPrefixNamespaces);
            String nomeAzioneCorrelata = XMLUtils.readNomeSPCoop(operationType.getOperazioneCorrelata(), mapPrefixNamespaces);
            String nomeServizioCorrelato = XMLUtils.readNomeSPCoop(operationType.getServizioCorrelato(), mapPrefixNamespaces);
            ProfiloDiCollaborazioneType profiloCollaborazione = operationType.getProfiloDiCollaborazione();
            PortType pt = null;
            if (servizi.containsKey(nomeServizio)) {
                pt = (PortType)servizi.remove(nomeServizio);
            } else {
                pt = new PortType();
                pt.setProfiloPT("ridefinito");
                pt.setFiltroDuplicati(StatoFunzionalita.ABILITATO);
                if (ProfiloDiCollaborazioneType.ONE_WAY.equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione(CostantiRegistroServizi.ONEWAY);
                } else if (ProfiloDiCollaborazioneType.SINCRONO.equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione(CostantiRegistroServizi.SINCRONO);
                } else if (ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO.equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_SIMMETRICO);
                } else if (ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione)) {
                    pt.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
                } else {
                    throw new XMLUtilsException("Profilo di collaborazione non valido [" + String.valueOf(profiloCollaborazione) + "]");
                }
                pt.setNome(nomeServizio);
            }
            Operation azione = new Operation();
            azione.setNome(nomeAzione);
            azione.setProfAzione("ridefinito");
            azione.setFiltroDuplicati(StatoFunzionalita.ABILITATO);
            if (ProfiloDiCollaborazioneType.ONE_WAY.equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione(CostantiRegistroServizi.ONEWAY);
            } else if (ProfiloDiCollaborazioneType.SINCRONO.equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione(CostantiRegistroServizi.SINCRONO);
            } else if (ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO.equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_SIMMETRICO);
            } else if (ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione)) {
                azione.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
            } else {
                throw new XMLUtilsException("Profilo di collaborazione non valido [" + String.valueOf(profiloCollaborazione) + "]");
            }
            pt.addAzione(azione);
            servizi.put(nomeServizio, pt);
            if (!ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO.equals(profiloCollaborazione) && !ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione) || nomeAzioneCorrelata == null) continue;
            String servizio = nomeServizioCorrelato;
            if (servizio == null) {
                servizio = nomeServizio;
            }
            PortType ptCorrelato = null;
            if (servizi.containsKey(servizio)) {
                ptCorrelato = (PortType)servizi.remove(servizio);
            } else {
                ptCorrelato = new PortType();
                ptCorrelato.setProfiloPT("ridefinito");
                ptCorrelato.setFiltroDuplicati(StatoFunzionalita.ABILITATO);
                if (ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO.equals(profiloCollaborazione)) {
                    ptCorrelato.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_SIMMETRICO);
                } else if (ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione)) {
                    ptCorrelato.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
                }
                ptCorrelato.setNome(servizio);
            }
            Operation azioneCorrelata = new Operation();
            azioneCorrelata.setNome(nomeAzioneCorrelata);
            azioneCorrelata.setProfAzione("ridefinito");
            azioneCorrelata.setFiltroDuplicati(StatoFunzionalita.ABILITATO);
            if (ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO.equals(profiloCollaborazione)) {
                azioneCorrelata.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_SIMMETRICO);
            } else if (ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione)) {
                azioneCorrelata.setProfiloCollaborazione(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
            }
            if (nomeServizio != null) {
                azioneCorrelata.setCorrelataServizio(nomeServizio);
            }
            azioneCorrelata.setCorrelata(nomeAzione);
            ptCorrelato.addAzione(azioneCorrelata);
            servizi.put(servizio, ptCorrelato);
        }
        if (servizi != null && !servizi.isEmpty()) {
            for (String pt : servizi.keySet()) {
                as.addPortType((PortType)servizi.get(pt));
            }
        }
    }

    public static DocumentoSemiformale generaDocumentoSemiformale(org.openspcoop2.core.registry.AccordoServizioParteComune as, AccordoServizioParteComune accServParteComuneSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        DocumentoSemiformale docSemiformalePerManifest = XMLUtils.generaDocumentoSemiformalePerManifesto();
        Documento docSICA = XMLUtils.generaDocumentoSemiformale(as, namespaceCnipa, nomiSPCoopQualified);
        accServParteComuneSICA.addSpecificaSemiformale(docSICA);
        return docSemiformalePerManifest;
    }

    public static DocumentoSemiformale generaDocumentoSemiformale(org.openspcoop2.core.registry.AccordoServizioParteComune as, AccordoServizioComposto accServCompostoSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        DocumentoSemiformale docSemiformalePerManifest = XMLUtils.generaDocumentoSemiformalePerManifesto();
        Documento docSICA = XMLUtils.generaDocumentoSemiformale(as, namespaceCnipa, nomiSPCoopQualified);
        accServCompostoSICA.addSpecificaSemiformale(docSICA);
        return docSemiformalePerManifest;
    }

    private static DocumentoSemiformale generaDocumentoSemiformalePerManifesto() throws XMLUtilsException {
        DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
        docSemiformale.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSemiformale.setBase("ProfiloDiCollaborazione.xml");
        return docSemiformale;
    }

    private static Documento generaDocumentoSemiformale(org.openspcoop2.core.registry.AccordoServizioParteComune as, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        Documento docSICA = new Documento();
        docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSICA.setNome("ProfiloDiCollaborazione.xml");
        try {
            byte[] dichiarazioneEGov = XMLUtils.generaDocumentoEGov(as, namespaceCnipa, nomiSPCoopQualified);
            docSICA.setContenuto(dichiarazioneEGov);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
        }
        return docSICA;
    }

    public static String generaGenericoDocumento(org.openspcoop2.core.registry.AccordoServizioParteComune as, AccordoServizioParteComune accServParteComuneSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        String genericoDocumentoPerManifest = XMLUtils.generaGenericoDocumentoPerManifesto();
        Documento docSICA = XMLUtils.generaGenericoDocumento(as, namespaceCnipa, nomiSPCoopQualified);
        accServParteComuneSICA.addAllegato(docSICA);
        return genericoDocumentoPerManifest;
    }

    public static String generaGenericoDocumento(org.openspcoop2.core.registry.AccordoServizioParteComune as, AccordoServizioComposto accServCompostoSICA, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        String genericoDocumentoPerManifest = XMLUtils.generaGenericoDocumentoPerManifesto();
        Documento docSICA = XMLUtils.generaGenericoDocumento(as, namespaceCnipa, nomiSPCoopQualified);
        accServCompostoSICA.addAllegato(docSICA);
        return genericoDocumentoPerManifest;
    }

    private static String generaGenericoDocumentoPerManifesto() throws XMLUtilsException {
        return "ProfiloDiCollaborazione.xml";
    }

    private static Documento generaGenericoDocumento(org.openspcoop2.core.registry.AccordoServizioParteComune as, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        Documento docSICA = new Documento();
        docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
        docSICA.setNome("ProfiloDiCollaborazione.xml");
        try {
            byte[] dichiarazioneEGov = XMLUtils.generaDocumentoEGov(as, namespaceCnipa, nomiSPCoopQualified);
            docSICA.setContenuto(dichiarazioneEGov);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
        }
        return docSICA;
    }

    private static byte[] generaDocumentoEGov(org.openspcoop2.core.registry.AccordoServizioParteComune as, boolean namespaceCnipa, boolean nomiSPCoopQualified) throws XMLUtilsException {
        Object prefissoNomiSPCoop = "";
        String namespaceQualified = null;
        if (nomiSPCoopQualified) {
            try {
                byte[] wsdlConcettuale = as.getByteWsdlConcettuale();
                if (wsdlConcettuale != null) {
                    OpenSPCoop2MessageFactory defaultFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
                    RegistroOpenSPCoopUtilities wsdlUtility = new RegistroOpenSPCoopUtilities(defaultFactory, null);
                    wsdlConcettuale = wsdlUtility.eliminaImportASParteComune(wsdlConcettuale);
                    DefinitionWrapper wsdl = new DefinitionWrapper(wsdlConcettuale, (AbstractXMLUtils)MessageXMLUtils.DEFAULT);
                    String targetNamespace = wsdl.getTargetNamespace();
                    String prefix = null;
                    if (targetNamespace != null && (prefix = wsdl.getPrefix(targetNamespace)) == null) {
                        prefix = "tnsService";
                    }
                    if (targetNamespace != null) {
                        prefissoNomiSPCoop = prefix + ":";
                        namespaceQualified = "xmlns:" + prefix + "=\"" + targetNamespace + "\"";
                    }
                }
            }
            catch (Exception e) {
                System.out.println("errore durante la lettura del target namespace del wsdl: " + e.getMessage());
            }
        }
        byte[] dichiarazioneEGov = XMLUtils.generateDichiarazioneEGov(XMLUtils.generaProfiloCollaborazioneEGOV(as, (String)prefissoNomiSPCoop), namespaceCnipa);
        if (nomiSPCoopQualified && namespaceQualified != null) {
            dichiarazioneEGov = new String(dichiarazioneEGov).replaceFirst("egovDecllElement", "egovDecllElement " + namespaceQualified).getBytes();
        }
        return dichiarazioneEGov;
    }

    private static EgovDecllElement generaProfiloCollaborazioneEGOV(org.openspcoop2.core.registry.AccordoServizioParteComune as, String prefissoNomiSPCoop) throws XMLUtilsException {
        if (as.sizePortTypeList() > 0) {
            EgovDecllElement egov = new EgovDecllElement();
            egov.setEGovVersion("e-govV1.1");
            try {
                URI uri = new URI(as.getNome());
                egov.setRifDefinizioneInterfaccia(uri);
            }
            catch (Exception e) {
                throw new XMLUtilsException(e.getMessage(), e);
            }
            OperationListType operations = new OperationListType();
            ArrayList<OperationType> operationsSICA_asincrone_nonAncoraInserite = new ArrayList<OperationType>();
            for (int i = 0; i < as.sizePortTypeList(); ++i) {
                PortType pt = as.getPortType(i);
                String nomeServizio = prefissoNomiSPCoop + pt.getNome();
                for (int j = 0; j < pt.sizeAzioneList(); ++j) {
                    OperationType opSICA;
                    Object nomeServizioCorrelato;
                    Operation op = pt.getAzione(j);
                    String nomeAzione = prefissoNomiSPCoop + op.getNome();
                    Object nomeAzioneCorrelata = op.getCorrelata();
                    if (nomeAzioneCorrelata != null) {
                        nomeAzioneCorrelata = prefissoNomiSPCoop + (String)nomeAzioneCorrelata;
                    }
                    if ((nomeServizioCorrelato = op.getCorrelataServizio()) != null) {
                        nomeServizioCorrelato = prefissoNomiSPCoop + (String)nomeServizioCorrelato;
                    }
                    ProfiloCollaborazione profilo = null;
                    profilo = "ridefinito".equals(op.getProfAzione()) ? op.getProfiloCollaborazione() : pt.getProfiloCollaborazione();
                    if (CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals((Object)profilo) || CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals((Object)profilo)) {
                        if (nomeAzioneCorrelata == null) {
                            opSICA = new OperationType();
                            opSICA.setOperazione(nomeAzione);
                            if (CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals((Object)profilo)) {
                                opSICA.setProfiloDiCollaborazione(ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO);
                            } else if (CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals((Object)profilo)) {
                                opSICA.setProfiloDiCollaborazione(ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO);
                            }
                            opSICA.setServizio(nomeServizio);
                            operationsSICA_asincrone_nonAncoraInserite.add(opSICA);
                            continue;
                        }
                        opSICA = new OperationType();
                        opSICA.setOperazione((String)nomeAzioneCorrelata);
                        opSICA.setOperazioneCorrelata(nomeAzione);
                        if (CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals((Object)profilo)) {
                            opSICA.setProfiloDiCollaborazione(ProfiloDiCollaborazioneType.ASINCRONO_ASIMMETRICO);
                        } else if (CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals((Object)profilo)) {
                            opSICA.setProfiloDiCollaborazione(ProfiloDiCollaborazioneType.ASINCRONO_SIMMETRICO);
                        }
                        if (nomeServizioCorrelato != null) {
                            opSICA.setServizio((String)nomeServizioCorrelato);
                        } else {
                            opSICA.setServizio(nomeServizio);
                        }
                        opSICA.setServizioCorrelato(nomeServizio);
                        operations.addOperation(opSICA);
                        continue;
                    }
                    opSICA = new OperationType();
                    opSICA.setOperazione(nomeAzione);
                    if (CostantiRegistroServizi.ONEWAY.equals((Object)profilo)) {
                        opSICA.setProfiloDiCollaborazione(ProfiloDiCollaborazioneType.ONE_WAY);
                    } else if (CostantiRegistroServizi.SINCRONO.equals((Object)profilo)) {
                        opSICA.setProfiloDiCollaborazione(ProfiloDiCollaborazioneType.SINCRONO);
                    }
                    opSICA.setServizio(nomeServizio);
                    operations.addOperation(opSICA);
                }
            }
            while (operationsSICA_asincrone_nonAncoraInserite.size() > 0) {
                OperationType opSICA = (OperationType)operationsSICA_asincrone_nonAncoraInserite.remove(0);
                boolean find = false;
                for (int i = 0; i < operations.sizeOperationList(); ++i) {
                    if (!opSICA.getServizio().equals(operations.getOperation(i).getServizio()) || !opSICA.getOperazione().equals(operations.getOperation(i).getOperazione())) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                operations.addOperation(opSICA);
            }
            egov.setOperationList(operations);
            return egov;
        }
        throw new XMLUtilsException("PortTypes non definiti per l'accordo di servizio");
    }
}

