/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdi.validator;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.protocol.basic.ProtocolliRegistrati;
import org.openspcoop2.protocol.basic.tracciamento.TracciaDriver;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdi.config.SDIProperties;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.LivelloRilevanza;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.FiltroRicercaTracceConPaginazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.InformazioniProtocollo;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.utils.transport.TransportUtils;

public class SDIValidazioneUtils {
    private IProtocolFactory<?> protocolFactory;
    private SDIProperties sdiProperties;
    private ITracciaDriver _tracciaDriver;

    public SDIValidazioneUtils(IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.sdiProperties = SDIProperties.getInstance(protocolFactory.getLogger());
    }

    private ITracciaDriver getDriverTracciamento() throws ProtocolException {
        if (this._tracciaDriver == null) {
            this._initDriverTracciamento();
        }
        return this._tracciaDriver;
    }

    private synchronized void _initDriverTracciamento() throws ProtocolException {
        if (this._tracciaDriver == null) {
            this._tracciaDriver = this.newDriverTracciamento(null);
        }
    }

    private ITracciaDriver getDriverTracciamento(Connection con) throws ProtocolException {
        if (con != null) {
            return this.newDriverTracciamento(con);
        }
        return this.getDriverTracciamento();
    }

    private TracciaDriver newDriverTracciamento(Connection con) throws ProtocolException {
        if (this.sdiProperties.isTracciamentoRequiredFromConfiguration()) {
            try {
                ITracciaDriver tracciaDriver;
                ProtocolliRegistrati pRegistrati = new ProtocolliRegistrati(ProtocolFactoryManager.getInstance().getProtocolFactories());
                String tipoDatabase = this.sdiProperties.getTracciamentoTipoDatabase();
                if (tipoDatabase == null) {
                    tipoDatabase = OpenSPCoop2Properties.getInstance().getDatabaseType();
                }
                if ((tracciaDriver = this.protocolFactory.createTracciaDriver()) instanceof TracciaDriver) {
                    TracciaDriver tracciaDriverBasic = (TracciaDriver)tracciaDriver;
                    if (con == null) {
                        String datasource = this.sdiProperties.getTracciamentoDatasource();
                        Properties datasourceJndiContext = this.sdiProperties.getTracciamentoDatasource_jndiContext();
                        tracciaDriverBasic.init(pRegistrati, datasource, tipoDatabase, datasourceJndiContext, this.protocolFactory.getLogger());
                    } else {
                        tracciaDriverBasic.init(pRegistrati, con, tipoDatabase, this.protocolFactory.getLogger());
                    }
                    return tracciaDriverBasic;
                }
                throw new Exception("Unexpected traccciamento driver '" + this._tracciaDriver.getClass().getName() + "'");
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public Eccezione newEccezioneValidazione(CodiceErroreCooperazione codiceErrore) throws ProtocolException {
        return Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)codiceErrore, null, this.protocolFactory);
    }

    public Eccezione newEccezioneValidazione(CodiceErroreCooperazione codiceErrore, String descrizioneErrore) throws ProtocolException {
        return Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)codiceErrore, (String)descrizioneErrore, this.protocolFactory);
    }

    public Eccezione newEccezioneValidazione(CodiceErroreCooperazione codiceErrore, String descrizioneErrore, Throwable e) throws ProtocolException {
        if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
            this.protocolFactory.getLogger().error(descrizioneErrore, e);
        }
        return Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)codiceErrore, (String)descrizioneErrore, this.protocolFactory);
    }

    public Eccezione newEccezioneValidazione(CodiceErroreCooperazione codiceErrore, boolean info) throws ProtocolException {
        Eccezione ecc = Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)codiceErrore, null, this.protocolFactory);
        if (info) {
            ecc.setRilevanza(LivelloRilevanza.INFO);
        }
        return ecc;
    }

    public Eccezione newEccezioneValidazione(CodiceErroreCooperazione codiceErrore, String descrizioneErrore, boolean info) throws ProtocolException {
        Eccezione ecc = Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)codiceErrore, (String)descrizioneErrore, this.protocolFactory);
        if (info) {
            ecc.setRilevanza(LivelloRilevanza.INFO);
        }
        return ecc;
    }

    public Eccezione newEccezioneValidazione(CodiceErroreCooperazione codiceErrore, String descrizioneErrore, Throwable e, boolean info) throws ProtocolException {
        if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
            this.protocolFactory.getLogger().error(descrizioneErrore, e);
        }
        Eccezione ecc = Eccezione.getEccezioneValidazione((CodiceErroreCooperazione)codiceErrore, (String)descrizioneErrore, this.protocolFactory);
        if (info) {
            ecc.setRilevanza(LivelloRilevanza.INFO);
        }
        return ecc;
    }

    public Eccezione newEccezioneProcessamento(CodiceErroreCooperazione codiceErrore) throws ProtocolException {
        return Eccezione.getEccezioneProcessamento((CodiceErroreCooperazione)codiceErrore, null, this.protocolFactory);
    }

    public Eccezione newEccezioneProcessamento(CodiceErroreCooperazione codiceErrore, String descrizioneErrore) throws ProtocolException {
        return Eccezione.getEccezioneProcessamento((CodiceErroreCooperazione)codiceErrore, (String)descrizioneErrore, this.protocolFactory);
    }

    public Eccezione newEccezioneProcessamento(CodiceErroreCooperazione codiceErrore, String descrizioneErrore, Throwable e) throws ProtocolException {
        if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
            this.protocolFactory.getLogger().error(descrizioneErrore, e);
        }
        return Eccezione.getEccezioneProcessamento((CodiceErroreCooperazione)codiceErrore, (String)descrizioneErrore, this.protocolFactory);
    }

    public void addHeaderIdentificativoSdiMessaggio(OpenSPCoop2Message msg, String idSdi, String idSdiRiferimentoArchivio) {
        if (msg == null) {
            return;
        }
        if (msg.getTransportRequestContext() == null || msg.getTransportRequestContext().getHeaders() == null) {
            return;
        }
        if (idSdi == null) {
            return;
        }
        if (idSdiRiferimentoArchivio != null) {
            TransportUtils.addHeader((Map)msg.getTransportRequestContext().getHeaders(), (String)"GovWay-SDI-IdCorrelazione", (String)(idSdi + " " + idSdiRiferimentoArchivio));
        } else {
            TransportUtils.addHeader((Map)msg.getTransportRequestContext().getHeaders(), (String)"GovWay-SDI-IdCorrelazione", (String)idSdi);
        }
    }

    public void readInformazioniFatturaRiferita(Busta busta, String identificativoSdI, String servizio, String azione, boolean applicativoMittente, boolean fatturazioneAttiva, IState state) throws ProtocolException {
        ITracciaDriver tracciaDriver;
        Connection con = null;
        if (state != null && state instanceof StateMessage) {
            StateMessage s = (StateMessage)state;
            try {
                if (s.getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                    con = s.getConnectionDB();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((tracciaDriver = this.getDriverTracciamento(con)) == null) {
            throw new ProtocolException("Accesso al database delle tracce non attivo");
        }
        Traccia traccia = null;
        if (fatturazioneAttiva) {
            Traccia tracciaRisposta = null;
            FiltroRicercaTracceConPaginazione filtro = new FiltroRicercaTracceConPaginazione();
            filtro.setTipoTraccia(RuoloMessaggio.RISPOSTA);
            filtro.setInformazioniProtocollo(new InformazioniProtocollo());
            filtro.getInformazioniProtocollo().setServizio(servizio);
            filtro.getInformazioniProtocollo().setAzione(azione);
            filtro.getInformazioniProtocollo().addProprietaProtocollo("IdentificativoSdI", identificativoSdI);
            filtro.setAsc(false);
            filtro.setLimit(1);
            List list2 = null;
            try {
                list2 = tracciaDriver.getTracce(filtro);
            }
            catch (DriverTracciamentoNotFoundException driverTracciamentoNotFoundException) {
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (list2 != null && !list2.isEmpty()) {
                tracciaRisposta = (Traccia)list2.get(0);
            }
            if (tracciaRisposta != null && tracciaRisposta.getIdTransazione() != null) {
                try {
                    traccia = tracciaDriver.getTraccia(tracciaRisposta.getIdTransazione(), RuoloMessaggio.RICHIESTA);
                }
                catch (DriverTracciamentoNotFoundException e) {
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            FiltroRicercaTracceConPaginazione filtro = new FiltroRicercaTracceConPaginazione();
            filtro.setTipoTraccia(RuoloMessaggio.RICHIESTA);
            filtro.setInformazioniProtocollo(new InformazioniProtocollo());
            filtro.getInformazioniProtocollo().setServizio(servizio);
            filtro.getInformazioniProtocollo().setAzione(azione);
            filtro.getInformazioniProtocollo().addProprietaProtocollo("IdentificativoSdI", identificativoSdI);
            filtro.setAsc(false);
            filtro.setLimit(1);
            List list = null;
            try {
                list = tracciaDriver.getTracce(filtro);
            }
            catch (DriverTracciamentoNotFoundException list2) {
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            if (list != null && !list.isEmpty()) {
                traccia = (Traccia)list.get(0);
            }
        }
        if (traccia != null) {
            String[] names;
            if (applicativoMittente && traccia.getBusta() != null && traccia.getBusta().getServizioApplicativoFruitore() != null && !"".equals(traccia.getBusta().getServizioApplicativoFruitore()) && busta.getServizioApplicativoFruitore() == null) {
                busta.addProperty("ApplicativoMittenteFattura", traccia.getBusta().getServizioApplicativoFruitore());
            }
            if (traccia.getBusta() != null && traccia.getBusta().sizeProperties() > 0 && (names = traccia.getBusta().getPropertiesNames()) != null && names.length > 0) {
                ArrayList<String> nomiDaRiportare = new ArrayList<String>();
                nomiDaRiportare.add("CodiceDestinatario");
                nomiDaRiportare.add("NomeFileMetadati");
                nomiDaRiportare.add("SoggettoEmittente");
                HashMap<String, String> nomiDaRiportareDiversamente = new HashMap<String, String>();
                nomiDaRiportareDiversamente.put("NomeFile", "NomeFileFattura");
                ArrayList<String> prefissiDaRiportare = new ArrayList<String>();
                prefissiDaRiportare.add("RiferimentoFattura-");
                prefissiDaRiportare.add("DatiTrasmissione-");
                prefissiDaRiportare.add("CedentePrestatore-");
                prefissiDaRiportare.add("CessionarioCommittente-");
                prefissiDaRiportare.add("TerzoIntermediarioOSoggettoEmittente-");
                for (int i = 0; i < names.length; ++i) {
                    String checkValue;
                    String checkNome = names[i];
                    if (checkNome == null || "".equals(checkNome) || (checkValue = traccia.getBusta().getProperty(checkNome)) == null || "".equals(checkValue)) continue;
                    if (!nomiDaRiportare.isEmpty()) {
                        for (String nome : nomiDaRiportare) {
                            if (!checkNome.equals(nome) || busta.existsProperty(checkNome)) continue;
                            busta.addProperty(checkNome, checkValue);
                        }
                    }
                    if (!nomiDaRiportareDiversamente.isEmpty()) {
                        for (String nome : nomiDaRiportareDiversamente.keySet()) {
                            if (!checkNome.equals(nome) || busta.existsProperty(checkNome)) continue;
                            busta.addProperty((String)nomiDaRiportareDiversamente.get(checkNome), checkValue);
                        }
                    }
                    if (prefissiDaRiportare.isEmpty()) continue;
                    for (String prefix : prefissiDaRiportare) {
                        if (!checkNome.startsWith(prefix) || busta.existsProperty(checkNome)) continue;
                        busta.addProperty(checkNome, checkValue);
                    }
                }
            }
        }
    }
}

