/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.validator;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.govway.struts.action.ActionErrors;
import org.govway.struts.action.ActionMapping;
import org.govway.struts.action.DynaActionForm;
import org.govway.struts.validator.Resources;

public class DynaValidatorForm
extends DynaActionForm
implements DynaBean,
Serializable {
    private static Log log = LogFactory.getLog(DynaValidatorForm.class);
    protected ValidatorResults validatorResults = null;
    protected int page = 0;

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        this.setPageFromDynaProperty();
        ServletContext application = this.getServlet().getServletContext();
        ActionErrors errors = new ActionErrors();
        String validationKey = this.getValidationKey(mapping, request);
        Validator validator = Resources.initValidator(validationKey, this, application, request, errors, this.page);
        try {
            this.validatorResults = validator.validate();
        }
        catch (ValidatorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return errors;
    }

    public String getValidationKey(ActionMapping mapping, HttpServletRequest request) {
        return mapping.getAttribute();
    }

    protected void setPageFromDynaProperty() {
        Map props = this.getMap();
        if (props.containsKey("page")) {
            Integer p = null;
            try {
                p = (Integer)props.get("page");
            }
            catch (ClassCastException e) {
                log.error((Object)"Dyna 'page' property must be of type java.lang.Integer.", (Throwable)e);
                throw e;
            }
            if (p == null) {
                throw new NullPointerException("Dyna 'page' property must not be null.  Either provide an initial value or set 'convertNull' to false. ");
            }
            this.page = p;
        }
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.page = 0;
        this.validatorResults = null;
    }

    public ValidatorResults getValidatorResults() {
        return this.validatorResults;
    }

    public void setValidatorResults(ValidatorResults validatorResults) {
        this.validatorResults = validatorResults;
    }

    public Map getResultValueMap() {
        return this.validatorResults != null ? this.validatorResults.getResultValueMap() : null;
    }
}

