/*
 * Decompiled with CFR 0.152.
 */
package org.govway.struts.chain.commands.servlet;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.govway.struts.action.ActionServlet;
import org.govway.struts.chain.commands.AbstractPerformForward;
import org.govway.struts.chain.contexts.ActionContext;
import org.govway.struts.chain.contexts.ServletActionContext;
import org.govway.struts.config.ForwardConfig;
import org.govway.struts.config.ModuleConfig;
import org.govway.struts.util.MessageResources;
import org.govway.struts.util.ModuleUtils;
import org.govway.struts.util.RequestUtils;

public class PerformForward
extends AbstractPerformForward {
    private static final Log LOG = LogFactory.getLog(PerformForward.class);

    @Override
    protected void perform(ActionContext context, ForwardConfig forwardConfig) throws Exception {
        ServletActionContext sacontext = (ServletActionContext)context;
        String uri = forwardConfig.getPath();
        if (uri == null) {
            ActionServlet servlet = sacontext.getActionServlet();
            MessageResources resources = servlet.getInternal();
            throw new IllegalArgumentException(resources.getMessage("forwardPathNull"));
        }
        HttpServletRequest request = sacontext.getRequest();
        ServletContext servletContext = sacontext.getContext();
        HttpServletResponse response = sacontext.getResponse();
        String actionIdPath = RequestUtils.actionIdURL(forwardConfig, sacontext.getRequest(), sacontext.getActionServlet());
        if (actionIdPath != null) {
            uri = actionIdPath;
            ForwardConfig actionIdForwardConfig = new ForwardConfig(forwardConfig);
            actionIdForwardConfig.setPath(actionIdPath);
            forwardConfig = actionIdForwardConfig;
        }
        if (uri.startsWith("/")) {
            uri = this.resolveModuleRelativePath(forwardConfig, servletContext, request);
        }
        if (response.isCommitted() && !forwardConfig.getRedirect()) {
            this.handleAsInclude(uri, servletContext, request, response);
        } else if (forwardConfig.getRedirect()) {
            this.handleAsRedirect(uri, request, response);
        } else {
            this.handleAsForward(uri, servletContext, request, response);
        }
    }

    private String resolveModuleRelativePath(ForwardConfig forwardConfig, ServletContext servletContext, HttpServletRequest request) {
        String prefix = forwardConfig.getModule();
        ModuleConfig moduleConfig = ModuleUtils.getInstance().getModuleConfig(prefix, request, servletContext);
        return RequestUtils.forwardURL(request, forwardConfig, moduleConfig);
    }

    private void handleAsForward(String uri, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher rd = servletContext.getRequestDispatcher(uri);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Forwarding to " + uri));
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void handleAsRedirect(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (((String)uri).startsWith("/")) {
            uri = request.getContextPath() + (String)uri;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting to " + (String)uri));
        }
        response.sendRedirect(response.encodeRedirectURL((String)uri));
    }

    private void handleAsInclude(String uri, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd = servletContext.getRequestDispatcher(uri);
        if (rd == null) {
            response.sendError(500, "Error getting RequestDispatcher for " + uri);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Including " + uri));
        }
        rd.include((ServletRequest)request, (ServletResponse)response);
    }
}

