/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.generic;

import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.Filter;

public class LookupCommand
implements Filter {
    private CatalogFactory catalogFactory = null;
    private String catalogName = null;
    private String name = null;
    private String nameKey = null;
    private boolean optional = false;
    private boolean ignoreExecuteResult = false;
    private boolean ignorePostprocessResult = false;

    public LookupCommand() {
        this(CatalogFactory.getInstance());
    }

    public LookupCommand(CatalogFactory factory) {
        this.catalogFactory = factory;
    }

    public void setCatalogFactory(CatalogFactory catalogFactory) {
        this.catalogFactory = catalogFactory;
    }

    public CatalogFactory getCatalogFactory() {
        return this.catalogFactory;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setNameKey(String nameKey) {
        this.nameKey = nameKey;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public boolean isIgnoreExecuteResult() {
        return this.ignoreExecuteResult;
    }

    public void setIgnoreExecuteResult(boolean ignoreReturn) {
        this.ignoreExecuteResult = ignoreReturn;
    }

    public boolean isIgnorePostprocessResult() {
        return this.ignorePostprocessResult;
    }

    public void setIgnorePostprocessResult(boolean ignorePostprocessResult) {
        this.ignorePostprocessResult = ignorePostprocessResult;
    }

    @Override
    public boolean execute(Context context) throws Exception {
        Command command = this.getCommand(context);
        if (command != null) {
            boolean result = command.execute(context);
            if (this.isIgnoreExecuteResult()) {
                return false;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean postprocess(Context context, Exception exception) {
        Command command = this.getCommand(context);
        if (command != null && command instanceof Filter) {
            boolean result = ((Filter)command).postprocess(context, exception);
            if (this.isIgnorePostprocessResult()) {
                return false;
            }
            return result;
        }
        return false;
    }

    protected Catalog getCatalog(Context context) {
        CatalogFactory lookupFactory = this.catalogFactory;
        if (lookupFactory == null) {
            lookupFactory = CatalogFactory.getInstance();
        }
        String catalogName = this.getCatalogName();
        Catalog catalog = null;
        catalog = catalogName == null ? lookupFactory.getCatalog() : lookupFactory.getCatalog(catalogName);
        if (catalog == null) {
            if (catalogName == null) {
                throw new IllegalArgumentException("Cannot find default catalog");
            }
            throw new IllegalArgumentException("Cannot find catalog '" + catalogName + "'");
        }
        return catalog;
    }

    protected Command getCommand(Context context) {
        Catalog catalog = this.getCatalog(context);
        Command command = null;
        String name = this.getCommandName(context);
        if (name != null) {
            command = catalog.getCommand(name);
            if (command == null && !this.isOptional()) {
                if (this.catalogName == null) {
                    throw new IllegalArgumentException("Cannot find command '" + name + "' in default catalog");
                }
                throw new IllegalArgumentException("Cannot find command '" + name + "' in catalog '" + this.catalogName + "'");
            }
            return command;
        }
        throw new IllegalArgumentException("No command name");
    }

    protected String getCommandName(Context context) {
        String name = this.getName();
        if (name == null) {
            name = (String)context.get(this.getNameKey());
        }
        return name;
    }
}

