/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.sdk.transaction;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openspcoop2.monitor.sdk.constants.MessageType;
import org.openspcoop2.monitor.sdk.transaction.AbstractContentResource;
import org.openspcoop2.monitor.sdk.transaction.Attachment;

public class AttachmentResource
extends AbstractContentResource {
    private LinkedList<Attachment> attachments = new LinkedList();

    public AttachmentResource(MessageType messageType) {
        super(messageType);
    }

    public void addAttachment(Attachment attach) {
        this.attachments.add(attach);
    }

    public void addAttachment(Attachment attach, int position) {
        this.attachments.add(position, attach);
    }

    public void setValue(LinkedList<Attachment> attachs) {
        this.attachments = attachs;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Attachment getAttachmentByPosition(int index) {
        return this.attachments.get(index);
    }

    public Attachment getAttachmentByContentId(String cid) {
        for (int i = 0; i < this.attachments.size(); ++i) {
            if (!cid.equals(this.attachments.get(i).getContentID())) continue;
            return this.attachments.get(i);
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.isRequest()) {
            return "request_attachment";
        }
        return "response_attachment";
    }

    @Override
    public LinkedList<Attachment> getValue() {
        return this.attachments;
    }

    public List<String> cids() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.attachments.size(); ++i) {
            list.add(this.attachments.get(i).getContentID());
        }
        return list;
    }
}

