/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.sdk.alarm;

import java.lang.reflect.Method;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.slf4j.Logger;

public class AlarmFactory {
    public static IAlarm getAlarm(String idAllarme) throws AlarmException {
        return AlarmFactory.getAlarm(LoggerWrapperFactory.getLogger(AlarmFactory.class), idAllarme);
    }

    public static IAlarm getAlarm(Logger log, String idAllarme) throws AlarmException {
        try {
            Class<?> c = Class.forName("org.openspcoop2.monitor.engine.alarm.AlarmManager");
            Class[] paramTypes = new Class[]{String.class, Logger.class, DAOFactory.class};
            DAOFactory daoFactory = DAOFactory.getInstance((Logger)log);
            Object[] params = new Object[]{idAllarme, log, daoFactory};
            Method m = c.getMethod("getAlarm", paramTypes);
            return (IAlarm)m.invoke(Utilities.newInstance(c), params);
        }
        catch (Exception e) {
            throw new AlarmException(e.getMessage(), e);
        }
    }
}

