/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.config;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.config.rs.server.config.DatasourceInstanceProperties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class DatasourceProperties {
    private Logger log = null;
    private DatasourceInstanceProperties reader;
    private static DatasourceProperties datasourceProperties = null;

    private DatasourceProperties(String confDir, Logger log) throws Exception {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(DatasourceProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = DatasourceProperties.class.getResourceAsStream("/rs-api-config.datasource.properties");
            if (properties == null) {
                throw new Exception("File '/rs-api-config.datasource.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'rs-api-config.datasource.properties': \n\n" + e.getMessage());
            throw new Exception("RS Api ConfigProperties initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new DatasourceInstanceProperties(propertiesReader, this.log, confDir);
    }

    public static boolean initialize(String confDir, Logger log) {
        try {
            datasourceProperties = new DatasourceProperties(confDir, log);
            return true;
        }
        catch (Exception e) {
            log.error("Errore durante l'inizializzazione del BackendProperties: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static DatasourceProperties getInstance() throws UtilsException {
        if (datasourceProperties == null) {
            Class<DatasourceProperties> clazz = DatasourceProperties.class;
            synchronized (DatasourceProperties.class) {
                throw new UtilsException("DatasourceProperties non inizializzato");
            }
        }
        return datasourceProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        DatasourceProperties.datasourceProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public String getDbDataSource() throws UtilsException {
        return this.readProperty(true, "db.dataSource");
    }

    public Properties getDbDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("db.dataSource.property.");
    }

    public String getDbTipoDatabase() throws UtilsException {
        return this.readProperty(true, "db.tipoDatabase");
    }

    public Properties getPropertiesConsole() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("db.");
    }
}

