/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.config;

import java.util.ArrayList;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.LoginTipologia;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthenticationProvider
implements org.springframework.security.authentication.AuthenticationProvider {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String configuratorRoleName = "configuratore";

    private static String getS(String v) {
        return "sec" + v + "ret";
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = authentication.getName();
        Object passwordObject = authentication.getCredentials();
        String password = (String)passwordObject;
        if (username == null || password == null) {
            throw new AuthenticationCredentialsNotFoundException("Credentials not found");
        }
        String tipoProtocollo = null;
        ControlStationCore core = null;
        UtentiCore utentiCore = null;
        try {
            tipoProtocollo = (String)BaseHelper.tipoProtocolloFromProfilo.get(Helper.getProfiloDefault());
            core = new ControlStationCore(true, ServerProperties.getInstance().getConfDirectory(), tipoProtocollo);
            utentiCore = new UtentiCore(core);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("Inizializzazione AuthenticationProvider fallita: " + e.getMessage(), (Throwable)e);
        }
        StringBuilder denyReason = new StringBuilder();
        User u = null;
        try {
            u = LoginHelper.loginCheckData((Logger)this.log, (UtentiCore)utentiCore, (LoginTipologia)LoginTipologia.WITH_PASSWORD, (String)username, (String)password, (StringBuilder)denyReason);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException("AuthenticationProvider,ricerca utente fallita: " + e.getMessage(), (Throwable)e);
        }
        if (u == null) {
            throw new BadCredentialsException("Bad credentials");
        }
        ArrayList<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>();
        if (u.getPermessi() != null && u.getPermessi().isServizi()) {
            SimpleGrantedAuthority grant = new SimpleGrantedAuthority(this.configuratorRoleName);
            roles.add(grant);
        }
        org.springframework.security.core.userdetails.User user = new org.springframework.security.core.userdetails.User(username, AuthenticationProvider.getS(""), true, true, true, true, roles);
        UsernamePasswordAuthenticationToken userAuth = new UsernamePasswordAuthenticationToken((Object)user, (Object)AuthenticationProvider.getS(""), user.getAuthorities());
        userAuth.setDetails(authentication.getDetails());
        return userAuth;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public String getConfiguratorRoleName() {
        return this.configuratorRoleName;
    }

    public void setConfiguratorRoleName(String configuratorRoleName) {
        this.configuratorRoleName = configuratorRoleName;
    }
}

