/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.fruizioni.configurazione;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.AutorizzazioneRuoli;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneServiziApplicativi;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneToken;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.constants.ValidazioneContenutiApplicativiTipo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.rs.server.api.FruizioniConfigurazioneApi;
import org.openspcoop2.core.config.rs.server.api.impl.Enums;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.api.impl.fruizioni.configurazione.FruizioniConfEnv;
import org.openspcoop2.core.config.rs.server.api.impl.fruizioni.configurazione.FruizioniConfigurazioneHelper;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKey;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKeyConfig;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneApiKeyPosizione;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneBasic;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneCustom;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazioneHttps;
import org.openspcoop2.core.config.rs.server.model.APIImplAutenticazionePrincipal;
import org.openspcoop2.core.config.rs.server.model.ApiCanale;
import org.openspcoop2.core.config.rs.server.model.ApiImplStato;
import org.openspcoop2.core.config.rs.server.model.CachingRisposta;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneApiCanale;
import org.openspcoop2.core.config.rs.server.model.ConfigurazioneCanaleEnum;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAttributeAuthority;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutenticazioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazione;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneApplicativi;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneApplicativo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuoli;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneRuolo;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScope;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneScopes;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiAutorizzazioneView;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiGestioneToken;
import org.openspcoop2.core.config.rs.server.model.ControlloAccessiIdentificazioneAttributi;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiestaEnum;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRichiestaItem;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRispostaEnum;
import org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRispostaItem;
import org.openspcoop2.core.config.rs.server.model.ElencoProprieta;
import org.openspcoop2.core.config.rs.server.model.GestioneCors;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRichiesta;
import org.openspcoop2.core.config.rs.server.model.ListaCorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.rs.server.model.ListaRateLimitingPolicy;
import org.openspcoop2.core.config.rs.server.model.OneOfControlloAccessiAutenticazioneAutenticazione;
import org.openspcoop2.core.config.rs.server.model.ProprietaOpzioneCifratura;
import org.openspcoop2.core.config.rs.server.model.RateLimitingCriteriMetricaEnum;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizione;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizioneUpdate;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyFruizioneView;
import org.openspcoop2.core.config.rs.server.model.RateLimitingPolicyItem;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneDiagnosticiConfigurazione;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneMessaggi;
import org.openspcoop2.core.config.rs.server.model.RegistrazioneTransazioniConfigurazione;
import org.openspcoop2.core.config.rs.server.model.StatoFunzionalitaConWarningEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoAutenticazionePrincipalToken;
import org.openspcoop2.core.config.rs.server.model.Validazione;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.servlet.ApiKeyState;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleUtilities;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class FruizioniConfigurazioneApiServiceImpl
extends BaseImpl
implements FruizioniConfigurazioneApi {
    public FruizioniConfigurazioneApiServiceImpl() {
        super(LoggerFactory.getLogger(FruizioniConfigurazioneApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    @Override
    public void addFruizioneControlloAccessiAutorizzazioneApplicativi(ControlloAccessiAutorizzazioneApplicativo body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
            idSA.setNome(body.getApplicativo());
            if (!TipoAutorizzazione.isAuthenticationRequired((String)pd.getAutorizzazione())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autenticazione puntuale non \u00e8 abilitata");
            }
            ServizioApplicativo sa = (ServizioApplicativo)BaseHelper.supplyOrNonValida(() -> env.saCore.getServizioApplicativo(idSA), (String)("Servizio Applicativo " + idSA.toString()));
            CredenzialeTipo tipoAutenticazione = CredenzialeTipo.toEnumConstant((String)pd.getAutenticazione());
            if (tipoAutenticazione == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non risulta abilitato un tipo di autenticazione trasporto nella fruizione selezionata");
            }
            Boolean appId = null;
            if (CredenzialeTipo.APIKEY.equals((Object)tipoAutenticazione)) {
                ApiKeyState apiKeyState = new ApiKeyState(env.pdCore.getParametroAutenticazione(pd.getAutenticazione(), pd.getProprietaAutenticazioneList()));
                appId = apiKeyState.appIdSelected;
            }
            boolean bothSslAndToken = false;
            List saCompatibili = env.saCore.soggettiServizioApplicativoList(env.idSoggetto.toIDSoggetto(), env.userLogin, tipoAutenticazione, appId, "client", bothSslAndToken, pd.getGestioneToken() != null ? pd.getGestioneToken().getPolicy() : null);
            if (!BaseHelper.findFirst((Iterable)saCompatibili, s -> s.getId().equals(sa.getId())).isPresent()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il tipo di credenziali dell'Applicativo non sono compatibili con l'autenticazione impostata nella fruizione selezionata");
            }
            if (BaseHelper.findFirst((Iterable)pd.getServizioApplicativoList(), s -> s.getNome().equals(sa.getNome())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Servizio Applicativo gi\u00e0 associato");
            }
            env.requestWrapper.overrideParameter("id", pd.getId().toString());
            env.requestWrapper.overrideParameter("idsogg", env.idSoggetto.getId().toString());
            env.requestWrapper.overrideParameter("servizioApplicativo", sa.getNome());
            if (!env.pdHelper.porteDelegateServizioApplicativoCheckData(TipoOperazione.ADD)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            PortaDelegataServizioApplicativo pdSa = new PortaDelegataServizioApplicativo();
            pdSa.setNome(body.getApplicativo());
            pd.addServizioApplicativo(pdSa);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneControlloAccessiAutorizzazioneApplicativiToken(ControlloAccessiAutorizzazioneApplicativo body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(env.idSoggetto.toIDSoggetto());
            idSA.setNome(body.getApplicativo());
            String tokenPolicy = null;
            if (pd.getGestioneToken() == null || pd.getGestioneToken().getPolicy() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione token per richiedente non \u00e8 utilizzabile, non risulta abilitata una token policy di validazione");
            }
            tokenPolicy = pd.getGestioneToken().getPolicy();
            if (pd.getAutorizzazioneToken() == null || !StatoFunzionalita.ABILITATO.equals((Object)pd.getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione token per richiedente non \u00e8 abilitata");
            }
            ServizioApplicativo sa = (ServizioApplicativo)BaseHelper.supplyOrNonValida(() -> env.saCore.getServizioApplicativo(idSA), (String)("Servizio Applicativo " + idSA.toString()));
            CredenzialeTipo tipoAutenticazione = CredenzialeTipo.TOKEN;
            Boolean appId = null;
            boolean bothSslAndToken = false;
            List saCompatibili = env.saCore.soggettiServizioApplicativoList(env.idSoggetto.toIDSoggetto(), env.userLogin, tipoAutenticazione, appId, "client", bothSslAndToken, tokenPolicy);
            if (!BaseHelper.findFirst((Iterable)saCompatibili, s -> s.getId().equals(sa.getId())).isPresent()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il tipo di credenziali dell'Applicativo non sono compatibili con l'autenticazione impostata nella fruizione selezionata");
            }
            if (pd.getAutorizzazioneToken() == null) {
                pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
            }
            if (pd.getAutorizzazioneToken().getServiziApplicativi() == null) {
                pd.getAutorizzazioneToken().setServiziApplicativi(new PortaDelegataAutorizzazioneServiziApplicativi());
            }
            if (BaseHelper.findFirst((Iterable)pd.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList(), s -> s.getNome().equals(sa.getNome())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Servizio Applicativo gi\u00e0 associato");
            }
            env.requestWrapper.overrideParameter("id", pd.getId().toString());
            env.requestWrapper.overrideParameter("idsogg", env.idSoggetto.getId().toString());
            env.requestWrapper.overrideParameter("servizioApplicativo", sa.getNome());
            if (!env.pdHelper.porteDelegateServizioApplicativoCheckData(TipoOperazione.ADD)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            PortaDelegataServizioApplicativo pdSa = new PortaDelegataServizioApplicativo();
            pdSa.setNome(body.getApplicativo());
            pd.getAutorizzazioneToken().getServiziApplicativi().addServizioApplicativo(pdSa);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneControlloAccessiAutorizzazioneRuoli(ControlloAccessiAutorizzazioneRuolo body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (!TipoAutorizzazione.isRolesRequired((String)pd.getAutorizzazione())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione per ruoli non \u00e8 abilitata");
            }
            RuoliCore ruoliCore = new RuoliCore(env.stationCore);
            BaseHelper.supplyOrNonValida(() -> ruoliCore.getRuolo(body.getRuolo()), (String)("Ruolo " + body.getRuolo()));
            if (pd.getRuoli() == null) {
                pd.setRuoli(new AutorizzazioneRuoli());
            }
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.PORTA_DELEGATA);
            filtroRuoli.setTipologia(RuoloTipologia.QUALSIASI);
            if (TipoAutorizzazione.isInternalRolesRequired((String)pd.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            } else if (TipoAutorizzazione.isExternalRolesRequired((String)pd.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.ESTERNO);
            }
            List ruoliAmmessi = env.stationCore.getAllRuoli(filtroRuoli);
            if (!ruoliAmmessi.contains(body.getRuolo())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il ruolo " + body.getRuolo() + "non \u00e8 tra i ruoli ammissibili per il gruppo");
            }
            List ruoliPresenti = pd.getRuoli().getRuoloList().stream().map(r -> r.getNome()).collect(Collectors.toList());
            if (BaseHelper.findFirst(ruoliPresenti, r -> r.equals(body.getRuolo())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Il ruolo " + body.getRuolo() + " \u00e8 gi\u00e0 associato al gruppo scelto");
            }
            if (!env.paHelper.ruoloCheckData(TipoOperazione.ADD, body.getRuolo(), ruoliPresenti)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(body.getRuolo());
            pd.getRuoli().addRuolo(ruolo);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneControlloAccessiAutorizzazioneRuoliToken(ControlloAccessiAutorizzazioneRuolo body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getAutorizzazioneToken() == null || !StatoFunzionalita.ABILITATO.equals((Object)pd.getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione token per ruoli non \u00e8 abilitata");
            }
            RuoliCore ruoliCore = new RuoliCore(env.stationCore);
            BaseHelper.supplyOrNonValida(() -> ruoliCore.getRuolo(body.getRuolo()), (String)("Ruolo " + body.getRuolo()));
            if (pd.getAutorizzazioneToken() == null) {
                pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
            }
            if (pd.getAutorizzazioneToken().getRuoli() == null) {
                pd.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
            }
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.PORTA_DELEGATA);
            filtroRuoli.setTipologia(RuoloTipologia.QUALSIASI);
            if (TipoAutorizzazione.isInternalRolesRequired((String)pd.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            } else if (TipoAutorizzazione.isExternalRolesRequired((String)pd.getAutorizzazione())) {
                filtroRuoli.setTipologia(RuoloTipologia.ESTERNO);
            }
            List ruoliAmmessi = env.stationCore.getAllRuoli(filtroRuoli);
            if (!ruoliAmmessi.contains(body.getRuolo())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il ruolo " + body.getRuolo() + "non \u00e8 tra i ruoli ammissibili per il gruppo");
            }
            List ruoliPresenti = pd.getAutorizzazioneToken().getRuoli().getRuoloList().stream().map(r -> r.getNome()).collect(Collectors.toList());
            if (BaseHelper.findFirst(ruoliPresenti, r -> r.equals(body.getRuolo())).isPresent()) {
                throw FaultCode.CONFLITTO.toException("Il ruolo " + body.getRuolo() + " \u00e8 gi\u00e0 associato al gruppo scelto");
            }
            if (!env.paHelper.ruoloCheckData(TipoOperazione.ADD, body.getRuolo(), ruoliPresenti)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(body.getRuolo());
            pd.getAutorizzazioneToken().getRuoli().addRuolo(ruolo);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneProprieta(ProprietaOpzioneCifratura body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            if (env.pdCore == null) {
                throw new CoreException("PdCore not initialized");
            }
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (body.getNome().indexOf(" ") != -1 || body.getValore().indexOf(" ") != -1) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non inserire spazi nei campi di testo");
            }
            if (pd.getProprietaList() != null && !pd.getProprietaList().isEmpty()) {
                for (Proprieta p : pd.getProprietaList()) {
                    if (!p.getNome().equals(body.getNome())) continue;
                    throw FaultCode.CONFLITTO.toException("Propriet\u00e0 " + body.getNome() + " gi\u00e0 assegnata alla configurazione");
                }
            }
            Proprieta p = new Proprieta();
            p.setNome(body.getNome());
            if (env.pdCore != null && env.pdCore.getDriverBYOKUtilities() != null && body.isEncrypted() != null && body.isEncrypted().booleanValue()) {
                p.setValore(env.pdCore.getDriverBYOKUtilities().wrap(body.getValore()));
            } else {
                if (body.getValore().length() > 255) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il valore della propriet\u00e0 non deve superare i 255 caratteri");
                }
                p.setValore(body.getValore());
            }
            pd.addProprieta(p);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneControlloAccessiAutorizzazioneScope(ControlloAccessiAutorizzazioneScope body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getScope() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("L'autorizzazione per scope non \u00e8 abilitata");
            }
            FiltroRicercaScope filtroScope = new FiltroRicercaScope();
            filtroScope.setContesto(ScopeContesto.PORTA_APPLICATIVA);
            filtroScope.setTipologia("");
            List scopeAmmessi = env.stationCore.getAllScope(filtroScope);
            List scopePresenti = pd.getScope().getScopeList().stream().map(Scope::getNome).collect(Collectors.toList());
            if (!scopeAmmessi.contains(body.getScope())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Scope " + body.getScope() + " non presente fra gli scope ammissibili.");
            }
            if (scopePresenti.contains(body.getScope())) {
                throw FaultCode.CONFLITTO.toException("Scope " + body.getScope() + " gi\u00e0 assegnato al gruppo");
            }
            if (!env.paHelper.scopeCheckData(TipoOperazione.ADD, body.getScope(), scopePresenti)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            Scope scope = new Scope();
            scope.setNome(body.getScope());
            pd.getScope().addScope(scope);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneRateLimitingPolicy(RateLimitingPolicyFruizione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            RuoloPolicy ruoloPorta = RuoloPolicy.DELEGATA;
            String nomePorta = pd.getNome();
            AttivazionePolicy policy = new AttivazionePolicy();
            policy.setFiltro(new AttivazionePolicyFiltro());
            policy.setGroupBy(new AttivazionePolicyRaggruppamento());
            String modalita = ErogazioniApiHelper.getDataElementModalita(body.getConfigurazione().getIdentificazione());
            String idPolicy = ErogazioniApiHelper.getIdPolicy(body, env.confCore, env.confHelper);
            if (idPolicy == null) {
                switch (body.getConfigurazione().getIdentificazione()) {
                    case POLICY: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Policy Utente non trovata");
                    }
                    case CRITERI: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Policy Built-In non trovata che rispettano i criteri forniti");
                    }
                }
            }
            policy.setIdPolicy(idPolicy);
            InfoPolicy infoPolicy = env.confCore.getInfoPolicy(policy.getIdPolicy());
            String serialId = env.confCore.getNextPolicyInstanceSerialId(infoPolicy.getIdPolicy());
            policy.setIdActivePolicy(ControlloTrafficoDriverUtils.buildIdActivePolicy((String)infoPolicy.getIdPolicy(), (String)serialId));
            ErogazioniApiHelper.override(infoPolicy.getTipoRisorsa(), body, env.protocolFactory.getProtocol(), env.idSoggetto.toIDSoggetto(), env.requestWrapper);
            String errorAttivazione = env.confHelper.readDatiAttivazionePolicyFromHttpParameters(policy, false, TipoOperazione.ADD, infoPolicy);
            if (!StringUtils.isEmpty((CharSequence)errorAttivazione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)errorAttivazione));
            }
            policy.getFiltro().setEnabled(true);
            policy.getFiltro().setProtocollo(env.tipo_protocollo);
            policy.getFiltro().setRuoloPorta(ruoloPorta);
            policy.getFiltro().setNomePorta(nomePorta);
            policy.getFiltro().setTipoFruitore(pd.getTipoSoggettoProprietario());
            policy.getFiltro().setNomeFruitore(pd.getNomeSoggettoProprietario());
            StringBuilder existsMessage = new StringBuilder();
            if (ConfigurazioneUtilities.alreadyExists((TipoOperazione)TipoOperazione.ADD, (ConfigurazioneCore)env.confCore, (ConfigurazioneHelper)env.confHelper, (AttivazionePolicy)policy, (InfoPolicy)infoPolicy, (RuoloPolicy)ruoloPorta, (String)nomePorta, (ServiceBinding)env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), (StringBuilder)existsMessage, (String)"<br/>", (String)modalita)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)existsMessage.toString()));
            }
            FruizioniConfigurazioneHelper.attivazionePolicyCheckData(TipoOperazione.ADD, pd, policy, infoPolicy, env, env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), modalita);
            ConfigurazioneUtilities.updatePosizioneAttivazionePolicy((ConfigurazioneCore)env.confCore, (InfoPolicy)infoPolicy, (AttivazionePolicy)policy, (RuoloPolicy)ruoloPorta, (String)nomePorta);
            env.confCore.performCreateOperation(env.userLogin, false, new Object[]{policy});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneTracciamentoCorrelazioneApplicativaRichiesta(CorrelazioneApplicativaRichiesta body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Long idPorta = pd.getId();
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            StringBuilder existsMessage = new StringBuilder();
            if (ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRichiesta((PorteDelegateCore)env.pdCore, (long)idPorta, (String)body.getElemento(), (long)0L, (StringBuilder)existsMessage)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)existsMessage.toString()));
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRichiestaCheckData(TipoOperazione.ADD, env.requestWrapper, (ConsoleHelper)env.paHelper, true, body, idPorta, null, serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            CorrelazioneApplicativa ca = pd.getCorrelazioneApplicativa();
            if (ca == null) {
                ca = new CorrelazioneApplicativa();
            }
            ca.addElemento(ErogazioniApiHelper.convert(body));
            pd.setCorrelazioneApplicativa(ca);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void addFruizioneTracciamentoCorrelazioneApplicativaRisposta(org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Long idPorta = pd.getId();
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            StringBuilder existsMessage = new StringBuilder();
            if (ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRisposta((PorteDelegateCore)env.pdCore, (long)idPorta, (String)body.getElemento(), (long)0L, (StringBuilder)existsMessage)) {
                throw FaultCode.CONFLITTO.toException(StringEscapeUtils.unescapeHtml4((String)existsMessage.toString()));
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRispostaCheckData(TipoOperazione.ADD, env.requestWrapper, (ConsoleHelper)env.pdHelper, true, body, idPorta, null, serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            if (pd.getCorrelazioneApplicativaRisposta() == null) {
                pd.setCorrelazioneApplicativaRisposta(new CorrelazioneApplicativaRisposta());
            }
            pd.getCorrelazioneApplicativaRisposta().addElemento(ErogazioniApiHelper.convert(body));
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneControlloAccessiAutorizzazioneApplicativi(String erogatore, String nome, Integer versione, String applicativoAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            PortaDelegataServizioApplicativo to_remove = (PortaDelegataServizioApplicativo)BaseHelper.findAndRemoveFirst((Iterable)pd.getServizioApplicativoList(), sa -> sa.getNome().equals(applicativoAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Applicativo " + applicativoAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneControlloAccessiAutorizzazioneApplicativiToken(String erogatore, String nome, Integer versione, String applicativoAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getAutorizzazioneToken() == null) {
                pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
            }
            if (pd.getAutorizzazioneToken().getServiziApplicativi() == null) {
                pd.getAutorizzazioneToken().setServiziApplicativi(new PortaDelegataAutorizzazioneServiziApplicativi());
            }
            PortaDelegataServizioApplicativo to_remove = (PortaDelegataServizioApplicativo)BaseHelper.findAndRemoveFirst((Iterable)pd.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList(), sa -> sa.getNome().equals(applicativoAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Applicativo " + applicativoAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneControlloAccessiAutorizzazioneRuoli(String erogatore, String nome, Integer versione, String ruoloAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getRuoli() == null) {
                pd.setRuoli(new AutorizzazioneRuoli());
            }
            Ruolo to_remove = (Ruolo)BaseHelper.findAndRemoveFirst((Iterable)pd.getRuoli().getRuoloList(), r -> r.getNome().equals(ruoloAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Ruolo " + ruoloAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneControlloAccessiAutorizzazioneRuoliToken(String erogatore, String nome, Integer versione, String ruoloAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getAutorizzazioneToken() == null) {
                pd.setAutorizzazioneToken(new PortaDelegataAutorizzazioneToken());
            }
            if (pd.getAutorizzazioneToken().getRuoli() == null) {
                pd.getAutorizzazioneToken().setRuoli(new AutorizzazioneRuoli());
            }
            Ruolo to_remove = (Ruolo)BaseHelper.findAndRemoveFirst((Iterable)pd.getAutorizzazioneToken().getRuoli().getRuoloList(), r -> r.getNome().equals(ruoloAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessun Ruolo " + ruoloAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneProprietaConfigurazione(String erogatore, String nome, Integer versione, String proprieta, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Proprieta to_remove = null;
            if (pd.getProprietaList() != null && !pd.getProprietaList().isEmpty()) {
                to_remove = (Proprieta)BaseHelper.findAndRemoveFirst((Iterable)pd.getProprietaList(), p -> p.getNome().equals(proprieta));
            }
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna propriet\u00e0 \u00e8 presente nella configurazione con nome '" + proprieta + "'");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneControlloAccessiAutorizzazioneScope(String erogatore, String nome, Integer versione, String scopeAutorizzato, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getScope() == null) {
                pd.setScope(new AutorizzazioneScope());
            }
            Scope to_remove = (Scope)BaseHelper.findAndRemoveFirst((Iterable)pd.getScope().getScopeList(), s -> s.getNome().equals(scopeAutorizzato));
            if (env.delete_404 && to_remove == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuno scope " + scopeAutorizzato + " \u00e8 associato al gruppo scelto");
            }
            if (to_remove != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneRateLimitingPolicy(String erogatore, String nome, Integer versione, String idPolicy, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            List policies = env.confCore.attivazionePolicyList(null, RuoloPolicy.DELEGATA, pd.getNome());
            AttivazionePolicy policy = BaseHelper.findFirst((Iterable)policies, p -> PolicyUtilities.getNomeActivePolicy((String)p.getAlias(), (String)p.getIdActivePolicy()).equals(idPolicy)).orElse(null);
            if (policy != null) {
                StringBuilder inUsoMessage = new StringBuilder();
                ArrayList policyRimosse = new ArrayList();
                ConfigurazioneUtilities.deleteAttivazionePolicy(new ArrayList<AttivazionePolicy>(Arrays.asList(policy)), (ConfigurazioneHelper)env.confHelper, (ConfigurazioneCore)env.confCore, (String)env.userLogin, (StringBuilder)inUsoMessage, (String)"<br/>", policyRimosse);
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)inUsoMessage.toString()));
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting con id " + idPolicy);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneTracciamentoCorrelazioneApplicativaRichiesta(String erogatore, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            CorrelazioneApplicativa correlazioneApplicativa = pd.getCorrelazioneApplicativa();
            String searchElemento = elemento.equals("*") ? "" : elemento;
            CorrelazioneApplicativaElemento to_del = (CorrelazioneApplicativaElemento)BaseHelper.evalnull(() -> (CorrelazioneApplicativaElemento)BaseHelper.findAndRemoveFirst((Iterable)correlazioneApplicativa.getElementoList(), e -> (e.getNome() == null ? "" : e.getNome()).equals(searchElemento)));
            if (to_del != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Correlazione applicativa per l'elemento " + elemento + " non trovata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneTracciamentoCorrelazioneApplicativaRisposta(String erogatore, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            CorrelazioneApplicativaRisposta correlazioneApplicativa = pd.getCorrelazioneApplicativaRisposta();
            String searchElemento = elemento.equals("*") ? "" : elemento;
            CorrelazioneApplicativaRispostaElemento to_del = (CorrelazioneApplicativaRispostaElemento)BaseHelper.evalnull(() -> (CorrelazioneApplicativaRispostaElemento)BaseHelper.findAndRemoveFirst((Iterable)correlazioneApplicativa.getElementoList(), e -> (e.getNome() == null ? "" : e.getNome()).equals(searchElemento)));
            if (to_del != null) {
                env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Correlazione applicativa per l'elemento " + elemento + " non trovata");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public byte[] downloadFruizioneControlloAccessiAutorizzazioneXacmlPolicy(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (pd.getXacmlPolicy() == null) {
                throw FaultCode.NOT_FOUND.toException("Xacml policy non assegnata al gruppo scelto");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return pd.getXacmlPolicy().getBytes();
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaRateLimitingPolicy findAllFruizioneRateLimitingPolicies(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio, String q, Integer limit, Integer offset, RateLimitingCriteriMetricaEnum metrica) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (metrica != null) {
                String risorsa = ErogazioniApiHelper.getDataElementModalitaRisorsa(metrica);
                ricerca.addFilter(idLista, "filtroTipoRisorsaPolicy", risorsa);
            }
            List policies = env.confCore.attivazionePolicyList(ricerca, RuoloPolicy.DELEGATA, pd.getNome());
            if (env.findall_404 && policies.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting associata");
            }
            ListaRateLimitingPolicy ret = (ListaRateLimitingPolicy)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaRateLimitingPolicy.class);
            policies.forEach(p -> {
                RateLimitingPolicyItem item = new RateLimitingPolicyItem();
                item.setNome(PolicyUtilities.getNomeActivePolicy((String)p.getAlias(), (String)p.getIdActivePolicy()));
                ret.addItemsItem(item);
            });
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaCorrelazioneApplicativaRichiesta findAllFruizioneTracciamentoCorrelazioneApplicativaRichiesta(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            int idLista = Liste.PORTE_DELEGATE_CORRELAZIONE_APPLICATIVA;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            List lista = env.pdCore.porteDelegateCorrelazioneApplicativaList((long)pd.getId().intValue(), (ISearch)ricerca);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna regola di correlazione applicativa associata");
            }
            ListaCorrelazioneApplicativaRichiesta ret = (ListaCorrelazioneApplicativaRichiesta)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaCorrelazioneApplicativaRichiesta.class);
            lista.forEach(c -> {
                CorrelazioneApplicativaRichiestaItem item = new CorrelazioneApplicativaRichiestaItem();
                item.setElemento(StringUtils.isEmpty((CharSequence)c.getNome()) ? "*" : c.getNome());
                item.setIdentificazioneTipo(CorrelazioneApplicativaRichiestaEnum.valueOf(c.getIdentificazione().name()));
                ret.addItemsItem(item);
            });
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaCorrelazioneApplicativaRisposta findAllFruizioneTracciamentoCorrelazioneApplicativaRisposta(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            int idLista = Liste.PORTE_DELEGATE_CORRELAZIONE_APPLICATIVA_RISPOSTA;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            List lista = env.pdCore.porteDelegateCorrelazioneApplicativaRispostaList((long)pd.getId().intValue(), (ISearch)ricerca);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna regola di correlazione applicativa della risposta associata");
            }
            ListaCorrelazioneApplicativaRisposta ret = (ListaCorrelazioneApplicativaRisposta)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaCorrelazioneApplicativaRisposta.class);
            lista.forEach(c -> {
                CorrelazioneApplicativaRispostaItem item = new CorrelazioneApplicativaRispostaItem();
                item.setElemento(StringUtils.isEmpty((CharSequence)c.getNome()) ? "*" : c.getNome());
                item.setIdentificazioneTipo(CorrelazioneApplicativaRispostaEnum.valueOf(c.getIdentificazione().name()));
                ret.addItemsItem(item);
            });
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public CachingRisposta getFruizioneCachingRisposta(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            CachingRisposta ret = ErogazioniApiHelper.buildCachingRisposta(pd.getResponseCaching());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiCanale getFruizioneCanale(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPd = ErogazioniApiHelper.getIDGruppoPDDefault(env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
            PortaDelegata pd = env.pdCore.getPortaDelegata(idPd);
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ApiCanale canale = ErogazioniApiHelper.toApiCanale(env, pd, apc, true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return canale;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutenticazione getFruizioneControlloAccessiAutenticazione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            OneOfControlloAccessiAutenticazioneAutenticazione autRet = null;
            TipoAutenticazioneEnum tipoAutenticazione = null;
            tipoAutenticazione = TipoAutenticazione.toEnumConstant((String)pd.getAutenticazione()) == null ? TipoAutenticazioneEnum.CUSTOM : Enums.dualizeMap(Enums.tipoAutenticazioneFromRest).get(TipoAutenticazione.toEnumConstant((String)pd.getAutenticazione()));
            ControlloAccessiAutenticazioneToken token = BaseHelper.evalnull(() -> pd.getGestioneToken().getAutenticazione()) != null ? ErogazioniApiHelper.fromGestioneTokenAutenticazione(pd.getGestioneToken().getAutenticazione()) : null;
            switch (tipoAutenticazione) {
                case HTTP_BASIC: {
                    APIImplAutenticazioneBasic authnBasic = new APIImplAutenticazioneBasic();
                    authnBasic.setTipo(tipoAutenticazione);
                    authnBasic.setOpzionale(Helper.statoFunzionalitaConfToBool(pd.getAutenticazioneOpzionale()));
                    autRet = authnBasic;
                    Optional<Proprieta> prop = pd.getProprietaAutenticazioneList().stream().filter(p -> "cleanAuthorizationHeader".equals(p.getNome())).findAny();
                    if (prop.isPresent() && prop.get().getValore().equals("true")) {
                        authnBasic.setForward(false);
                        break;
                    }
                    authnBasic.setForward(true);
                    break;
                }
                case HTTPS: {
                    APIImplAutenticazioneHttps authnHttps = new APIImplAutenticazioneHttps();
                    authnHttps.setTipo(tipoAutenticazione);
                    authnHttps.setOpzionale(Helper.statoFunzionalitaConfToBool(pd.getAutenticazioneOpzionale()));
                    autRet = authnHttps;
                    break;
                }
                case PRINCIPAL: {
                    Optional<Proprieta> prop;
                    APIImplAutenticazionePrincipal authnPrincipal = new APIImplAutenticazionePrincipal();
                    authnPrincipal.setTipo(tipoAutenticazione);
                    authnPrincipal.setOpzionale(Helper.statoFunzionalitaConfToBool(pd.getAutenticazioneOpzionale()));
                    autRet = authnPrincipal;
                    TipoAutenticazionePrincipal tipoAuthnPrincipal = pd.getProprietaAutenticazioneList().stream().filter(p -> "tipoAutenticazione".equals(p.getNome())).map(p -> TipoAutenticazionePrincipal.toEnumConstant((String)p.getValore())).findAny().orElse(TipoAutenticazionePrincipal.CONTAINER);
                    authnPrincipal.setTipoPrincipal(Enums.dualizeMap(Enums.tipoAutenticazionePrincipalFromRest).get(tipoAuthnPrincipal));
                    switch (authnPrincipal.getTipoPrincipal()) {
                        case CONTAINER: 
                        case IP_ADDRESS: 
                        case IP_ADDRESS_FORWARDED_FOR: {
                            break;
                        }
                        case HEADER_BASED: {
                            prop = pd.getProprietaAutenticazioneList().stream().filter(p -> "nome".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            authnPrincipal.setNome(prop.get().getValore());
                            break;
                        }
                        case FORM_BASED: {
                            prop = pd.getProprietaAutenticazioneList().stream().filter(p -> "nome".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            authnPrincipal.setNome(prop.get().getValore());
                            break;
                        }
                        case URL_BASED: {
                            prop = pd.getProprietaAutenticazioneList().stream().filter(p -> "pattern".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            authnPrincipal.setPattern(prop.get().getValore());
                            break;
                        }
                        case TOKEN: {
                            prop = pd.getProprietaAutenticazioneList().stream().filter(p -> "claim".equals(p.getNome())).findAny();
                            if (!prop.isPresent()) break;
                            if ("subject".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.SUBJECT);
                                break;
                            }
                            if ("clientId".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.CLIENTID);
                                break;
                            }
                            if ("username".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.USERNAME);
                                break;
                            }
                            if ("eMail".equals(prop.get().getValore())) {
                                authnPrincipal.setToken(TipoAutenticazionePrincipalToken.EMAIL);
                                break;
                            }
                            if (!"custom".equals(prop.get().getValore())) break;
                            authnPrincipal.setToken(TipoAutenticazionePrincipalToken.CUSTOM);
                            Optional<Proprieta> propName = pd.getProprietaAutenticazioneList().stream().filter(p -> "nome".equals(p.getNome())).findAny();
                            if (!propName.isPresent()) break;
                            authnPrincipal.setNome(propName.get().getValore());
                            break;
                        }
                    }
                    prop = pd.getProprietaAutenticazioneList().stream().filter(p -> "cleanPrincipal".equals(p.getNome())).findAny();
                    if (prop.isPresent() && "true".equals(prop.get().getValore())) {
                        authnPrincipal.setForward(false);
                        break;
                    }
                    authnPrincipal.setForward(true);
                    break;
                }
                case API_KEY: {
                    String valoreP;
                    String nomeP;
                    APIImplAutenticazioneApiKey authnApiKey = new APIImplAutenticazioneApiKey();
                    authnApiKey.setTipo(tipoAutenticazione);
                    authnApiKey.setOpzionale(Helper.statoFunzionalitaConfToBool(pd.getAutenticazioneOpzionale()));
                    autRet = authnApiKey;
                    if (pd.getProprietaAutenticazioneList() == null || pd.sizeProprietaAutenticazioneList() <= 0) break;
                    APIImplAutenticazioneApiKeyPosizione posizione = null;
                    APIImplAutenticazioneApiKeyConfig apiKeyNomi = null;
                    APIImplAutenticazioneApiKeyConfig appIdNomi = null;
                    boolean useOasNames = false;
                    for (Proprieta proprieta : pd.getProprietaAutenticazioneList()) {
                        boolean clean;
                        nomeP = proprieta.getNome();
                        valoreP = proprieta.getValore();
                        if ("appId".equals(nomeP)) {
                            authnApiKey.setAppId("true".equals(valoreP));
                            continue;
                        }
                        if ("queryParameter".equals(nomeP)) {
                            if (posizione == null) {
                                posizione = new APIImplAutenticazioneApiKeyPosizione();
                            }
                            posizione.setQueryParameter("true".equals(valoreP));
                            continue;
                        }
                        if ("header".equals(nomeP)) {
                            if (posizione == null) {
                                posizione = new APIImplAutenticazioneApiKeyPosizione();
                            }
                            posizione.setHeader("true".equals(valoreP));
                            continue;
                        }
                        if ("cookie".equals(nomeP)) {
                            if (posizione == null) {
                                posizione = new APIImplAutenticazioneApiKeyPosizione();
                            }
                            posizione.setCookie("true".equals(valoreP));
                            continue;
                        }
                        if ("useOAS3Names".equals(nomeP)) {
                            useOasNames = "true".equals(valoreP);
                            continue;
                        }
                        if ("cleanApiKey".equals(nomeP)) {
                            clean = "true".equals(valoreP);
                            authnApiKey.setApiKeyForward(!clean);
                            continue;
                        }
                        if (!"cleanAppId".equals(nomeP)) continue;
                        clean = "true".equals(valoreP);
                        authnApiKey.setAppIdForward(!clean);
                    }
                    if (!useOasNames) {
                        for (Proprieta proprieta : pd.getProprietaAutenticazioneList()) {
                            nomeP = proprieta.getNome();
                            valoreP = proprieta.getValore();
                            if ("queryParameterApiKey".equals(nomeP)) {
                                if (apiKeyNomi == null) {
                                    apiKeyNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                apiKeyNomi.setQueryParameter(valoreP);
                                continue;
                            }
                            if ("headerApiKey".equals(nomeP)) {
                                if (apiKeyNomi == null) {
                                    apiKeyNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                apiKeyNomi.setHeader(valoreP);
                                continue;
                            }
                            if ("cookieApiKey".equals(nomeP)) {
                                if (apiKeyNomi == null) {
                                    apiKeyNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                apiKeyNomi.setCookie(valoreP);
                                continue;
                            }
                            if ("queryParameterAppId".equals(nomeP)) {
                                if (appIdNomi == null) {
                                    appIdNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                appIdNomi.setQueryParameter(valoreP);
                                continue;
                            }
                            if ("headerAppId".equals(nomeP)) {
                                if (appIdNomi == null) {
                                    appIdNomi = new APIImplAutenticazioneApiKeyConfig();
                                }
                                appIdNomi.setHeader(valoreP);
                                continue;
                            }
                            if (!"cookieAppId".equals(nomeP)) continue;
                            if (appIdNomi == null) {
                                appIdNomi = new APIImplAutenticazioneApiKeyConfig();
                            }
                            appIdNomi.setCookie(valoreP);
                        }
                    }
                    authnApiKey.setPosizione(posizione);
                    authnApiKey.setApiKeyNomi(apiKeyNomi);
                    authnApiKey.setAppIdNomi(appIdNomi);
                    break;
                }
                case CUSTOM: {
                    APIImplAutenticazioneCustom authnCustom = new APIImplAutenticazioneCustom();
                    authnCustom.setTipo(tipoAutenticazione);
                    authnCustom.setOpzionale(Helper.statoFunzionalitaConfToBool(pd.getAutenticazioneOpzionale()));
                    autRet = authnCustom;
                    authnCustom.setNome(pd.getAutenticazione());
                    break;
                }
            }
            ControlloAccessiAutenticazione ret = new ControlloAccessiAutenticazione();
            ret.setAutenticazione(autRet);
            ret.setToken(token);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneView getFruizioneControlloAccessiAutorizzazione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiAutorizzazioneView ret = ErogazioniApiHelper.controlloAccessiAutorizzazioneFromPD(pd);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneApplicativi getFruizioneControlloAccessiAutorizzazioneApplicativi(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiAutorizzazioneApplicativi ret = new ControlloAccessiAutorizzazioneApplicativi();
            int idLista = Liste.PORTE_DELEGATE_SERVIZIO_APPLICATIVO;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata("", -1, 0, idLista);
            List lista = env.pdCore.porteDelegateServizioApplicativoList(pd.getId().longValue(), (ISearch)ricerca);
            ret.setApplicativi(lista.stream().map(saPA -> saPA.getNome()).collect(Collectors.toList()));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneApplicativi getFruizioneControlloAccessiAutorizzazioneApplicativiToken(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiAutorizzazioneApplicativi ret = new ControlloAccessiAutorizzazioneApplicativi();
            int idLista = Liste.PORTE_DELEGATE_TOKEN_SERVIZIO_APPLICATIVO;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata("", -1, 0, idLista);
            List lista = env.pdCore.porteDelegateServizioApplicativoTokenList(pd.getId().longValue(), (ISearch)ricerca);
            ret.setApplicativi(lista.stream().map(saPA -> saPA.getNome()).collect(Collectors.toList()));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneRuoli getFruizioneControlloAccessiAutorizzazioneRuoli(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiAutorizzazioneRuoli ret = new ControlloAccessiAutorizzazioneRuoli();
            if (pd.getRuoli() != null && pd.getRuoli().sizeRuoloList() > 0) {
                ret.setRuoli((List)BaseHelper.evalnull(() -> pd.getRuoli().getRuoloList().stream().map(Ruolo::getNome).collect(Collectors.toList())));
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneRuoli getFruizioneControlloAccessiAutorizzazioneRuoliToken(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiAutorizzazioneRuoli ret = new ControlloAccessiAutorizzazioneRuoli();
            if (pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getRuoli() != null && pd.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                ret.setRuoli((List)BaseHelper.evalnull(() -> pd.getAutorizzazioneToken().getRuoli().getRuoloList().stream().map(Ruolo::getNome).collect(Collectors.toList())));
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiAutorizzazioneScopes getFruizioneControlloAccessiAutorizzazioneScope(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiAutorizzazioneScopes ret = new ControlloAccessiAutorizzazioneScopes();
            ret.setScope((List)BaseHelper.evalnull(() -> pd.getScope().getScopeList().stream().map(Scope::getNome).collect(Collectors.toList())));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ElencoProprieta getFruizioneElencoProprieta(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ElencoProprieta ret = new ElencoProprieta();
            ret.setProprieta(new ArrayList<ProprietaOpzioneCifratura>());
            if (pd.getProprietaList() != null && !pd.getProprietaList().isEmpty()) {
                for (Proprieta p : pd.getProprietaList()) {
                    ProprietaOpzioneCifratura retP = new ProprietaOpzioneCifratura();
                    retP.setNome(p.getNome());
                    retP.setValore(p.getValore());
                    retP.setEncrypted(BYOKUtilities.isWrappedValue((String)p.getValore()));
                    ret.addProprietaItem(retP);
                }
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiIdentificazioneAttributi getFruizioneControlloAccessiIdentificazioneAttributi(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiIdentificazioneAttributi ret = new ControlloAccessiIdentificazioneAttributi();
            if (pd.sizeAttributeAuthorityList() > 0) {
                ret.setAbilitato(true);
                ret.setAttributeAuthority(new ArrayList<ControlloAccessiAttributeAuthority>());
                for (AttributeAuthority aa : pd.getAttributeAuthorityList()) {
                    ControlloAccessiAttributeAuthority attributeAuthorityItem = new ControlloAccessiAttributeAuthority();
                    attributeAuthorityItem.setNome(aa.getNome());
                    if (aa.sizeAttributoList() > 0) {
                        attributeAuthorityItem.setAttributi(new ArrayList<String>());
                        for (String attributeName : aa.getAttributoList()) {
                            attributeAuthorityItem.addAttributiItem(attributeName);
                        }
                    }
                    ret.addAttributeAuthorityItem(attributeAuthorityItem);
                }
            } else {
                ret.setAbilitato(false);
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ProprietaOpzioneCifratura getFruizioneProprieta(String erogatore, String nome, Integer versione, String proprieta, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            Optional op;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Proprieta toGet = null;
            if (pd.getProprietaList() != null && !pd.getProprietaList().isEmpty() && (op = BaseHelper.findFirst((Iterable)pd.getProprietaList(), p -> p.getNome().equals(proprieta))).isPresent()) {
                toGet = (Proprieta)op.get();
            }
            ProprietaOpzioneCifratura ret = null;
            if (toGet == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna propriet\u00e0 \u00e8 presente nella configurazione con nome '" + proprieta + "'");
            }
            ret = new ProprietaOpzioneCifratura();
            ret.setNome(toGet.getNome());
            ret.setValore(toGet.getValore());
            ret.setEncrypted(BYOKUtilities.isWrappedValue((String)toGet.getValore()));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ControlloAccessiGestioneToken getFruizioneControlloAccessiGestioneToken(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ControlloAccessiGestioneToken ret = new ControlloAccessiGestioneToken();
            GestioneToken paToken = pd.getGestioneToken();
            ret.setAbilitato(paToken != null);
            if (paToken != null) {
                ret.setIntrospection(StatoFunzionalitaConWarningEnum.fromValue(paToken.getIntrospection().getValue()));
                ret.setPolicy(paToken.getPolicy());
                ret.setTokenForward(Helper.statoFunzionalitaConfToBool(paToken.getForward()));
                ret.setTokenOpzionale(Helper.statoFunzionalitaConfToBool(paToken.getTokenOpzionale()));
                ret.setUserInfo(StatoFunzionalitaConWarningEnum.fromValue(paToken.getUserInfo().getValue()));
                ret.setValidazioneJwt(StatoFunzionalitaConWarningEnum.fromValue(paToken.getValidazione().getValue()));
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public GestioneCors getFruizioneGestioneCORS(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPd = ErogazioniApiHelper.getIDGruppoPDDefault(env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
            PortaDelegata pd = env.pdCore.getPortaDelegata(idPd);
            CorsConfigurazione pdConf = pd.getGestioneCors();
            GestioneCors ret = ErogazioniApiHelper.convert(pdConf);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RateLimitingPolicyFruizioneView getFruizioneRateLimitingPolicy(String erogatore, String nome, Integer versione, String idPolicy, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            AttivazionePolicy policy = (AttivazionePolicy)BaseHelper.supplyOrNotFound(() -> env.confCore.getAttivazionePolicy(idPolicy, RuoloPolicy.DELEGATA, pd.getNome()), (String)("Rate Limiting Policy con nome " + idPolicy));
            if (policy == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting con nome " + idPolicy);
            }
            InfoPolicy infoPolicy = env.confCore.getInfoPolicy(policy.getIdPolicy());
            RateLimitingPolicyFruizioneView ret = ErogazioniApiHelper.convert(policy, infoPolicy, new RateLimitingPolicyFruizioneView());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RegistrazioneDiagnosticiConfigurazione getFruizioneRegistrazioneDiagnostici(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            RegistrazioneDiagnosticiConfigurazione ret = ErogazioniApiHelper.fromDiagnosticiConfigurazione(pd.getTracciamento());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RegistrazioneMessaggi getFruizioneRegistrazioneMessaggi(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            RegistrazioneMessaggi ret = ErogazioniApiHelper.fromDumpConfigurazione(pd.getDump());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public RegistrazioneTransazioniConfigurazione getFruizioneRegistrazioneTransazioni(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            RegistrazioneTransazioniConfigurazione ret = ErogazioniApiHelper.fromTransazioniConfigurazione(pd.getTracciamento(), env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplStato getFruizioneStato(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ApiImplStato ret = new ApiImplStato();
            ret.setAbilitato(Helper.statoFunzionalitaConfToBool(pd.getStato()));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public CorrelazioneApplicativaRichiesta getFruizioneTracciamentoCorrelazioneApplicativaRichiesta(String erogatore, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            String searchElemento = elemento.equals("*") ? "" : elemento;
            List lista = (List)BaseHelper.evalnull(() -> pd.getCorrelazioneApplicativa().getElementoList());
            Optional el = BaseHelper.findFirst((Iterable)lista, c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento));
            if (!el.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("CorrelazioneApplicativaRichiesta per l'elemento " + elemento + " non presente");
            }
            CorrelazioneApplicativaRichiesta ret = ErogazioniApiHelper.convert((CorrelazioneApplicativaElemento)el.get());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta getFruizioneTracciamentoCorrelazioneApplicativaRisposta(String erogatore, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            String searchElemento = elemento.equals("*") ? "" : elemento;
            List lista = (List)BaseHelper.evalnull(() -> pd.getCorrelazioneApplicativaRisposta().getElementoList());
            Optional el = BaseHelper.findFirst((Iterable)lista, c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento));
            if (!el.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("CorrelazioneApplicativaRisposta per l'elemento " + elemento + " non presente");
            }
            org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta ret = ErogazioniApiHelper.convert((CorrelazioneApplicativaRispostaElemento)el.get());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public Validazione getFruizioneValidazione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Validazione ret = ErogazioniApiHelper.fromValidazioneContenutiApplicativi(pd.getValidazioneContenutiApplicativi());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneCachingRisposta(CachingRisposta body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (!env.paHelper.checkDataConfigurazioneResponseCachingPorta(TipoOperazione.OTHER, true, body.getStato().toString())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ResponseCachingConfigurazione newConfigurazione = ErogazioniApiHelper.buildResponseCachingConfigurazione(body, env.paHelper);
            pd.setResponseCaching(newConfigurazione);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneCanale(ConfigurazioneApiCanale body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPd = ErogazioniApiHelper.getIDGruppoPDDefault(env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
            PortaDelegata pd = env.pdCore.getPortaDelegata(idPd);
            if (ConfigurazioneCanaleEnum.RIDEFINITO.equals((Object)body.getConfigurazione())) {
                if (body.getCanale() == null || "".equals(body.getCanale())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare un canale");
                }
                if (!env.canali.contains(body.getCanale())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il canale fornito '" + body.getCanale() + "' non \u00e8 presente nel registro");
                }
                pd.setCanale(body.getCanale());
            } else {
                pd.setCanale(null);
            }
            env.paCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneControlloAccessiAutenticazione(ControlloAccessiAutenticazione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata oldPd = env.pdCore.getPortaDelegata(env.idPd);
            PortaDelegata newPd = env.pdCore.getPortaDelegata(env.idPd);
            ErogazioniApiHelper.fillPortaDelegata(env, body, newPd);
            if (!ErogazioniApiHelper.controlloAccessiCheckPD(env, oldPd, newPd)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{newPd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneControlloAccessiAutorizzazione(ControlloAccessiAutorizzazione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            PortaDelegata newPd = env.pdCore.getPortaDelegata(env.idPd);
            ErogazioniApiHelper.fillPortaDelegata(body, newPd);
            if (!ErogazioniApiHelper.controlloAccessiCheckPD(env, pd, newPd)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{newPd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneControlloAccessiGestioneToken(ControlloAccessiGestioneToken body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata newPd = env.pdCore.getPortaDelegata(env.idPd);
            PortaDelegata oldPd = env.pdCore.getPortaDelegata(env.idPd);
            if (body.isAbilitato().booleanValue()) {
                GestioneToken gTok = newPd.getGestioneToken() != null ? newPd.getGestioneToken() : new GestioneToken();
                ErogazioniApiHelper.fillGestioneToken(gTok, body);
                newPd.setGestioneToken(gTok);
            } else {
                newPd.setGestioneToken(null);
            }
            if (!ErogazioniApiHelper.controlloAccessiCheckPD(env, oldPd, newPd)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{newPd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneProprieta(ProprietaOpzioneCifratura body, String erogatore, String nome, Integer versione, String proprieta, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            if (env.pdCore == null) {
                throw new CoreException("PdCore not initialized");
            }
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (body.getNome().indexOf(" ") != -1 || body.getValore().indexOf(" ") != -1) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Non inserire spazi nei campi di testo");
            }
            if (!proprieta.equals(body.getNome()) && pd.getProprietaList() != null && !pd.getProprietaList().isEmpty()) {
                for (Proprieta p : pd.getProprietaList()) {
                    if (!p.getNome().equals(body.getNome())) continue;
                    throw FaultCode.CONFLITTO.toException("Propriet\u00e0 " + body.getNome() + " gi\u00e0 assegnata alla configurazione");
                }
            }
            boolean found = false;
            if (pd.getProprietaList() != null && !pd.getProprietaList().isEmpty()) {
                for (Proprieta p : pd.getProprietaList()) {
                    if (!p.getNome().equals(proprieta)) continue;
                    p.setNome(body.getNome());
                    if (env.pdCore != null && env.pdCore.getDriverBYOKUtilities() != null && body.isEncrypted() != null && body.isEncrypted().booleanValue()) {
                        p.setValore(env.pdCore.getDriverBYOKUtilities().wrap(body.getValore()));
                    } else {
                        if (body.getValore().length() > 255) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Il valore della propriet\u00e0 non deve superare i 255 caratteri");
                        }
                        p.setValore(body.getValore());
                    }
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw FaultCode.NOT_FOUND.toException("Propriet\u00e0 " + body.getNome() + " non presente nella configurazione");
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneControlloAccessiIdentificazioneAttributi(ControlloAccessiIdentificazioneAttributi body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata newPd = env.pdCore.getPortaDelegata(env.idPd);
            PortaDelegata oldPd = env.pdCore.getPortaDelegata(env.idPd);
            if (body.isAbilitato().booleanValue() && body.getAttributeAuthority() != null && !body.getAttributeAuthority().isEmpty()) {
                if (newPd.getAttributeAuthorityList() == null) {
                    newPd.setAttributeAuthorityList(new ArrayList());
                } else {
                    newPd.getAttributeAuthorityList().clear();
                }
                for (ControlloAccessiAttributeAuthority controlloAccessiAttributeAuthority : body.getAttributeAuthority()) {
                    GenericProperties gp = null;
                    try {
                        gp = env.confCore.getGenericProperties(controlloAccessiAttributeAuthority.getNome(), "attributeAuthority", false);
                    }
                    catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                        // empty catch block
                    }
                    if (gp == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("AttributeAuthority '" + controlloAccessiAttributeAuthority.getNome() + "' non esistente");
                    }
                    AttributeAuthority aa = new AttributeAuthority();
                    aa.setNome(controlloAccessiAttributeAuthority.getNome());
                    if (controlloAccessiAttributeAuthority.getAttributi() != null && !controlloAccessiAttributeAuthority.getAttributi().isEmpty()) {
                        aa.setAttributoList(controlloAccessiAttributeAuthority.getAttributi());
                    }
                    newPd.addAttributeAuthority(aa);
                }
            } else if (newPd.getAttributeAuthorityList() != null) {
                newPd.getAttributeAuthorityList().clear();
            } else {
                newPd.setAttributeAuthorityList(new ArrayList());
            }
            if (!ErogazioniApiHelper.controlloAccessiCheckPD(env, oldPd, newPd)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{newPd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneGestioneCORS(GestioneCors body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            IDPortaDelegata idPd = ErogazioniApiHelper.getIDGruppoPDDefault(env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
            PortaDelegata pd = env.pdCore.getPortaDelegata(idPd);
            CorsConfigurazione oldConf = pd.getGestioneCors();
            if (body.isRidefinito().booleanValue()) {
                pd.setGestioneCors(ErogazioniApiHelper.buildCorsConfigurazione(body, env, oldConf));
            } else {
                pd.setGestioneCors(null);
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneRateLimitingPolicy(RateLimitingPolicyFruizioneUpdate body, String erogatore, String nome, Integer versione, String idPolicy, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            AttivazionePolicy policy = (AttivazionePolicy)BaseHelper.supplyOrNotFound(() -> env.confCore.getAttivazionePolicy(idPolicy, RuoloPolicy.DELEGATA, pd.getNome()), (String)("Rate Limiting Policy con nome " + idPolicy));
            if (policy == null) {
                throw FaultCode.NOT_FOUND.toException("Nessuna policy di rate limiting con nome " + idPolicy);
            }
            InfoPolicy infoPolicy = env.confCore.getInfoPolicy(policy.getIdPolicy());
            ErogazioniApiHelper.override(infoPolicy.getTipoRisorsa(), body, env.protocolFactory.getProtocol(), env.idSoggetto.toIDSoggetto(), env.requestWrapper);
            String errorAttivazione = env.confHelper.readDatiAttivazionePolicyFromHttpParameters(policy, false, TipoOperazione.CHANGE, infoPolicy);
            if (!StringUtils.isEmpty((CharSequence)errorAttivazione)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)errorAttivazione));
            }
            String modalita = ErogazioniApiHelper.getDataElementModalita(infoPolicy.isBuiltIn());
            FruizioniConfigurazioneHelper.attivazionePolicyCheckData(TipoOperazione.CHANGE, pd, policy, infoPolicy, env, env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), modalita);
            env.confCore.performUpdateOperation(env.userLogin, false, new Object[]{policy});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneRegistrazioneDiagnostici(RegistrazioneDiagnosticiConfigurazione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ErogazioniApiHelper.updateTracciamento(body, pd, (ErogazioniEnv)env);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneRegistrazioneMessaggi(RegistrazioneMessaggi body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            if (body.isRidefinito().booleanValue()) {
                pd.setDump(ErogazioniApiHelper.buildDumpConfigurazione(body, false, env));
            } else {
                pd.setDump(null);
            }
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneRegistrazioneTransazioni(RegistrazioneTransazioniConfigurazione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            ErogazioniApiHelper.updateTracciamento(body, (Object)pd, (ErogazioniEnv)env);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneStato(ApiImplStato body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            IDPortaDelegata oldIDPortaDelegataForUpdate = new IDPortaDelegata();
            oldIDPortaDelegataForUpdate.setNome(pd.getNome());
            pd.setOldIDPortaDelegataForUpdate(oldIDPortaDelegataForUpdate);
            pd.setStato(Helper.boolToStatoFunzionalitaConf(body.isAbilitato()));
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneTracciamentoCorrelazioneApplicativaRichiesta(CorrelazioneApplicativaRichiesta body, String erogatore, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            List correlazioni;
            CorrelazioneApplicativaElemento oldElem;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            String searchElemento = elemento.equals("*") ? "" : elemento;
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Long idPorta = pd.getId();
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            if (pd.getCorrelazioneApplicativa() == null) {
                pd.setCorrelazioneApplicativa(new CorrelazioneApplicativa());
            }
            if ((oldElem = (CorrelazioneApplicativaElemento)BaseHelper.findAndRemoveFirst((Iterable)(correlazioni = pd.getCorrelazioneApplicativa().getElementoList()), c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento))) == null) {
                throw FaultCode.NOT_FOUND.toException("Correlazione Applicativa Richiesta per l'elemento " + elemento + " non trovata ");
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRichiestaCheckData(TipoOperazione.CHANGE, env.requestWrapper, (ConsoleHelper)env.pdHelper, true, body, idPorta, oldElem.getId(), serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            correlazioni.add(ErogazioniApiHelper.convert(body));
            pd.getCorrelazioneApplicativa().setElementoList(correlazioni);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneTracciamentoCorrelazioneApplicativaRisposta(org.openspcoop2.core.config.rs.server.model.CorrelazioneApplicativaRisposta body, String erogatore, String nome, Integer versione, String elemento, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            List correlazioni;
            CorrelazioneApplicativaRispostaElemento oldElem;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getElemento() == null) {
                body.setElemento("");
            }
            String searchElemento = elemento.equals("*") ? "" : elemento;
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            Long idPorta = pd.getId();
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            ServiceBinding serviceBinding = env.apcCore.toMessageServiceBinding(apc.getServiceBinding());
            if (pd.getCorrelazioneApplicativaRisposta() == null) {
                pd.setCorrelazioneApplicativaRisposta(new CorrelazioneApplicativaRisposta());
            }
            if ((oldElem = (CorrelazioneApplicativaRispostaElemento)BaseHelper.findAndRemoveFirst((Iterable)(correlazioni = pd.getCorrelazioneApplicativaRisposta().getElementoList()), c -> (c.getNome() == null ? "" : c.getNome()).equals(searchElemento))) == null) {
                throw FaultCode.NOT_FOUND.toException("Correlazione Applicativa Risposta per l'elemento " + elemento + " non trovata ");
            }
            if (!ErogazioniApiHelper.correlazioneApplicativaRispostaCheckData(TipoOperazione.CHANGE, env.requestWrapper, (ConsoleHelper)env.pdHelper, true, body, idPorta, oldElem.getId(), serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            correlazioni.add(ErogazioniApiHelper.convert(body));
            pd.getCorrelazioneApplicativaRisposta().setElementoList(correlazioni);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneValidazione(Validazione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String gruppo, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            FruizioniConfEnv env = new FruizioniConfEnv(context.getServletRequest(), profilo, soggetto, context, erogatore, nome, versione, gruppo, tipoServizio);
            PortaDelegata pd = env.pdCore.getPortaDelegata(env.idPd);
            String stato = (String)BaseHelper.evalnull(() -> body.getStato().toString());
            String tipoValidazione = (String)BaseHelper.evalnull(() -> body.getTipo().toString());
            env.requestWrapper.overrideParameter("xsd", stato);
            if (!env.pdHelper.validazioneContenutiCheck(TipoOperazione.OTHER, true)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(StringEscapeUtils.unescapeHtml4((String)env.pd.getMessage()));
            }
            ValidazioneContenutiApplicativi vx = new ValidazioneContenutiApplicativi();
            vx.setAcceptMtomMessage((StatoFunzionalita)BaseHelper.evalnull(() -> pd.getValidazioneContenutiApplicativi().getAcceptMtomMessage()));
            vx.setStato(StatoFunzionalitaConWarning.toEnumConstant((String)stato));
            vx.setTipo(ValidazioneContenutiApplicativiTipo.toEnumConstant((String)tipoValidazione));
            pd.setValidazioneContenutiApplicativi(vx);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }
}

