/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.fruizioni;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.rs.server.api.FruizioniApi;
import org.openspcoop2.core.config.rs.server.api.impl.Helper;
import org.openspcoop2.core.config.rs.server.api.impl.IdServizio;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ConnettoreAPIHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ModiErogazioniApiHelper;
import org.openspcoop2.core.config.rs.server.config.ServerProperties;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGenerali;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGeneraliView;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazione;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazioneView;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApi;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApiView;
import org.openspcoop2.core.config.rs.server.model.ConnettoreApplicativoServer;
import org.openspcoop2.core.config.rs.server.model.ConnettoreFruizione;
import org.openspcoop2.core.config.rs.server.model.ConnettoreMessageBox;
import org.openspcoop2.core.config.rs.server.model.Fruizione;
import org.openspcoop2.core.config.rs.server.model.FruizioneModI;
import org.openspcoop2.core.config.rs.server.model.FruizioneViewItem;
import org.openspcoop2.core.config.rs.server.model.ListaApiImplAllegati;
import org.openspcoop2.core.config.rs.server.model.ListaFruizioni;
import org.openspcoop2.core.config.rs.server.model.ModalitaIdentificazioneAzioneEnum;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.core.config.utils.UpdateProprietaOggetto;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.information_missing.constants.StatoType;
import org.openspcoop2.protocol.sdk.constants.ConsoleInterfaceType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedListServlet;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.LoggerFactory;

public class FruizioniApiServiceImpl
extends BaseImpl
implements FruizioniApi {
    public FruizioniApiServiceImpl() {
        super(LoggerFactory.getLogger(FruizioniApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    private WebApplicationException newNotFoundSoggettoFruitore(ErogazioniEnv env) {
        return FaultCode.NOT_FOUND.toException("Soggetto fruitore " + env.idSoggetto.toString() + "non registrato per la fruizione scelta");
    }

    @Override
    public void createFruizione(Fruizione body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            AccordoServizioParteSpecifica asps;
            IDServizio idAps;
            boolean alreadyExists;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IdSoggetto idero = new IdSoggetto(new IDSoggetto(env.tipo_soggetto, body.getErogatore()));
            Soggetto erogatore = (Soggetto)BaseHelper.supplyOrNotFound(() -> env.soggettiCore.getSoggettoRegistro(idero.toIDSoggetto()), (String)"Soggetto Erogatore");
            idero.setId(erogatore.getId());
            Soggetto fruitore = env.soggettiCore.getSoggettoRegistro(env.idSoggetto.toIDSoggetto());
            IDSoggetto idReferente = ErogazioniApiHelper.getIdReferente(body, env);
            AccordoServizioParteComuneSintetico as = Helper.getAccordoSintetico(body.getApiNome(), body.getApiVersione(), idReferente, env.apcCore);
            Object referente = "";
            if (env.apcCore.isSupportatoSoggettoReferente(env.tipo_protocollo) && idReferente != null) {
                referente = " (referente: " + String.valueOf(idReferente) + ")";
            }
            if (as == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna Api registrata con nome " + body.getApiNome() + " e versione " + body.getApiVersione() + (String)referente);
            }
            if (ServiceBinding.SOAP.equals((Object)as.getServiceBinding())) {
                if (StringUtils.isEmpty((CharSequence)body.getApiSoapServizio())) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Per una API di tipo SOAP il claim 'api_soap_servizio' deve essere obbligatoriamente fornito");
                }
                boolean ptFind = false;
                if (as.getPortType() != null && !as.getPortType().isEmpty()) {
                    for (PortTypeSintetico pt : as.getPortType()) {
                        if (!pt.getNome().equals(body.getApiSoapServizio())) continue;
                        ptFind = true;
                        break;
                    }
                }
                if (!ptFind) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nel claim 'api_soap_servizio' \u00e8 stato indicato un servizio non esistente nell'API " + body.getApiNome() + " v" + body.getApiVersione() + (String)referente);
                }
            }
            if (alreadyExists = env.apsCore.existsAccordoServizioParteSpecifica(idAps = env.idServizioFactory.getIDServizioFromValues((asps = ErogazioniApiHelper.apiImplToAps(body, erogatore, as, env)).getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue()))) {
                asps = env.apsCore.getServizio(idAps);
            }
            ServletUtils.setObjectIntoSession((HttpServletRequest)context.getServletRequest(), (HttpSession)context.getServletRequest().getSession(), (Object)"fruizione", (String)"_tabKey_tipologiaErogazione");
            ErogazioniApiHelper.serviziCheckData(TipoOperazione.ADD, env, as, asps, Optional.of(env.idSoggetto), body);
            IDFruizione idFruizione = new IDFruizione();
            idFruizione.setIdServizio(idAps);
            idFruizione.setIdFruitore(new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome()));
            Connettore regConnettore = ErogazioniApiHelper.buildConnettoreRegistro(env, body.getConnettore());
            Fruitore f = new Fruitore();
            f.setTipo(fruitore.getTipo());
            f.setNome(fruitore.getNome());
            f.setStatoPackage(StatoType.FINALE.getValue());
            f.setConnettore(regConnettore);
            f.setDescrizione(body.getDescrizione());
            env.apsCore.setDataCreazioneFruitore(f);
            asps.addFruitore(f);
            ProtocolProperties protocolProperties = null;
            if (profilo != null) {
                AccordoServizioParteComune accordoFull;
                boolean required = false;
                if (env.isProfiloModi() && (accordoFull = Helper.getAccordoFull(body.getApiNome(), body.getApiVersione(), idReferente, env.apcCore)).sizeProtocolPropertyList() > 0) {
                    for (ProtocolProperty pp : accordoFull.getProtocolPropertyList()) {
                        String v;
                        if (!"modipaSecurityMessageProfile".equals(pp.getName()) || (v = pp.getValue()) == null || !StringUtils.isNotEmpty((CharSequence)v) || "-".equals(v)) continue;
                        required = true;
                    }
                }
                if (env.isProfiloModi()) {
                    ErogazioniApiHelper.addInfoTokenPolicyForModI(regConnettore, env, true);
                }
                if ((protocolProperties = ErogazioniApiHelper.getProtocolProperties(body, profilo, asps, env, required)) != null) {
                    f.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
                }
            }
            ErogazioniApiHelper.validateProperties(env, protocolProperties, idFruizione, ConsoleOperationType.ADD);
            ErogazioniApiHelper.createAps(env, asps, regConnettore, body, alreadyExists, false);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void createFruizioneAllegato(ApiImplAllegato body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
            try {
                env.pdCore.getIDPorteDelegateAssociate(idServizio, env.idSoggetto.toIDSoggetto());
            }
            catch (Exception e) {
                throw FaultCode.NOT_FOUND.toException(e.getMessage());
            }
            ErogazioniApiHelper.createAllegatoAsps(body, env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            context.getServletResponse().setStatus(201);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.evalnull(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env));
            if (asps != null) {
                IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
                StringBuilder inUsoMessage = new StringBuilder();
                AccordiServizioParteSpecificaUtilities.deleteAccordoServizioParteSpecifica((AccordoServizioParteSpecifica)asps, (boolean)true, (boolean)false, (IDSoggetto)env.idSoggetto.toIDSoggetto(), (IDServizio)idServizio, (IExtendedListServlet)env.paCore.getExtendedServletPortaApplicativa(), (String)env.userLogin, (AccordiServizioParteSpecificaCore)env.apsCore, (AccordiServizioParteSpecificaHelper)env.apsHelper, (StringBuilder)inUsoMessage, (String)"\n");
                if (inUsoMessage.length() > 0) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(inUsoMessage.toString());
                }
            } else if (env.delete_404) {
                throw FaultCode.NOT_FOUND.toException("Fruizione inesistente");
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void deleteFruizioneAllegato(String erogatore, String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            ErogazioniApiHelper.deleteAllegato(nomeAllegato, env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public byte[] downloadFruizioneAllegato(String erogatore, String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            Optional<Long> idDoc = ErogazioniApiHelper.getIdDocumento(nomeAllegato, asps);
            if (!idDoc.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("Allegato di nome " + nomeAllegato + " non presente.");
            }
            Documento allegato = env.archiviCore.getDocumento(idDoc.get().longValue(), true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            Helper.setContentType(context, allegato.getFile());
            return allegato.getByteContenuto();
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaFruizioni findAllFruizioni(ProfiloEnum profilo, String soggetto, String q, Integer limit, Integer offset, TipoApiEnum tipoApi, String tag, String uriApiImplementata, Boolean profiloQualsiasi, Boolean soggettoQualsiasi) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            int idLista = Liste.SERVIZI;
            ConsoleSearch ricerca = Helper.setupRicercaPaginata(q, limit, offset, idLista, env.idSoggetto.toIDSoggetto(), env.tipo_protocollo);
            if (profiloQualsiasi != null && profiloQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroProtocollo");
            }
            if (soggettoQualsiasi != null && soggettoQualsiasi.booleanValue()) {
                ricerca.clearFilter(idLista, "filtroSoggetto");
            }
            if (tipoApi != null) {
                ricerca.addFilter(idLista, "filtroServiceBinding", tipoApi.toString().toLowerCase());
            }
            if (tag != null) {
                ricerca.addFilter(idLista, "filtroGruppo", tag);
            }
            if (uriApiImplementata != null) {
                ErogazioniApiHelper.setFiltroApiImplementata(uriApiImplementata, idLista, ricerca, env);
            }
            List lista = env.apsCore.soggettiServizioList(null, (ISearch)ricerca, null, true, false);
            if (env.findall_404 && lista.isEmpty()) {
                throw FaultCode.NOT_FOUND.toException("Nessuna fruizione presente nel registro");
            }
            ListaFruizioni ret = (ListaFruizioni)ListaUtils.costruisciListaPaginata((UriInfo)context.getUriInfo(), (Integer)ricerca.getIndexIniziale(idLista), (Integer)ricerca.getPageSize(idLista), (long)ricerca.getNumEntries(idLista), ListaFruizioni.class);
            lista.forEach(asps -> asps.getFruitoreList().forEach(fruitore -> {
                try {
                    IdSoggetto idFruitore = new IdSoggetto(env.soggettiCore.getIdSoggettoRegistro(fruitore.getIdSoggetto().longValue()));
                    idFruitore.setId(fruitore.getIdSoggetto());
                    ret.addItemsItem(ErogazioniApiHelper.fruizioneViewItemToFruizioneItem(ErogazioniApiHelper.aspsToFruizioneViewItem(env, asps, idFruitore)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaApiImplAllegati findAllFruizioneAllegati(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, String q, Integer limit, Integer offset) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            ListaApiImplAllegati ret = ErogazioniApiHelper.findAllAllegati(q, limit, offset, context.getUriInfo(), env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public FruizioneViewItem getFruizione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            FruizioneViewItem ret = ErogazioniApiHelper.aspsToFruizioneViewItem(env, asps, env.idSoggetto);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplVersioneApiView getFruizioneAPI(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            ApiImplVersioneApiView ret = ErogazioniApiHelper.aspsToApiImplVersioneApiView(env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplAllegato getFruizioneAllegato(String erogatore, String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Accordo servizio parte specifica");
            Optional<Long> idDoc = ErogazioniApiHelper.getIdDocumento(nomeAllegato, asps);
            if (!idDoc.isPresent()) {
                throw FaultCode.NOT_FOUND.toException("Allegato di nome " + nomeAllegato + " non presente.");
            }
            Documento doc = env.archiviCore.getDocumento(idDoc.get().longValue(), true);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ErogazioniApiHelper.documentoToImplAllegato(doc);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ConnettoreFruizione getFruizioneConnettore(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, String gruppo) {
        IContext context = this.getContext();
        try {
            IdServizio idAsps;
            IDPortaDelegata idPd;
            PortaDelegata pd;
            MappingFruizionePortaDelegata mapping;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            Connettore regConn = null;
            if (gruppo != null && !(mapping = env.pdCore.getMappingFruizionePortaDelegata(pd = env.pdCore.getPortaDelegata(idPd = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> FruizioniApiServiceImpl.lambda$getFruizioneConnettore$12(gruppo, env, idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId())), (String)"Gruppo per l'erogazione scelta")))).isDefault()) {
                long idServizioFruitoreInt;
                Fruitore servFru;
                List listaAzioniPDAssociataMappingNonDefault = pd.getAzione().getAzioneDelegataList();
                String azioneConnettore = null;
                if (listaAzioniPDAssociataMappingNonDefault != null && listaAzioniPDAssociataMappingNonDefault.size() > 0) {
                    azioneConnettore = (String)listaAzioniPDAssociataMappingNonDefault.get(0);
                }
                if ((servFru = env.apsCore.getServizioFruitore(idServizioFruitoreInt = env.apsCore.getServizioFruitore(IDServizioFactory.getInstance().getIDServizioFromAccordo(asps), env.idSoggetto.getId().longValue()))) == null) {
                    throw this.newNotFoundSoggettoFruitore(env);
                }
                Fruitore fruitore = (Fruitore)BaseHelper.findFirst((Iterable)asps.getFruitoreList(), f -> f.getTipo().equals(servFru.getTipo()) && f.getNome().equals(servFru.getNome())).orElseThrow(() -> FaultCode.RICHIESTA_NON_VALIDA.toException("Fruizione non presente nel registro."));
                if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                    for (ConfigurazioneServizioAzione check : fruitore.getConfigurazioneAzioneList()) {
                        if (!check.getAzioneList().contains(azioneConnettore)) continue;
                        regConn = check.getConnettore();
                    }
                }
            }
            if (regConn == null) {
                regConn = ErogazioniApiHelper.getConnettoreFruizione(asps, env.idSoggetto, env);
            }
            ConnettoreFruizione c = ConnettoreAPIHelper.buildConnettoreFruizione(regConn);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return c;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiDescrizione getFruizioneDescrizione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IDFruizione idFruizione = new IDFruizione();
            IDServizio idAps = new IDServizio();
            if (asps != null) {
                idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                idAps.setPortType(asps.getPortType());
            }
            idFruizione.setIdServizio(idAps);
            idFruizione.setIdFruitore(new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome()));
            Fruitore f = ErogazioniApiHelper.getFruitore(asps, env.idSoggetto.getNome());
            ApiDescrizione descr = new ApiDescrizione();
            descr.setDescrizione(f.getDescrizione());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return descr;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplInformazioniGeneraliView getFruizioneInformazioniGenerali(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            ApiImplInformazioniGeneraliView ret = ErogazioniApiHelper.fruizioneToApiImplInformazioniGeneraliView(env, asps, env.idSoggetto);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public FruizioneModI getFruizioneModI(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IDFruizione idFruizione = new IDFruizione();
            IDServizio idAps = new IDServizio();
            if (asps != null) {
                idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                idAps.setPortType(asps.getPortType());
            }
            idFruizione.setIdServizio(idAps);
            idFruizione.setIdFruitore(new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome()));
            Fruitore f = ErogazioniApiHelper.getFruitore(asps, env.idSoggetto.getNome());
            if (env.isProfiloModi()) {
                ErogazioniApiHelper.addInfoTokenPolicyForModI(f.getConnettore(), env, false);
            }
            FruizioneModI ret = ModiErogazioniApiHelper.getFruizioneModI(asps, env, profilo, ErogazioniApiHelper.getProtocolPropertiesMap(idFruizione, f, env));
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ApiImplUrlInvocazioneView getFruizioneUrlInvocazione(String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico aspc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            IDPortaDelegata idPorta = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getIDPortaDelegataAssociataDefault(env.idServizioFactory.getIDServizioFromAccordo(asps), env.idSoggetto.toIDSoggetto()), (String)"Porta Delegata");
            PortaDelegata pd = (PortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getPortaDelegata(idPorta), (String)"Porta Delegata");
            PortaDelegataAzione pdAzione = pd.getAzione();
            String urlInvocazione = ErogazioniApiHelper.getUrlInvocazioneFruizione(asps, env.idSoggetto.toIDSoggetto(), env);
            ApiImplUrlInvocazioneView ret = new ApiImplUrlInvocazioneView();
            Map azioni = env.paCore.getAzioniConLabel(asps, aspc, false, true, new ArrayList());
            ret.setAzioni(Arrays.asList(azioni.keySet().toArray(new String[azioni.size()])));
            ret.setForceInterface(Helper.statoFunzionalitaConfToBool(pdAzione.getForceInterfaceBased()));
            ret.setModalita(Enum.valueOf(ModalitaIdentificazioneAzioneEnum.class, pdAzione.getIdentificazione().name()));
            switch (ret.getModalita()) {
                case CONTENT_BASED: 
                case URL_BASED: {
                    ret.setPattern(pdAzione.getPattern());
                    break;
                }
                case HEADER_BASED: {
                    ret.setNome(pdAzione.getPattern());
                    break;
                }
                case INPUT_BASED: 
                case PROTOCOL_BASED: 
                case SOAP_ACTION_BASED: {
                    break;
                }
                case STATIC: 
                case INTERFACE_BASED: {
                    ret.setForceInterface(false);
                }
            }
            ret.setUrlInvocazione(urlInvocazione);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneAPI(ApiImplVersioneApi body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IdSoggetto idErogatore = new IdSoggetto(new IDSoggetto(env.tipo_soggetto, erogatore));
            Soggetto soggErogatore = (Soggetto)BaseHelper.supplyOrNotFound(() -> env.soggettiCore.getSoggettoRegistro(idErogatore.toIDSoggetto()), (String)"Soggetto Erogatore");
            idErogatore.setId(soggErogatore.getId());
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore.toIDSoggetto(), env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            AccordoServizioParteComuneSintetico as = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            List asParteComuneCompatibili = env.apsCore.findAccordiParteComuneBySoggettoAndNome(as.getNome(), new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome()));
            Optional newApc = BaseHelper.findFirst((Iterable)asParteComuneCompatibili, a -> a.getVersione() != null && body.getApiVersione() != null && a.getVersione().intValue() == body.getApiVersione().intValue());
            if (!newApc.isPresent()) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Nessuna api " + as.getNome() + " e versione " + body.getApiVersione() + " registrata");
            }
            asps.setAccordoServizioParteComune(env.idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)newApc.get()));
            asps.setIdAccordo(((AccordoServizioParteComune)newApc.get()).getId());
            asps.setOldIDServizioForUpdate(env.idServizioFactory.getIDServizioFromAccordo(asps));
            ErogazioniApiHelper.serviziUpdateCheckData(as, asps, false, env);
            List oggettiDaAggiornare = AccordiServizioParteSpecificaUtilities.getOggettiDaAggiornare((AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            env.apsCore.performUpdateOperation(env.userLogin, false, oggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneAllegato(ApiImplAllegato body, String erogatore, String nome, Integer versione, String nomeAllegato, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            ErogazioniApiHelper.updateAllegatoAsps(body, nomeAllegato, env, asps);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneConnettore(ConnettoreFruizione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio, String gruppo) {
        IContext context = this.getContext();
        try {
            PortaDelegata pd;
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getConnettore() instanceof ConnettoreMessageBox) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile associare a una fruizione il connettore di tipo message-box");
            }
            if (body.getConnettore() instanceof ConnettoreApplicativoServer) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Impossibile associare a una fruizione il connettore di tipo applicativo server");
            }
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            List fruitori = asps.getFruitoreList();
            long idServizioFruitoreInt = env.apsCore.getServizioFruitore(IDServizioFactory.getInstance().getIDServizioFromAccordo(asps), env.idSoggetto.getId().longValue());
            Fruitore servFru = env.apsCore.getServizioFruitore(idServizioFruitoreInt);
            if (servFru == null) {
                throw this.newNotFoundSoggettoFruitore(env);
            }
            Connettore connettore = null;
            IDPortaDelegata idPd = null;
            Fruitore fruitore = (Fruitore)BaseHelper.findAndRemoveFirst((Iterable)fruitori, f -> f.getTipo().equals(servFru.getTipo()) && f.getNome().equals(servFru.getNome()));
            IdServizio idAsps = new IdServizio(env.idServizioFactory.getIDServizioFromAccordo(asps), asps.getId());
            if (gruppo != null) {
                idPd = (IDPortaDelegata)BaseHelper.supplyOrNonValida(() -> ErogazioniApiHelper.getIDGruppoPD(gruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore), (String)"Gruppo per l'erogazione scelta");
                pd = env.pdCore.getPortaDelegata(idPd);
                MappingFruizionePortaDelegata mapping = env.pdCore.getMappingFruizionePortaDelegata(pd);
                if (!mapping.isDefault()) {
                    List listaAzioniPDAssociataMappingNonDefault = pd.getAzione().getAzioneDelegataList();
                    String azioneConnettore = null;
                    if (listaAzioniPDAssociataMappingNonDefault != null && listaAzioniPDAssociataMappingNonDefault.size() > 0) {
                        azioneConnettore = (String)listaAzioniPDAssociataMappingNonDefault.get(0);
                    }
                    if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                        for (ConfigurazioneServizioAzione check : fruitore.getConfigurazioneAzioneList()) {
                            if (!check.getAzioneList().contains(azioneConnettore)) continue;
                            connettore = check.getConnettore();
                        }
                    }
                }
            } else {
                idPd = env.pdCore.getIDPortaDelegataAssociataDefault((IDServizio)idAsps, env.idSoggetto.toIDSoggetto());
            }
            pd = env.pdCore.getPortaDelegata(idPd);
            if (gruppo != null) {
                if (connettore != null) {
                    oldConnT = connettore.getTipo();
                    if (connettore.getCustom() != null && connettore.getCustom().booleanValue() && !connettore.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connettore.getTipo().equals(TipiConnettore.FILE.toString()) && !connettore.getTipo().equals(TipiConnettore.STATUS.toString())) {
                        oldConnT = TipiConnettore.CUSTOM.toString();
                    }
                    ConnettoreAPIHelper.fillConnettoreRegistro(connettore, env, body.getConnettore(), oldConnT);
                    if (!ConnettoreAPIHelper.connettoreCheckData(body.getConnettore(), env, false)) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
                    }
                } else {
                    ConfigurazioneServizioAzione configurazioneAzione = new ConfigurazioneServizioAzione();
                    Connettore connettoreN = new Connettore();
                    String oldConnT = connettoreN.getTipo();
                    if (connettoreN.getCustom() != null && connettoreN.getCustom().booleanValue() && !connettoreN.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connettoreN.getTipo().equals(TipiConnettore.FILE.toString()) && !connettoreN.getTipo().equals(TipiConnettore.STATUS.toString())) {
                        oldConnT = TipiConnettore.CUSTOM.toString();
                    }
                    ConnettoreAPIHelper.fillConnettoreRegistro(connettoreN, env, body.getConnettore(), oldConnT);
                    if (!ConnettoreAPIHelper.connettoreCheckData(body.getConnettore(), env, false)) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
                    }
                    configurazioneAzione.setConnettore(connettoreN);
                    for (int i = 0; i < pd.getAzione().sizeAzioneDelegataList(); ++i) {
                        configurazioneAzione.addAzione(pd.getAzione().getAzioneDelegata(i));
                    }
                    fruitore.addConfigurazioneAzione(configurazioneAzione);
                }
            } else {
                connettore = fruitore.getConnettore();
                oldConnT = connettore.getTipo();
                if (connettore.getCustom() != null && connettore.getCustom().booleanValue() && !connettore.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connettore.getTipo().equals(TipiConnettore.FILE.toString()) && !connettore.getTipo().equals(TipiConnettore.STATUS.toString())) {
                    oldConnT = TipiConnettore.CUSTOM.toString();
                }
                ConnettoreAPIHelper.fillConnettoreRegistro(connettore, env, body.getConnettore(), oldConnT);
                if (!ConnettoreAPIHelper.connettoreCheckData(body.getConnettore(), env, false)) {
                    throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
                }
                fruitore.setConnettore(ConnettoreAPIHelper.buildConnettoreRegistro(env, body.getConnettore()));
            }
            fruitori.add(fruitore);
            env.apsCore.setDataAggiornamentoFruitore(fruitore);
            asps.setFruitoreList(fruitori);
            if (gruppo != null) {
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setNome(pd.getNome());
                UpdateProprietaOggetto uPO = new UpdateProprietaOggetto(idPD, env.userLogin);
                env.apsCore.performUpdateOperation(env.userLogin, false, new Object[]{asps, uPO});
            } else {
                env.apsCore.performUpdateOperation(env.userLogin, false, new Object[]{asps});
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneDescrizione(ApiDescrizione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IDServizio idAps = env.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue());
            IDFruizione idFruizione = new IDFruizione();
            idFruizione.setIdServizio(idAps);
            idFruizione.setIdFruitore(new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome()));
            long idServizioFruitoreInt = env.apsCore.getServizioFruitore(IDServizioFactory.getInstance().getIDServizioFromAccordo(asps), env.idSoggetto.getId().longValue());
            Fruitore servFru = env.apsCore.getServizioFruitore(idServizioFruitoreInt);
            if (servFru == null) {
                throw this.newNotFoundSoggettoFruitore(env);
            }
            Fruitore fruitore = (Fruitore)BaseHelper.findFirst((Iterable)asps.getFruitoreList(), f -> f.getTipo().equals(servFru.getTipo()) && f.getNome().equals(servFru.getNome())).orElseThrow(() -> FaultCode.RICHIESTA_NON_VALIDA.toException("Fruizione non presente nel registro."));
            fruitore.setDescrizione(body.getDescrizione());
            env.apsCore.setDataAggiornamentoFruitore(fruitore);
            IDServizio oldIDServizioForUpdate = env.idServizioFactory.getIDServizioFromAccordo(asps);
            asps.setOldIDServizioForUpdate(oldIDServizioForUpdate);
            List oggettiDaAggiornare = AccordiServizioParteSpecificaUtilities.getOggettiDaAggiornare((AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            env.apsCore.performUpdateOperation(env.userLogin, false, oggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneInformazioniGenerali(ApiImplInformazioniGenerali body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            ErogazioniApiHelper.updateInformazioniGenerali(body, env, asps, false);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneModI(FruizioneModI body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IDServizio idAps = env.idServizioFactory.getIDServizioFromValues(asps.getTipo(), asps.getNome(), new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()), asps.getVersione().intValue());
            IDFruizione idFruizione = new IDFruizione();
            idFruizione.setIdServizio(idAps);
            idFruizione.setIdFruitore(new IDSoggetto(env.idSoggetto.getTipo(), env.idSoggetto.getNome()));
            ProtocolProperties protocolProperties = null;
            if (profilo != null && (protocolProperties = ModiErogazioniApiHelper.updateModiProtocolProperties(asps, profilo, body.getModi(), env)) != null) {
                Fruitore f2 = ErogazioniApiHelper.getFruitore(asps, env.idSoggetto.getNome());
                f2.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)ConsoleOperationType.ADD, null));
            }
            asps.setOldIDServizioForUpdate(env.idServizioFactory.getIDServizioFromAccordo(asps));
            ErogazioniApiHelper.validateProperties(env, protocolProperties, idFruizione, ConsoleOperationType.CHANGE);
            long idServizioFruitoreInt = env.apsCore.getServizioFruitore(IDServizioFactory.getInstance().getIDServizioFromAccordo(asps), env.idSoggetto.getId().longValue());
            Fruitore servFru = env.apsCore.getServizioFruitore(idServizioFruitoreInt);
            if (servFru == null) {
                throw this.newNotFoundSoggettoFruitore(env);
            }
            Fruitore fruitore = (Fruitore)BaseHelper.findFirst((Iterable)asps.getFruitoreList(), f -> f.getTipo().equals(servFru.getTipo()) && f.getNome().equals(servFru.getNome())).orElseThrow(() -> FaultCode.RICHIESTA_NON_VALIDA.toException("Fruizione non presente nel registro."));
            env.apsCore.setDataAggiornamentoFruitore(fruitore);
            List oggettiDaAggiornare = AccordiServizioParteSpecificaUtilities.getOggettiDaAggiornare((AccordoServizioParteSpecifica)asps, (AccordiServizioParteSpecificaCore)env.apsCore);
            env.apsCore.performUpdateOperation(env.userLogin, false, oggettiDaAggiornare.toArray());
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public void updateFruizioneUrlInvocazione(ApiImplUrlInvocazione body, String erogatore, String nome, Integer versione, ProfiloEnum profilo, String soggetto, String tipoServizio) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            if (body.getModalita() == null) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Specificare una modalit\u00e0 di identificazione azione valida");
            }
            ErogazioniEnv env = new ErogazioniEnv(context.getServletRequest(), profilo, soggetto, context);
            IDSoggetto idErogatore = new IDSoggetto(env.tipo_soggetto, erogatore);
            AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)BaseHelper.supplyOrNotFound(() -> ErogazioniApiHelper.getServizioIfFruizione(tipoServizio, nome, versione, idErogatore, env.idSoggetto.toIDSoggetto(), env), (String)"Fruizione");
            IDServizio idServizio = env.idServizioFactory.getIDServizioFromAccordo(asps);
            IDPortaDelegata idPorta = (IDPortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getIDPortaDelegataAssociataDefault(env.idServizioFactory.getIDServizioFromAccordo(asps), env.idSoggetto.toIDSoggetto()), (String)"Porta Delegata");
            PortaDelegata pd = (PortaDelegata)BaseHelper.supplyOrNotFound(() -> env.pdCore.getPortaDelegata(idPorta), (String)"Porta Delegata");
            PortaDelegataAzione pdAzione = new PortaDelegataAzione();
            AccordoServizioParteComuneSintetico apc = env.apcCore.getAccordoServizioSintetico(asps.getIdAccordo().longValue());
            List identModes = env.pdHelper.getModalitaIdentificazionePorta(env.tipo_protocollo, env.apcCore.toMessageServiceBinding(apc.getServiceBinding()), ConsoleInterfaceType.AVANZATA);
            if (!identModes.contains(PortaDelegataAzioneIdentificazione.STATIC)) {
                identModes.add(PortaDelegataAzioneIdentificazione.STATIC);
            }
            if (!identModes.contains(PortaDelegataAzioneIdentificazione.valueOf((String)body.getModalita().name()))) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione deve essere una fra: " + identModes.toString());
            }
            boolean setPattern = true;
            long idAzione = -1L;
            switch (body.getModalita()) {
                case CONTENT_BASED: {
                    if (body.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'pattern'");
                    }
                    pdAzione.setPattern(body.getPattern());
                    pdAzione.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case HEADER_BASED: {
                    if (body.getNome() == null && body.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'nome'");
                    }
                    if (body.getNome() != null && body.getPattern() != null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito solo il parametro 'nome'");
                    }
                    if (body.getNome() != null) {
                        pdAzione.setPattern(body.getNome());
                    } else {
                        pdAzione.setPattern(body.getPattern());
                    }
                    setPattern = true;
                    pdAzione.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case INPUT_BASED: {
                    pdAzione.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case INTERFACE_BASED: {
                    break;
                }
                case SOAP_ACTION_BASED: {
                    if (!ServiceBinding.SOAP.equals((Object)apc.getServiceBinding())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") non \u00e8 permessa per API di tipo " + String.valueOf(apc.getServiceBinding()));
                    }
                    pdAzione.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case URL_BASED: {
                    if (!ServiceBinding.SOAP.equals((Object)apc.getServiceBinding())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") non \u00e8 permessa per API di tipo " + String.valueOf(apc.getServiceBinding()));
                    }
                    if (body.getPattern() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'pattern'");
                    }
                    pdAzione.setPattern(body.getPattern());
                    pdAzione.setForceInterfaceBased(Helper.boolToStatoFunzionalitaConf(body.isForceInterface()));
                    break;
                }
                case PROTOCOL_BASED: {
                    break;
                }
                case STATIC: {
                    if (!ServiceBinding.SOAP.equals((Object)apc.getServiceBinding())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") non \u00e8 permessa per API di tipo " + String.valueOf(apc.getServiceBinding()));
                    }
                    PortTypeSintetico pt = null;
                    for (PortTypeSintetico ptCheck : apc.getPortType()) {
                        if (!ptCheck.getNome().equals(asps.getPortType())) continue;
                        pt = ptCheck;
                        break;
                    }
                    if (pt == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") \u00e8 permessa solamente per API di tipo SOAP che definiscono 1 sola operazione: port-type non trovato");
                    }
                    if (pt.getAzione() == null || pt.getAzione().size() <= 0) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") \u00e8 permessa solamente per API di tipo SOAP che definiscono 1 sola operazione: non sono state trovate azioni");
                    }
                    if (pt.getAzione().size() > 1) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") \u00e8 permessa solamente per API di tipo SOAP che definiscono 1 sola operazione: sono state trovate " + pt.getAzione().size() + " azioni");
                    }
                    if (body.getNome() == null) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") richiede che sia definito il parametro 'nome'");
                    }
                    boolean findAzione = false;
                    for (OperationSintetica op : pt.getAzione()) {
                        if (!op.getNome().equals(body.getNome())) continue;
                        findAzione = true;
                        idAzione = op.getId();
                        break;
                    }
                    if (!findAzione) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("La modalit\u00e0 di identificazione azione indicata (" + body.getModalita().toString() + ") riferisce una azione '" + body.getNome() + "' non esistente");
                    }
                    pdAzione.setNome(body.getNome());
                    setPattern = false;
                }
            }
            pdAzione.setIdentificazione(Enum.valueOf(PortaDelegataAzioneIdentificazione.class, body.getModalita().name()));
            ErogazioniApiHelper.overrideFruizioneUrlInvocazione(env.requestWrapper, idErogatore, idServizio, pd, pdAzione, setPattern, idAzione);
            org.openspcoop2.message.constants.ServiceBinding serviceBinding = org.openspcoop2.message.constants.ServiceBinding.valueOf((String)apc.getServiceBinding().name());
            if (!env.pdHelper.porteDelegateCheckData(TipoOperazione.CHANGE, pd.getNome(), false, serviceBinding)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException(env.pd.getMessage());
            }
            pd.setAzione(pdAzione);
            pd.setOldIDPortaDelegataForUpdate(idPorta);
            env.pdCore.performUpdateOperation(env.userLogin, false, new Object[]{pd});
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    private static /* synthetic */ IDPortaDelegata lambda$getFruizioneConnettore$12(String gruppo, ErogazioniEnv env, IdServizio idAsps) throws Exception {
        return ErogazioniApiHelper.getIDGruppoPD(gruppo, env.idSoggetto.toIDSoggetto(), idAsps, env.apsCore);
    }
}

