/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.AbstractConnettoreApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.erogazioni.ErogazioniEnv;
import org.openspcoop2.core.config.rs.server.model.ConnettoreEnum;
import org.openspcoop2.core.config.rs.server.model.ConnettoreStatus;
import org.openspcoop2.core.config.rs.server.model.ConnettoreStatusVerificaStatistica;
import org.openspcoop2.core.config.rs.server.model.OneOfApplicativoServerConnettore;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreErogazioneConnettore;
import org.openspcoop2.core.config.rs.server.model.OneOfConnettoreFruizioneConnettore;
import org.openspcoop2.core.config.rs.server.model.TipoPeriodoStatisticoEnum;
import org.openspcoop2.core.config.rs.server.model.TipoRispostaStatusEnum;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreStatusParams;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class ConnettoreStatusApiHelper
extends AbstractConnettoreApiHelper<ConnettoreStatus> {
    @Override
    protected boolean connettoreCheckData(ConnettoreStatus conn, ErogazioniEnv env, boolean erogazione) throws Exception {
        return !ConnettoreStatusParams.check((ConsoleHelper)env.apsHelper, null, null).getParsingErrors();
    }

    @Override
    public org.openspcoop2.core.registry.Connettore fillConnettoreRegistro(org.openspcoop2.core.registry.Connettore regConnettore, ErogazioniEnv env, ConnettoreStatus conn, String oldConnT) throws Exception {
        ConnettoreStatusParams params = new ConnettoreStatusParams().statusResponseType(conn.getRisposta().toString()).testConnectivity(conn.isVerificaConnettivita()).testStatistics(Boolean.valueOf(false));
        if (conn.getVerificaStatistica() != null) {
            params.testStatistics(Boolean.valueOf(true));
            params.periodValue(conn.getVerificaStatistica().getIntervallo());
            params.period(conn.getVerificaStatistica().getFrequenza().toString());
            params.statLifetime(conn.getVerificaStatistica().getCacheLifeTime());
        }
        env.apsHelper.fillConnettore(regConnettore, conn.isDebug() == Boolean.TRUE ? "true" : "false", TipiConnettore.STATUS.getNome(), oldConnT, "", null, null, null, null, null, null, null, null, null, null, null, null, false, true, null, null, null, null, false, null, "", null, null, null, null, null, null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, "no", "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, params, null);
        return regConnettore;
    }

    @Override
    public Connettore buildConnettoreConfigurazione(Connettore regConnettore, ErogazioniEnv env, ConnettoreStatus conn, String oldConnType) throws Exception {
        ConnettoreStatusParams params = new ConnettoreStatusParams().statusResponseType(conn.getRisposta().toString()).testConnectivity(conn.isVerificaConnettivita()).testStatistics(Boolean.valueOf(false));
        if (conn.getVerificaStatistica() != null) {
            params.testStatistics(Boolean.valueOf(true));
            params.periodValue(conn.getVerificaStatistica().getIntervallo());
            params.period(conn.getVerificaStatistica().getFrequenza().toString());
            params.statLifetime(conn.getVerificaStatistica().getCacheLifeTime());
        }
        env.apsHelper.fillConnettore(regConnettore, conn.isDebug() == Boolean.TRUE ? "true" : "false", TipiConnettore.STATUS.getNome(), oldConnType, "", null, null, null, null, null, null, null, null, null, null, null, null, false, true, null, null, null, null, false, null, "", null, null, null, null, null, null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, null, ServletUtils.boolToCheckBoxStatus((Boolean)false), null, null, null, "no", "", "", "", "", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, params, null);
        return regConnettore;
    }

    @Override
    public ConnettoreStatus buildConnettore(Map<String, String> props, String tipo) {
        String verificaConnettivita = props.get("testConnectivity");
        String statusResponseType = props.get("statusResponseType");
        String period = props.get("period");
        String periodValue = props.get("periodValue");
        String cacheLifetime = props.get("statLifetime");
        String debug = props.get("debug");
        ConnettoreStatusVerificaStatistica verificaStatistica = null;
        if (period != null) {
            verificaStatistica = new ConnettoreStatusVerificaStatistica().intervallo(Integer.valueOf(periodValue)).frequenza(TipoPeriodoStatisticoEnum.fromValue(period)).cacheLifeTime(cacheLifetime == null ? null : Integer.valueOf(cacheLifetime));
        }
        return new ConnettoreStatus().tipo(ConnettoreEnum.STATUS).risposta(TipoRispostaStatusEnum.fromValue(statusResponseType)).debug(((Serializable)Objects.requireNonNullElse(debug, Boolean.FALSE)).equals(Boolean.TRUE)).verificaConnettivita(((Serializable)Objects.requireNonNullElse(verificaConnettivita, Boolean.FALSE)).equals(Boolean.TRUE)).verificaStatistica(verificaStatistica);
    }

    @Override
    public String getUrlConnettore(Map<String, String> props, String tipoConnettore) throws Exception {
        return "[status] govway://status";
    }

    @Override
    protected ConnettoreStatus getConnettore(OneOfConnettoreErogazioneConnettore conn) throws Exception {
        return (ConnettoreStatus)conn;
    }

    @Override
    protected ConnettoreStatus getConnettore(OneOfConnettoreFruizioneConnettore conn) throws Exception {
        return (ConnettoreStatus)conn;
    }

    @Override
    protected ConnettoreStatus getConnettore(OneOfApplicativoServerConnettore conn) throws Exception {
        return (ConnettoreStatus)conn;
    }
}

