/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.utils;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.IProvider;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.certificate.ocsp.OCSPProvider;

public abstract class AbstractSecurityProvider
implements IProvider {
    private boolean asTruststore = false;
    private OCSPProvider ocspProvider = new OCSPProvider();
    private BYOKProvider byokProvider;

    public boolean isAsTruststore() {
        return this.asTruststore;
    }

    public void useAsKeystore() {
        this.asTruststore = false;
    }

    public void useAsTruststore() {
        this.asTruststore = true;
    }

    protected AbstractSecurityProvider() {
        try {
            this.byokProvider = BYOKProvider.getUnwrapInstance();
        }
        catch (Exception e) {
            throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
    }

    public List<String> getValues(String id) throws ProviderException {
        List l = null;
        if ("keystoreType".equals(id)) {
            l = SecurityConstants.getTipologieKeystoreValues(this.asTruststore);
        } else if ("secretkeystoreType".equals(id)) {
            l = SecurityConstants.getTipologieSecretKeystoreValues();
        } else if ("truststoreType".equals(id)) {
            l = SecurityConstants.getTipologieKeystoreValues(true);
        } else if ("truststoreOcspPolicy".equals(id) || "keystoreOcspPolicy".equals(id)) {
            l = this.ocspProvider.getValues();
        } else if ("keystoreByokPolicy".equals(id) || "secretkeystoreByokPolicy".equals(id)) {
            l = this.byokProvider.getValues();
        }
        return l;
    }

    public List<String> getLabels(String id) throws ProviderException {
        List<Object> l = null;
        l = "keystoreType".equals(id) ? SecurityConstants.getTipologieKeystoreLabels(this.asTruststore) : ("secretkeystoreType".equals(id) ? SecurityConstants.getTipologieSecretKeystoreLabels() : ("truststoreType".equals(id) ? SecurityConstants.getTipologieKeystoreLabels(true) : ("truststoreOcspPolicy".equals(id) || "keystoreOcspPolicy".equals(id) ? this.ocspProvider.getLabels() : ("keystoreByokPolicy".equals(id) || "secretkeystoreByokPolicy".equals(id) ? this.byokProvider.getLabels() : this.getValues(id)))));
        return l;
    }

    public String getDefault(String id) throws ProviderException {
        return null;
    }

    public String dynamicUpdate(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if ("keystoreFile".equals(item.getName()) || "secretkeystoreFile".equals(item.getName()) || "truststoreFile".equals(item.getName())) {
            return this.dynamicUpdateStoreFile(items, mapNameValue, item, actualValue);
        }
        if ("keystorePassword".equals(item.getName()) || "secretkeystorePassword".equals(item.getName()) || "truststorePassword".equals(item.getName())) {
            return this.dynamicUpdateStorePassword(items, mapNameValue, item, actualValue);
        }
        if ("keystorePrivateKeyPassword".equals(item.getName()) || "secretkeystorePrivateKeyPassword".equals(item.getName())) {
            return this.dynamicUpdateStoreKeyPassword(items, mapNameValue, item, actualValue);
        }
        if ("truststoreOcspPolicy".equals(item.getName()) || "keystoreOcspPolicy".equals(item.getName())) {
            if (!this.ocspProvider.isOcspEnabled()) {
                item.setValue("");
                item.setType(ItemType.HIDDEN);
            }
        } else if ("keystoreByokPolicy".equals(item.getName()) || "secretkeystoreByokPolicy".equals(item.getName())) {
            return this.dynamicUpdateByok(items, mapNameValue, item, actualValue);
        }
        return actualValue;
    }

    private String dynamicUpdateStoreFile(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "keystoreType";
        if ("secretkeystoreFile".equals(item.getName())) {
            type = "secretkeystoreType";
        } else if ("truststoreFile".equals(item.getName())) {
            type = "truststoreType";
        }
        return AbstractSecurityProvider.processStoreFile(type, items, mapNameValue, item, actualValue);
    }

    private String dynamicUpdateStorePassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = "keystoreType";
        boolean keystore = true;
        if ("secretkeystorePassword".equals(item.getName())) {
            type = "secretkeystoreType";
        } else if ("truststorePassword".equals(item.getName())) {
            type = "truststoreType";
            keystore = false;
        }
        return AbstractSecurityProvider.processStorePassword(keystore, type, items, mapNameValue, item, actualValue);
    }

    private String dynamicUpdateStoreKeyPassword(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (!HSMUtils.isHsmConfigurableKeyPassword()) {
            String type = "keystoreType";
            if ("secretkeystorePrivateKeyPassword".equals(item.getName())) {
                type = "secretkeystoreType";
            }
            return AbstractSecurityProvider.processStoreKeyPassword(type, items, mapNameValue, item, actualValue);
        }
        return actualValue;
    }

    private String dynamicUpdateByok(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (!this.byokProvider.isByokEnabled()) {
            item.setValue("");
            item.setType(ItemType.HIDDEN);
            return actualValue;
        }
        return this.dynamicUpdateByokPolicy(items, mapNameValue, item, actualValue);
    }

    private String dynamicUpdateByokPolicy(List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        String type = null;
        if ("secretkeystoreByokPolicy".equals(item.getName())) {
            type = "secretkeystoreType";
        } else if ("keystoreByokPolicy".equals(item.getName())) {
            type = "keystoreType";
        }
        return AbstractSecurityProvider.processStoreByokPolicy(type, items, mapNameValue, item, actualValue);
    }

    public static String readValue(String identificativo, List<?> items, Map<String, String> mapNameValue) {
        String value = null;
        if (items != null && !items.isEmpty()) {
            for (Object itemCheck : items) {
                Item listItem;
                if (!(itemCheck instanceof Item) || !identificativo.equals((listItem = (Item)itemCheck).getName())) continue;
                value = mapNameValue.get(identificativo);
                break;
            }
        }
        return value;
    }

    public static String processStoreFile(String type, List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (items != null && !items.isEmpty()) {
            for (Object itemCheck : items) {
                if (!(itemCheck instanceof Item)) continue;
                Item listItem = (Item)itemCheck;
                boolean find = false;
                String value = null;
                if (type.equals(listItem.getName())) {
                    find = true;
                    value = mapNameValue.get(type);
                }
                if (!find) continue;
                return AbstractSecurityProvider.processStoreFile(value, item, actualValue);
            }
        }
        return actualValue;
    }

    private static String processStoreFile(String value, Item item, String actualValue) {
        if (value != null && HSMUtils.isKeystoreHSM((String)value)) {
            item.setValue("HSM-" + value);
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        item.setValue(actualValue);
        item.setType(ItemType.TEXTAREA);
        return item.getValue();
    }

    public static String processStorePassword(boolean keystore, String type, List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (items != null && !items.isEmpty()) {
            for (Object itemCheck : items) {
                if (!(itemCheck instanceof Item)) continue;
                Item listItem = (Item)itemCheck;
                boolean find = false;
                String value = null;
                if (type.equals(listItem.getName())) {
                    find = true;
                    value = mapNameValue.get(type);
                }
                if (!find) continue;
                AbstractSecurityProvider.processStorePasswordRequired(keystore, value, item);
                return AbstractSecurityProvider.processStorePassword(value, item, actualValue);
            }
        }
        return actualValue;
    }

    private static String processStorePassword(String value, Item item, String actualValue) {
        if (value != null && HSMUtils.isKeystoreHSM((String)value)) {
            item.setValue("-");
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        item.setValue(actualValue);
        item.setType(ItemType.LOCK);
        return item.getValue();
    }

    private static void processStorePasswordRequired(boolean keystore, String value, Item item) {
        if (KeystoreType.JKS.isType(value)) {
            item.setRequired(keystore ? DBUtils.isKeystoreJksPasswordRequired() : DBUtils.isTruststoreJksPasswordRequired());
        } else if (KeystoreType.PKCS12.isType(value)) {
            item.setRequired(keystore ? DBUtils.isKeystorePkcs12PasswordRequired() : DBUtils.isTruststorePkcs12PasswordRequired());
        }
    }

    public static String processStoreKeyPassword(String type, List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (items != null && !items.isEmpty()) {
            for (Object itemCheck : items) {
                if (!(itemCheck instanceof Item)) continue;
                Item listItem = (Item)itemCheck;
                boolean find = false;
                String value = null;
                if (type.equals(listItem.getName())) {
                    find = true;
                    value = mapNameValue.get(type);
                }
                if (!find) continue;
                AbstractSecurityProvider.processStoreKeyPasswordRequired(value, item);
                return AbstractSecurityProvider.processStoreKeyPassword(value, item, actualValue);
            }
        }
        return actualValue;
    }

    private static String processStoreKeyPassword(String value, Item item, String actualValue) {
        if (value != null && HSMUtils.isKeystoreHSM((String)value)) {
            item.setValue("-");
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        item.setValue(actualValue);
        item.setType(ItemType.LOCK);
        return item.getValue();
    }

    private static void processStoreKeyPasswordRequired(String value, Item item) {
        if (KeystoreType.JKS.isType(value)) {
            item.setRequired(DBUtils.isKeystoreJksKeyPasswordRequired());
        } else if (KeystoreType.PKCS12.isType(value)) {
            item.setRequired(DBUtils.isKeystorePkcs12PasswordRequired());
        }
    }

    public static String processStoreByokPolicy(String type, List<?> items, Map<String, String> mapNameValue, Item item, String actualValue) {
        if (items != null && !items.isEmpty()) {
            for (Object itemCheck : items) {
                if (!(itemCheck instanceof Item)) continue;
                Item listItem = (Item)itemCheck;
                boolean find = false;
                String value = null;
                if (type.equals(listItem.getName())) {
                    find = true;
                    value = mapNameValue.get(type);
                }
                if (!find) continue;
                return AbstractSecurityProvider.processStoreByokPolicy(value, item, actualValue);
            }
        }
        return actualValue;
    }

    private static String processStoreByokPolicy(String value, Item item, String actualValue) {
        if (value != null && HSMUtils.isKeystoreHSM((String)value)) {
            item.setValue("-");
            item.setType(ItemType.HIDDEN);
            return item.getValue();
        }
        item.setValue(actualValue);
        item.setType(ItemType.SELECT);
        return item.getValue();
    }
}

