/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import java.util.List;
import java.util.Map;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.Utilities;

public class WSSUtilities {
    public static List<Reference> getDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2SoapMessage message) throws SecurityException {
        try {
            boolean mustUnderstandValue = false;
            Object mustUnderstand = messageSecurityContext.getIncomingProperties().get("mustUnderstand");
            if (mustUnderstand != null) {
                if (mustUnderstand instanceof String) {
                    mustUnderstandValue = Boolean.parseBoolean((String)mustUnderstand);
                } else if (mustUnderstand instanceof Boolean) {
                    mustUnderstandValue = (Boolean)mustUnderstand;
                } else {
                    throw new SecurityException("Unexected type '" + mustUnderstand.getClass().getName() + "' for property 'mustUnderstand'");
                }
            }
            String actor = messageSecurityContext.getActor();
            if ("".equals(messageSecurityContext.getActor())) {
                actor = null;
            }
            List references = message.getWSSDirtyElements(actor, mustUnderstandValue);
            messageSecurityContext.setReferences(references);
            return references;
        }
        catch (Exception e) {
            SecurityException sec = new SecurityException(e.getMessage(), e);
            if (Utilities.existsInnerMessageException((Throwable)e, (String)"[WSS-Signature ReferencesSearch]", (boolean)true)) {
                sec.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
            } else if (Utilities.existsInnerMessageException((Throwable)e, (String)"[WSS-Encrypt ReferencesSearch]", (boolean)true)) {
                sec.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
            }
            throw sec;
        }
    }

    public static void cleanDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2SoapMessage message, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws SecurityException {
        try {
            boolean mustUnderstandValue = false;
            Object mustUnderstand = messageSecurityContext.getIncomingProperties().get("mustUnderstand");
            if (mustUnderstand != null) {
                if (mustUnderstand instanceof String) {
                    mustUnderstandValue = Boolean.parseBoolean((String)mustUnderstand);
                } else if (mustUnderstand instanceof Boolean) {
                    mustUnderstandValue = (Boolean)mustUnderstand;
                } else {
                    throw new SecurityException("Unexected type '" + mustUnderstand.getClass().getName() + "' for property 'mustUnderstand'");
                }
            }
            String actor = messageSecurityContext.getActor();
            if ("".equals(messageSecurityContext.getActor())) {
                actor = null;
            }
            message.cleanWSSDirtyElements(actor, mustUnderstandValue, elementsToClean, detachHeaderWSSecurity, removeAllIdRef);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public static boolean isNormalizeToSaajImpl(MessageSecurityContext wssContext) {
        if (wssContext == null) {
            return false;
        }
        Map<String, Object> wssProperties = null;
        wssProperties = wssContext.isFunctionAsClient() ? wssContext.getOutgoingProperties() : wssContext.getIncomingProperties();
        if (wssProperties != null && wssProperties.containsKey("normalizeToSaajImpl")) {
            return Boolean.parseBoolean((String)wssProperties.get("normalizeToSaajImpl"));
        }
        if (wssProperties != null && wssProperties.containsKey("action")) {
            String action = (String)wssProperties.get("action");
            if (action.contains("Signature") || action.contains("SAMLTokenUnsigned") || action.contains("SAMLTokenSigned") || action.contains("UsernameTokenSignature") || action.contains("SignatureDerived") || action.contains("SignatureWithKerberosToken")) {
                return true;
            }
            if (!wssContext.isFunctionAsClient() && (SecurityConstants.containsActionEncryption(action) || SecurityConstants.containsActionDecryption(action)) && wssProperties.containsKey("encryptionParts")) {
                String attach = "{Attach}";
                String attachAll = attach + "{*}";
                String encryptParts = (String)wssProperties.get("encryptionParts");
                if (encryptParts != null && encryptParts.contains(attach) && !encryptParts.contains(attachAll)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

