/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.constants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.CostantiLabel;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;

public class SecurityConstants {
    public static final String ACTION = "action";
    public static final String TIPO_SECURITY_ENGINE_SEPARATOR = " ";
    public static final String TIPO_SECURITY_ACTION_SEPARATOR = ",";
    public static final String SECURITY_ENGINE = "securityEngine";
    public static final String SECURITY_ENGINE_WSS4J = "wss4j";
    public static final String SECURITY_ENGINE_DSS = "dss";
    public static final String SECURITY_ENGINE_JOSE = "jose";
    public static final String SECURITY_ENGINE_XML = "xml";
    public static final String NORMALIZE_TO_SAAJ_IMPL = "normalizeToSaajImpl";
    public static final String WSS_HEADER_ELEMENT = "Security";
    public static final String WSS_HEADER_ELEMENT_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSS_HEADER_UTILITY_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final QName QNAME_WSS_ELEMENT_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    public static final String WSS_HEADER_ATTRIBUTE_REFERENCE_ID_WSSECURITY = "Id";
    public static final String WSS_HEADER_DS_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String WSS_HEADER_DS_REFERENCE_ELEMENT = "Reference";
    public static final String WSS_HEADER_DS_REFERENCE_ATTRIBUTE_URI = "URI";
    public static final String WSS_HEADER_DS_REFERENCE_DIGEST_VALUE_ELEMENT = "DigestValue";
    public static final String ACTOR = "actor";
    public static final String MUST_UNDERSTAND = "mustUnderstand";
    public static final boolean SECURITY_CLIENT = true;
    public static final boolean SECURITY_SERVER = false;
    public static final String USER = "user";
    public static final String CID_ATTACH_WSS4J = "cid:Attachments";
    public static final String NAMESPACE_ATTACH = "Attach";
    public static final String PART_CONTENT = "Content";
    public static final String PART_COMPLETE = "Complete";
    public static final String PART_ELEMENT = "Element";
    public static final String ATTACHMENT_INDEX_ALL = "*";
    public static final String SOAP_NAMESPACE_TEMPLATE = "SOAP_TEMPLATE_NS";
    public static final String SUFFIX_SSL = ".ssl";
    public static final String SUFFIX_ALGORITHM = ".algorithm";
    public static final String SUFFIX_PUBLIC_KEY = ".public";
    public static final String SUFFIX_CRL = ".crl";
    public static final String SUFFIX_OCSP = ".ocsp";
    public static final String SUFFIX_BYOK = ".byok";
    public static final String MODE_JSON = "json";
    public static final String MODE_COMPACT = "compact";
    public static final String MULTI_USER_KEYWORD_PORTA_DOMINIO_FRUITORE = "#MultiPropUsePddFruitoreAsAlias#";
    public static final String MULTI_USER_KEYWORD_PORTA_DOMINIO_EROGATORE = "#MultiPropUsePddErogatoreAsAlias#";
    public static final String MULTI_USER_KEYWORD_IDENTIFICATIVO_PORTA_FRUITORE = "#MultiPropUseIdentificativoPortaFruitoreAsAlias#";
    public static final String MULTI_USER_KEYWORD_IDENTIFICATIVO_PORTA_EROGATORE = "#MultiPropUseIdentificativoPortaErogatoreAsAlias#";
    public static final String MULTI_USER_KEYWORD_FRUITORE = "#MultiPropUseFruitoreAsAlias#";
    public static final String MULTI_USER_KEYWORD_EROGATORE = "#MultiPropUseErogatoreAsAlias#";
    public static final String MULTI_USER_KEYWORD_FRUITORE_EROGATORE = "#MultiPropUseFruitoreErogatoreAsAlias#";
    public static final String PASSWORD_CALLBACK_CLASS = "passwordCallbackClass";
    public static final String PASSWORD_CALLBACK_REF = "passwordCallbackRef";
    public static final String SYMMETRIC_KEY = "symmetricKey";
    public static final String SYMMETRIC_KEY_TRUE = "true";
    public static final String SYMMETRIC_KEY_FALSE = "false";
    public static final String ENABLE_REVOCATION = "enableRevocation";
    public static final String ENCRYPTION_ACTION = "Encryption";
    public static final String ENCRYPT_ACTION_OLD = "Encrypt";
    public static final String DECRYPTION_ACTION = "Decryption";
    public static final String DECRYPT_ACTION_OLD = "Decrypt";
    public static final String ENCRYPTION_USER = "encryptionUser";
    public static final String ENCRYPTION_PASSWORD = "encryptionPassword";
    public static final String ENCRYPTION_SOAP_FAULT = "encryptionSOAPFault";
    public static final String ENCRYPTION_PROBLEM_DETAILS = "encryptionProblemDetails";
    public static final String ENCRYPTION_PARTS = "encryptionParts";
    public static final String ENCRYPTION_PARTS_VERIFY = "encryptionPartsVerify";
    public static final String ENCRYPTION_NAMESPACE_ATTACH = "Attach";
    public static final String ENCRYPTION_PART_CONTENT = "Content";
    public static final String ENCRYPTION_PART_COMPLETE = "Complete";
    public static final String ENCRYPTION_PART_ELEMENT = "Element";
    public static final String ENCRYPTION_JWK_SET_FILE = "encryptionJWKSetFile";
    public static final String ENCRYPTION_PROPERTY_REF_ID = "encryptionPropRefId";
    public static final String ENCRYPTION_PROPERTY_FILE = "encryptionPropFile";
    public static final String ENCRYPTION_TRUSTSTORE_PROPERTY_FILE = "encryptionTrustStorePropFile";
    public static final String ENCRYPTION_TRUSTSTORE_PROPERTY_REF_ID = "encryptionTrustStorePropRefId";
    public static final String ENCRYPTION_MULTI_PROPERTY_FILE = "encryptionMultiPropFile";
    public static final String ENCRYPTION_SYMMETRIC_KEY_VALUE = "encryptionSymmetricKeyValue";
    public static final String ENCRYPTION_SYMMETRIC = "encryptionSymmetricKey";
    public static final String ENCRYPTION_SYMMETRIC_WRAPPED = "encryptionSymmetricKeyWrapped";
    public static final String ENCRYPTION_SYMMETRIC_WRAPPED_TRUE = "true";
    public static final String ENCRYPTION_SYMMETRIC_WRAPPED_FALSE = "false";
    public static final String ENCRYPTION_KEY_SIZE = "encryptionKeySize";
    public static final String ENCRYPTION_KEY_TRANSPORT_ALGORITHM = "encryptionKeyTransportAlgorithm";
    public static final String ENCRYPTION_SYMMETRIC_ALGORITHM = "encryptionSymAlgorithm";
    public static final String ENCRYPTION_DIGEST_ALGORITHM = "encryptionDigestAlgorithm";
    public static final String ENCRYPTION_C14N_ALGORITHM = "encryptionC14nAlgorithm";
    public static final String ENCRYPTION_KEY_ALGORITHM = "encryptionKeyAlgorithm";
    public static final String ENCRYPTION_CONTENT_ALGORITHM = "encryptionContentAlgorithm";
    public static final String ENCRYPTION_ALGORITHM = "encryptionAlgorithm";
    public static final String ENCRYPTION_KEY_IDENTIFIER = "encryptionKeyIdentifier";
    public static final String ENCRYPTION_MODE = "encryptionMode";
    public static final String ENCRYPTION_MODE_JSON = "json";
    public static final String ENCRYPTION_MODE_COMPACT = "compact";
    public static final String ENCRYPTION_DEFLATE = "deflate";
    public static final String ENCRYPTION_DEFLATE_TRUE = "true";
    public static final String ENCRYPTION_DEFLATE_FALSE = "false";
    public static final String DECRYPTION_JWK_SET_FILE = "decryptionJWKSetFile";
    public static final String DECRYPTION_PROPERTY_FILE = "decryptionPropFile";
    public static final String DECRYPTION_PROPERTY_REF_ID = "decryptionPropRefId";
    public static final String DECRYPTION_TRUSTSTORE_PROPERTY_FILE = "decryptionTrustStorePropFile";
    public static final String DECRYPTION_TRUSTSTORE_PROPERTY_REF_ID = "decryptionTrustStorePropRefId";
    public static final String DECRYPTION_MULTI_PROPERTY_FILE = "decryptionMultiPropFile";
    public static final String DECRYPTION_SYMMETRIC_KEY_VALUE = "decryptionSymmetricKeyValue";
    public static final String DECRYPTION_SYMMETRIC_ALGORITHM = "decryptionSymAlgorithm";
    public static final String DECRYPTION_USER = "decryptionUser";
    public static final String DECRYPTION_PASSWORD = "decryptionPassword";
    public static final String DECRYPTION_SYMMETRIC = "decryptionSymmetricKey";
    public static final String DECRYPTION_SYMMETRIC_WRAPPED = "decryptionSymmetricKeyWrapped";
    public static final String DECRYPTION_SYMMETRIC_WRAPPED_TRUE = "true";
    public static final String DECRYPTION_SYMMETRIC_WRAPPED_FALSE = "false";
    public static final String DECRYPTION_MODE = "decryptionMode";
    public static final String DECRYPTION_MODE_JSON = "json";
    public static final String DECRYPTION_MODE_COMPACT = "compact";
    public static final String SIGNATURE_ACTION = "Signature";
    public static final String SIGNATURE_USER = "signatureUser";
    public static final String SIGNATURE_PASSWORD = "signaturePassword";
    public static final String USE_REQ_SIG_CERT = "useReqSigCert";
    public static final String SIGNATURE_SOAP_FAULT = "signatureSOAPFault";
    public static final String SIGNATURE_PROBLEM_DETAILS = "signatureProblemDetails";
    public static final String SIGNATURE_PARTS = "signatureParts";
    public static final String SIGNATURE_PARTS_VERIFY = "signaturePartsVerify";
    public static final String SIGNATURE_NAMESPACE_ATTACH = "Attach";
    public static final String SIGNATURE_PART_CONTENT = "Content";
    public static final String SIGNATURE_PART_COMPLETE = "Complete";
    public static final String SIGNATURE_PART_ELEMENT = "Element";
    public static final String SIGNATURE_JWK_SET_FILE = "signatureJWKSetFile";
    public static final String SIGNATURE_PROPERTY_REF_ID = "signaturePropRefId";
    public static final String SIGNATURE_PROPERTY_FILE = "signaturePropFile";
    public static final String SIGNATURE_TRUSTSTORE_PROPERTY_FILE = "signatureTrustStorePropFile";
    public static final String SIGNATURE_TRUSTSTORE_PROPERTY_REF_ID = "signatureTrustStorePropRefId";
    public static final String SIGNATURE_MULTI_PROPERTY_FILE = "signatureMultiPropFile";
    public static final String SIGNATURE_C14N_ALGORITHM = "signatureC14nAlgorithm";
    public static final String SIGNATURE_DIGEST_ALGORITHM = "signatureDigestAlgorithm";
    public static final String SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String SIGNATURE_KEY_IDENTIFIER = "signatureKeyIdentifier";
    public static final String SIGNATURE_VALIDITY_CHECK = "signatureValidityCheck";
    public static final String SIGNATURE_CRL = "signatureCRL";
    public static final String SIGNATURE_CRL_VALIDATE_ONLY_END_ENTITY = "signatureCRLValidateOnlyEndEntity";
    public static final String SIGNATURE_OCSP = "signatureOCSP";
    public static final String SIGNATURE_VERIFICATION_PROPERTY_REF_ID = "signatureVerificationPropRefId";
    public static final String SIGNATURE_VERIFICATION_PROPERTY_FILE = "signatureVerificationPropFile";
    public static final String SIGNATURE_MODE = "signatureMode";
    public static final String SIGNATURE_MODE_JSON = "json";
    public static final String SIGNATURE_MODE_COMPACT = "compact";
    public static final String SIGNATURE_PAYLOAD_ENCODING = "signaturePayloadEncoding";
    public static final String SIGNATURE_PAYLOAD_ENCODING_TRUE = "true";
    public static final String SIGNATURE_PAYLOAD_ENCODING_FALSE = "false";
    public static final String SIGNATURE_DETACHED = "signatureDetached";
    public static final String SIGNATURE_DETACHED_TRUE = "true";
    public static final String SIGNATURE_DETACHED_FALSE = "false";
    public static final String SIGNATURE_DETACHED_BASE64 = "signatureDetachedBase64";
    public static final String SIGNATURE_DETACHED_BASE64_TRUE = "true";
    public static final String SIGNATURE_DETACHED_BASE64_FALSE = "false";
    public static final boolean SIGNATURE_DETACHED_BASE64_DEFAULT = Boolean.parseBoolean("true");
    public static final String SIGNATURE_DETACHED_HEADER = "signatureDetachedHeader";
    public static final String SIGNATURE_DETACHED_PROPERTY_URL = "signatureDetachedPropertyURL";
    public static final String SIGNATURE_XML_KEY_INFO = "keyInfo";
    public static final String SIGNATURE_XML_KEY_INFO_ALIAS = "keyInfoAlias";
    public static final String SIGNATURE_XML_KEY_INFO_X509 = "x509";
    public static final String SIGNATURE_XML_KEY_INFO_RSA = "RSA";
    public static final String USERNAME_TOKEN_ACTION = "UsernameToken";
    public static final String USERNAME_TOKEN_NO_PASSWORD_ACTION = "UsernameTokenNoPassword";
    public static final String USERNAME_TOKEN_SIGNATURE_ACTION = "UsernameTokenSignature";
    public static final String USERNAME_TOKEN_SOAP_FAULT = "UsernameTokenSOAPFault";
    public static final String USERNAME_TOKEN_PROBLEM_DETAILS = "UsernameTokenProblemDetails";
    public static final String SAML_TOKEN_SIGNED_ACTION = "SAMLTokenSigned";
    public static final String SAML_TOKEN_UNSIGNED_ACTION = "SAMLTokenUnsigned";
    public static final String SAML_TOKEN_SOAP_FAULT = "SAMLTokenSOAPFault";
    public static final String SAML_TOKEN_PROBLEM_DETAILS = "SAMLTokenProblemDetails";
    public static final String JOSE_KEYSTORE = "rs.security.keystore";
    public static final String JOSE_KEYSTORE_JWKSET = "rs.security.keystore.jwkset";
    public static final String JOSE_KEYSTORE_TYPE = "rs.security.keystore.type";
    public static final String JOSE_KEYSTORE_FILE = "rs.security.keystore.file";
    public static final String JOSE_KEYSTORE_KEY_ALGORITHM = "rs.security.keystore.file.algorithm";
    public static final String JOSE_KEYSTORE_PUBLIC_KEY = "rs.security.keystore.file.public";
    public static final String JOSE_KEYSTORE_PSWD = "rs.security.keystore.password";
    public static final String JOSE_KEYSTORE_KEY_ALIAS = "rs.security.keystore.alias";
    public static final String JOSE_KEYSTORE_KEY_PSWD = "rs.security.key.password";
    public static final String JOSE_KEYSTORE_CRL = "rs.security.keystore.crl";
    public static final String JOSE_KEYSTORE_OCSP_POLICY = "rs.security.keystore.ocsp";
    public static final String JOSE_KEYSTORE_BYOK_POLICY = "rs.security.keystore.file.byok";
    public static final String JOSE_TRUSTSTORE_SSL_TYPE = "rs.security.keystore.type.ssl";
    public static final String JOSE_TRUSTSTORE_SSL_FILE = "rs.security.keystore.file.ssl";
    public static final String JOSE_TRUSTSTORE_SSL_PSWD = "rs.security.keystore.password.ssl";
    public static final String JOSE_TRUSTSTORE_SSL_CRL = "rs.security.keystore.ssl.crl";
    public static final String JOSE_TRUSTSTORE_SSL_OCSP = "rs.security.keystore.ssl.ocsp";
    public static final String JOSE_TRUSTSTORE_SSL_TRUSTALL = "rs.security.keystore.trustAll.ssl";
    public static final String JOSE_TRUSTSTORE_SSL_CONNECTION_TIMEOUT = "rs.security.keystore.ssl.connectionTimeout";
    public static final String JOSE_TRUSTSTORE_SSL_READ_TIMEOUT = "rs.security.keystore.ssl.readTimeout";
    public static final String JOSE_TRUSTSTORE_SSL_HOSTNAME_VERIFIER = "rs.security.keystore.ssl.hostNameVerifier";
    private static final String JOSE_FORWARD_PROXY_PREFIX = "rs.security.forwardProxy.";
    public static final String JOSE_FORWARD_PROXY_ENDPOINT = "rs.security.forwardProxy.endpoint";
    public static final String JOSE_FORWARD_PROXY_HEADER = "rs.security.forwardProxy.header";
    public static final String JOSE_FORWARD_PROXY_HEADER_BASE64 = "rs.security.forwardProxy.header.base64";
    public static final String JOSE_FORWARD_PROXY_QUERY = "rs.security.forwardProxy.query";
    public static final String JOSE_FORWARD_PROXY_QUERY_BASE64 = "rs.security.forwardProxy.query.base64";
    private static final String JOSE_PROXY_PREFIX = "rs.security.proxy.";
    public static final String JOSE_PROXY_TYPE = "rs.security.proxy.type";
    public static final String JOSE_PROXY_HOSTNAME = "rs.security.proxy.hostname";
    public static final String JOSE_PROXY_PORT = "rs.security.proxy.port";
    public static final String JOSE_PROXY_USERNAME = "rs.security.proxy.username";
    public static final String JOSE_PROXY_PASSWORD = "rs.security.proxy.password";
    public static final String JOSE_KID = "joseKeyId";
    public static final String JOSE_KID_TRUE = "true";
    public static final String JOSE_KID_FALSE = "false";
    public static final String JOSE_KID_CUSTOM = "joseKeyIdCustom";
    public static final String JOSE_INCLUDE_CERT = "joseIncludeCert";
    public static final String JOSE_INCLUDE_CERT_TRUE = "true";
    public static final String JOSE_INCLUDE_CERT_FALSE = "false";
    public static final String JOSE_INCLUDE_CERT_CHAIN = "joseIncludeCertChain";
    public static final String JOSE_INCLUDE_CERT_CHAIN_TRUE = "true";
    public static final String JOSE_INCLUDE_CERT_CHAIN_FALSE = "false";
    public static final String JOSE_INCLUDE_CERT_SHA = "joseIncludeCertSHA";
    public static final String JOSE_INCLUDE_CERT_SHA_1 = "sha1";
    public static final String JOSE_INCLUDE_CERT_SHA_256 = "sha256";
    public static final String JOSE_CONTENT_TYPE = "joseContentType";
    public static final String JOSE_CONTENT_TYPE_TRUE = "true";
    public static final String JOSE_CONTENT_TYPE_FALSE = "false";
    public static final String JOSE_TYPE = "joseType";
    public static final String JOSE_X509_URL = "joseX509Url";
    public static final String JOSE_JWK_SET_URL = "joseJWKSetUrl";
    public static final String JOSE_CRITICAL_HEADERS = "joseCriticalHeaders";
    public static final String JOSE_CRITICAL_HEADERS_SEPARATOR = ",";
    public static final String JOSE_EXT_HEADER_PREFIX = "joseExtensionHeader.";
    public static final String JOSE_EXT_HEADER_SUFFIX_NAME = ".name";
    public static final String JOSE_EXT_HEADER_SUFFIX_VALUE = ".value";
    public static final String JOSE_USE_HEADERS = "joseUseHeaders";
    public static final String JOSE_USE_HEADERS_X5C = "joseUseHeaders.x5c";
    public static final String JOSE_USE_HEADERS_X5U = "joseUseHeaders.x5u";
    public static final String JOSE_USE_HEADERS_X5T = "joseUseHeaders.x5t";
    public static final String JOSE_USE_HEADERS_X5T_256 = "joseUseHeaders.x5t256";
    public static final String JOSE_USE_HEADERS_JWK = "joseUseHeaders.jwk";
    public static final String JOSE_USE_HEADERS_JKU = "joseUseHeaders.jku";
    public static final String JOSE_USE_HEADERS_KID = "joseUseHeaders.kid";
    public static final String JOSE_USE_HEADERS_TRUE = "true";
    public static final String JOSE_USE_HEADERS_FALSE = "false";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_TYPE = "joseUseHeaders.truststore.type";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_FILE = "joseUseHeaders.truststore.file";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_KEY_PAIR_ALGORITHM = "joseUseHeaders.truststore.file.algorithm";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_PASSWORD = "joseUseHeaders.truststore.password";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_VALIDITY_CHECK = "joseUseHeaders.truststore.validityCheck";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_CRL = "joseUseHeaders.truststore.crl";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_OCSP = "joseUseHeaders.truststore.ocsp";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_SSL_TYPE = "rs.security.keystore.type.ssl";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_SSL_FILE = "rs.security.keystore.file.ssl";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_SSL_PASSWORD = "rs.security.keystore.password.ssl";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_SSL_CRL = "rs.security.keystore.ssl.crl";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_SSL_OCSP = "rs.security.keystore.ssl.ocsp";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_REMOTE_STORE_PROVIDER = "joseUseHeaders.truststore.remoteStoreProvider";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_REMOTE_STORE_KEY_TYPE = "joseUseHeaders.truststore.remoteStoreKeyType";
    public static final String JOSE_USE_HEADERS_TRUSTSTORE_REMOTE_STORE_CONFIG = "joseUseHeaders.truststore.remoteStoreConfig";
    public static final String JOSE_USE_HEADERS_KEYSTORE_TYPE = "joseUseHeaders.keystore.type";
    public static final String JOSE_USE_HEADERS_KEYSTORE_FILE = "joseUseHeaders.keystore.file";
    public static final String JOSE_USE_HEADERS_KEYSTORE_KEY_PAIR_ALGORITHM = "joseUseHeaders.keystore.file.algorithm";
    public static final String JOSE_USE_HEADERS_KEYSTORE_PASSWORD = "joseUseHeaders.keystore.password";
    public static final String JOSE_USE_HEADERS_KEYSTORE_MAP_ALIAS_PW = "joseUseHeaders.key.";
    public static final String JOSE_USE_HEADERS_KEYSTORE_MAP_ALIAS_PW_SUFFIX_ALIAS = ".alias";
    public static final String JOSE_USE_HEADERS_KEYSTORE_MAP_ALIAS_PW_SUFFIX_PW = ".password";
    public static final String TIMESTAMP_ACTION = "Timestamp";
    public static final String TIMESTAMP_TTL = "timeToLive";
    public static final String TIMESTAMP_STRICT = "timestampStrict";
    public static final String TIMESTAMP_PRECISION = "precisionInMilliseconds";
    public static final String TIMESTAMP_FUTURE_TTL = "futureTimeToLive";
    public static final String USERNAME_TOKEN_PW = "usernameTokenPassword";
    public static final String USERNAME_TOKEN_PW_TYPE = "passwordType";
    public static final String USERNAME_TOKEN_PW_TYPE_DIGEST = "PasswordDigest";
    public static final String USERNAME_TOKEN_PW_TYPE_TEXT = "PasswordText";
    public static final String USERNAME_TOKEN_PW_TYPE_NONE = "PasswordNone";
    public static final String USERNAME_TOKEN_PW_MAP_MODE = "usernameTokenPasswordMode";
    public static final String USERNAME_TOKEN_PW_MAP_MODE_SINGLE = "single";
    public static final String USERNAME_TOKEN_PW_MAP_MODE_MAP = "map";
    public static final String USERNAME_TOKEN_PW_MAP = "usernameTokenPasswordMap";
    public static final String SAML_PROF_FILE = "samlPropFile";
    public static final String SAML_PROF_REF_ID = "samlPropRefId";
    public static final String SAML_CALLBACK_REF = "samlCallbackRef";
    public static final String SAML_VERSION_XMLCONFIG_ID = "samlVersion";
    public static final String SAML_VERSION_XMLCONFIG_ID_VALUE_20 = "2.0";
    public static final String SAML_ISSUER_FORMAT_XMLCONFIG_ID_2 = "issuerFormat2";
    public static final String SAML_SUBJECT_FORMAT_XMLCONFIG_ID_1 = "subjectFormat1";
    public static final String SAML_SUBJECT_FORMAT_XMLCONFIG_ID_2 = "subjectFormat2";
    public static final String SAML_SUBJECT_CONFIRMATION_METHOD_XMLCONFIG_ID_1 = "subjectConfirmationMethod1";
    public static final String SAML_SUBJECT_CONFIRMATION_METHOD_XMLCONFIG_ID_2 = "subjectConfirmationMethod2";
    public static final String SAML_AUTHN_CONTEXT_CLASS_REF_XMLCONFIG_ID_1 = "authnContextClassRef1";
    public static final String SAML_AUTHN_CONTEXT_CLASS_REF_XMLCONFIG_ID_2 = "authnContextClassRef2";
    public static final String SAML_ENVELOPED_SAML_SIGNATURE_XMLCONFIG_PREFIX_ID = "signatureActionChoice";
    public static final String SAML_ATTRIBUTE_STATEMENT_FORMAT_XMLCONFIG_PREFIX_ID = "attributeStatementFormat_";
    public static final String SAML_SUBJECT_CONFIRMATION_VALIDATION_METHOD_XMLCONFIG_ID = "validateSamlSubjectConfirmationType";
    public static final String SAML_SUBJECT_CONFIRMATION_VALIDATION_METHOD_XMLCONFIG_ID_SENDER_VOUCHES = "sender-vouches";
    public static final String SAML_SUBJECT_CONFIRMATION_VALIDATION_METHOD_XMLCONFIG_ID_HOLDER_OF_KEY = "holder-of-key";
    public static final String SAML_SIGNATURE_PARAM_CONVERTO_INTO_SAML_CONFIG = "signaturePropRefId_convertParamsIntoSamlPropRefId";
    public static final String SAML_SIGNATURE_PARAM_CONVERTO_INTO_SAML_CONFIG_HOLDER_OF_KEY = "signaturePropRefId_convertParamsIntoSamlPropRefId_holderOfKey";
    public static final String SAML_NAMESPACE_TEMPLATE = "SAML_TEMPLATE_NS";
    public static final String AUTH_PDP_LOCAL = "pdpLocal";
    public static final String AUTH_PDP_REMOTE_URL = "pdpRemoteUrl";
    public static final String AUTH_PDP_REMOTE_CONNECTION_TIMEOUT = "pdpRemoteConnectionTimeout";
    public static final String AUTH_PDP_REMOTE_READ_CONNECTION_TIMEOUT = "pdpRemoteReadConnectionTimeout";
    public static final String ACTION_NO_SECURITY = "NoSecurity";
    public static final String ACTION_USERNAME_TOKEN_SIGNATURE = "UsernameTokenSignature";
    public static final String ACTION_USERNAME_TOKEN = "UsernameToken";
    public static final String ACTION_USERNAME_TOKEN_NO_PASSWORD = "UsernameTokenNoPassword";
    public static final String ACTION_SAML_TOKEN_UNSIGNED = "SAMLTokenUnsigned";
    public static final String ACTION_SAML_TOKEN_SIGNED = "SAMLTokenSigned";
    public static final String ACTION_SIGNATURE = "Signature";
    public static final String ACTION_ENCRYPTION = "Encryption";
    public static final String ACTION_ENCRYPT_OLD = "Encrypt";
    public static final String ACTION_DECRYPTION = "Decryption";
    public static final String ACTION_DECRYPT_OLD = "Decrypt";
    public static final String ACTION_TIMESTAMP = "Timestamp";
    public static final String ACTION_SIGNATURE_DERIVED = "SignatureDerived";
    public static final String ACTION_ENCRYPTION_DERIVED = "EncryptionDerived";
    public static final String ACTION_ENCRYPT_DERIVED_OLD = "EncryptDerived";
    public static final String ACTION_SIGNATURE_WITH_KERBEROS_TOKEN = "SignatureWithKerberosToken";
    public static final String ACTION_ENCRYPTION_WITH_KERBEROS_TOKEN = "EncryptionWithKerberosToken";
    public static final String ACTION_ENCRYPT_WITH_KERBEROS_TOKEN_OLD = "EncryptWithKerberosToken";
    public static final String ACTION_KERBEROS_TOKEN = "KerberosToken";
    public static final String ACTION_CUSTOM_TOKEN = "CustomToken";
    public static final String KEY_IDENTIFIER_BST_DIRECT_REFERENCE = "DirectReference";
    public static final String KEY_IDENTIFIER_ISSUER_SERIAL = "IssuerSerial";
    public static final String KEY_IDENTIFIER_X509 = "X509KeyIdentifier";
    public static final String KEY_IDENTIFIER_SKI = "SKIKeyIdentifier";
    public static final String KEY_IDENTIFIER_EMBEDDED_KEY_NAME = "EmbeddedKeyName";
    public static final String KEY_IDENTIFIER_THUMBPRINT = "Thumbprint";
    public static final String KEY_IDENTIFIER_ENCRYPTED_KEY_SHA1 = "EncryptedKeySHA1";
    public static final String KEY_IDENTIFIER_BST_DIRECT_REFERENCE_USE_SINGLE_CERTIFICATE = "useSingleCertificate";
    public static final String KEY_IDENTIFIER_INCLUDE_SIGNATURE_TOKEN = "includeSignatureToken";
    public static final String KEY_IDENTIFIER_INCLUDE_ENCRYPT_TOKEN = "includeEncryptionToken";
    public static final String IS_BSP_COMPLIANT = "isBSPCompliant";
    public static final String AUTHORIZATION_CLASS = "authorizationClass";
    public static final String DETACH_HEADER_WSS = "detachHeaderWSSecurity";
    public static final String DETACH_SECURITY_INFO = "detachSecurityInfo";
    public static final String REMOVE_ALL_WSU_ID_REF = "removeAllWsuIdRef";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String KEYSTORE_TYPE_KEY_PAIR_VALUE = CostantiDB.KEYSTORE_TYPE_KEY_PAIR;
    public static final String KEYSTORE_TYPE_KEY_PAIR_LABEL = CostantiLabel.KEYSTORE_TYPE_KEY_PAIR;
    public static final String KEYSTORE_TYPE_PUBLIC_KEY_VALUE = CostantiDB.KEYSTORE_TYPE_PUBLIC_KEY;
    public static final String KEYSTORE_TYPE_PUBLIC_KEY_LABEL = CostantiLabel.KEYSTORE_TYPE_PUBLIC_KEY;
    public static final String KEYSTORE_TYPE_JWK_VALUE = CostantiDB.KEYSTORE_TYPE_JWK;
    public static final String KEYSTORE_TYPE_JWK_LABEL = CostantiLabel.KEYSTORE_TYPE_JWK;
    public static final String KEYSTORE_TYPE_JKS_VALUE = CostantiDB.KEYSTORE_TYPE_JKS;
    public static final String KEYSTORE_TYPE_JKS_LABEL = CostantiLabel.KEYSTORE_TYPE_JKS;
    public static final String KEYSTORE_TYPE_PKCS12_VALUE = CostantiDB.KEYSTORE_TYPE_PKCS12;
    public static final String KEYSTORE_TYPE_PKCS12_LABEL = CostantiLabel.KEYSTORE_TYPE_PKCS12;
    public static final String KEYSTORE_TYPE_JCEKS_VALUE = "jceks";
    public static final String KEYSTORE_TYPE_JCEKS_LABEL = "JCEKS";
    public static final String SECRETKEYSTORE_TYPE = "secretkeystoreType";
    public static final String SECRETKEYSTORE_FILE = "secretkeystoreFile";
    public static final String SECRETKEYSTORE_PASSWORD = "secretkeystorePassword";
    public static final String SECRETKEYSTORE_PRIVATE_KEY_PASSWORD = "secretkeystorePrivateKeyPassword";
    public static final String SECRETKEYSTORE_BYOK_POLICY = "secretkeystoreByokPolicy";
    public static final String KEYSTORE_TYPE = "keystoreType";
    public static final String KEYSTORE_FILE = "keystoreFile";
    public static final String KEYSTORE_PASSWORD = "keystorePassword";
    public static final String KEYSTORE_PRIVATE_KEY_PASSWORD = "keystorePrivateKeyPassword";
    public static final String KEYSTORE_OCSP_POLICY = "keystoreOcspPolicy";
    public static final String KEYSTORE_BYOK_POLICY = "keystoreByokPolicy";
    public static final String TRUSTSTORE_TYPE = "truststoreType";
    public static final String TRUSTSTORE_FILE = "truststoreFile";
    public static final String TRUSTSTORE_PASSWORD = "truststorePassword";
    public static final String TRUSTSTORE_OCSP_POLICY = "truststoreOcspPolicy";
    public static final String PRE_BASE64_ENCODING_ATTACHMENT_TRUE = "true";
    public static final String PRE_BASE64_ENCODING_ATTACHMENT_FALSE = "false";
    public static final boolean PRE_BASE64_ENCODING_ATTACHMENT_DEFAULT = Boolean.parseBoolean("false");
    public static final String PRE_BASE64_ENCODING_ATTACHMENT = "preBase64EncodingAttachment";
    public static final String POST_BASE64_ENCODING_ATTACHMENT_TRUE = "true";
    public static final String POST_BASE64_ENCODING_ATTACHMENT_FALSE = "false";
    public static final boolean POST_BASE64_ENCODING_ATTACHMENT_DEFAULT = Boolean.parseBoolean("false");
    public static final String POST_BASE64_ENCODING_ATTACHMENT = "postBase64EncodingAttachment";
    public static final String POST_BASE64_DECODING_ATTACHMENT_TRUE = "true";
    public static final String POST_BASE64_DECODING_ATTACHMENT_FALSE = "false";
    public static final boolean POST_BASE64_DECODING_ATTACHMENT_DEFAULT = Boolean.parseBoolean("false");
    public static final String POST_BASE64_DECODING_ATTACHMENT = "postBase64DecodingAttachment";
    public static final String ADD_ATTACHMENT_ID_BRACKETS_FALSE = "false";
    public static final String ADD_ATTACHMENT_ID_BRACKETS_TRUE = "true";
    public static final boolean ADD_ATTACHMENT_ID_BRACKETS_DEFAULT = Boolean.parseBoolean("false");
    public static final String ADD_ATTACHMENT_ID_BRACKETS = "addAttachmentIdBrackets";
    public static final String ENCRYPT_ATTACHMENT_HEADERS_FALSE = "false";
    public static final String ENCRYPT_ATTACHMENT_HEADERS_TRUE = "true";
    public static final boolean ENCRYPT_ATTACHMENT_HEADERS_DEFAULT = Boolean.parseBoolean("false");
    public static final String ENCRYPT_ATTACHMENT_HEADERS = "encryptAttachmentHeaders";

    private SecurityConstants() {
    }

    public static String convertActionToString(Map<String, Object> flow) {
        if (flow != null && flow.containsKey(ACTION)) {
            Object o;
            String engine = SECURITY_ENGINE_WSS4J;
            if (flow.containsKey(SECURITY_ENGINE) && (o = flow.get(SECURITY_ENGINE)) instanceof String) {
                engine = (String)o;
            }
            if ((o = flow.get(ACTION)) instanceof String) {
                String actions = (String)o;
                return SecurityConstants.getActionValue(actions, engine);
            }
        }
        return null;
    }

    private static String getActionValue(String actions, String engine) {
        if ((actions = actions.trim()).contains(TIPO_SECURITY_ENGINE_SEPARATOR)) {
            String[] tmp = actions.split(TIPO_SECURITY_ENGINE_SEPARATOR);
            StringBuilder bf = new StringBuilder();
            bf.append(engine);
            bf.append(TIPO_SECURITY_ENGINE_SEPARATOR);
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i] == null) continue;
                if (i > 0) {
                    bf.append(",");
                }
                bf.append(tmp[i].trim());
            }
            return bf.toString();
        }
        return engine + TIPO_SECURITY_ENGINE_SEPARATOR + actions;
    }

    public static boolean isActionEncryption(String action) {
        return "Encryption".equals(action) || "Encrypt".equals(action) || ACTION_ENCRYPTION_DERIVED.equals(action) || ACTION_ENCRYPT_DERIVED_OLD.equals(action) || ACTION_ENCRYPTION_WITH_KERBEROS_TOKEN.equals(action) || ACTION_ENCRYPT_WITH_KERBEROS_TOKEN_OLD.equals(action);
    }

    public static boolean containsActionEncryption(String action) {
        if (action == null) {
            return false;
        }
        return action.contains("Encryption") || action.contains("Encrypt") || action.contains(ACTION_ENCRYPTION_DERIVED) || action.contains(ACTION_ENCRYPT_DERIVED_OLD) || action.contains(ACTION_ENCRYPTION_WITH_KERBEROS_TOKEN) || action.contains(ACTION_ENCRYPT_WITH_KERBEROS_TOKEN_OLD);
    }

    public static boolean isActionDecryption(String action) {
        return "Decryption".equals(action) || "Decrypt".equals(action);
    }

    public static boolean containsActionDecryption(String action) {
        if (action == null) {
            return false;
        }
        return action.contains("Decryption") || action.contains("Decrypt");
    }

    public static boolean isActionUsernameToken(String action) {
        return "UsernameToken".equals(action) || "UsernameTokenNoPassword".equals(action) || "UsernameTokenSignature".equals(action);
    }

    public static boolean containsActionUsernameToken(String action) {
        if (action == null) {
            return false;
        }
        return action.contains("UsernameToken") || action.contains("UsernameTokenNoPassword") || action.contains("UsernameTokenSignature");
    }

    public static boolean isActionSAMLToken(String action) {
        return "SAMLTokenSigned".equals(action) || "SAMLTokenUnsigned".equals(action);
    }

    public static boolean containsActionSAMLToken(String action) {
        if (action == null) {
            return false;
        }
        return action.contains("SAMLTokenSigned") || action.contains("SAMLTokenUnsigned");
    }

    public static List<String> getTipologieKeystoreValues(boolean truststore) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(KEYSTORE_TYPE_JKS_VALUE);
        l.add(KEYSTORE_TYPE_PKCS12_VALUE);
        HSMUtils.fillTipologieKeystore((boolean)truststore, (boolean)false, l);
        return l;
    }

    public static List<String> getTipologieKeystoreLabels(boolean truststore) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(KEYSTORE_TYPE_JKS_LABEL);
        l.add(KEYSTORE_TYPE_PKCS12_LABEL);
        HSMUtils.fillTipologieKeystore((boolean)truststore, (boolean)false, l);
        return l;
    }

    public static List<String> getTipologieSecretKeystoreValues() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(KEYSTORE_TYPE_JCEKS_VALUE);
        HSMUtils.fillTipologieKeystore((boolean)false, (boolean)true, l);
        return l;
    }

    public static List<String> getTipologieSecretKeystoreLabels() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(KEYSTORE_TYPE_JCEKS_LABEL);
        HSMUtils.fillTipologieKeystore((boolean)false, (boolean)true, l);
        return l;
    }
}

