/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.authorization;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPPart;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.WSSecurityUtils;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.authorization.IMessageSecurityAuthorization;
import org.openspcoop2.security.message.authorization.MessageSecurityAuthorizationRequest;
import org.openspcoop2.security.message.authorization.MessageSecurityAuthorizationResult;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.xacml.MarshallUtilities;
import org.openspcoop2.utils.xacml.PolicyDecisionPoint;
import org.openspcoop2.utils.xacml.PolicyException;
import org.openspcoop2.utils.xacml.ResultCombining;
import org.openspcoop2.utils.xacml.ResultUtilities;
import org.openspcoop2.utils.xacml.XacmlRequest;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XPathException;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.openspcoop2.utils.xml.XPathNotValidException;
import org.openspcoop2.utils.xml.XPathReturnType;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MessageSecurityAuthorizationSAMLPolicy
implements IMessageSecurityAuthorization {
    public static final String SAML_20_ISSUER = "urn:oasis:names:tc:SAML:2.0:assertion:Issuer";
    public static final String SAML_20_SUBJECT_NAME = "urn:oasis:names:tc:SAML:2.0:assertion:Subject:NameID";
    public static final String SAML_20_ATTRIBUTE_NAME = "urn:oasis:names:tc:SAML:2.0:assertion:AttributeStatement:Attribute:Name:";
    public static final String SAML_11_ISSUER = "urn:oasis:names:tc:SAML:2.0:assertion:Issuer";
    public static final String SAML_11_AUTHENTICATION_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.0:assertion:AuthenticationStatement:Subject:NameIdentifier";
    public static final String SAML_11_AUTHORIZATION_SUBJECT_NAME = "urn:oasis:names:tc:SAML:1.0:assertion:AttributeStatement:Subject:NameIdentifier";
    public static final String SAML_11_ATTRIBUTE_NAME = "urn:oasis:names:tc:SAML:1.0:assertion:AttributeStatement:Attribute:Name:";
    private static PolicyDecisionPoint pdp;

    private static synchronized void initPdD(Logger log) throws PolicyException {
        if (pdp == null) {
            pdp = new PolicyDecisionPoint(log);
        }
    }

    public MessageSecurityAuthorizationSAMLPolicy() {
        PolicyDecisionPoint.runInitializers();
    }

    @Override
    public MessageSecurityAuthorizationResult authorize(MessageSecurityAuthorizationRequest request) throws SecurityException {
        String principalWSS = request.getSecurityPrincipal();
        Busta busta = request.getBusta();
        MessageSecurityContext messageSecurityContext = request.getMessageSecurityContext();
        OpenSPCoop2Message msg = request.getMessage();
        IDServizio idServizio = null;
        try {
            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), busta.getTipoDestinatario(), busta.getDestinatario(), busta.getVersioneServizio().intValue());
            OpenSPCoop2SoapMessage soapMessage = msg.castAsSoap();
            String actor = messageSecurityContext.getActor();
            if ("".equals(messageSecurityContext.getActor())) {
                actor = null;
            }
            String pdpLocalString = (String)messageSecurityContext.getIncomingProperties().get("pdpLocal");
            boolean pdpLocal = true;
            if (pdpLocalString == null || "".equals(pdpLocalString.trim())) {
                pdpLocal = true;
            } else if ("true".equalsIgnoreCase(pdpLocalString.trim())) {
                pdpLocal = true;
            } else if ("false".equalsIgnoreCase(pdpLocalString.trim())) {
                pdpLocal = false;
            } else {
                throw new SecurityException("Property 'pdpLocal' with wrong value [" + pdpLocalString.trim() + "]");
            }
            String remotePdD_url = null;
            Integer remotePdD_connectionTimeout = 10000;
            Integer remotePdD_readConnectionTimeout = 120000;
            if (!pdpLocal) {
                remotePdD_url = (String)messageSecurityContext.getIncomingProperties().get("pdpRemoteUrl");
                if (pdpLocalString == null || "".equals(pdpLocalString.trim())) {
                    throw new SecurityException("Property 'pdpRemoteUrl' not found (required with pdpLocal=false)");
                }
                pdpLocalString = pdpLocalString.trim();
                try {
                    new URI(remotePdD_url).toString();
                }
                catch (Exception e) {
                    throw new SecurityException("Property 'pdpRemoteUrl' with wrong value [" + remotePdD_url + "]: " + e.getMessage(), e);
                }
                String tmp = (String)messageSecurityContext.getIncomingProperties().get("pdpRemoteConnectionTimeout");
                if (tmp != null && !"".equals(tmp)) {
                    tmp = tmp.trim();
                    try {
                        remotePdD_connectionTimeout = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        throw new SecurityException("Property 'pdpRemoteConnectionTimeout' with wrong value [" + tmp + "]: " + e.getMessage(), e);
                    }
                }
                if ((tmp = (String)messageSecurityContext.getIncomingProperties().get("pdpRemoteReadConnectionTimeout")) != null && !"".equals(tmp)) {
                    tmp = tmp.trim();
                    try {
                        remotePdD_readConnectionTimeout = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        throw new SecurityException("Property 'pdpRemoteReadConnectionTimeout' with wrong value [" + tmp + "]: " + e.getMessage(), e);
                    }
                }
            }
            String tipoSoggettoErogatore = busta.getTipoDestinatario();
            String nomeSoggettoErogatore = busta.getDestinatario();
            String tipoServizio = busta.getTipoServizio();
            String nomeServizio = busta.getServizio();
            String azione = busta.getAzione() != null ? busta.getAzione() : "";
            String servizioKey = "http://" + tipoSoggettoErogatore + nomeSoggettoErogatore + ".openspcoop2.org/servizi/" + tipoServizio + nomeServizio;
            String azioneKey = servizioKey + "/" + azione;
            if (pdpLocal) {
                byte[] policy = null;
                try {
                    AccordoServizioParteSpecifica asps = RegistroServiziManager.getInstance().getAccordoServizioParteSpecifica(idServizio, null, Boolean.valueOf(true), null);
                    for (int i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                        Documento d = asps.getSpecificaSicurezza(i);
                        if (!TipiDocumentoSicurezza.XACML_POLICY.getNome().equals(d.getTipo())) continue;
                        if (policy == null) {
                            if (d.getByteContenuto() != null) {
                                policy = d.getByteContenuto();
                                continue;
                            }
                            if (d.getFile() == null) continue;
                            if (d.getFile().startsWith("http://") || d.getFile().startsWith("file://")) {
                                URL url = new URI(d.getFile()).toURL();
                                policy = HttpUtilities.requestHTTPFile((String)url.toString());
                                continue;
                            }
                            File f = new File(d.getFile());
                            policy = FileSystemUtilities.readBytesFromFile((File)f);
                            continue;
                        }
                        throw new SecurityException("Piu di una xacml policy trovata trovata per il servizio " + idServizio.toString());
                    }
                }
                catch (Exception e) {
                    throw new SecurityException("Errore durante la ricerca delle policies xacml per il servizio " + idServizio.toString() + ": " + e.getMessage(), e);
                }
                if (policy == null) {
                    throw new SecurityException("Nessuna xacml policy trovata per il servizio " + idServizio.toString());
                }
                if (pdp == null) {
                    MessageSecurityAuthorizationSAMLPolicy.initPdD(messageSecurityContext.getLog());
                }
                pdp.addPolicy(MarshallUtilities.unmarshallPolicy(policy), servizioKey);
            }
            SOAPElement security = null;
            try {
                security = WSSecurityUtils.getSecurityHeader((SOAPPart)soapMessage.getSOAPPart(), (MessageType)soapMessage.getMessageType(), (String)actor, (boolean)true);
            }
            catch (Exception e) {
                throw new SecurityException("Errore durante la ricerca dell'header WSSecurity (actor:" + actor + ") " + e.getMessage(), e);
            }
            if (security == null) {
                throw new SecurityException("Header WSSecurity (actor:" + actor + ") contenente una SAML non trovato");
            }
            DynamicNamespaceContext dnc = null;
            dnc = MessageType.SOAP_11.equals((Object)soapMessage.getMessageType()) ? MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)soapMessage.getFactory()).getNamespaceContextFromSoapEnvelope11(soapMessage.getSOAPPart().getEnvelope()) : MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)soapMessage.getFactory()).getNamespaceContextFromSoapEnvelope12(soapMessage.getSOAPPart().getEnvelope());
            XPathExpressionEngine xpathExpressionEngine = new XPathExpressionEngine(soapMessage.getFactory());
            boolean SAML_2_0 = false;
            try {
                Object o = xpathExpressionEngine.getMatchPattern(security, dnc, "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion", XPathReturnType.NODE);
                SAML_2_0 = o != null;
            }
            catch (XPathNotFoundException e) {
                SAML_2_0 = false;
            }
            XacmlRequest xacmlRequest = new XacmlRequest();
            xacmlRequest.addAction(azioneKey);
            if (principalWSS != null) {
                xacmlRequest.addSubjectAttribute("urn:oasis:names:tc:xacml:1.0:subject:subject-id", principalWSS);
            }
            SAMLAttributes saml = new SAMLAttributes(this, security, dnc, SAML_2_0, (AbstractXPathExpressionEngine)xpathExpressionEngine);
            if (SAML_2_0) {
                if (saml.nameIDAuthorization != null) {
                    xacmlRequest.addSubjectAttribute(SAML_20_SUBJECT_NAME, saml.nameIDAuthorization);
                }
            } else {
                if (saml.nameIDAuthorization != null) {
                    xacmlRequest.addSubjectAttribute(SAML_11_AUTHORIZATION_SUBJECT_NAME, saml.nameIDAuthorization);
                }
                if (saml.nameIDAuthentication != null) {
                    xacmlRequest.addSubjectAttribute(SAML_11_AUTHENTICATION_SUBJECT_NAME, saml.nameIDAuthentication);
                }
            }
            if (SAML_2_0) {
                xacmlRequest.addSubjectAttribute("urn:oasis:names:tc:SAML:2.0:assertion:Issuer", saml.issuer);
            } else {
                xacmlRequest.addSubjectAttribute("urn:oasis:names:tc:SAML:2.0:assertion:Issuer", saml.issuer);
            }
            for (String string : saml.customAttributes.keySet()) {
                xacmlRequest.addSubjectAttribute(string, saml.customAttributes.get(string));
            }
            xacmlRequest.createEnvironment();
            List results = null;
            if (pdpLocal) {
                try {
                    xacmlRequest.addResourceAttribute("___resource-id___", servizioKey);
                    messageSecurityContext.getLog().debug("----XACML Request locale begin ---");
                    messageSecurityContext.getLog().debug(new String(MarshallUtilities.marshallRequest((XacmlRequest)xacmlRequest)));
                    messageSecurityContext.getLog().debug("----XACML Request locale end ---");
                    results = pdp.evaluate(xacmlRequest);
                    messageSecurityContext.getLog().debug("----XACML Results begin ---");
                    for (ResultType result2 : results) {
                        messageSecurityContext.getLog().debug("Decision: " + result2.getDecision().toString());
                    }
                    messageSecurityContext.getLog().debug("----XACML Results end ---");
                }
                catch (Exception exception) {
                    throw new SecurityException("Errore avvenuto durante l'interrogazione del PdP locale per l'autorizzazione del servizio " + idServizio.toString() + ": " + exception.getMessage(), exception);
                }
            }
            try {
                xacmlRequest.createResource();
                byte[] byArray = MarshallUtilities.marshallRequest((XacmlRequest)xacmlRequest);
                messageSecurityContext.getLog().debug("----XACML Request remota begin ---");
                messageSecurityContext.getLog().debug(new String(byArray));
                messageSecurityContext.getLog().debug("----XACML Request remota end ---");
                HttpRequest httpRequest = new HttpRequest();
                httpRequest.setUrl(remotePdD_url);
                httpRequest.setContent(byArray);
                httpRequest.setMethod(HttpRequestMethod.POST);
                httpRequest.setContentType("text/xml");
                httpRequest.setReadTimeout(remotePdD_readConnectionTimeout.intValue());
                httpRequest.setConnectTimeout(remotePdD_connectionTimeout.intValue());
                HttpResponse httpResponse = HttpUtilities.httpInvoke((HttpRequest)httpRequest);
                if (httpResponse.getResultHTTPOperation() != 200) {
                    throw new Exception("invocazione fallita (http-return-code: " + httpResponse.getResultHTTPOperation() + ")");
                }
                byte[] res = httpResponse.getContent();
                results = MarshallUtilities.unmarshallResult((byte[])res);
            }
            catch (Exception exception) {
                throw new SecurityException("Errore avvenuto durante l'interrogazione del PdP remoto [" + remotePdD_url + "] per l'autorizzazione del servizio " + idServizio.toString() + ": " + exception.getMessage(), exception);
            }
            DecisionType decisionType = ResultCombining.combineDenyOverrides((List)results);
            MessageSecurityAuthorizationResult result = new MessageSecurityAuthorizationResult();
            if (DecisionType.PERMIT.equals((Object)decisionType)) {
                result.setAuthorized(true);
                result.setErrorMessage(null);
            } else {
                String resultAsString;
                Object url = "";
                String tipo = "XACML-Policy";
                if (!pdpLocal) {
                    url = " url[" + remotePdD_url + "]";
                    tipo = "XACML-Policy-RemotePdp";
                }
                try {
                    resultAsString = ResultUtilities.toRawString((List)results);
                    messageSecurityContext.getLog().error("Autorizzazione con XACMLPolicy fallita pddLocal[" + pdpLocal + "]" + (String)url + "; results (size:" + results.size() + "): \n" + resultAsString);
                }
                catch (Throwable e) {
                    messageSecurityContext.getLog().error("Autorizzazione con XACMLPolicy fallita pddLocal[" + pdpLocal + "]" + (String)url + ". Serializzazione risposta non riuscita", e);
                }
                result.setAuthorized(false);
                resultAsString = ResultUtilities.toString((List)results, (DecisionType)decisionType);
                if (resultAsString != null && resultAsString.length() > 0) {
                    result.setErrorMessage(tipo + " " + resultAsString);
                } else {
                    result.setErrorMessage(tipo);
                }
            }
            return result;
        }
        catch (SecurityException e) {
            messageSecurityContext.getLog().error("Errore di sicurezza durante la gestione della richiesta per il servizio: " + String.valueOf(idServizio), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            messageSecurityContext.getLog().error("Errore generico durante la gestione della richiesta per il servizio: " + String.valueOf(idServizio), (Throwable)e);
            throw new SecurityException(e);
        }
    }

    private class SAMLAttributes {
        public String nameIDAuthentication;
        public String nameIDAuthorization;
        public String issuer;
        public Map<String, List<String>> customAttributes;
        private DynamicNamespaceContext dnc;
        private boolean saml20;
        private AbstractXPathExpressionEngine xpathExpressionEngine;

        public SAMLAttributes(MessageSecurityAuthorizationSAMLPolicy messageSecurityAuthorizationSAMLPolicy, SOAPElement security, DynamicNamespaceContext dnc, boolean saml20, AbstractXPathExpressionEngine xpathExpressionEngine) throws Exception {
            this.dnc = dnc;
            this.saml20 = saml20;
            this.xpathExpressionEngine = xpathExpressionEngine;
            if (this.saml20) {
                this.nameIDAuthorization = this.find(security, "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:Subject/{urn:oasis:names:tc:SAML:2.0:assertion}:NameID/text()", false);
                this.issuer = this.find(security, "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:Issuer/text()", true);
            } else {
                this.nameIDAuthorization = this.find(security, "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AttributeStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Subject/{urn:oasis:names:tc:SAML:1.0:assertion}:NameIdentifier/text()", false);
                this.nameIDAuthentication = this.find(security, "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AuthenticationStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Subject/{urn:oasis:names:tc:SAML:1.0:assertion}:NameIdentifier/text()", false);
                this.issuer = this.find(security, "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/@Issuer", true);
            }
            this.customAttributes = this.findNameAttributes(security);
        }

        private String find(SOAPElement security, String xpath, boolean required) throws SAXException, SOAPException, XPathException, XPathNotValidException, Exception {
            String match = null;
            try {
                match = (String)this.xpathExpressionEngine.getMatchPattern(security, this.dnc, xpath, XPathReturnType.STRING);
            }
            catch (XPathNotFoundException e) {
                if (required) {
                    throw new Exception(e.getMessage(), e);
                }
                return null;
            }
            return match;
        }

        private Map<String, List<String>> findNameAttributes(SOAPElement security) throws SAXException, SOAPException, XPathException, XPathNotValidException, Exception {
            HashMap<String, List<String>> nameAttributes = new HashMap<String, List<String>>();
            String xpath = null;
            xpath = this.saml20 ? "//{urn:oasis:names:tc:SAML:2.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:2.0:assertion}:AttributeStatement/{urn:oasis:names:tc:SAML:2.0:assertion}:Attribute" : "//{urn:oasis:names:tc:SAML:1.0:assertion}:Assertion/{urn:oasis:names:tc:SAML:1.0:assertion}:AttributeStatement/{urn:oasis:names:tc:SAML:1.0:assertion}:Attribute";
            try {
                NodeList attributes = (NodeList)this.xpathExpressionEngine.getMatchPattern(security, this.dnc, xpath, XPathReturnType.NODESET);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node attribute = attributes.item(i);
                        String name = null;
                        String friendlyName = null;
                        boolean uriNameFormat = false;
                        if (this.saml20) {
                            Node nameFormatAttribute;
                            nameAttribute = attribute.getAttributes().getNamedItem("Name");
                            name = nameAttribute.getNodeValue();
                            friendlyNameAttribute = attribute.getAttributes().getNamedItem("FriendlyName");
                            if (friendlyNameAttribute != null) {
                                friendlyName = friendlyNameAttribute.getNodeValue();
                            }
                            if ((nameFormatAttribute = attribute.getAttributes().getNamedItem("NameFormat")) != null) {
                                uriNameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:uri".equals(nameFormatAttribute.getNodeValue());
                            }
                        } else {
                            nameAttribute = attribute.getAttributes().getNamedItem("AttributeNamespace");
                            name = nameAttribute.getNodeValue();
                            friendlyNameAttribute = attribute.getAttributes().getNamedItem("AttributeName");
                            friendlyName = friendlyNameAttribute.getNodeValue();
                        }
                        if (!uriNameFormat && friendlyName == null && (name.startsWith("urn:") || name.startsWith("url:") || name.startsWith("http:") || name.startsWith("htts:"))) {
                            uriNameFormat = true;
                        }
                        Object key = null;
                        key = friendlyName != null ? (this.saml20 ? MessageSecurityAuthorizationSAMLPolicy.SAML_20_ATTRIBUTE_NAME + friendlyName : MessageSecurityAuthorizationSAMLPolicy.SAML_11_ATTRIBUTE_NAME + friendlyName) : (uriNameFormat ? name : (this.saml20 ? MessageSecurityAuthorizationSAMLPolicy.SAML_20_ATTRIBUTE_NAME + name : MessageSecurityAuthorizationSAMLPolicy.SAML_11_ATTRIBUTE_NAME + name));
                        String samlNamespace = null;
                        samlNamespace = this.saml20 ? "urn:oasis:names:tc:SAML:2.0:assertion" : "urn:oasis:names:tc:SAML:1.0:assertion";
                        List values = null;
                        values = nameAttributes.containsKey(key) ? (List)nameAttributes.remove(key) : new ArrayList();
                        NodeList attributeValues = attribute.getChildNodes();
                        if (attributeValues != null) {
                            for (int j = 0; j < attributeValues.getLength(); ++j) {
                                Node attributeValue = attributeValues.item(j);
                                if (attributeValue == null || !"AttributeValue".equals(attributeValue.getLocalName()) || !samlNamespace.equals(attributeValue.getNamespaceURI())) continue;
                                values.add(attributeValue.getTextContent());
                            }
                        }
                        nameAttributes.put((String)key, values);
                    }
                }
            }
            catch (XPathNotFoundException e) {
                throw new Exception("Impossibile trovare l'xPath [" + xpath + "]");
            }
            return nameAttributes;
        }
    }
}

