/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.SSLSocketFactory;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.transport.http.SSLConfig;

public class SSLSocketFactoryCache
extends AbstractKeystoreCache<SSLSocketFactory> {
    @Override
    public SSLSocketFactory createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 2) {
            if (!(params[0] instanceof RequestInfo)) {
                throw new SecurityException("Param[0] must be RequestInfo");
            }
            RequestInfo requestInfo = (RequestInfo)params[0];
            if (!(params[1] instanceof SSLConfig)) {
                throw new SecurityException("Param[1] must be SSLConfig");
            }
            SSLConfig sslConfig = (SSLConfig)params[1];
            return new SSLSocketFactory(requestInfo, sslConfig);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    @Override
    public String getPrefixKey() {
        return "SSLSocketFactory ";
    }
}

