/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.KeystoreConstants;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;

public class MerlinProvider
extends Merlin {
    private static boolean useBouncyCastleProvider = false;
    private org.openspcoop2.utils.certificate.KeyStore op2KeyStore;
    private org.openspcoop2.utils.certificate.KeyStore op2TrustStore;
    private Boolean useBouncyCastleProviderDirective = null;
    private static final String TRUST_STORE_REF = "truststore";
    private static final String KEY_STORE_REF = "keystore";
    public static final String SUFFIX_BYOK = ".byok";
    public static final String X509_CRL_FILE_VALIDATE_ONLY_END_ENTITY = "x509crl.file.validateOnlyEndEntity";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public static boolean isUseBouncyCastleProvider() {
        return useBouncyCastleProvider;
    }

    public static void setUseBouncyCastleProvider(boolean useBouncyCastleProvider) {
        MerlinProvider.useBouncyCastleProvider = useBouncyCastleProvider;
    }

    public MerlinProvider() {
    }

    public MerlinProvider(Properties properties, ClassLoader loader, PasswordEncryptor passwordEncryptor) throws WSSecurityException, IOException {
        super(properties, loader, passwordEncryptor);
    }

    public org.openspcoop2.utils.certificate.KeyStore getOp2KeyStore() {
        return this.op2KeyStore;
    }

    public org.openspcoop2.utils.certificate.KeyStore getOp2TrustStore() {
        return this.op2TrustStore;
    }

    public static String readPrefix(Properties properties) {
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            String propKey = (String)key;
            if (propKey.startsWith("org.apache.wss4j.crypto.merlin.")) {
                return "org.apache.wss4j.crypto.merlin.";
            }
            if (!propKey.startsWith("org.apache.ws.security.crypto.merlin.")) continue;
            return "org.apache.ws.security.crypto.merlin.";
        }
        return "org.apache.wss4j.crypto.merlin.";
    }

    private String getError(String tipoStore, String location) {
        if (location != null) {
            return "Accesso al " + tipoStore + " '" + location + "' non riuscito";
        }
        return "Accesso al " + tipoStore + " non riuscito";
    }

    public void loadProperties(Properties properties, ClassLoader loader, PasswordEncryptor passwordEncryptor) throws WSSecurityException, IOException {
        String crlLocations;
        MerlinTruststore merlinTs;
        String trustStoreType;
        String trustStorePassword;
        String keyStoreType;
        String keyStorePassword;
        String keyStoreLocation;
        if (properties == null) {
            return;
        }
        this.properties = properties;
        this.passwordEncryptor = passwordEncryptor;
        String prefix = MerlinProvider.readPrefix(properties);
        RequestInfo requestInfo = null;
        Object requestInfoObject = properties.get("requestInfo");
        if (requestInfoObject instanceof RequestInfo) {
            requestInfo = (RequestInfo)requestInfoObject;
        }
        if ((keyStoreLocation = properties.getProperty(prefix + "keystore.file")) == null) {
            keyStoreLocation = properties.getProperty(prefix + "file");
        }
        Object keyStoreArchiveObject = properties.get(prefix + KEY_STORE_REF);
        byte[] keyStoreArchive = null;
        if (keyStoreArchiveObject instanceof byte[]) {
            keyStoreArchive = (byte[])keyStoreArchiveObject;
        }
        if ((keyStorePassword = properties.getProperty(prefix + "keystore.password")) != null) {
            keyStorePassword = keyStorePassword.trim();
            keyStorePassword = this.decryptPassword(keyStorePassword, passwordEncryptor);
        }
        if ((keyStoreType = properties.getProperty(prefix + "keystore.type", KeyStore.getDefaultType())) != null) {
            keyStoreType = keyStoreType.trim();
        }
        if (keyStoreLocation != null) {
            String keyStoreByokPolicy = properties.getProperty(prefix + "keystore.file.byok");
            BYOKRequestParams byokParams = null;
            if (keyStoreByokPolicy == null) {
                keyStoreByokPolicy = properties.getProperty(prefix + "file.byok");
            }
            if (keyStoreByokPolicy != null && BYOKProvider.isPolicyDefined((String)(keyStoreByokPolicy = keyStoreByokPolicy.trim()))) {
                try {
                    byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)keyStoreByokPolicy, requestInfo != null && requestInfo.getDynamicMap() != null ? requestInfo.getDynamicMap() : new HashMap());
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.properties.remove(prefix + "keystore.file");
            this.properties.remove(prefix + "file");
            String privatePasswd = properties.getProperty(prefix + "keystore.private.password");
            if (privatePasswd != null) {
                this.privatePasswordSet = true;
            }
            keyStoreLocation = keyStoreLocation.trim();
            try {
                MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore(requestInfo, keyStoreLocation, keyStoreType, keyStorePassword, byokParams);
                if (merlinKs == null) {
                    throw new IOException(this.getError(KEY_STORE_REF, keyStoreLocation));
                }
                if (merlinKs.getKeyStore() == null) {
                    throw new IOException(this.getError(KEY_STORE_REF, keyStoreLocation));
                }
                this.op2KeyStore = merlinKs.getKeyStore();
                this.keystore = this.op2KeyStore.getKeystore();
            }
            catch (Exception e) {
                throw new IOException("[Keystore-File] '" + keyStoreLocation + "' " + e.getMessage(), e);
            }
        }
        if (keyStoreArchive != null) {
            try {
                MerlinKeystore merlinKs = GestoreKeystoreCache.getMerlinKeystore(requestInfo, keyStoreArchive, keyStoreType, keyStorePassword);
                if (merlinKs == null) {
                    throw new IOException(this.getError(KEY_STORE_REF, null));
                }
                if (merlinKs.getKeyStore() == null) {
                    throw new IOException(this.getError(KEY_STORE_REF, null));
                }
                this.op2KeyStore = merlinKs.getKeyStore();
                this.keystore = this.op2KeyStore.getKeystore();
            }
            catch (Exception e) {
                throw new IOException("[Keystore-Archive] " + e.getMessage(), e);
            }
        }
        String trustStoreLocation = properties.getProperty(prefix + "truststore.file");
        Object trustStoreArchiveObject = properties.get(prefix + TRUST_STORE_REF);
        byte[] trustStoreArchive = null;
        if (trustStoreArchiveObject instanceof byte[]) {
            trustStoreArchive = (byte[])trustStoreArchiveObject;
        }
        if ((trustStorePassword = properties.getProperty(prefix + "truststore.password")) != null) {
            trustStorePassword = trustStorePassword.trim();
            trustStorePassword = this.decryptPassword(trustStorePassword, passwordEncryptor);
        }
        if ((trustStoreType = properties.getProperty(prefix + "truststore.type", KeyStore.getDefaultType())) != null) {
            trustStoreType = trustStoreType.trim();
        }
        if (trustStoreLocation != null) {
            this.properties.remove(prefix + "truststore.file");
            this.loadCACerts = false;
            trustStoreLocation = trustStoreLocation.trim();
            try {
                merlinTs = GestoreKeystoreCache.getMerlinTruststore(requestInfo, trustStoreLocation, trustStoreType, trustStorePassword);
                if (merlinTs == null) {
                    throw new IOException(this.getError(TRUST_STORE_REF, trustStoreLocation));
                }
                if (merlinTs.getTrustStore() == null) {
                    throw new IOException(this.getError(TRUST_STORE_REF, trustStoreLocation));
                }
                this.op2TrustStore = merlinTs.getTrustStore();
                this.truststore = this.op2TrustStore.getKeystore();
            }
            catch (Exception e) {
                throw new IOException("[Truststore-File] '" + trustStoreLocation + "' " + e.getMessage(), e);
            }
        }
        if (trustStoreArchive != null) {
            try {
                merlinTs = GestoreKeystoreCache.getMerlinTruststore(requestInfo, trustStoreArchive, trustStoreType, trustStorePassword);
                if (merlinTs == null) {
                    throw new IOException(this.getError(TRUST_STORE_REF, null));
                }
                if (merlinTs.getTrustStore() == null) {
                    throw new IOException(this.getError(TRUST_STORE_REF, null));
                }
                this.op2TrustStore = merlinTs.getTrustStore();
                this.truststore = this.op2TrustStore.getKeystore();
            }
            catch (Exception e) {
                throw new IOException("[Truststore-Archive] " + e.getMessage(), e);
            }
        }
        if (this.truststore != null) {
            properties.remove(prefix + "load.cacerts");
            properties.setProperty(prefix + "load.cacerts", FALSE);
        }
        if ((crlLocations = properties.getProperty(prefix + "x509crl.file")) != null) {
            String validateOnlyEndEntity;
            this.properties.remove(prefix + "x509crl.file");
            CRLCertstore crlCertstore = null;
            try {
                crlCertstore = GestoreKeystoreCache.getCRLCertstore(requestInfo, crlLocations);
                if (crlCertstore == null) {
                    throw new IOException("Accesso alle crl '" + crlLocations + "' non riuscito");
                }
                this.crlCertStore = crlCertstore.getCertStore();
            }
            catch (Exception e) {
                throw new IOException("[CRLCertstore] " + e.getMessage(), e);
            }
            String useBouncyCastleProviderProperty = properties.getProperty(prefix + "useBouncyCastleProvider");
            if (useBouncyCastleProviderProperty != null) {
                if (TRUE.equalsIgnoreCase(useBouncyCastleProviderProperty.trim())) {
                    this.useBouncyCastleProviderDirective = true;
                } else if (FALSE.equalsIgnoreCase(useBouncyCastleProviderProperty.trim())) {
                    this.useBouncyCastleProviderDirective = false;
                }
            }
            if ((validateOnlyEndEntity = properties.getProperty(prefix + X509_CRL_FILE_VALIDATE_ONLY_END_ENTITY)) != null) {
                if (TRUE.equalsIgnoreCase(validateOnlyEndEntity.trim())) {
                    this.setValidateOnlyEndEntity(true);
                } else if (FALSE.equalsIgnoreCase(validateOnlyEndEntity.trim())) {
                    this.setValidateOnlyEndEntity(false);
                }
            } else if (crlCertstore != null && crlCertstore.getWrappedCRLCertStore() != null && crlCertstore.getWrappedCRLCertStore().countCrls() == 1) {
                this.setValidateOnlyEndEntity(true);
            }
        }
        super.loadProperties(properties, loader, passwordEncryptor);
    }

    public PrivateKey getPrivateKey(String alias, String password) throws WSSecurityException {
        if (this.op2KeyStore != null) {
            try {
                return this.op2KeyStore.getPrivateKey(alias, password);
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.SECURITY_ERROR, e);
            }
        }
        return super.getPrivateKey(alias, password);
    }

    public String getCryptoProvider() {
        boolean useBC;
        boolean bl = useBC = this.useBouncyCastleProviderDirective != null && this.useBouncyCastleProviderDirective != false || useBouncyCastleProvider;
        if (useBC) {
            if (this.truststore != null && this.truststore.getType() != null && this.truststore.getType().equalsIgnoreCase(KeystoreType.PKCS11.getNome())) {
                useBC = false;
            }
            if (this.keystore != null && this.keystore.getType() != null && this.keystore.getType().equalsIgnoreCase(KeystoreType.PKCS11.getNome())) {
                useBC = false;
            }
        }
        if (useBC) {
            return "BC";
        }
        return super.getCryptoProvider();
    }

    public static void correctProviderName(MessageSecurity messageSecurity) {
        if (messageSecurity != null) {
            MessageSecurityFlow request = messageSecurity.getRequestFlow();
            MerlinProvider.correctProviderNameRequestFlow(request);
            MessageSecurityFlow response = messageSecurity.getResponseFlow();
            MerlinProvider.correctProviderNameResponseFlow(response);
        }
    }

    private static void correctProviderNameRequestFlow(MessageSecurityFlow request) {
        if (request != null && request.sizeParameterList() > 0) {
            for (MessageSecurityFlowParameter param : request.getParameterList()) {
                if (param.getNome() == null || !param.getNome().trim().endsWith("org.apache.ws.security.crypto.provider") || param.getValore() == null || !"org.openspcoop2.security.keystore.Merlin".equals(param.getValore().trim())) continue;
                param.setValore(KeystoreConstants.PROVIDER_GOVWAY);
            }
        }
    }

    private static void correctProviderNameResponseFlow(MessageSecurityFlow response) {
        if (response != null && response.sizeParameterList() > 0) {
            for (MessageSecurityFlowParameter param : response.getParameterList()) {
                if (param.getNome() == null || !param.getNome().trim().endsWith("org.apache.ws.security.crypto.provider") || param.getValore() == null || !"org.openspcoop2.security.keystore.Merlin".equals(param.getValore().trim())) continue;
                param.setValore(KeystoreConstants.PROVIDER_GOVWAY);
            }
        }
    }
}

