/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertStore;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.utils.transport.http.HttpOptions;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;

public class HttpStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] storeBytes;
    private String endpoint;
    private Boolean trustAll = null;
    private MerlinTruststore trustStoreSsl = null;
    private CRLCertstore crlTrustStoreSsl = null;
    private int connectionTimeout = 10000;
    private int readTimeout = 120000;
    private HttpOptions[] options;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("HttpStore (").append(this.endpoint).append(")");
        if (this.trustAll != null) {
            bf.append(" ").append(this.trustAll);
        }
        if (this.trustStoreSsl != null) {
            bf.append(" ").append(this.trustStoreSsl.toString());
        }
        if (this.crlTrustStoreSsl != null) {
            bf.append(" ").append(this.crlTrustStoreSsl.getWrappedCRLCertStore() != null ? this.crlTrustStoreSsl.getWrappedCRLCertStore().toString() : this.crlTrustStoreSsl.toString());
        }
        if (this.options != null && this.options.length > 0) {
            for (HttpOptions httpOptions : this.options) {
                bf.append(" ").append(httpOptions.toString());
            }
        }
        return bf.toString();
    }

    public HttpStore(String endpoint, HttpOptions ... options) throws SecurityException {
        this(endpoint, (Integer)null, (Integer)null, (MerlinTruststore)null, (CRLCertstore)null, options);
    }

    public HttpStore(String endpoint, Integer connectionTimeout, Integer readTimeout, HttpOptions ... options) throws SecurityException {
        this(endpoint, connectionTimeout, readTimeout, (MerlinTruststore)null, (CRLCertstore)null, options);
    }

    public HttpStore(String endpoint, Integer connectionTimeout, Integer readTimeout, MerlinTruststore trustStoreSsl, HttpOptions ... options) throws SecurityException {
        this(endpoint, connectionTimeout, readTimeout, trustStoreSsl, (CRLCertstore)null, options);
    }

    public HttpStore(String endpoint, MerlinTruststore trustStoreSsl, HttpOptions ... options) throws SecurityException {
        this(endpoint, (Integer)null, (Integer)null, trustStoreSsl, (CRLCertstore)null, options);
    }

    public HttpStore(String endpoint, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl, HttpOptions ... options) throws SecurityException {
        this(endpoint, null, null, trustStoreSsl, crlTrustStoreSsl, options);
    }

    public HttpStore(String endpoint, Integer connectionTimeout, Integer readTimeout, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl, HttpOptions ... options) throws SecurityException {
        this(endpoint, connectionTimeout, readTimeout, null, trustStoreSsl, crlTrustStoreSsl, options);
    }

    public HttpStore(String endpoint, Boolean trustAll, HttpOptions ... options) throws SecurityException {
        this(endpoint, (Integer)null, (Integer)null, trustAll, (MerlinTruststore)null, (CRLCertstore)null, options);
    }

    public HttpStore(String endpoint, Integer connectionTimeout, Integer readTimeout, Boolean trustAll, HttpOptions ... options) throws SecurityException {
        this(endpoint, connectionTimeout, readTimeout, trustAll, (MerlinTruststore)null, (CRLCertstore)null, options);
    }

    private HttpStore(String endpoint, Integer connectionTimeout, Integer readTimeout, Boolean trustAll, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl, HttpOptions ... options) throws SecurityException {
        this.endpoint = endpoint;
        if (connectionTimeout != null) {
            this.connectionTimeout = connectionTimeout;
        }
        if (readTimeout != null) {
            this.readTimeout = readTimeout;
        }
        this.trustAll = trustAll;
        this.trustStoreSsl = trustStoreSsl;
        this.crlTrustStoreSsl = crlTrustStoreSsl;
        this.options = options;
        try {
            if (endpoint == null) {
                throw new SecurityException("Endpoint per lo Store non indicato");
            }
            HttpResponse httpResponse = null;
            httpResponse = this.endpoint.startsWith("https:") && this.trustStoreSsl == null && (this.trustAll == null || this.trustAll == false) || this.endpoint.startsWith("http:") ? HttpUtilities.getHTTPResponse((String)this.endpoint, (int)this.readTimeout, (int)this.connectionTimeout, (HttpOptions[])this.options) : (this.trustAll != null ? HttpUtilities.getHTTPSResponse_trustAllCerts((String)this.endpoint, (int)this.readTimeout, (int)this.connectionTimeout, (HttpOptions[])this.options) : HttpUtilities.getHTTPSResponse((String)this.endpoint, (int)this.readTimeout, (int)this.connectionTimeout, (KeyStore)this.trustStoreSsl.getTrustStore().getKeystore(), (CertStore)(this.crlTrustStoreSsl != null ? this.crlTrustStoreSsl.getCertStore() : null), (HttpOptions[])this.options));
            if (httpResponse == null || httpResponse.getContent() == null) {
                throw new SecurityException("Store '" + this.endpoint + "' unavailable");
            }
            if (httpResponse.getResultHTTPOperation() != 200) {
                throw new SecurityException("Retrieve store '" + this.endpoint + "' failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
            }
            this.storeBytes = httpResponse.getContent();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public byte[] getStoreBytes() {
        return this.storeBytes;
    }
}

