/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.validator;

import jakarta.xml.soap.SOAPHeader;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.ProprietaManifestAttachments;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSintattica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSintatticaResult;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class ValidazioneSintattica {
    protected OpenSPCoop2Message msg;
    protected SOAPHeader headerSOAP = null;
    protected BustaRawContent<?> headerProtocollo;
    protected List<Eccezione> erroriValidazione;
    protected List<Eccezione> erroriProcessamento;
    private String erroreProcessamento_internalMessage;
    protected List<Eccezione> errorsTrovatiSullaListaEccezioni;
    protected Busta busta;
    protected Boolean isRichiesta;
    protected ErroreCooperazione errore;
    protected IntegrationFunctionError errore_integrationFunctionError;
    protected boolean readQualifiedAttribute;
    protected Logger log = null;
    protected boolean segnalazioneElementoPresentePiuVolte = false;
    private IProtocolFactory<?> protocolFactory;
    private IProtocolManager protocolManager;
    protected boolean messaggioScaduto = false;
    protected Busta bustaErroreHeaderIntestazione = null;
    private IState state;
    private Context context;

    public BustaRawContent<?> getProtocolHeader() {
        return this.headerProtocollo;
    }

    public void setHeaderSOAP(SOAPHeader headerSOAP) {
        this.headerSOAP = headerSOAP;
    }

    public Busta getBustaErroreHeaderIntestazione() {
        return this.bustaErroreHeaderIntestazione;
    }

    public ValidazioneSintattica(Context context, IState state, OpenSPCoop2Message aMsg, boolean readQualifiedAttribute, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(context, state, aMsg, Configurazione.getLibraryLog(), readQualifiedAttribute, protocolFactory);
    }

    public ValidazioneSintattica(Context context, IState state, OpenSPCoop2Message aMsg, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(context, state, aMsg, Configurazione.getLibraryLog(), false, protocolFactory);
    }

    public ValidazioneSintattica(Context context, IState state, OpenSPCoop2Message aMsg, Logger alog, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(context, state, aMsg, alog, false, protocolFactory);
    }

    public ValidazioneSintattica(Context context, IState state, OpenSPCoop2Message aMsg, Busta busta, Boolean isRichiesta, Logger alog, boolean readQualifiedAttribute, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this(context, state, aMsg, alog, readQualifiedAttribute, protocolFactory);
        this.busta = busta;
        this.isRichiesta = isRichiesta;
    }

    public ValidazioneSintattica(Context context, IState state, OpenSPCoop2Message aMsg, Logger alog, boolean readQualifiedAttribute, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.state = state;
        this.context = context;
        this.msg = aMsg;
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger((String)ValidazioneSintattica.class.getName());
        this.readQualifiedAttribute = readQualifiedAttribute;
        this.protocolFactory = protocolFactory;
        this.protocolManager = this.protocolFactory.createProtocolManager();
    }

    public void updateMsg(OpenSPCoop2Message msg) throws ProtocolException {
        boolean update;
        String msgClassName = msg.getClass().getName();
        boolean bl = update = !msgClassName.equals(this.msg.getClass().getName());
        if (update) {
            this.msg = msg;
            if (this.headerProtocollo != null) {
                IValidazioneSintattica validazioneSintattica = this.protocolFactory.createValidazioneSintattica(this.state);
                this.headerProtocollo = validazioneSintattica.getBustaRawContent_senzaControlli(this.msg);
            }
        }
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public List<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public List<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public String getErroreProcessamento_internalMessage() {
        return this.erroreProcessamento_internalMessage;
    }

    public List<Eccezione> getErroriTrovatiSullaListaEccezioni() {
        return this.errorsTrovatiSullaListaEccezioni;
    }

    public ErroreCooperazione getErrore() {
        return this.errore;
    }

    public IntegrationFunctionError getErrore_integrationFunctionError() {
        return this.errore_integrationFunctionError;
    }

    public boolean valida() {
        ValidazioneSintatticaResult result = null;
        IValidazioneSintattica validazioneSintattica = null;
        boolean protocolException = false;
        try {
            validazioneSintattica = this.protocolFactory.createValidazioneSintattica(this.state);
            validazioneSintattica.setContext(this.context);
            ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
            pValidazioneErrori.setIgnoraEccezioniNonGravi(this.protocolManager.isIgnoraEccezioniNonGravi());
            result = this.isRichiesta == null || this.isRichiesta.booleanValue() ? validazioneSintattica.validaRichiesta(this.msg, this.busta, pValidazioneErrori) : validazioneSintattica.validaRisposta(this.msg, this.busta, pValidazioneErrori);
        }
        catch (ProtocolException e) {
            protocolException = true;
        }
        if (result != null) {
            if (result.getBusta() != null) {
                this.busta = result.getBusta();
            }
            if (result.getBustaErrore() != null) {
                this.bustaErroreHeaderIntestazione = result.getBustaErrore();
            }
            this.errore = result.getErrore();
            this.errore_integrationFunctionError = result.getErrore_integrationFunctionError();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new ArrayList<Eccezione>();
            }
            this.erroreProcessamento_internalMessage = result.getErroreProcessamento_internalMessage();
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new ArrayList<Eccezione>();
            }
            this.errorsTrovatiSullaListaEccezioni = result.getErrorsTrovatiSullaListaEccezioni();
            if (this.errorsTrovatiSullaListaEccezioni == null) {
                this.errorsTrovatiSullaListaEccezioni = new ArrayList<Eccezione>();
            }
            if (result.getBustaRawContent() != null) {
                this.headerProtocollo = result.getBustaRawContent();
            }
            return result.isValido();
        }
        if (protocolException) {
            this.errore_integrationFunctionError = this.isRichiesta == null || this.isRichiesta != false ? IntegrationFunctionError.INTERNAL_REQUEST_ERROR : IntegrationFunctionError.INTERNAL_RESPONSE_ERROR;
        }
        return false;
    }

    public boolean verifyProtocolPresence(TipoPdD tipoPdD, ProfiloDiCollaborazione profilo, RuoloMessaggio ruoloMessaggio) throws Exception {
        return this.protocolFactory.createValidazioneSintattica(this.state).verifyProtocolPresence(tipoPdD, profilo, ruoloMessaggio, this.msg);
    }

    public void validazioneFault(OpenSPCoop2Message msg) throws ProtocolException {
        ValidazioneSintatticaResult result = this.protocolFactory.createValidazioneSintattica(this.state).validazioneFault(msg);
        if (result != null) {
            if (result.getBusta() != null) {
                this.busta = result.getBusta();
            }
            if (result.getBustaErrore() != null) {
                this.bustaErroreHeaderIntestazione = result.getBustaErrore();
            }
            this.errore = result.getErrore();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new ArrayList<Eccezione>();
            }
            this.erroreProcessamento_internalMessage = result.getErroreProcessamento_internalMessage();
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new ArrayList<Eccezione>();
            }
            this.errorsTrovatiSullaListaEccezioni = result.getErrorsTrovatiSullaListaEccezioni();
            if (this.errorsTrovatiSullaListaEccezioni == null) {
                this.errorsTrovatiSullaListaEccezioni = new ArrayList<Eccezione>();
            }
            if (result.getBustaRawContent() != null) {
                this.headerProtocollo = result.getBustaRawContent();
            }
        }
    }

    public void validazioneManifestAttachments(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        ValidazioneSintatticaResult result = this.protocolFactory.createValidazioneSintattica(this.state).validazioneManifestAttachments(msg, proprietaManifestAttachments);
        if (result != null) {
            if (result.getBusta() != null) {
                this.busta = result.getBusta();
            }
            if (result.getBustaErrore() != null) {
                this.bustaErroreHeaderIntestazione = result.getBustaErrore();
            }
            this.errore = result.getErrore();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new ArrayList<Eccezione>();
            }
            this.erroreProcessamento_internalMessage = result.getErroreProcessamento_internalMessage();
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new ArrayList<Eccezione>();
            }
            this.errorsTrovatiSullaListaEccezioni = result.getErrorsTrovatiSullaListaEccezioni();
            if (this.errorsTrovatiSullaListaEccezioni == null) {
                this.errorsTrovatiSullaListaEccezioni = new ArrayList<Eccezione>();
            }
            if (result.getBustaRawContent() != null) {
                this.headerProtocollo = result.getBustaRawContent();
            }
        }
    }

    public BustaRawContent<?> getHeaderProtocollo_senzaControlli() throws ProtocolException {
        return this.protocolFactory.createValidazioneSintattica(this.state).getBustaRawContent_senzaControlli(this.msg);
    }
}

