/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.validator;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.driver.ConsegnaInOrdine;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.state.StatelessMessage;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSemanticaResult;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class ValidazioneSemantica {
    protected IState state;
    protected Context context;
    protected List<Eccezione> erroriValidazione;
    protected List<Eccezione> erroriProcessamento;
    protected IntegrationFunctionError errore_integrationFunctionError;
    protected Busta busta;
    protected boolean validazioneIdentificativiCompleta = false;
    protected String servizioCorrelato;
    protected String tipoServizioCorrelato;
    protected Integer versioneServizioCorrelato;
    protected String azioneCorrelata;
    protected RegistroServiziManager registroServiziReader;
    protected Servizio infoServizio = null;
    protected Logger log = null;
    private IProtocolFactory<?> protocolFactory;

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    public ValidazioneSemantica(Busta aBusta, Context context, IState state, boolean validazioneIdentificativiCompleta, IProtocolFactory<?> protocolFactory) {
        this(aBusta, context, state, validazioneIdentificativiCompleta, Configurazione.getLibraryLog(), protocolFactory);
    }

    public ValidazioneSemantica(Busta aBusta, Context context, IState state, boolean validazioneIdentificativiCompleta, Logger alog, IProtocolFactory<?> protocolFactory) {
        this.busta = aBusta;
        this.context = context;
        this.state = state;
        this.registroServiziReader = RegistroServiziManager.getInstance((IState)state);
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(ValidazioneSemantica.class);
        this.validazioneIdentificativiCompleta = validazioneIdentificativiCompleta;
        this.protocolFactory = protocolFactory;
    }

    public List<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public List<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public IntegrationFunctionError getErrore_integrationFunctionError() {
        return this.errore_integrationFunctionError;
    }

    public void valida(OpenSPCoop2Message msg, ProprietaValidazione proprietaValidazione, RuoloBusta tipoBusta, String versioneProtocollo, RequestInfo requestInfo) throws ProtocolException {
        try {
            IProtocolVersionManager protocolVersioneManager;
            StatoFunzionalitaProtocollo modalitaGestioneCollaborazione;
            proprietaValidazione.setValidazioneIDCompleta(this.validazioneIdentificativiCompleta);
            proprietaValidazione.setVersioneProtocollo(versioneProtocollo);
            IValidazioneSemantica validazioneSemantica = this.protocolFactory.createValidazioneSemantica(this.state);
            validazioneSemantica.setContext(this.context);
            ValidazioneSemanticaResult result = validazioneSemantica.valida(msg, this.busta, proprietaValidazione, tipoBusta);
            this.infoServizio = result.getInfoServizio();
            this.servizioCorrelato = result.getServizioCorrelato();
            this.tipoServizioCorrelato = result.getTipoServizioCorrelato();
            this.versioneServizioCorrelato = result.getVersioneServizioCorrelato();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new ArrayList<Eccezione>();
            }
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new ArrayList<Eccezione>();
            }
            this.errore_integrationFunctionError = result.getErrore_integrationFunctionError();
            if (this.erroriValidazione.size() == 0 && this.erroriProcessamento.size() == 0 && this.busta != null && !RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString()) && !RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
                this.validazioneCorrelazione(tipoBusta);
            }
            if (this.erroriValidazione.size() == 0 && this.erroriProcessamento.size() == 0 && this.busta != null && this.busta.getRiferimentoMessaggio() != null) {
                this.validazioneRiferimentoMessaggio(tipoBusta);
            }
            if (this.erroriValidazione.size() == 0 && this.erroriProcessamento.size() == 0 && this.busta != null && this.busta.getProfiloDiCollaborazione() != null && !RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString()) && (StatoFunzionalitaProtocollo.ABILITATA.equals((Object)(modalitaGestioneCollaborazione = (protocolVersioneManager = this.protocolFactory.createProtocolVersionManager(versioneProtocollo)).getCollaborazione(this.busta))) || StatoFunzionalitaProtocollo.REGISTRO.equals((Object)modalitaGestioneCollaborazione) && this.infoServizio != null && this.infoServizio.getCollaborazione())) {
                this.riconoscimentoCollaborazione(tipoBusta, requestInfo);
            }
        }
        catch (ProtocolException e) {
            this.log.error("ProtocolException error", (Throwable)e);
            throw e;
        }
    }

    public static String riconoscimentoVersioneProtocolloServizioErogato(Busta busta, ITraduttore costanti, RuoloBusta tipoBusta, IState state, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto idSoggettoFruitoreProfiloGestito = null;
        if (busta.getTipoServizio() != null && busta.getServizio() != null) {
            IDSoggetto idSoggettoErogatoreProfiloGestito = null;
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)busta.getProfiloDiCollaborazione()) && RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                idSoggettoErogatoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && !RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
                    idSoggettoErogatoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    idSoggettoErogatoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                } else {
                    idSoggettoErogatoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString()))) {
                idSoggettoErogatoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            } else {
                idSoggettoErogatoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            }
            IDServizio idServizioProfiloGestito = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), idSoggettoErogatoreProfiloGestito, busta.getVersioneServizio().intValue());
            idServizioProfiloGestito.setAzione(busta.getAzione());
            return RegistroServiziManager.getInstance((IState)state).getProfiloGestioneErogazioneServizio(idSoggettoFruitoreProfiloGestito, idServizioProfiloGestito, null, requestInfo);
        }
        idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
        return RegistroServiziManager.getInstance((IState)state).getProfiloGestioneSoggetto(idSoggettoFruitoreProfiloGestito, null, requestInfo);
    }

    public static RuoloBusta getTipoBustaDaValidare(ServiceBinding serviceBinding, Busta busta, IProtocolFactory<?> protocolFactory, boolean rispostaConnectionReply, IState state, Logger log) throws ProtocolException {
        RuoloBusta tipo = RuoloBusta.BUSTA_DI_SERVIZIO;
        if (busta.getProfiloDiCollaborazione() == null || busta.getServizio() == null || busta.getTipoServizio() == null) {
            tipo = RuoloBusta.BUSTA_DI_SERVIZIO;
        } else if (busta.getProfiloDiCollaborazione().equals((Object)org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY) && busta.getRiferimentoMessaggio() != null) {
            tipo = protocolFactory.createProtocolConfiguration().isSupportato(serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA) ? RuoloBusta.RICHIESTA : RuoloBusta.BUSTA_DI_SERVIZIO;
        } else if (busta.getProfiloDiCollaborazione().equals((Object)org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY)) {
            tipo = RuoloBusta.RICHIESTA;
        } else if (busta.getProfiloDiCollaborazione().equals((Object)org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO)) {
            tipo = busta.getRiferimentoMessaggio() == null ? RuoloBusta.RICHIESTA : (rispostaConnectionReply ? RuoloBusta.RISPOSTA : (protocolFactory.createProtocolConfiguration().isSupportato(serviceBinding, FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA) ? RuoloBusta.RICHIESTA : RuoloBusta.RISPOSTA));
        } else if (busta.getProfiloDiCollaborazione().equals((Object)org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO) || busta.getProfiloDiCollaborazione().equals((Object)org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
            ProfiloDiCollaborazione profilo;
            tipo = busta.getRiferimentoMessaggio() == null && busta.getCollaborazione() == null ? RuoloBusta.RICHIESTA : ((profilo = new ProfiloDiCollaborazione(state, log, protocolFactory)).asincrono_isRicevutaRichiesta(busta.getRiferimentoMessaggio()) ? RuoloBusta.RICEVUTA_RICHIESTA : (profilo.asincrono_isRicevutaRisposta(busta.getRiferimentoMessaggio()) ? RuoloBusta.RICEVUTA_RISPOSTA : (!rispostaConnectionReply && profilo.asincrono_isRisposta(busta) ? RuoloBusta.RISPOSTA : RuoloBusta.RICHIESTA)));
        }
        return tipo;
    }

    public boolean validazioneID(String id) throws ProtocolException {
        return this.validazioneID(id, null, null, null);
    }

    private boolean validazioneID(String id, String tipoCodAmm, String codAmm, String codDominio) throws ProtocolException {
        ProprietaValidazione proprietaValidazione = new ProprietaValidazione();
        proprietaValidazione.setValidazioneIDCompleta(this.validazioneIdentificativiCompleta);
        IDSoggetto dominio = new IDSoggetto(tipoCodAmm, codAmm, codDominio);
        return this.protocolFactory.createValidazioneSemantica(this.state).validazioneID(id, dominio, proprietaValidazione);
    }

    private void validazioneRiferimentoMessaggio(RuoloBusta tipoBusta) throws ProtocolException {
        if (this.state == null && RuoloBusta.RICHIESTA.equals((Object)tipoBusta) && this.busta != null && (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)this.busta.getProfiloDiCollaborazione()) || org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)this.busta.getProfiloDiCollaborazione()))) {
            return;
        }
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione((IState)stateful, this.log, this.protocolFactory);
            boolean error = false;
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString()) && !profiloDiCollaborazione.sincrono_validazioneRiferimentoMessaggio(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                if (!profiloDiCollaborazione.asincronoSimmetrico_validazioneRiferimentoMessaggio(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneRiferimentoMessaggio_richiestaStato(this.busta.getRiferimentoMessaggio())) {
                        error = true;
                    }
                } else if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneRiferimentoMessaggio_ricevuta(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            }
            if (error) {
                Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), this.protocolFactory);
                this.erroriValidazione.add(ecc);
            }
        } else if (this.state instanceof StatelessMessage) {
            StatelessMessage stateless;
            Busta bustaCorrelata;
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)this.busta.getProfiloDiCollaborazione()) && (bustaCorrelata = (stateless = (StatelessMessage)this.state).getBustaCorrelata()) != null && this.busta.getRiferimentoMessaggio() != null && !this.busta.getRiferimentoMessaggio().equals(bustaCorrelata.getID())) {
                Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), this.protocolFactory);
                this.erroriValidazione.add(ecc);
            }
        } else {
            throw new ProtocolException("Metodo invocato con IState non valido");
        }
    }

    private void riconoscimentoCollaborazione(RuoloBusta tipoBusta, RequestInfo requestInfo) throws ProtocolException {
        IDSoggetto soggMitt = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
        String dominioMittente = null;
        try {
            dominioMittente = this.registroServiziReader.getDominio(soggMitt, null, this.protocolFactory, requestInfo);
            if (dominioMittente == null) {
                throw new Exception("Dominio non definito");
            }
        }
        catch (DriverRegistroServiziNotFound es) {
            Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.MITTENTE_SCONOSCIUTO.getErroreCooperazione(), this.protocolFactory);
            this.log.debug("Identificazione mittente fallita:" + es.getMessage());
            this.erroriValidazione.add(ecc);
            return;
        }
        catch (Exception es) {
            Eccezione ecc = Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Identificazione mittente non riuscita: errore di processamento"), this.protocolFactory);
            this.log.error("Identificazione mittente non riuscita", (Throwable)es);
            this.erroriProcessamento.add(ecc);
            return;
        }
        IDSoggetto soggDest = new IDSoggetto(this.busta.getTipoDestinatario(), this.busta.getDestinatario());
        String dominioDestinatario = null;
        try {
            dominioDestinatario = this.registroServiziReader.getDominio(soggDest, null, this.protocolFactory, requestInfo);
            if (dominioDestinatario == null) {
                throw new Exception("Dominio non definito");
            }
        }
        catch (DriverRegistroServiziNotFound es) {
            Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.DESTINATARIO_SCONOSCIUTO.getErroreCooperazione(), this.protocolFactory);
            this.log.debug("Identificazione destinatario fallita: " + es.getMessage());
            this.erroriValidazione.add(ecc);
            return;
        }
        catch (Exception es) {
            Eccezione ecc = Eccezione.getEccezioneProcessamento((ErroreCooperazione)ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Identificazione destinatario non riuscita: errore di processamento"), this.protocolFactory);
            this.log.error("Identificazione destinatario non riuscita", (Throwable)es);
            this.erroriProcessamento.add(ecc);
            return;
        }
        if (this.busta.getCollaborazione() != null && !this.validazioneID(this.busta.getCollaborazione(), this.busta.getTipoMittente(), this.busta.getMittente(), dominioMittente) && !this.validazioneID(this.busta.getCollaborazione(), this.busta.getTipoDestinatario(), this.busta.getDestinatario(), dominioDestinatario)) {
            Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.COLLABORAZIONE_NON_VALIDA.getErroreCooperazione(), this.protocolFactory);
            this.erroriValidazione.add(ecc);
            return;
        }
        boolean validaIdCollaborazioneProfiliNonOneway = false;
        boolean validaIdCollaborazioneConsegnaInOrdine = false;
        if (!org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)this.busta.getProfiloDiCollaborazione())) {
            validaIdCollaborazioneProfiliNonOneway = !tipoBusta.equals((Object)RuoloBusta.RICHIESTA);
        } else if (this.busta.getSequenza() != -1L && this.busta.getCollaborazione() != null) {
            validaIdCollaborazioneConsegnaInOrdine = true;
        }
        if (!validaIdCollaborazioneProfiliNonOneway && !validaIdCollaborazioneConsegnaInOrdine) {
            return;
        }
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            if (this.busta.getCollaborazione() != null) {
                ConsegnaInOrdine consegna;
                Eccezione ecc;
                ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione((IState)stateful, this.log, this.protocolFactory);
                boolean error = false;
                if (!org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                    if (!tipoBusta.equals((Object)RuoloBusta.RICHIESTA)) {
                        if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                            if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString()) && !profiloDiCollaborazione.sincrono_validazioneCollaborazione(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                            if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                                if (!profiloDiCollaborazione.asincronoSimmetrico_validazioneCollaborazione_risposta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                    error = true;
                                }
                            } else if ((RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) && !profiloDiCollaborazione.asincronoSimmetrico_validazioneCollaborazione_ricevuta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                            if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                                if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneCollaborazione_richiestaStato(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                    error = true;
                                }
                            } else if ((RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) && !profiloDiCollaborazione.asincronoAsimmetrico_validazioneCollaborazione_ricevuta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        }
                    }
                } else if (validaIdCollaborazioneConsegnaInOrdine && (ecc = (consegna = new ConsegnaInOrdine((IState)stateful, this.log, this.protocolFactory)).validazioneDatiConsegnaInOrdine(this.busta, this.protocolFactory)) != null) {
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (error) {
                    Eccezione ecc2 = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.COLLABORAZIONE_SCONOSCIUTA.getErroreCooperazione(), this.protocolFactory);
                    this.erroriValidazione.add(ecc2);
                    return;
                }
            }
            return;
        }
        if (this.state instanceof StatelessMessage) {
            ConsegnaInOrdine consegna;
            Eccezione ecc;
            StatelessMessage stateless = (StatelessMessage)this.state;
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals((Object)this.busta.getProfiloDiCollaborazione()) && validaIdCollaborazioneConsegnaInOrdine && (ecc = (consegna = new ConsegnaInOrdine((IState)stateless, this.log, this.protocolFactory)).validazioneDatiConsegnaInOrdine(this.busta, this.protocolFactory)) != null) {
                this.erroriValidazione.add(ecc);
                return;
            }
            return;
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    private void validazioneCorrelazione(RuoloBusta tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione((IState)stateful, this.log, this.protocolFactory);
            Eccezione ecc = null;
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.sincrono_validazioneCorrelazione(this.busta, this.protocolFactory);
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_ricevutaRichiesta(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_risposta(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_ricevutaRisposta(this.busta, this.protocolFactory);
                }
            } else if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiesta(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_richiestaStato(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiestaStato(this.busta, this.protocolFactory);
                }
            }
            if (ecc != null) {
                this.erroriValidazione.add(ecc);
                return;
            }
        } else if (this.state instanceof StatelessMessage) {
            StatelessMessage stateless;
            Busta bustaCorrelata;
            if (org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals((Object)this.busta.getProfiloDiCollaborazione()) && (bustaCorrelata = (stateless = (StatelessMessage)this.state).getBustaCorrelata()) != null) {
                if (!this.busta.getTipoDestinatario().equals(bustaCorrelata.getTipoMittente())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione("Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (!this.busta.getDestinatario().equals(bustaCorrelata.getMittente())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.MITTENTE_NON_VALIDO.getErroreCooperazione("Mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (!this.busta.getTipoMittente().equals(bustaCorrelata.getTipoDestinatario())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione("Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (!this.busta.getMittente().equals(bustaCorrelata.getDestinatario())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.DESTINATARIO_NON_VALIDO.getErroreCooperazione("Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (this.busta.getServizio() != null && bustaCorrelata.getTipoServizio() != null) {
                    if (!this.busta.getTipoServizio().equals(bustaCorrelata.getTipoServizio())) {
                        Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione("Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                    if (!this.busta.getServizio().equals(bustaCorrelata.getServizio())) {
                        Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione("Servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                    if (this.busta.getAzione() != null && !this.busta.getAzione().equals(bustaCorrelata.getAzione())) {
                        Eccezione ecc = Eccezione.getEccezioneValidazione((ErroreCooperazione)ErroriCooperazione.AZIONE_NON_VALIDA.getErroreCooperazione("Azione diversa da quella atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                }
            }
        } else {
            throw new ProtocolException("Metodo invocato con IState non valido");
        }
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public Integer getVersioneServizioCorrelato() {
        return this.versioneServizioCorrelato;
    }

    public Servizio getInfoServizio() {
        return this.infoServizio;
    }

    public String getAzioneCorrelata() {
        return this.azioneCorrelata;
    }

    public void setAzioneCorrelata(String azioneCorrelata) {
        this.azioneCorrelata = azioneCorrelata;
    }

    public void setValidazioneIdentificativiCompleta(boolean v) {
        this.validazioneIdentificativiCompleta = v;
    }
}

