/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class NamingUtils {
    public static final String LABEL_DOMINIO = "@";

    private NamingUtils() {
    }

    public static List<String> getLabelsProtocolli(List<String> protocolli) throws ProtocolException {
        ArrayList<String> l = null;
        if (protocolli == null || protocolli.isEmpty()) {
            return l;
        }
        l = new ArrayList<String>();
        for (String protocollo : protocolli) {
            l.add(NamingUtils.getLabelProtocollo(protocollo));
        }
        return l;
    }

    public static String getLabelProtocollo(String protocollo) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        return protocolFactoryManager.getProtocolFactoryByName(protocollo).getInformazioniProtocol().getLabel();
    }

    public static String getDescrizioneProtocollo(String protocollo) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        return protocolFactoryManager.getProtocolFactoryByName(protocollo).getInformazioniProtocol().getDescription();
    }

    public static String getWebSiteProtocollo(String protocollo) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        return protocolFactoryManager.getProtocolFactoryByName(protocollo).getInformazioniProtocol().getWebSite();
    }

    public static String getLabelSoggetto(IDSoggetto idSoggetto) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(idSoggetto.getTipo());
        return NamingUtils.getLabelSoggetto(protocollo, idSoggetto.getTipo(), idSoggetto.getNome());
    }

    public static String getLabelSoggetto(String protocollo, IDSoggetto idSoggetto) throws ProtocolException {
        return NamingUtils.getLabelSoggetto(protocollo, idSoggetto.getTipo(), idSoggetto.getNome());
    }

    public static String getLabelSoggetto(String protocollo, String tipoSoggetto, String nomeSoggetto) throws ProtocolException {
        StringBuilder bf = new StringBuilder();
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        if (((List)protocolFactoryManager.getOrganizationTypes().get((Object)protocollo)).size() > 1) {
            IProtocolFactory<?> protocolFactory = protocolFactoryManager.getProtocolFactoryByName(protocollo);
            if (tipoSoggetto.equals(protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault())) {
                bf.append(nomeSoggetto);
            } else {
                bf.append(tipoSoggetto).append("/").append(nomeSoggetto);
            }
        } else {
            bf.append(nomeSoggetto);
        }
        return bf.toString();
    }

    public static IDSoggetto getSoggettoFromLabel(String protocollo, String labelSoggetto) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        IProtocolFactory<?> protocolFactory = protocolFactoryManager.getProtocolFactoryByName(protocollo);
        String tipoSoggettoDefault = protocolFactory.createProtocolConfiguration().getTipoSoggettoDefault();
        String tipo = null;
        String nome = null;
        if (labelSoggetto.contains("/")) {
            String[] tmp = labelSoggetto.split("/");
            tipo = tmp[0];
            nome = tmp[1];
        } else {
            tipo = tipoSoggettoDefault;
            nome = labelSoggetto;
        }
        return new IDSoggetto(tipo, nome);
    }

    public static String getLabelServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
        return NamingUtils.getLabelServizioApplicativo(protocollo, idServizioApplicativo);
    }

    public static String getLabelServizioApplicativo(String protocollo, IDServizioApplicativo idServizioApplicativo) throws ProtocolException {
        StringBuilder bf = new StringBuilder();
        bf.append(idServizioApplicativo.getNome());
        bf.append(" (");
        bf.append(NamingUtils.getLabelSoggetto(protocollo, idServizioApplicativo.getIdSoggettoProprietario()));
        bf.append(")");
        return bf.toString();
    }

    private static IDAccordo getIDAccordoFromAccordo(AccordoServizioParteComune as) throws ProtocolException {
        try {
            return IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getLabelAccordoServizioParteComune(AccordoServizioParteComune as) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(as.getSoggettoReferente().getTipo());
        return NamingUtils.getLabelAccordoServizioParteComune(protocollo, NamingUtils.getIDAccordoFromAccordo(as));
    }

    private static IDAccordo getIDAccordoFromAccordo(AccordoServizioParteComuneSintetico as) throws ProtocolException {
        try {
            return IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getLabelAccordoServizioParteComune(AccordoServizioParteComuneSintetico as) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(as.getSoggettoReferente().getTipo());
        return NamingUtils.getLabelAccordoServizioParteComune(protocollo, NamingUtils.getIDAccordoFromAccordo(as));
    }

    public static String getLabelAccordoServizioParteComune(String protocollo, AccordoServizioParteComune as) throws ProtocolException {
        return NamingUtils.getLabelAccordoServizioParteComune(protocollo, NamingUtils.getIDAccordoFromAccordo(as));
    }

    public static String getLabelAccordoServizioParteComune(IDAccordo idAccordo) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(idAccordo.getSoggettoReferente().getTipo());
        return NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo);
    }

    public static String getLabelAccordoServizioParteComune(String protocollo, IDAccordo idAccordo) throws ProtocolException {
        return NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo, true);
    }

    public static String getLabelAccordoServizioParteComune(String protocollo, IDAccordo idAccordo, boolean addSoggettoReferente) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager;
        boolean supportatoSoggettoReferente;
        StringBuilder bf = new StringBuilder();
        bf.append(idAccordo.getNome());
        bf.append(" v");
        bf.append(idAccordo.getVersione());
        if (addSoggettoReferente && (supportatoSoggettoReferente = (protocolFactoryManager = ProtocolFactoryManager.getInstance()).getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune()) && idAccordo.getSoggettoReferente() != null) {
            bf.append(" (");
            bf.append(NamingUtils.getLabelSoggetto(protocollo, idAccordo.getSoggettoReferente().getTipo(), idAccordo.getSoggettoReferente().getNome()));
            bf.append(")");
        }
        return bf.toString();
    }

    public static String getLabelAccordoServizioParteSpecificaSenzaErogatore(String protocollo, String tipoServizio, String nomeServizio, Integer versioneInt) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager;
        Object versione = "";
        if (ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoVersionamentoAccordiParteSpecifica()) {
            versione = " v" + versioneInt;
        }
        if ((protocolFactoryManager = ProtocolFactoryManager.getInstance())._getServiceTypes().get(protocollo).size() > 1) {
            IProtocolFactory<?> protocolFactory = protocolFactoryManager.getProtocolFactoryByName(protocollo);
            if (tipoServizio.equals(protocolFactory.createProtocolConfiguration().getTipoServizioDefault(null))) {
                return nomeServizio + (String)versione;
            }
            return tipoServizio + "/" + nomeServizio + (String)versione;
        }
        return nomeServizio + (String)versione;
    }

    private static IDServizio getIDAccordoFromAccordo(AccordoServizioParteSpecifica as) throws ProtocolException {
        try {
            return IDServizioFactory.getInstance().getIDServizioFromAccordo(as);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getLabelAccordoServizioParteSpecifica(AccordoServizioParteSpecifica as) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(as.getTipoSoggettoErogatore());
        return NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, NamingUtils.getIDAccordoFromAccordo(as));
    }

    public static String getLabelAccordoServizioParteSpecifica(String protocollo, AccordoServizioParteSpecifica as) throws ProtocolException {
        return NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, NamingUtils.getIDAccordoFromAccordo(as));
    }

    public static String getLabelAccordoServizioParteSpecifica(IDServizio idServizio) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(idServizio.getSoggettoErogatore().getTipo());
        return NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, idServizio);
    }

    public static String getLabelAccordoServizioParteSpecificaSenzaErogatore(IDServizio idServizio) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByServiceType(idServizio.getTipo());
        return NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore(protocollo, idServizio);
    }

    public static String getLabelAccordoServizioParteSpecificaSenzaErogatore(String protocollo, IDServizio idServizio) throws ProtocolException {
        return NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore(protocollo, idServizio.getTipo(), idServizio.getNome(), idServizio.getVersione());
    }

    public static String getLabelAccordoServizioParteSpecifica(String protocollo, IDServizio idServizio) throws ProtocolException {
        StringBuilder bf = new StringBuilder();
        bf.append(NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore(protocollo, idServizio.getTipo(), idServizio.getNome(), idServizio.getVersione()));
        bf.append(" (");
        bf.append(NamingUtils.getLabelSoggetto(protocollo, idServizio.getSoggettoErogatore().getTipo(), idServizio.getSoggettoErogatore().getNome()));
        bf.append(")");
        return bf.toString();
    }

    private static IDAccordoCooperazione getIDAccordoFromAccordo(AccordoCooperazione ac) throws ProtocolException {
        try {
            return IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromAccordo(ac);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getLabelAccordoCooperazione(AccordoCooperazione ac) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(ac.getSoggettoReferente().getTipo());
        return NamingUtils.getLabelAccordoCooperazione(protocollo, NamingUtils.getIDAccordoFromAccordo(ac));
    }

    public static String getLabelAccordoCooperazione(String protocollo, AccordoCooperazione ac) throws ProtocolException {
        return NamingUtils.getLabelAccordoCooperazione(protocollo, NamingUtils.getIDAccordoFromAccordo(ac));
    }

    public static String getLabelAccordoCooperazione(IDAccordoCooperazione idAccordo) throws ProtocolException {
        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
        String protocollo = protocolFactoryManager.getProtocolByOrganizationType(idAccordo.getSoggettoReferente().getTipo());
        return NamingUtils.getLabelAccordoCooperazione(protocollo, idAccordo);
    }

    public static String getLabelAccordoCooperazione(String protocollo, IDAccordoCooperazione idAccordo) throws ProtocolException {
        StringBuilder bf = new StringBuilder();
        bf.append(idAccordo.getNome());
        bf.append(" v");
        bf.append(idAccordo.getVersione());
        if (idAccordo.getSoggettoReferente() != null) {
            bf.append(" (");
            bf.append(NamingUtils.getLabelSoggetto(protocollo, idAccordo.getSoggettoReferente().getTipo(), idAccordo.getSoggettoReferente().getNome()));
            bf.append(")");
        }
        return bf.toString();
    }

    public static String getLabelResource(Resource resource) {
        String method = null;
        if (resource.getMethod() != null) {
            method = resource.getMethod().getValue();
        }
        return NamingUtils.getLabelResource(method, resource.getPath());
    }

    public static String getLabelResource(ResourceSintetica resource) {
        String method = null;
        if (resource.getMethod() != null) {
            method = resource.getMethod().getValue();
        }
        return NamingUtils.getLabelResource(method, resource.getPath());
    }

    public static String getLabelResource(String httpmethodParam, String pathParam) {
        String method = null;
        if (httpmethodParam != null && !"".equals(httpmethodParam)) {
            method = httpmethodParam;
        }
        String path = null;
        path = pathParam == null || "".equals(pathParam) ? "Qualsiasi" : pathParam;
        if (method != null) {
            return method + " " + path;
        }
        return path;
    }

    public static String getLabelServizioConDominioErogatore(String servizio, String erogatore) {
        if (servizio.contains(" ")) {
            String[] split = servizio.split(" ");
            if (split != null && split.length == 2) {
                StringBuilder bf = new StringBuilder();
                bf.append(split[0]);
                bf.append(LABEL_DOMINIO);
                bf.append(erogatore);
                bf.append(" ");
                bf.append(split[1]);
                return bf.toString();
            }
            StringBuilder bf = new StringBuilder();
            bf.append(servizio);
            bf.append(LABEL_DOMINIO);
            bf.append(erogatore);
            return bf.toString();
        }
        StringBuilder bf = new StringBuilder();
        bf.append(servizio);
        bf.append(LABEL_DOMINIO);
        bf.append(erogatore);
        return bf.toString();
    }
}

