/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_soggetti {
    protected static boolean isSoggettoConfigInUso(Connection con, String tipoDB, IDSoggetto idSoggettoConfig, boolean checkControlloTraffico, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        return DBOggettiInUsoUtils_soggetti.isSoggettoInUso(con, tipoDB, idSoggettoConfig, null, checkControlloTraffico, whereIsInUso, normalizeObjectIds, verificaRuoli);
    }

    protected static boolean isSoggettoRegistryInUso(Connection con, String tipoDB, IDSoggetto idSoggettoRegistro, boolean checkControlloTraffico, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        return DBOggettiInUsoUtils_soggetti.isSoggettoInUso(con, tipoDB, null, idSoggettoRegistro, checkControlloTraffico, whereIsInUso, normalizeObjectIds, verificaRuoli);
    }

    private static boolean isSoggettoInUso(Connection con, String tipoDB, IDSoggetto idSoggettoConfig, IDSoggetto idSoggettoRegistro, boolean checkControlloTraffico, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        boolean bl;
        String nomeMetodo = "isSoggettoInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            StringBuilder bf;
            IDAccordo idAccordo;
            Integer versione;
            String nomeAccordo;
            ResultPorta resultPorta;
            String nome;
            String protocollo;
            String tipo_soggetto;
            boolean isInUso = false;
            long idSoggetto = -1L;
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            if (idSoggettoRegistro != null) {
                tipoSoggetto = idSoggettoRegistro.getTipo();
                nomeSoggetto = idSoggettoRegistro.getNome();
            } else {
                tipoSoggetto = idSoggettoConfig.getTipo();
                nomeSoggetto = idSoggettoConfig.getNome();
            }
            idSoggetto = DBUtils.getIdSoggetto((String)nomeSoggetto, (String)tipoSoggetto, (Connection)con, (String)tipoDB);
            if (idSoggetto <= 0L) {
                throw new UtilsException("Soggetto con tipo[" + tipoSoggetto + "] e nome[" + nomeSoggetto + "] non trovato");
            }
            List<String> servizi_fruitori_list = whereIsInUso.get(ErrorsHandlerCostant.IS_FRUITORE);
            List<String> servizi_applicativi_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_SERVIZI_APPLICATIVI);
            List<String> servizi_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_SERVIZI);
            List<String> porte_delegate_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE);
            List<String> porte_applicative_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> mappingErogazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingFruizionePD_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            List<String> accordi_list = whereIsInUso.get(ErrorsHandlerCostant.IS_REFERENTE);
            List<String> accordi_coop_list = whereIsInUso.get(ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE);
            List<String> partecipanti_list = whereIsInUso.get(ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE);
            List<String> utenti_list = whereIsInUso.get(ErrorsHandlerCostant.UTENTE);
            List<String> ct_list = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
            List<String> allarme_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI);
            List<String> autorizzazionePA_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING);
            List<String> autorizzazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.AUTORIZZAZIONE);
            List<String> ruoliPA_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_MAPPING);
            List<String> ruoliPA_list = whereIsInUso.get(ErrorsHandlerCostant.RUOLI);
            List<String> ruoliTokenPA_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA);
            List<String> ruoliTokenPA_list = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PA);
            List<String> ruoliTokenPA_mapping_modi_list = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA_MODI);
            List<String> ruoliTokenPA_modi_list = whereIsInUso.get(ErrorsHandlerCostant.RUOLI_TOKEN_PA_MODI);
            List<String> trasformazionePA_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PA);
            List<String> trasformazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_PA);
            List<String> configurazioniProxyPass_list = whereIsInUso.get(ErrorsHandlerCostant.CONFIGURAZIONE_REGOLE_PROXY_PASS);
            List<String> tracciamentoPdndList = whereIsInUso.get(ErrorsHandlerCostant.IS_RIFERITA_MODI_TRACCIAMENTO);
            if (servizi_fruitori_list == null) {
                servizi_fruitori_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_FRUITORE, servizi_fruitori_list);
            }
            if (servizi_applicativi_list == null) {
                servizi_applicativi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI_APPLICATIVI, servizi_applicativi_list);
            }
            if (servizi_list == null) {
                servizi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, servizi_list);
            }
            if (porte_delegate_list == null) {
                porte_delegate_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, porte_delegate_list);
            }
            if (porte_applicative_list == null) {
                porte_applicative_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porte_applicative_list);
            }
            if (mappingErogazionePA_list == null) {
                mappingErogazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePA_list);
            }
            if (mappingFruizionePD_list == null) {
                mappingFruizionePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePD_list);
            }
            if (accordi_list == null) {
                accordi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, accordi_list);
            }
            if (accordi_coop_list == null) {
                accordi_coop_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE, accordi_coop_list);
            }
            if (partecipanti_list == null) {
                partecipanti_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE, partecipanti_list);
            }
            if (utenti_list == null) {
                utenti_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.UTENTE, utenti_list);
            }
            if (ct_list == null) {
                ct_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ct_list);
            }
            if (allarme_list == null) {
                allarme_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.ALLARMI, allarme_list);
            }
            if (autorizzazionePA_mapping_list == null) {
                autorizzazionePA_mapping_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING, autorizzazionePA_mapping_list);
            }
            if (autorizzazionePA_list == null) {
                autorizzazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.AUTORIZZAZIONE, autorizzazionePA_list);
            }
            if (ruoliPA_mapping_list == null) {
                ruoliPA_mapping_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_MAPPING, ruoliPA_mapping_list);
            }
            if (ruoliPA_list == null) {
                ruoliPA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI, ruoliPA_list);
            }
            if (ruoliTokenPA_mapping_list == null) {
                ruoliTokenPA_mapping_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA, ruoliTokenPA_mapping_list);
            }
            if (ruoliTokenPA_list == null) {
                ruoliTokenPA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PA, ruoliTokenPA_list);
            }
            if (ruoliTokenPA_mapping_modi_list == null) {
                ruoliTokenPA_mapping_modi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_MAPPING_PA_MODI, ruoliTokenPA_mapping_modi_list);
            }
            if (ruoliTokenPA_modi_list == null) {
                ruoliTokenPA_modi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.RUOLI_TOKEN_PA_MODI, ruoliTokenPA_modi_list);
            }
            if (trasformazionePA_mapping_list == null) {
                trasformazionePA_mapping_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PA, trasformazionePA_mapping_list);
            }
            if (trasformazionePA_list == null) {
                trasformazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_PA, trasformazionePA_list);
            }
            if (configurazioniProxyPass_list == null) {
                configurazioniProxyPass_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONFIGURAZIONE_REGOLE_PROXY_PASS, configurazioniProxyPass_list);
            }
            if (tracciamentoPdndList == null) {
                tracciamentoPdndList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_RIFERITA_MODI_TRACCIAMENTO, tracciamentoPdndList);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("servizi_applicativi.nome");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                tipo_soggetto = risultato.getString("tipo_soggetto");
                String nome2 = risultato.getString("nome");
                if (normalizeObjectIds) {
                    protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                    servizi_applicativi_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + nome2);
                } else {
                    servizi_applicativi_list.add(nome2);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_delegate.nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore = ?", "(tipo_soggetto_erogatore = ? AND nome_soggetto_erogatore = ?)", "id_soggetto = ?"});
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            stmt.setString(2, tipoSoggetto);
            stmt.setString(3, nomeSoggetto);
            stmt.setLong(4, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    mappingFruizionePD_list.add(resultPorta.label);
                } else {
                    porte_delegate_list.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto = ?", "id_soggetto_virtuale = ?", "(tipo_soggetto_virtuale = ? AND nome_soggetto_virtuale = ?)"});
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            stmt.setLong(2, idSoggetto);
            stmt.setString(3, tipoSoggetto);
            stmt.setString(4, nomeSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                nome = risultato.getString("nome_porta");
                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                if (resultPorta.mapping) {
                    mappingErogazionePA_list.add(resultPorta.label);
                } else {
                    porte_applicative_list.add(resultPorta.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            if (idSoggettoRegistro != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_referente = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nomeAccordo = risultato.getString("nome");
                    versione = risultato.getInt("versione");
                    if (normalizeObjectIds) {
                        protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggettoRegistro.getTipo());
                        idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAccordo, idSoggettoRegistro, versione);
                        accordi_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo));
                    } else {
                        bf = new StringBuilder();
                        bf.append(idSoggettoRegistro.toString());
                        bf.append(":");
                        bf.append(nomeAccordo);
                        if (versione != null) {
                            bf.append(":");
                            bf.append(versione);
                        }
                        accordi_list.add(bf.toString());
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (idSoggettoRegistro != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_referente = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nomeAccordo = risultato.getString("nome");
                    versione = risultato.getInt("versione");
                    if (normalizeObjectIds) {
                        protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggettoRegistro.getTipo());
                        idAccordo = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromValues(nomeAccordo, idSoggettoRegistro, versione.intValue());
                        accordi_coop_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoCooperazione(protocollo, (IDAccordoCooperazione)idAccordo));
                    } else {
                        bf = new StringBuilder();
                        bf.append(idSoggettoRegistro.toString());
                        bf.append(":");
                        bf.append(nomeAccordo);
                        if (versione != null) {
                            bf.append(":");
                            bf.append(versione);
                        }
                        accordi_coop_list.add(bf.toString());
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (idSoggettoRegistro != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione = accordi_cooperazione.id");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nomeAccordo = risultato.getString("nome");
                    versione = risultato.getInt("versione");
                    if (normalizeObjectIds) {
                        protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggettoRegistro.getTipo());
                        idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(nomeAccordo, idSoggettoRegistro, versione);
                        partecipanti_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo));
                    } else {
                        bf = new StringBuilder();
                        bf.append(idSoggettoRegistro.toString());
                        bf.append(":");
                        bf.append(nomeAccordo);
                        if (versione != null) {
                            bf.append(":");
                            bf.append(versione);
                        }
                        partecipanti_list.add(bf.toString());
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (idSoggettoRegistro != null && mappingFruizionePD_list.isEmpty() && mappingErogazionePA_list.isEmpty()) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nome_servizio = risultato.getString("nome_servizio");
                    String tipo_servizio = risultato.getString("tipo_servizio");
                    Integer versione_servizio = risultato.getInt("versione_servizio");
                    if (normalizeObjectIds) {
                        String protocollo2 = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggettoRegistro.getTipo());
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipo_servizio, nome_servizio, idSoggettoRegistro, versione_servizio.intValue());
                        servizi_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo2) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo2, idServizio));
                    } else {
                        servizi_list.add(idSoggettoRegistro.toString() + "_" + tipo_servizio + "/" + nome_servizio + "/" + versione_servizio);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (idSoggettoRegistro != null && mappingFruizionePD_list.isEmpty() && mappingErogazionePA_list.isEmpty()) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("versione_servizio");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    tipo_soggetto = risultato.getString("tipo_soggetto");
                    String nome_soggetto = risultato.getString("nome_soggetto");
                    String tipoServizio = risultato.getString("tipo_servizio");
                    String nomeServizio = risultato.getString("nome_servizio");
                    Integer versioneServizio = risultato.getInt("versione_servizio");
                    if (normalizeObjectIds) {
                        String protocollo3 = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggettoRegistro.getTipo());
                        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, new IDSoggetto(tipo_soggetto, nome_soggetto), versioneServizio.intValue());
                        servizi_fruitori_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo3) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo3, idServizio));
                    } else {
                        servizi_fruitori_list.add(tipo_soggetto + "/" + nome_soggetto + "_" + tipoServizio + "/" + nomeServizio + "/" + versioneServizio);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("users");
            sqlQueryObject.addFromTable("users_soggetti");
            sqlQueryObject.addSelectField("login");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("users_soggetti.id_soggetto = ?");
            sqlQueryObject.addWhereCondition("users.id = users_soggetti.id_utente");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                utenti_list.add(risultato.getString("login"));
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            int max = 2;
            if (!CostantiDB.isAllarmiEnabled()) {
                max = 1;
            }
            for (int i = 0; i < max; ++i) {
                String tabella = "ct_active_policy";
                String identificativo_column = "active_policy_id";
                String alias_column = "policy_alias";
                List<String> list = ct_list;
                String oggetto = "Policy";
                if (i == 1) {
                    tabella = "allarmi";
                    identificativo_column = "nome";
                    alias_column = "alias";
                    list = allarme_list;
                    oggetto = "Allarme";
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addSelectField(identificativo_column);
                sqlQueryObject.addSelectField(alias_column);
                sqlQueryObject.addSelectField("filtro_ruolo");
                sqlQueryObject.addSelectField("filtro_porta");
                sqlQueryObject.setANDLogicOperator(false);
                sqlQueryObject.addWhereCondition(true, new String[]{tabella + ".filtro_tipo_fruitore = ?", tabella + ".filtro_nome_fruitore = ?"});
                sqlQueryObject.addWhereCondition(true, new String[]{tabella + ".filtro_tipo_erogatore = ?", tabella + ".filtro_nome_erogatore = ?"});
                sqlQueryObject.addOrderBy("filtro_ruolo");
                sqlQueryObject.addOrderBy("filtro_porta");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setString(index++, tipoSoggetto);
                stmt.setString(index++, nomeSoggetto);
                stmt.setString(index++, tipoSoggetto);
                stmt.setString(index++, nomeSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String alias = risultato.getString(alias_column);
                    if (alias == null || "".equals(alias)) {
                        alias = risultato.getString(identificativo_column);
                    }
                    String nomePorta = risultato.getString("filtro_porta");
                    String filtro_ruolo = risultato.getString("filtro_ruolo");
                    if (nomePorta != null) {
                        String tipo = null;
                        String label = null;
                        if ("delegata".equals(filtro_ruolo)) {
                            try {
                                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    label = "Fruizione di Servizio " + resultPorta.label;
                                }
                            }
                            catch (Exception e) {
                                tipo = "Outbound";
                            }
                        } else if ("applicativa".equals(filtro_ruolo)) {
                            try {
                                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    label = "Erogazione di Servizio " + resultPorta.label;
                                }
                            }
                            catch (Exception e) {
                                tipo = "Inbound";
                            }
                        } else {
                            tipo = filtro_ruolo;
                        }
                        if (label == null) {
                            list.add(oggetto + " '" + alias + "' attiva nella porta '" + tipo + "' '" + nomePorta + "' ");
                        } else {
                            list.add(oggetto + " '" + alias + "' attiva nella " + label);
                        }
                    } else {
                        list.add(oggetto + " '" + alias + "'");
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("pa_soggetti");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("pa_soggetti.id_porta = porte_applicative.id");
            sqlQueryObject.addWhereCondition("pa_soggetti.tipo_soggetto=?");
            sqlQueryObject.addWhereCondition("pa_soggetti.nome_soggetto=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoSoggetto);
            stmt.setString(2, nomeSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nome3 = risultato.getString("nome_porta");
                ResultPorta resultPorta2 = DBOggettiInUsoUtils.formatPortaApplicativa(nome3, tipoDB, con, normalizeObjectIds);
                if (resultPorta2.mapping) {
                    autorizzazionePA_mapping_list.add(resultPorta2.label);
                } else {
                    autorizzazionePA_list.add(resultPorta2.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            if (verificaRuoli) {
                ArrayList<String> listRuoliSoggetti = new ArrayList<String>();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectAliasField("ruoli", "nome", "nomeRuolo");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti_ruoli.id_soggetto=soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti_ruoli.id_ruolo=ruoli.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String ruolo = risultato.getString("nomeRuolo");
                    listRuoliSoggetti.add(ruolo);
                }
                risultato.close();
                stmt.close();
                if (!listRuoliSoggetti.isEmpty()) {
                    boolean isInUsoRuoliToken;
                    boolean isInUsoRuoli = DBOggettiInUsoUtils_soggetti._checkSoggetto_ruoloInUsoInPorteApplicative(con, tipoDB, normalizeObjectIds, "pa_ruoli", listRuoliSoggetti, ruoliPA_mapping_list, ruoliPA_list, ruoliPA_mapping_list, ruoliPA_list);
                    if (isInUsoRuoli) {
                        isInUso = true;
                    }
                    if (isInUsoRuoliToken = DBOggettiInUsoUtils_soggetti._checkSoggetto_ruoloInUsoInPorteApplicative(con, tipoDB, normalizeObjectIds, "pa_token_ruoli", listRuoliSoggetti, ruoliTokenPA_mapping_list, ruoliTokenPA_list, ruoliTokenPA_mapping_modi_list, ruoliTokenPA_modi_list)) {
                        isInUso = true;
                    }
                }
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("pa_transform");
            sqlQueryObject.addFromTable("pa_transform_soggetti");
            sqlQueryObject.addSelectField("porte_applicative.nome_porta");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("pa_transform.id_porta = porte_applicative.id");
            sqlQueryObject.addWhereCondition("pa_transform.id = pa_transform_soggetti.id_trasformazione");
            sqlQueryObject.addWhereCondition("pa_transform_soggetti.tipo_soggetto=?");
            sqlQueryObject.addWhereCondition("pa_transform_soggetti.nome_soggetto=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoSoggetto);
            stmt.setString(2, nomeSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nome4 = risultato.getString("nome_porta");
                ResultPorta resultPorta3 = DBOggettiInUsoUtils.formatPortaApplicativa(nome4, tipoDB, con, normalizeObjectIds);
                if (resultPorta3.mapping) {
                    trasformazionePA_mapping_list.add(resultPorta3.label);
                } else {
                    trasformazionePA_list.add(resultPorta3.label);
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("config_url_regole");
            sqlQueryObject.addSelectField("config_url_regole.nome");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("config_url_regole.tipo_soggetto=?");
            sqlQueryObject.addWhereCondition("config_url_regole.nome_soggetto=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoSoggetto);
            stmt.setString(2, nomeSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nome5 = risultato.getString("nome");
                configurazioniProxyPass_list.add(nome5);
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            if (idSoggettoRegistro != null && "modipa".equals(idSoggettoRegistro.getTipo())) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("protocol_properties");
                sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("soggetti.id = protocol_properties.id_proprietario");
                sqlQueryObject.addWhereCondition("protocol_properties.tipo_proprietario=?");
                sqlQueryObject.addWhereCondition("protocol_properties.name=?");
                sqlQueryObject.addWhereCondition("protocol_properties.value_string=?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setString(index++, ProprietariProtocolProperty.SOGGETTO.name());
                stmt.setString(index++, "modipaSoggettoPdndTracingAggregato");
                stmt.setString(index++, idSoggettoRegistro.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nome6 = risultato.getString("nomeSoggetto");
                    tracciamentoPdndList.add(nome6);
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _checkSoggetto_ruoloInUsoInPorteApplicative(Connection con, String tipoDB, boolean normalizeObjectIds, String nomeTabella, List<String> listRuoliSoggetti, List<String> ruoliPA_mapping_list, List<String> ruoliPA_list, List<String> ruoliPA_mapping_modi_list, List<String> ruoliPA_modi_list) throws Exception {
        boolean isInUso = false;
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            Object resultPorta;
            ArrayList<String> distinctPorteApplicative = new ArrayList<String>();
            ArrayList<String> verificaPorteApplicativeAll = new ArrayList<String>();
            for (String ruolo : listRuoliSoggetti) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("ruoli_match");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=porte_applicative.id");
                sqlQueryObject.addWhereCondition(nomeTabella + ".ruolo=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, ruolo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nome = risultato.getString("nome_porta");
                    String ruolo_match = risultato.getString("ruoli_match");
                    if (RuoloTipoMatch.ANY.getValue().equals(ruolo_match)) {
                        if (distinctPorteApplicative.contains(nome)) continue;
                        distinctPorteApplicative.add(nome);
                        resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                        if (((ResultPorta)resultPorta).mapping) {
                            if (((ResultPorta)resultPorta).erogazioneModi) {
                                ruoliPA_mapping_modi_list.add(((ResultPorta)resultPorta).label);
                            } else {
                                ruoliPA_mapping_list.add(((ResultPorta)resultPorta).label);
                            }
                        } else if (((ResultPorta)resultPorta).erogazioneModi) {
                            ruoliPA_modi_list.add(((ResultPorta)resultPorta).label);
                        } else {
                            ruoliPA_list.add(((ResultPorta)resultPorta).label);
                        }
                        isInUso = true;
                        continue;
                    }
                    if (verificaPorteApplicativeAll.contains(nome)) continue;
                    verificaPorteApplicativeAll.add(nome);
                }
                risultato.close();
                stmt.close();
            }
            if (!verificaPorteApplicativeAll.isEmpty()) {
                for (String nome : verificaPorteApplicativeAll) {
                    ArrayList<String> listRuoliPorta = new ArrayList<String>();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("porte_applicative");
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("ruolo");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition("porte_applicative.nome_porta=?");
                    sqlQueryObject.addWhereCondition(nomeTabella + ".id_porta=porte_applicative.id");
                    String queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setString(1, nome);
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        String ruolo = risultato.getString("ruolo");
                        listRuoliPorta.add(ruolo);
                    }
                    risultato.close();
                    stmt.close();
                    if (listRuoliPorta.isEmpty()) continue;
                    boolean match = true;
                    for (String ruoloPorta : listRuoliPorta) {
                        if (listRuoliSoggetti.contains(ruoloPorta)) continue;
                        match = false;
                        break;
                    }
                    if (!match || distinctPorteApplicative.contains(nome)) continue;
                    distinctPorteApplicative.add(nome);
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (((ResultPorta)resultPorta).mapping) {
                        if (((ResultPorta)resultPorta).erogazioneModi) {
                            ruoliPA_mapping_modi_list.add(((ResultPorta)resultPorta).label);
                        } else {
                            ruoliPA_mapping_list.add(((ResultPorta)resultPorta).label);
                        }
                    } else if (((ResultPorta)resultPorta).erogazioneModi) {
                        ruoliPA_modi_list.add(((ResultPorta)resultPorta).label);
                    } else {
                        ruoliPA_list.add(((ResultPorta)resultPorta).label);
                    }
                    isInUso = true;
                }
            }
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return isInUso;
    }

    protected static String toString(IDSoggetto idSoggetto, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object labelSoggetto = idSoggetto.toString();
        try {
            if (normalizeObjectIds) {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idSoggetto.getTipo());
                labelSoggetto = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelSoggetto(protocollo, idSoggetto);
            }
        }
        catch (Exception protocollo) {
            // empty catch block
        }
        Object msg = "Soggetto '" + (String)labelSoggetto + "' non eliminabile perch&egrave; :" + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block29: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case IS_FRUITORE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "fruitore dei Servizi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IN_USO_IN_SERVIZI_APPLICATIVI: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato negli Applicativi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IN_USO_IN_SERVIZI: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "erogatore dei Servizi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IN_USO_IN_PORTE_DELEGATE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Porte Outbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IS_REFERENTE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "referente di API: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IS_REFERENTE_COOPERAZIONE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "referente di Accordi di Cooperazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IS_PARTECIPANTE_COOPERAZIONE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "partecipante in Accordi di Cooperazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case UTENTE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "associato ad Utenti: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato in policy di Rate Limiting: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case ALLARMI: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato in Allarmi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case AUTORIZZAZIONE_MAPPING: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nel Controllo degli Accessi (Soggetti Autenticati) delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case AUTORIZZAZIONE: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Porte Inbound (Controllo degli Accessi - Soggetti Autenticati): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case RUOLI_MAPPING: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "compatibile con l'Autorizzazione Trasporto per Ruoli indicata nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case RUOLI: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "compatibile con l'Autorizzazione Trasporto per Ruoli indicata nel Controllo degli Accessi delle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case RUOLI_TOKEN_MAPPING_PA: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "compatibile con l'Autorizzazione Token per Ruoli indicata nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case RUOLI_TOKEN_PA: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "compatibile con l'Autorizzazione Token per Ruoli indicata nel Controllo degli Accessi delle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case RUOLI_TOKEN_MAPPING_PA_MODI: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "compatibile con l'Autorizzazione Messaggio per Ruoli indicata nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case RUOLI_TOKEN_PA_MODI: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "compatibile con l'Autorizzazione Messaggio per Ruoli indicata nel Controllo degli Accessi delle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case TRASFORMAZIONE_MAPPING_PA: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nel criterio di applicabilit\u00e0 della Trasformazione (Soggetti) per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case TRASFORMAZIONE_PA: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Porte Inbound (Criterio di applicabilit\u00e0 della Trasformazione - Soggetti): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case CONFIGURAZIONE_REGOLE_PROXY_PASS: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "utilizzato nelle Regole di Proxy Pass: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
                case IS_RIFERITA_MODI_TRACCIAMENTO: {
                    if (messages == null || messages.size() <= 0) continue block29;
                    msg = (String)msg + "riferito come aggregatore del tracciamento PDND per i soggetti: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block29;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + String.valueOf(key) + ")" + separator;
        }
        return msg;
    }
}

