/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_accordiRest {
    private DBOggettiInUsoUtils_accordiRest() {
    }

    protected static boolean isRisorsaConfigInUso(Connection con, String tipoDB, IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiRest.isRisorsaInUsoInternal(con, tipoDB, idRisorsa, false, true, whereIsInUso, normalizeObjectIds);
    }

    protected static boolean isRisorsaRegistryInUso(Connection con, String tipoDB, IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiRest.isRisorsaInUsoInternal(con, tipoDB, idRisorsa, true, false, whereIsInUso, normalizeObjectIds);
    }

    protected static boolean isRisorsaInUso(Connection con, String tipoDB, IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiRest.isRisorsaInUsoInternal(con, tipoDB, idRisorsa, true, true, whereIsInUso, normalizeObjectIds);
    }

    private static boolean isRisorsaInUsoInternal(Connection con, String tipoDB, IDResource idRisorsa, boolean registry, boolean config, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "_isRisorsaInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            long idAccordoServizioParteComune;
            long idAccordo;
            boolean isInUso = false;
            List<String> correlazioneList = whereIsInUso.get(ErrorsHandlerCostant.IS_CORRELATA);
            List<String> porteApplicativeList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> porteDelegateList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE);
            List<String> mappingErogazionePAList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingFruizionePDList = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            List<String> trasformazionePDMappingList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PD);
            List<String> trasformazionePDList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_PD);
            List<String> trasformazionePAMappingList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PA);
            List<String> trasformazionePAList = whereIsInUso.get(ErrorsHandlerCostant.TRASFORMAZIONE_PA);
            List<String> ctList = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
            List<String> allarmeList = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI);
            List<String> modiSignalHubList = whereIsInUso.get(ErrorsHandlerCostant.IS_RIFERITA_MODI_SIGNAL_HUB);
            if (correlazioneList == null) {
                correlazioneList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_CORRELATA, correlazioneList);
            }
            if (porteApplicativeList == null) {
                porteApplicativeList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porteApplicativeList);
            }
            if (porteDelegateList == null) {
                porteDelegateList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, porteDelegateList);
            }
            if (mappingErogazionePAList == null) {
                mappingErogazionePAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePAList);
            }
            if (mappingFruizionePDList == null) {
                mappingFruizionePDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePDList);
            }
            if (trasformazionePDMappingList == null) {
                trasformazionePDMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PD, trasformazionePDMappingList);
            }
            if (trasformazionePDList == null) {
                trasformazionePDList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_PD, trasformazionePDList);
            }
            if (trasformazionePAMappingList == null) {
                trasformazionePAMappingList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_MAPPING_PA, trasformazionePAMappingList);
            }
            if (trasformazionePAList == null) {
                trasformazionePAList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.TRASFORMAZIONE_PA, trasformazionePAList);
            }
            if (ctList == null) {
                ctList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ctList);
            }
            if (allarmeList == null) {
                allarmeList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.ALLARMI, allarmeList);
            }
            if (modiSignalHubList == null) {
                modiSignalHubList = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_RIFERITA_MODI_SIGNAL_HUB, modiSignalHubList);
            }
            if ((idAccordo = DBUtils.getIdAccordoServizioParteComune((IDAccordo)idRisorsa.getIdAccordo(), (Connection)con, (String)tipoDB)) <= 0L) {
                throw new UtilsException("Accordo non trovato");
            }
            long idR = DBUtils.getIdResource((Long)idAccordo, (String)idRisorsa.getNome(), (Connection)con);
            if (idR <= 0L) {
                throw new UtilsException("Risorsa non trovata");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.addWhereCondition("servizi.port_type is null");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            ArrayList<IDServizio> idServiziWithAccordo = new ArrayList<IDServizio>();
            while (risultato.next()) {
                IDSoggetto soggettoErogatore = new IDSoggetto(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto"));
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(risultato.getString("tipo_servizio"), risultato.getString("nome_servizio"), soggettoErogatore, risultato.getInt("versione_servizio"));
                idServiziWithAccordo.add(idServizio);
            }
            risultato.close();
            stmt.close();
            if ("modipa".equals(idRisorsa.getIdAccordo().getSoggettoReferente().getTipo())) {
                ISQLQueryObject sqlQueryObjectApiExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObjectApiExists.setANDLogicOperator(true);
                sqlQueryObjectApiExists.addFromTable("protocol_properties");
                sqlQueryObjectApiExists.addSelectField("protocol_properties", "name");
                sqlQueryObjectApiExists.addWhereCondition("api_resources.id = protocol_properties.id_proprietario");
                sqlQueryObjectApiExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                sqlQueryObjectApiExists.addWhereCondition("protocol_properties.name=?");
                sqlQueryObjectApiExists.addWhereCondition("protocol_properties.value_string=?");
                ISQLQueryObject sqlQueryObjectOperationExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObjectOperationExists.setANDLogicOperator(true);
                sqlQueryObjectOperationExists.addFromTable("protocol_properties");
                sqlQueryObjectOperationExists.addSelectField("protocol_properties", "name");
                sqlQueryObjectOperationExists.addWhereCondition("api_resources.id = protocol_properties.id_proprietario");
                sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.name=?");
                sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.value_string=?");
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("api_resources");
                sqlQueryObject.addWhereCondition("api_resources.id_accordo = ?");
                sqlQueryObject.addSelectAliasField("api_resources", "nome", "nomeRisorsaCorrelata");
                sqlQueryObject.addSelectAliasField("api_resources", "http_method", "httpMethodRisorsaCorrelata");
                sqlQueryObject.addSelectAliasField("api_resources", "path", "pathRisorsaCorrelata");
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectApiExists);
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectOperationExists);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pathRisorsaCorrelata");
                sqlQueryObject.addOrderBy("httpMethodRisorsaCorrelata");
                sqlQueryObject.setSortType(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setLong(index++, idAccordo);
                stmt.setString(index++, ProprietariProtocolProperty.RESOURCE.name());
                stmt.setString(index++, "modipaInteractionAsyncApiRequest");
                stmt.setString(index++, "-");
                stmt.setString(index++, ProprietariProtocolProperty.RESOURCE.name());
                stmt.setString(index++, "modipaInteractionAsyncActionRequest");
                stmt.setString(index++, idRisorsa.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nomeRisorsaCorrelata = risultato.getString("nomeRisorsaCorrelata");
                    String httpMethodRisorsaCorrelata = risultato.getString("httpMethodRisorsaCorrelata");
                    String pathRisorsaCorrelata = risultato.getString("pathRisorsaCorrelata");
                    String path = null;
                    path = pathRisorsaCorrelata == null || "".equals(pathRisorsaCorrelata) ? "*" : pathRisorsaCorrelata;
                    String method = null;
                    method = httpMethodRisorsaCorrelata == null || "".equals(httpMethodRisorsaCorrelata) ? "Qualsiasi" : httpMethodRisorsaCorrelata;
                    correlazioneList.add("Risorsa " + method + " " + path + " (interazione: NonBloccante-Pull)");
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("api_resources");
                sqlQueryObject.addSelectAliasField("api_resources", "nome", "nomeRisorsaCorrelata");
                sqlQueryObject.addSelectAliasField("api_resources", "http_method", "httpMethodRisorsaCorrelata");
                sqlQueryObject.addSelectAliasField("api_resources", "path", "pathRisorsaCorrelata");
                sqlQueryObject.addSelectAliasField("accordi", "nome", "nomeApi");
                sqlQueryObject.addSelectAliasField("accordi", "versione", "versioneApi");
                sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoReferenteApi");
                sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeReferenteApi");
                sqlQueryObject.addWhereCondition("api_resources.id_accordo = accordi.id");
                sqlQueryObject.addWhereCondition("soggetti.id = accordi.id_referente");
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectApiExists);
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectOperationExists);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nomeApi");
                sqlQueryObject.addOrderBy("versioneApi");
                sqlQueryObject.addOrderBy("nomeReferenteApi");
                sqlQueryObject.addOrderBy("tipoReferenteApi");
                sqlQueryObject.addOrderBy("pathRisorsaCorrelata");
                sqlQueryObject.addOrderBy("httpMethodRisorsaCorrelata");
                sqlQueryObject.setSortType(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                index = 1;
                stmt.setString(index++, ProprietariProtocolProperty.RESOURCE.name());
                stmt.setString(index++, "modipaInteractionAsyncApiRequest");
                stmt.setString(index++, IDAccordoFactory.getInstance().getUriFromIDAccordo(idRisorsa.getIdAccordo()));
                stmt.setString(index++, ProprietariProtocolProperty.RESOURCE.name());
                stmt.setString(index++, "modipaInteractionAsyncActionRequest");
                stmt.setString(index++, idRisorsa.getNome());
                risultato = stmt.executeQuery();
                IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
                while (risultato.next()) {
                    String nomeApi = risultato.getString("nomeApi");
                    int versioneApi = risultato.getInt("versioneApi");
                    String tipoReferenteApi = risultato.getString("tipoReferenteApi");
                    String nomeReferenteApi = risultato.getString("nomeReferenteApi");
                    IDAccordo idAPI = idAccordoFactory.getIDAccordoFromValues(nomeApi, tipoReferenteApi, nomeReferenteApi, Integer.valueOf(versioneApi));
                    String nomeRisorsaCorrelata = risultato.getString("nomeRisorsaCorrelata");
                    String httpMethodRisorsaCorrelata = risultato.getString("httpMethodRisorsaCorrelata");
                    String pathRisorsaCorrelata = risultato.getString("pathRisorsaCorrelata");
                    String path = null;
                    path = pathRisorsaCorrelata == null || "".equals(pathRisorsaCorrelata) ? "*" : pathRisorsaCorrelata;
                    String method = null;
                    method = httpMethodRisorsaCorrelata == null || "".equals(httpMethodRisorsaCorrelata) ? "Qualsiasi" : httpMethodRisorsaCorrelata;
                    correlazioneList.add("Risorsa " + method + " " + path + " dell'API '" + idAccordoFactory.getUriFromIDAccordo(idAPI) + "' (interazione: NonBloccante-Push)");
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config && idServiziWithAccordo != null && !idServiziWithAccordo.isEmpty()) {
                for (IDServizio idServizio : idServiziWithAccordo) {
                    long idS = DBUtils.getIdServizio((String)idServizio.getNome(), (String)idServizio.getTipo(), (Integer)idServizio.getVersione(), (String)idServizio.getSoggettoErogatore().getNome(), (String)idServizio.getSoggettoErogatore().getTipo(), (Connection)con, (String)tipoDB);
                    if (idS <= 0L) {
                        throw new CoreException("Servizio '" + String.valueOf(idServizio) + "' non esistente");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                    sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                    sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                    sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                    sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                    sqlQueryObject.addSelectField("soggetti.id");
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                    sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                    sqlQueryObject.setSortType(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idS);
                    risultato = stmt.executeQuery();
                    ArrayList<IDSoggetto> listFruitori = new ArrayList<IDSoggetto>();
                    while (risultato.next()) {
                        listFruitori.add(new IDSoggetto(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto")));
                    }
                    risultato.close();
                    stmt.close();
                    if (listFruitori == null || listFruitori.isEmpty()) continue;
                    for (IDSoggetto idSoggettoFruitore : listFruitori) {
                        List lPD = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)tipoDB, (IDSoggetto)idSoggettoFruitore, (IDServizio)idServizio, (boolean)true);
                        if (lPD == null || lPD.isEmpty()) continue;
                        for (MappingFruizionePortaDelegata mapping : lPD) {
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addFromTable("porte_delegate");
                            sqlQueryObject.addFromTable("mapping_fruizione_pd");
                            sqlQueryObject.addFromTable("pd_azioni");
                            sqlQueryObject.addSelectField("nome_porta");
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQueryObject.addWhereCondition("porte_delegate.nome_porta=?");
                            sqlQueryObject.addWhereCondition("porte_delegate.id=mapping_fruizione_pd.id_porta");
                            sqlQueryObject.addWhereCondition("pd_azioni.id_porta=porte_delegate.id");
                            sqlQueryObject.addWhereCondition("pd_azioni.azione=?");
                            queryString = sqlQueryObject.createSQLQuery();
                            stmt = con.prepareStatement(queryString);
                            stmt.setString(1, mapping.getIdPortaDelegata().getNome());
                            stmt.setString(2, idRisorsa.getNome());
                            risultato = stmt.executeQuery();
                            while (risultato.next()) {
                                String nome = risultato.getString("nome_porta");
                                ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    mappingFruizionePDList.add(resultPorta.label);
                                } else {
                                    porteDelegateList.add(resultPorta.label);
                                }
                                isInUso = true;
                            }
                            risultato.close();
                            stmt.close();
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addFromTable("pd_transform");
                            sqlQueryObject.addFromTable("porte_delegate");
                            sqlQueryObject.addSelectField("nome_porta");
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQueryObject.addWhereCondition("porte_delegate.nome_porta=?");
                            sqlQueryObject.addWhereCondition("pd_transform.id_porta=porte_delegate.id");
                            ISQLQueryObject sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectOr.setANDLogicOperator(false);
                            sqlQueryObjectOr.addWhereLikeCondition("pd_transform.applicabilita_azioni", idRisorsa.getNome(), false, false);
                            sqlQueryObjectOr.addWhereLikeCondition("pd_transform.applicabilita_azioni", idRisorsa.getNome() + ",", LikeConfig.startsWith((boolean)false));
                            sqlQueryObjectOr.addWhereLikeCondition("pd_transform.applicabilita_azioni", "," + idRisorsa.getNome(), LikeConfig.endsWith((boolean)false));
                            sqlQueryObjectOr.addWhereLikeCondition("pd_transform.applicabilita_azioni", "," + idRisorsa.getNome() + ",", true, false);
                            sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
                            queryString = sqlQueryObject.createSQLQuery();
                            stmt = con.prepareStatement(queryString);
                            stmt.setString(1, mapping.getIdPortaDelegata().getNome());
                            risultato = stmt.executeQuery();
                            while (risultato.next()) {
                                String nome = risultato.getString("nome_porta");
                                ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    trasformazionePDMappingList.add(resultPorta.label);
                                } else {
                                    trasformazionePDList.add(resultPorta.label);
                                }
                                isInUso = true;
                            }
                            risultato.close();
                            stmt.close();
                            int max = 2;
                            if (!CostantiDB.isAllarmiEnabled()) {
                                max = 1;
                            }
                            for (int i = 0; i < max; ++i) {
                                String tabella = "ct_active_policy";
                                String identificativoColumn = "active_policy_id";
                                String aliasColumn = "policy_alias";
                                List<String> list = ctList;
                                String oggetto = "Policy";
                                if (i == 1) {
                                    tabella = "allarmi";
                                    identificativoColumn = "nome";
                                    aliasColumn = "alias";
                                    list = allarmeList;
                                    oggetto = "Allarme";
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObject.addFromTable(tabella);
                                sqlQueryObject.addSelectField(identificativoColumn);
                                sqlQueryObject.addSelectField(aliasColumn);
                                sqlQueryObject.addSelectField("filtro_ruolo");
                                sqlQueryObject.addSelectField("filtro_porta");
                                sqlQueryObject.setANDLogicOperator(true);
                                sqlQueryObject.addWhereCondition(tabella + ".filtro_ruolo=?");
                                sqlQueryObject.addWhereCondition(tabella + ".filtro_porta=?");
                                sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObjectOr.setANDLogicOperator(false);
                                sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", idRisorsa.getNome(), false, false);
                                sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", idRisorsa.getNome() + ",", LikeConfig.startsWith((boolean)false));
                                sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", "," + idRisorsa.getNome(), LikeConfig.endsWith((boolean)false));
                                sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", "," + idRisorsa.getNome() + ",", true, false);
                                sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
                                sqlQueryObject.addOrderBy("filtro_ruolo");
                                sqlQueryObject.addOrderBy("filtro_porta");
                                queryString = sqlQueryObject.createSQLQuery();
                                stmt = con.prepareStatement(queryString);
                                stmt.setString(1, "delegata");
                                stmt.setString(2, mapping.getIdPortaDelegata().getNome());
                                risultato = stmt.executeQuery();
                                while (risultato.next()) {
                                    String alias = risultato.getString(aliasColumn);
                                    if (alias == null || "".equals(alias)) {
                                        alias = risultato.getString(identificativoColumn);
                                    }
                                    String nomePorta = risultato.getString("filtro_porta");
                                    String filtroRuolo = risultato.getString("filtro_ruolo");
                                    if (nomePorta != null) {
                                        String tipo = null;
                                        String label = null;
                                        if ("delegata".equals(filtroRuolo)) {
                                            try {
                                                ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                                                if (resultPorta.mapping) {
                                                    label = "Fruizione di Servizio " + resultPorta.label;
                                                }
                                            }
                                            catch (Exception e) {
                                                tipo = "Outbound";
                                            }
                                        } else {
                                            tipo = filtroRuolo;
                                        }
                                        if (label == null) {
                                            list.add(oggetto + " '" + alias + "' attiva nella porta '" + tipo + "' '" + nomePorta + "' ");
                                        } else {
                                            list.add(oggetto + " '" + alias + "' attiva nella " + label);
                                        }
                                    } else {
                                        list.add(oggetto + " '" + alias + "'");
                                    }
                                    isInUso = true;
                                }
                                risultato.close();
                                stmt.close();
                            }
                        }
                    }
                }
            }
            if (config && idServiziWithAccordo != null && !idServiziWithAccordo.isEmpty()) {
                for (IDServizio idServizio : idServiziWithAccordo) {
                    List lPA = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)tipoDB, (IDServizio)idServizio, (boolean)true);
                    if (lPA == null || lPA.isEmpty()) continue;
                    for (MappingErogazionePortaApplicativa mapping : lPA) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("porte_applicative");
                        sqlQueryObject.addFromTable("mapping_erogazione_pa");
                        sqlQueryObject.addFromTable("pa_azioni");
                        sqlQueryObject.addSelectField("nome_porta");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("porte_applicative.nome_porta=?");
                        sqlQueryObject.addWhereCondition("porte_applicative.id=mapping_erogazione_pa.id_porta");
                        sqlQueryObject.addWhereCondition("pa_azioni.id_porta=porte_applicative.id");
                        sqlQueryObject.addWhereCondition("pa_azioni.azione=?");
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setString(1, mapping.getIdPortaApplicativa().getNome());
                        stmt.setString(2, idRisorsa.getNome());
                        risultato = stmt.executeQuery();
                        while (risultato.next()) {
                            String nome = risultato.getString("nome_porta");
                            ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                mappingErogazionePAList.add(resultPorta.label);
                            } else {
                                porteApplicativeList.add(resultPorta.label);
                            }
                            isInUso = true;
                        }
                        risultato.close();
                        stmt.close();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("pa_transform");
                        sqlQueryObject.addFromTable("porte_applicative");
                        sqlQueryObject.addSelectField("nome_porta");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("porte_applicative.nome_porta=?");
                        sqlQueryObject.addWhereCondition("pa_transform.id_porta=porte_applicative.id");
                        ISQLQueryObject sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectOr.setANDLogicOperator(false);
                        sqlQueryObjectOr.addWhereLikeCondition("pa_transform.applicabilita_azioni", idRisorsa.getNome(), false, false);
                        sqlQueryObjectOr.addWhereLikeCondition("pa_transform.applicabilita_azioni", idRisorsa.getNome() + ",", LikeConfig.startsWith((boolean)false));
                        sqlQueryObjectOr.addWhereLikeCondition("pa_transform.applicabilita_azioni", "," + idRisorsa.getNome(), LikeConfig.endsWith((boolean)false));
                        sqlQueryObjectOr.addWhereLikeCondition("pa_transform.applicabilita_azioni", "," + idRisorsa.getNome() + ",", true, false);
                        sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setString(1, mapping.getIdPortaApplicativa().getNome());
                        risultato = stmt.executeQuery();
                        while (risultato.next()) {
                            String nome = risultato.getString("nome_porta");
                            ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                trasformazionePAMappingList.add(resultPorta.label);
                            } else {
                                trasformazionePAList.add(resultPorta.label);
                            }
                            isInUso = true;
                        }
                        risultato.close();
                        stmt.close();
                        int max = 2;
                        if (!CostantiDB.isAllarmiEnabled()) {
                            max = 1;
                        }
                        for (int i = 0; i < max; ++i) {
                            String tabella = "ct_active_policy";
                            String identificativoColumn = "active_policy_id";
                            String aliasColumn = "policy_alias";
                            List<String> list = ctList;
                            String oggetto = "Policy";
                            if (i == 1) {
                                tabella = "allarmi";
                                identificativoColumn = "nome";
                                aliasColumn = "alias";
                                list = allarmeList;
                                oggetto = "Allarme";
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addFromTable(tabella);
                            sqlQueryObject.addSelectField(identificativoColumn);
                            sqlQueryObject.addSelectField(aliasColumn);
                            sqlQueryObject.addSelectField("filtro_ruolo");
                            sqlQueryObject.addSelectField("filtro_porta");
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQueryObject.addWhereCondition(tabella + ".filtro_ruolo=?");
                            sqlQueryObject.addWhereCondition(tabella + ".filtro_porta=?");
                            sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectOr.setANDLogicOperator(false);
                            sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", idRisorsa.getNome(), false, false);
                            sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", idRisorsa.getNome() + ",", LikeConfig.startsWith((boolean)false));
                            sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", "," + idRisorsa.getNome(), LikeConfig.endsWith((boolean)false));
                            sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", "," + idRisorsa.getNome() + ",", true, false);
                            sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
                            sqlQueryObject.addOrderBy("filtro_ruolo");
                            sqlQueryObject.addOrderBy("filtro_porta");
                            queryString = sqlQueryObject.createSQLQuery();
                            stmt = con.prepareStatement(queryString);
                            stmt.setString(1, "applicativa");
                            stmt.setString(2, mapping.getIdPortaApplicativa().getNome());
                            risultato = stmt.executeQuery();
                            while (risultato.next()) {
                                String alias = risultato.getString(aliasColumn);
                                if (alias == null || "".equals(alias)) {
                                    alias = risultato.getString(identificativoColumn);
                                }
                                String nomePorta = risultato.getString("filtro_porta");
                                String filtroRuolo = risultato.getString("filtro_ruolo");
                                if (nomePorta != null) {
                                    String tipo = null;
                                    String label = null;
                                    if ("applicativa".equals(filtroRuolo)) {
                                        try {
                                            ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                                            if (resultPorta.mapping) {
                                                label = "Erogazione di Servizio " + resultPorta.label;
                                            }
                                        }
                                        catch (Exception e) {
                                            tipo = "Inbound";
                                        }
                                    } else {
                                        tipo = filtroRuolo;
                                    }
                                    if (label == null) {
                                        list.add(oggetto + " '" + alias + "' attiva nella porta '" + tipo + "' '" + nomePorta + "' ");
                                    } else {
                                        list.add(oggetto + " '" + alias + "' attiva nella " + label);
                                    }
                                } else {
                                    list.add(oggetto + " '" + alias + "'");
                                }
                                isInUso = true;
                            }
                            risultato.close();
                            stmt.close();
                        }
                    }
                }
            }
            if ((idAccordoServizioParteComune = DBUtils.getIdAccordoServizioParteComune((IDAccordo)idRisorsa.getIdAccordo(), (Connection)con, (String)tipoDB)) <= 0L) {
                throw new UtilsException("Accordi di Servizio Parte Comune con id [" + idRisorsa.getIdAccordo().toString() + "] non trovato");
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteComune);
            risultato = stmt.executeQuery();
            ArrayList<IDServizio> listIDServizio = new ArrayList<IDServizio>();
            while (risultato.next()) {
                String tipoSoggettoErogatore = risultato.getString("tipo_soggetto");
                String nomeSoggettoErogatore = risultato.getString("nome_soggetto");
                String tipoServizio = risultato.getString("tipo_servizio");
                String nomeServizio = risultato.getString("nome_servizio");
                int versioneServizio = risultato.getInt("versione_servizio");
                IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, tipoSoggettoErogatore, nomeSoggettoErogatore, versioneServizio);
                listIDServizio.add(idServizio);
            }
            risultato.close();
            stmt.close();
            if (!listIDServizio.isEmpty()) {
                for (IDServizio idServizio : listIDServizio) {
                    int max = 2;
                    if (!CostantiDB.isAllarmiEnabled()) {
                        max = 1;
                    }
                    for (int i = 0; i < max; ++i) {
                        String tabella = "ct_active_policy";
                        String identificativoColumn = "active_policy_id";
                        String aliasColumn = "policy_alias";
                        List<String> list = ctList;
                        String oggetto = "Policy";
                        if (i == 1) {
                            tabella = "allarmi";
                            identificativoColumn = "nome";
                            aliasColumn = "alias";
                            list = allarmeList;
                            oggetto = "Allarme";
                        }
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable(tabella);
                        sqlQueryObject.setSelectDistinct(true);
                        sqlQueryObject.addSelectField(identificativoColumn);
                        sqlQueryObject.addSelectField(aliasColumn);
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereIsNullCondition(tabella + ".filtro_porta");
                        ISQLQueryObject sqlQueryObjectServizioCompleto = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectServizioCompleto.addWhereCondition(tabella + ".filtro_tipo_erogatore=?");
                        sqlQueryObjectServizioCompleto.addWhereCondition(tabella + ".filtro_nome_erogatore=?");
                        sqlQueryObjectServizioCompleto.addWhereCondition(tabella + ".filtro_tipo_servizio=?");
                        sqlQueryObjectServizioCompleto.addWhereCondition(tabella + ".filtro_nome_servizio=?");
                        sqlQueryObjectServizioCompleto.addWhereCondition(tabella + ".filtro_versione_servizio=?");
                        ISQLQueryObject sqlQueryObjectServizioParziale = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectServizioParziale.addWhereIsNullCondition(tabella + ".filtro_tipo_erogatore");
                        sqlQueryObjectServizioParziale.addWhereIsNullCondition(tabella + ".filtro_nome_erogatore");
                        sqlQueryObjectServizioParziale.addWhereCondition(tabella + ".filtro_tipo_servizio=?");
                        sqlQueryObjectServizioParziale.addWhereCondition(tabella + ".filtro_nome_servizio=?");
                        sqlQueryObjectServizioParziale.addWhereCondition(tabella + ".filtro_versione_servizio=?");
                        sqlQueryObject.addWhereCondition(false, false, new String[]{sqlQueryObjectServizioCompleto.createSQLConditions(), sqlQueryObjectServizioParziale.createSQLConditions()});
                        ISQLQueryObject sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectOr.setANDLogicOperator(false);
                        sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", idRisorsa.getNome(), false, false);
                        sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", idRisorsa.getNome() + ",", LikeConfig.startsWith((boolean)false));
                        sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", "," + idRisorsa.getNome(), LikeConfig.endsWith((boolean)false));
                        sqlQueryObjectOr.addWhereLikeCondition(tabella + ".filtro_azione", "," + idRisorsa.getNome() + ",", true, false);
                        sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
                        sqlQueryObject.addOrderBy(aliasColumn);
                        sqlQueryObject.addOrderBy(identificativoColumn);
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        int index = 1;
                        stmt.setString(index++, idServizio.getSoggettoErogatore().getTipo());
                        stmt.setString(index++, idServizio.getSoggettoErogatore().getNome());
                        stmt.setString(index++, idServizio.getTipo());
                        stmt.setString(index++, idServizio.getNome());
                        stmt.setInt(index++, idServizio.getVersione());
                        stmt.setString(index++, idServizio.getTipo());
                        stmt.setString(index++, idServizio.getNome());
                        stmt.setInt(index++, idServizio.getVersione());
                        risultato = stmt.executeQuery();
                        while (risultato.next()) {
                            String oggettoTrovato;
                            String alias = risultato.getString(aliasColumn);
                            if (alias == null || "".equals(alias)) {
                                alias = risultato.getString(identificativoColumn);
                            }
                            if (!list.contains(oggettoTrovato = oggetto + " '" + alias + "'")) {
                                list.add(oggettoTrovato);
                            }
                            isInUso = true;
                        }
                        risultato.close();
                        stmt.close();
                    }
                }
            }
            if (registry && "modipa".equals(idRisorsa.getIdAccordo().getSoggettoReferente().getTipo()) && idServiziWithAccordo != null && !idServiziWithAccordo.isEmpty()) {
                for (IDServizio idServizio : idServiziWithAccordo) {
                    long idS = DBUtils.getIdServizio((String)idServizio.getNome(), (String)idServizio.getTipo(), (Integer)idServizio.getVersione(), (String)idServizio.getSoggettoErogatore().getNome(), (String)idServizio.getSoggettoErogatore().getTipo(), (Connection)con, (String)tipoDB);
                    if (idS <= 0L) {
                        throw new CoreException("Servizio '" + String.valueOf(idServizio) + "' non esistente");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi");
                    sqlQueryObject.addFromTable("protocol_properties");
                    sqlQueryObject.addSelectAliasField("servizi", "id", "idServizio");
                    sqlQueryObject.addWhereCondition("servizi.id = ?");
                    sqlQueryObject.addWhereCondition("servizi.id = protocol_properties.id_proprietario");
                    sqlQueryObject.addWhereCondition("protocol_properties.tipo_proprietario=?");
                    sqlQueryObject.addWhereCondition("protocol_properties.name=?");
                    sqlQueryObject.addWhereCondition("protocol_properties.value_string=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    int index = 1;
                    stmt.setLong(index++, idS);
                    stmt.setString(index++, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_SPECIFICA.name());
                    stmt.setString(index++, "modipaInfoGenSignalHubOp");
                    stmt.setString(index++, idRisorsa.getNome());
                    risultato = stmt.executeQuery();
                    if (!risultato.next()) continue;
                    IDPortaApplicativa idPA = DBMappingUtils.getIDPortaApplicativaAssociataDefault((IDServizio)idServizio, (Connection)con, (String)tipoDB);
                    if (idPA != null) {
                        ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(idPA.getNome(), tipoDB, con, normalizeObjectIds);
                        modiSignalHubList.add(resultPorta.label);
                    } else {
                        modiSignalHubList.add(idServizio.toString());
                    }
                    isInUso = true;
                }
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    protected static String toString(IDResource idRisorsa, String methodPath, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_accordiRest.toString(idRisorsa, methodPath, whereIsInUso, prefix, separator, " non eliminabile perch&egrave; :");
    }

    protected static String toString(IDResource idRisorsa, String methodPath, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        StringBuilder msgBuilder = new StringBuilder("Risorsa '" + (methodPath != null ? methodPath : idRisorsa.getNome()) + "'" + intestazione + separator);
        if (!prefix) {
            msgBuilder = new StringBuilder("");
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block14: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && !messages.isEmpty()) {
                msgBuilder.append(separatorCategorie);
            }
            switch (key) {
                case IS_CORRELATA: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("correlata ad altre risorse: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("appartenente ad un gruppo differente da quello predefinito nelle Porte Inbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case IN_USO_IN_PORTE_DELEGATE: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("appartenente ad un gruppo differente da quello predefinito nelle Porte Outbound: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("appartenente ad un gruppo differente da quello predefinito nelle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("appartenente ad un gruppo differente da quello predefinito nelle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case TRASFORMAZIONE_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("utilizzata nel criterio di applicabilit\u00e0 della Trasformazione (Risorse) per le Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case TRASFORMAZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("utilizzata nelle Porte Outbound (Criterio di applicabilit\u00e0 della Trasformazione - Risorse): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case TRASFORMAZIONE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("utilizzata nel criterio di applicabilit\u00e0 della Trasformazione (Risorse) per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case TRASFORMAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("utilizzata nelle Porte Inbound (Criterio di applicabilit\u00e0 della Trasformazione - Risorse): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("utilizzata in Policy di Rate Limiting: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case ALLARMI: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("utilizzato in Allarmi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
                case IS_RIFERITA_MODI_SIGNAL_HUB: {
                    if (messages == null || messages.isEmpty()) continue block14;
                    msgBuilder.append("riferito nella configurazione 'SignalHub' dell'erogazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block14;
                }
            }
            msgBuilder.append("utilizzata in oggetto non codificato (" + String.valueOf(key) + ")" + separator);
        }
        return msgBuilder.toString();
    }
}

