/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class DBManager {
    private static Logger checkLogger = null;
    private static boolean checkIsClosed = true;
    private static boolean checkAutocommit = true;
    private static Logger log = null;
    private static DBManager manager = null;
    private static boolean initialized = false;
    private ServiceManagerProperties serviceManagerPropertiesConfig;
    private DataSource dataSourceConfig = null;
    private String dataSourceConfigName = null;
    private Properties dataSourceConfigContext = null;
    private ServiceManagerProperties serviceManagerPropertiesTracce;
    private DataSource dataSourceTracce = null;
    private String dataSourceTracceName = null;
    private Properties dataSourceTracceContext = null;
    private ServiceManagerProperties serviceManagerPropertiesStatistiche;
    private DataSource dataSourceStatistiche = null;
    private String dataSourceStatisticheName = null;
    private Properties dataSourceStatisticheContext = null;

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        DBManager.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        DBManager.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        DBManager.checkLogger = checkLogger;
    }

    public ServiceManagerProperties getServiceManagerPropertiesConfig() {
        return this.serviceManagerPropertiesConfig;
    }

    public String getDataSourceConfigName() {
        return this.dataSourceConfigName;
    }

    public Properties getDataSourceConfigContext() {
        return this.dataSourceConfigContext;
    }

    public ServiceManagerProperties getServiceManagerPropertiesTracce() {
        return this.serviceManagerPropertiesTracce;
    }

    public String getDataSourceTracceName() {
        return this.dataSourceTracceName;
    }

    public Properties getDataSourceTracceContext() {
        return this.dataSourceTracceContext;
    }

    public ServiceManagerProperties getServiceManagerPropertiesStatistiche() {
        return this.serviceManagerPropertiesStatistiche;
    }

    public String getDataSourceStatisticheName() {
        return this.dataSourceStatisticheName;
    }

    public Properties getDataSourceStatisticheContext() {
        return this.dataSourceStatisticheContext;
    }

    private DBManager(String jndiNameConfig, Properties contextConfig, String tipoDBConfig, String jndiNameTracce, Properties contextTracce, String tipoDBTracce, String jndiNameStatistiche, Properties contextStatistiche, String tipoDBStatistiche, boolean debug) throws Exception {
        try {
            String key;
            Enumeration<Object> en;
            log = LoggerProperties.getLoggerCore();
            this.dataSourceConfigName = jndiNameConfig;
            this.dataSourceConfigContext = contextConfig;
            if (this.dataSourceConfigContext != null) {
                log.info("Proprieta' di contesto:" + this.dataSourceConfigContext.size());
                Enumeration<Object> en2 = this.dataSourceConfigContext.keys();
                while (en2.hasMoreElements()) {
                    String key2 = (String)en2.nextElement();
                    log.info("\tNome[" + key2 + "] Valore[" + this.dataSourceConfigContext.getProperty(key2) + "]");
                }
            } else {
                log.info("Proprieta' di contesto non fornite");
            }
            log.info("Nome dataSource:" + this.dataSourceConfigName);
            InitialContext initC = null;
            initC = this.dataSourceConfigContext != null && this.dataSourceConfigContext.size() > 0 ? new InitialContext(this.dataSourceConfigContext) : new InitialContext();
            this.dataSourceConfig = (DataSource)initC.lookup(this.dataSourceConfigName);
            initC.close();
            this.serviceManagerPropertiesConfig = new ServiceManagerProperties();
            this.serviceManagerPropertiesConfig.setDatabaseType(tipoDBConfig);
            this.serviceManagerPropertiesConfig.setShowSql(debug);
            this.dataSourceTracceName = jndiNameTracce;
            this.dataSourceTracceContext = contextTracce;
            if (this.dataSourceTracceContext != null) {
                log.info("Proprieta' di contesto:" + this.dataSourceTracceContext.size());
                en = this.dataSourceTracceContext.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    log.info("\tNome[" + key + "] Valore[" + this.dataSourceTracceContext.getProperty(key) + "]");
                }
            } else {
                log.info("Proprieta' di contesto non fornite");
            }
            log.info("Nome dataSource:" + this.dataSourceTracceName);
            initC = null;
            initC = this.dataSourceTracceContext != null && this.dataSourceTracceContext.size() > 0 ? new InitialContext(this.dataSourceTracceContext) : new InitialContext();
            this.dataSourceTracce = (DataSource)initC.lookup(this.dataSourceTracceName);
            initC.close();
            this.serviceManagerPropertiesTracce = new ServiceManagerProperties();
            this.serviceManagerPropertiesTracce.setDatabaseType(tipoDBTracce);
            this.serviceManagerPropertiesTracce.setShowSql(debug);
            this.dataSourceStatisticheName = jndiNameStatistiche;
            this.dataSourceStatisticheContext = contextStatistiche;
            if (this.dataSourceStatisticheContext != null) {
                log.info("Proprieta' di contesto:" + this.dataSourceStatisticheContext.size());
                en = this.dataSourceStatisticheContext.keys();
                while (en.hasMoreElements()) {
                    key = (String)en.nextElement();
                    log.info("\tNome[" + key + "] Valore[" + this.dataSourceStatisticheContext.getProperty(key) + "]");
                }
            } else {
                log.info("Proprieta' di contesto non fornite");
            }
            log.info("Nome dataSource:" + this.dataSourceStatisticheName);
            initC = null;
            initC = this.dataSourceStatisticheContext != null && this.dataSourceStatisticheContext.size() > 0 ? new InitialContext(this.dataSourceStatisticheContext) : new InitialContext();
            this.dataSourceStatistiche = (DataSource)initC.lookup(this.dataSourceStatisticheName);
            initC.close();
            this.serviceManagerPropertiesStatistiche = new ServiceManagerProperties();
            this.serviceManagerPropertiesStatistiche.setDatabaseType(tipoDBStatistiche);
            this.serviceManagerPropertiesStatistiche.setShowSql(debug);
        }
        catch (Exception e) {
            log.error("Lookup datasource non riuscita", (Throwable)e);
            throw e;
        }
    }

    public static synchronized boolean initialize(String jndiNameConfig, Properties contextConfig, String tipoDBConfig, String jndiNameTracce, Properties contextTracce, String tipoDBTracce, String jndiNameStatistiche, Properties contextStatistiche, String tipoDBStatistiche, boolean debug) throws Exception {
        try {
            if (manager == null) {
                manager = new DBManager(jndiNameConfig, contextConfig, tipoDBConfig, jndiNameTracce, contextTracce, tipoDBTracce, jndiNameStatistiche, contextStatistiche, tipoDBStatistiche, debug);
                DBManager.setInitialized(true);
            }
            return true;
        }
        catch (Exception e) {
            DBManager.setInitialized(false);
            log.debug("Errore di inizializzazione del Database", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBManager getInstance() {
        if (manager == null) {
            Class<DBManager> clazz = DBManager.class;
            synchronized (DBManager.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return manager;
            }
        }
        return manager;
    }

    public Connection getConnectionConfig() {
        if (this.dataSourceConfig == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.dataSourceConfig.getConnection();
        }
        catch (Exception e) {
            log.error("getConnectionConfig from db", (Throwable)e);
            return null;
        }
        return connectionDB;
    }

    public void releaseConnectionConfig(Connection connectionDB) {
        try {
            JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
        }
        catch (SQLException e) {
            log.error("closeConnection config db", (Throwable)e);
        }
    }

    public Connection getConnectionTracce() {
        if (this.dataSourceTracce == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.dataSourceTracce.getConnection();
        }
        catch (Exception e) {
            log.error("getConnectionTracce from db", (Throwable)e);
            return null;
        }
        return connectionDB;
    }

    public void releaseConnectionTracce(Connection connectionDB) {
        try {
            JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
        }
        catch (SQLException e) {
            log.error("closeConnection tracce db", (Throwable)e);
        }
    }

    public Connection getConnectionStatistiche() {
        if (this.dataSourceStatistiche == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.dataSourceStatistiche.getConnection();
        }
        catch (Exception e) {
            log.error("getConnectionStatistiche from db", (Throwable)e);
            return null;
        }
        return connectionDB;
    }

    public void releaseConnectionStatistiche(Connection connectionDB) {
        try {
            JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
        }
        catch (SQLException e) {
            log.error("closeConnection statistiche db", (Throwable)e);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static void setInitialized(boolean initialized) {
        DBManager.initialized = initialized;
    }
}

