/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api.impl.utils;

import jakarta.ws.rs.core.UriInfo;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.CheckNotNull;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Converter;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Enums;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.MonitoraggioEnv;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.ReportisticaHelper;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.SearchFormUtilities;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.monitor.rs.server.model.EsitoTransazioneFullSearchEnum;
import org.openspcoop2.core.monitor.rs.server.model.FiltroApiBase;
import org.openspcoop2.core.monitor.rs.server.model.FiltroApiSoggetti;
import org.openspcoop2.core.monitor.rs.server.model.FiltroEsito;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteErogazioneApplicativo;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteErogazioneSoggetto;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteFruizioneApplicativo;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteIdAutenticato;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteIndirizzoIP;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteTokenClaim;
import org.openspcoop2.core.monitor.rs.server.model.FiltroMittenteTokenClaimSoggetto;
import org.openspcoop2.core.monitor.rs.server.model.FiltroRicercaRuoloTransazioneEnum;
import org.openspcoop2.core.monitor.rs.server.model.ListaTransazioni;
import org.openspcoop2.core.monitor.rs.server.model.OneOfRicercaIntervalloTemporaleMittente;
import org.openspcoop2.core.monitor.rs.server.model.RicercaBaseTransazione;
import org.openspcoop2.core.monitor.rs.server.model.RicercaIdApplicativo;
import org.openspcoop2.core.monitor.rs.server.model.RicercaIntervalloTemporale;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.service.beans.FiltroRicercaId;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.TransazioniService;

public class TransazioniHelper {
    public static boolean isEmpty(IDSoggetto _this) {
        return StringUtils.isEmpty((CharSequence)_this.getTipo()) || StringUtils.isEmpty((CharSequence)_this.getNome());
    }

    public static final void overrideFiltroApiBase(FiltroApiBase filtro_api, String azione, IDSoggetto erogatore, TransazioniSearchForm search, MonitoraggioEnv env) {
        FiltroApiSoggetti f;
        search.setNomeAzione(azione);
        if (filtro_api == null) {
            return;
        }
        boolean checkAzione = true;
        if (filtro_api instanceof FiltroApiSoggetti && (f = (FiltroApiSoggetti)filtro_api).getApiImplementata() != null) {
            checkAzione = false;
        }
        if (!StringUtils.isEmpty((CharSequence)filtro_api.getNome()) || filtro_api.getVersione() != null || checkAzione && !StringUtils.isEmpty((CharSequence)azione) || !StringUtils.isEmpty((CharSequence)filtro_api.getTipo())) {
            String uri;
            if (StringUtils.isEmpty((CharSequence)filtro_api.getNome())) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Filtro Api incompleto. Specificare il nome della API");
            }
            if (erogatore == null || TransazioniHelper.isEmpty(erogatore)) {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Filtro Api incompleto. Specificare il Soggetto Erogatore (Nelle fruizioni \u00e8 il soggetto remoto)");
            }
            if (filtro_api.getVersione() == null) {
                filtro_api.setVersione(1);
            }
            if (filtro_api.getTipo() == null) {
                try {
                    IProtocolConfiguration protocolConf = env.protocolFactoryMgr.getProtocolFactoryByName(env.tipo_protocollo).createProtocolConfiguration();
                    ServiceBinding defaultBinding = protocolConf.getDefaultServiceBindingConfiguration(null).getDefaultBinding();
                    filtro_api.setTipo(protocolConf.getTipoServizioDefault(defaultBinding));
                }
                catch (Exception e) {
                    throw FaultCode.ERRORE_INTERNO.toException("Impossibile determinare il tipo del servizio: " + e.getMessage());
                }
            }
            if ((uri = ReportisticaHelper.buildNomeServizioForOverride(filtro_api.getNome(), filtro_api.getTipo(), filtro_api.getVersione(), Optional.of(erogatore))) == null) {
                throw FaultCode.ERRORE_INTERNO.toException("Non sono riuscito a costruire la URI dell'Id Servizio");
            }
            search.setNomeServizio(uri);
        }
    }

    public static final void overrideFiltroFruizione(FiltroApiSoggetti filtro, String azione, TransazioniSearchForm search, MonitoraggioEnv env) {
        if (filtro == null) {
            return;
        }
        TransazioniHelper.overrideFiltroApiBase(filtro, azione, new IDSoggetto(env.tipoSoggetto, filtro.getErogatore()), search, env);
    }

    public static final void overrideFiltroQualsiasi(FiltroApiSoggetti filtro, String azione, TransazioniSearchForm search, MonitoraggioEnv env) {
        if (filtro == null) {
            return;
        }
        TransazioniHelper.overrideFiltroApiBase(filtro, azione, new IDSoggetto(env.tipoSoggetto, filtro.getErogatore()), search, env);
        if (!StringUtils.isEmpty((CharSequence)filtro.getSoggettoRemoto())) {
            search.setTipoNomeTrafficoPerSoggetto(new IDSoggetto(env.tipoSoggetto, filtro.getSoggettoRemoto()).toString());
        }
    }

    public static final void overrideFiltroRicercaId(FiltroRicercaId filtro, TransazioniSearchForm search, MonitoraggioEnv env, String tipoRiconoscimento) {
        if (filtro == null) {
            return;
        }
        search.setMittenteMatchingType((BooleanUtils.isTrue((Boolean)filtro.isRicercaEsatta()) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
        search.setMittenteCaseSensitiveType((BooleanUtils.isTrue((Boolean)filtro.isCaseSensitive()) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
        search.setValoreRiconoscimento(filtro.getId());
        search.setRiconoscimento(tipoRiconoscimento);
    }

    public static final void overrideFiltroMittenteIdApplicativo(FiltroMittenteIdAutenticato filtro, TransazioniSearchForm search, MonitoraggioEnv env) {
        if (filtro == null) {
            return;
        }
        TransazioniHelper.overrideFiltroRicercaId(filtro, search, env, "identificativoAutenticato");
        search.setAutenticazione(Enums.toTipoAutenticazione.get((Object)filtro.getAutenticazione()).toString());
    }

    public static final void overrideFiltroMittenteIndirizzoIP(FiltroMittenteIndirizzoIP filtro, TransazioniSearchForm search, MonitoraggioEnv env) {
        if (filtro == null) {
            return;
        }
        TransazioniHelper.overrideFiltroRicercaId(filtro, search, env, "ip");
        if (filtro.getTipo() != null) {
            search.setClientAddressMode(Enums.toTipoIndirizzzoIP.get((Object)filtro.getTipo()));
        }
    }

    private static void setEsitoCodice(EsitoTransazioneFullSearchEnum tipo, FiltroEsito filtro, TransazioniSearchForm search) {
        if (filtro.getCodice() != null) {
            search.setEsitoDettaglio(filtro.getCodice());
        } else if (filtro.getCodici() != null && !filtro.getCodici().isEmpty()) {
            if (filtro.getCodici().size() == 1) {
                search.setEsitoDettaglio(filtro.getCodici().get(0));
            } else {
                throw FaultCode.RICHIESTA_NON_VALIDA.toException("Con il tipo di esito indicato '" + tipo.toString() + "' pu\u00f2 essere indicato solamente un codice");
            }
        }
    }

    public static final void overrideFiltroEsito(FiltroEsito filtro, TransazioniSearchForm search, MonitoraggioEnv env) {
        if (filtro == null) {
            return;
        }
        if (filtro != null) {
            EsitoTransazioneFullSearchEnum tipo = CheckNotNull.getEsitoTransazione(filtro);
            switch (tipo) {
                case QUALSIASI: {
                    search.setEsitoGruppo(EsitoUtils.ALL_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    if (filtro.isEscludiScartate() == null) break;
                    search.setEscludiRichiesteScartate(filtro.isEscludiScartate().booleanValue());
                    break;
                }
                case OK: {
                    search.setEsitoGruppo(EsitoUtils.ALL_OK_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    break;
                }
                case FAULT: {
                    search.setEsitoGruppo(EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    break;
                }
                case FALLITE: {
                    search.setEsitoGruppo(EsitoUtils.ALL_ERROR_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    if (filtro.isEscludiScartate() == null) break;
                    search.setEscludiRichiesteScartate(filtro.isEscludiScartate().booleanValue());
                    break;
                }
                case FALLITE_E_FAULT: {
                    search.setEsitoGruppo(EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    if (filtro.isEscludiScartate() == null) break;
                    search.setEscludiRichiesteScartate(filtro.isEscludiScartate().booleanValue());
                    break;
                }
                case ERRORI_CONSEGNA: {
                    search.setEsitoGruppo(EsitoUtils.ALL_ERROR_CONSEGNA_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    break;
                }
                case RICHIESTE_SCARTATE: {
                    search.setEsitoGruppo(EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE);
                    TransazioniHelper.setEsitoCodice(tipo, filtro, search);
                    break;
                }
                case PERSONALIZZATO: {
                    search.setEsitoGruppo(EsitoUtils.ALL_PERSONALIZZATO_VALUE);
                    if (filtro.getCodice() == null && (filtro.getCodici() == null || filtro.getCodici().isEmpty())) {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Con il tipo di esito indicato '" + tipo.toString() + "' deve essere indicato almeno un codice");
                    }
                    List<Integer> dettaglioEsito = filtro.getCodici();
                    if (dettaglioEsito == null || dettaglioEsito.isEmpty()) {
                        dettaglioEsito = new ArrayList<Integer>();
                        dettaglioEsito.add(filtro.getCodice());
                    }
                    search.setEsitoDettaglioPersonalizzato(dettaglioEsito.toArray(new Integer[1]));
                }
            }
        }
    }

    public static final void overrideRicercaBaseTransazione(RicercaBaseTransazione body, TransazioniSearchForm search, MonitoraggioEnv env) throws Exception {
        if (body == null) {
            return;
        }
        if (body.getAzione() != null && body.getApi() == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Se viene specificato il filtro 'azione' \u00e8 necessario specificare anche il filtro Api");
        }
        search.setGruppo(body.getTag());
        if (body.getApi() != null && body.getApi().getApiImplementata() != null) {
            search.setApi(ReportisticaHelper.toUriApiImplementata(body.getApi().getApiImplementata(), env));
        }
        switch (body.getTipo()) {
            case EROGAZIONE: {
                IDSoggetto idSoggettoLocale = new IDSoggetto(env.tipoSoggetto, env.nomeSoggettoLocale);
                TransazioniHelper.overrideFiltroApiBase(body.getApi(), body.getAzione(), idSoggettoLocale, search, env);
                break;
            }
            case FRUIZIONE: {
                TransazioniHelper.overrideFiltroFruizione(body.getApi(), body.getAzione(), search, env);
                break;
            }
            case QUALSIASI: {
                TransazioniHelper.overrideFiltroQualsiasi(body.getApi(), body.getAzione(), search, env);
            }
        }
        TransazioniHelper.overrideFiltroEsito(body.getEsito(), search, env);
        search.setEvento(body.getEvento());
        search.setClusterId(body.getIdCluster());
    }

    public static final void overrideFiltroMittente(RicercaIntervalloTemporale body, TransazioniSearchForm search, MonitoraggioEnv env) {
        if (body == null) {
            return;
        }
        OneOfRicercaIntervalloTemporaleMittente fMittente = body.getMittente();
        if (fMittente == null) {
            return;
        }
        String tipo_soggetto = env.tipoSoggetto;
        block0 : switch (body.getTipo()) {
            case FRUIZIONE: {
                switch (fMittente.getIdentificazione()) {
                    case EROGAZIONE_SOGGETTO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.FRUIZIONE.toString() + "'");
                    }
                    case FRUIZIONE_APPLICATIVO: {
                        if (!(fMittente instanceof FiltroMittenteFruizioneApplicativo)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteFruizioneApplicativo.class.getName() + ")");
                        }
                        FiltroMittenteFruizioneApplicativo fAppl = (FiltroMittenteFruizioneApplicativo)fMittente;
                        search.setRiconoscimento("applicativo");
                        if (fAppl.getTipoIdentificazioneApplicativo() != null) {
                            switch (fAppl.getTipoIdentificazioneApplicativo()) {
                                case TRASPORTO: {
                                    search.setIdentificazione("commons.identificazione.trasporto.label");
                                    break;
                                }
                                case TOKEN: {
                                    search.setIdentificazione("commons.identificazione.token.label");
                                }
                            }
                        } else {
                            search.setIdentificazione("commons.identificazione.trasporto.label");
                        }
                        search.setServizioApplicativo(fAppl.getApplicativo());
                        search.setTipoNomeMittente(new IDSoggetto(tipo_soggetto, env.nomeSoggettoLocale).toString());
                        break block0;
                    }
                    case EROGAZIONE_APPLICATIVO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.FRUIZIONE.toString() + "'");
                    }
                    case IDENTIFICATIVO_AUTENTICATO: {
                        if (!(fMittente instanceof FiltroMittenteIdAutenticato)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteIdAutenticato.class.getName() + ")");
                        }
                        FiltroMittenteIdAutenticato fIdAutenticato = (FiltroMittenteIdAutenticato)fMittente;
                        TransazioniHelper.overrideFiltroMittenteIdApplicativo(fIdAutenticato, search, env);
                        break block0;
                    }
                    case EROGAZIONE_TOKEN_INFO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.FRUIZIONE.toString() + "'");
                    }
                    case TOKEN_INFO: {
                        if (!(fMittente instanceof FiltroMittenteTokenClaim)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteTokenClaim.class.getName() + ")");
                        }
                        FiltroMittenteTokenClaim fClaim = (FiltroMittenteTokenClaim)fMittente;
                        search.setRiconoscimento("tokenInfo");
                        search.setTokenClaim(Enums.toTipoCredenzialeMittente(fClaim.getClaim()).getRawValue());
                        search.setMittenteMatchingType((BooleanUtils.isTrue((Boolean)fClaim.isRicercaEsatta()) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
                        search.setMittenteCaseSensitiveType((BooleanUtils.isTrue((Boolean)fClaim.isCaseSensitive()) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
                        search.setValoreRiconoscimento(fClaim.getId());
                        break block0;
                    }
                    case INDIRIZZO_IP: {
                        if (!(fMittente instanceof FiltroMittenteIndirizzoIP)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteIndirizzoIP.class.getName() + ")");
                        }
                        FiltroMittenteIndirizzoIP fIndirizzoIP = (FiltroMittenteIndirizzoIP)fMittente;
                        TransazioniHelper.overrideFiltroMittenteIndirizzoIP(fIndirizzoIP, search, env);
                        break block0;
                    }
                }
                break;
            }
            case EROGAZIONE: {
                switch (fMittente.getIdentificazione()) {
                    case EROGAZIONE_SOGGETTO: {
                        if (!(fMittente instanceof FiltroMittenteErogazioneSoggetto)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteErogazioneSoggetto.class.getName() + ")");
                        }
                        FiltroMittenteErogazioneSoggetto fSogg = (FiltroMittenteErogazioneSoggetto)fMittente;
                        search.setRiconoscimento("soggetto");
                        search.setTipoNomeMittente(new IDSoggetto(tipo_soggetto, fSogg.getSoggetto()).toString());
                        break;
                    }
                    case FRUIZIONE_APPLICATIVO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.EROGAZIONE.toString() + "'");
                    }
                    case EROGAZIONE_APPLICATIVO: {
                        if (!(fMittente instanceof FiltroMittenteErogazioneApplicativo)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteErogazioneApplicativo.class.getName() + ")");
                        }
                        FiltroMittenteErogazioneApplicativo fAppl = (FiltroMittenteErogazioneApplicativo)fMittente;
                        search.setRiconoscimento("applicativo");
                        if (fAppl.getTipoIdentificazioneApplicativo() != null) {
                            switch (fAppl.getTipoIdentificazioneApplicativo()) {
                                case TRASPORTO: {
                                    search.setIdentificazione("commons.identificazione.trasporto.label");
                                    break;
                                }
                                case TOKEN: {
                                    search.setIdentificazione("commons.identificazione.token.label");
                                }
                            }
                        } else {
                            search.setIdentificazione("commons.identificazione.trasporto.label");
                        }
                        search.setServizioApplicativo(fAppl.getApplicativo());
                        search.setTipoNomeMittente(new IDSoggetto(tipo_soggetto, fAppl.getSoggetto()).toString());
                        break;
                    }
                    case IDENTIFICATIVO_AUTENTICATO: {
                        if (!(fMittente instanceof FiltroMittenteIdAutenticato)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteIdAutenticato.class.getName() + ")");
                        }
                        FiltroMittenteIdAutenticato fIdAutenticato = (FiltroMittenteIdAutenticato)fMittente;
                        TransazioniHelper.overrideFiltroMittenteIdApplicativo(fIdAutenticato, search, env);
                        break;
                    }
                    case EROGAZIONE_TOKEN_INFO: {
                        if (!(fMittente instanceof FiltroMittenteTokenClaimSoggetto)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteTokenClaimSoggetto.class.getName() + ")");
                        }
                        FiltroMittenteTokenClaimSoggetto fClaim = (FiltroMittenteTokenClaimSoggetto)fMittente;
                        search.setRiconoscimento("tokenInfo");
                        search.setTokenClaim(Enums.toTipoCredenzialeMittente(fClaim.getClaim()).getRawValue());
                        search.setMittenteMatchingType((BooleanUtils.isTrue((Boolean)fClaim.isRicercaEsatta()) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
                        search.setMittenteCaseSensitiveType((BooleanUtils.isTrue((Boolean)fClaim.isCaseSensitive()) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
                        search.setValoreRiconoscimento(fClaim.getId());
                        if (StringUtils.isEmpty((CharSequence)fClaim.getSoggetto())) break;
                        search.setTipoNomeMittente(new IDSoggetto(tipo_soggetto, fClaim.getSoggetto()).toString());
                        break;
                    }
                    case TOKEN_INFO: {
                        if (!(fMittente instanceof FiltroMittenteTokenClaim)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteTokenClaim.class.getName() + ")");
                        }
                        FiltroMittenteTokenClaim fClaim = (FiltroMittenteTokenClaim)fMittente;
                        search.setRiconoscimento("tokenInfo");
                        search.setTokenClaim(Enums.toTipoCredenzialeMittente(fClaim.getClaim()).getRawValue());
                        search.setMittenteMatchingType((BooleanUtils.isTrue((Boolean)fClaim.isRicercaEsatta()) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
                        search.setMittenteCaseSensitiveType((BooleanUtils.isTrue((Boolean)fClaim.isCaseSensitive()) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
                        search.setValoreRiconoscimento(fClaim.getId());
                        break;
                    }
                    case INDIRIZZO_IP: {
                        if (!(fMittente instanceof FiltroMittenteIndirizzoIP)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteIndirizzoIP.class.getName() + ")");
                        }
                        FiltroMittenteIndirizzoIP fIndirizzoIP = (FiltroMittenteIndirizzoIP)fMittente;
                        TransazioniHelper.overrideFiltroMittenteIndirizzoIP(fIndirizzoIP, search, env);
                        break;
                    }
                }
                break;
            }
            case QUALSIASI: {
                switch (fMittente.getIdentificazione()) {
                    case EROGAZIONE_SOGGETTO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.QUALSIASI.toString() + "'");
                    }
                    case FRUIZIONE_APPLICATIVO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.QUALSIASI.toString() + "'");
                    }
                    case EROGAZIONE_APPLICATIVO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.QUALSIASI.toString() + "'");
                    }
                    case IDENTIFICATIVO_AUTENTICATO: {
                        if (!(fMittente instanceof FiltroMittenteIdAutenticato)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteIdAutenticato.class.getName() + ")");
                        }
                        FiltroMittenteIdAutenticato fIdAutenticato = (FiltroMittenteIdAutenticato)fMittente;
                        TransazioniHelper.overrideFiltroMittenteIdApplicativo(fIdAutenticato, search, env);
                        break block0;
                    }
                    case EROGAZIONE_TOKEN_INFO: {
                        throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile in una ricerca di transazioni con il criterio ruolo impostato al valore '" + FiltroRicercaRuoloTransazioneEnum.QUALSIASI.toString() + "'");
                    }
                    case TOKEN_INFO: {
                        if (!(fMittente instanceof FiltroMittenteTokenClaim)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteTokenClaim.class.getName() + ")");
                        }
                        FiltroMittenteTokenClaim fClaim = (FiltroMittenteTokenClaim)fMittente;
                        search.setRiconoscimento("tokenInfo");
                        search.setTokenClaim(Enums.toTipoCredenzialeMittente(fClaim.getClaim()).getRawValue());
                        search.setMittenteMatchingType((BooleanUtils.isTrue((Boolean)fClaim.isRicercaEsatta()) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
                        search.setMittenteCaseSensitiveType((BooleanUtils.isTrue((Boolean)fClaim.isCaseSensitive()) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
                        search.setValoreRiconoscimento(fClaim.getId());
                        break block0;
                    }
                    case INDIRIZZO_IP: {
                        if (!(fMittente instanceof FiltroMittenteIndirizzoIP)) {
                            throw FaultCode.RICHIESTA_NON_VALIDA.toException("Identificazione '" + fMittente.getIdentificazione().toString() + "' non utilizzabile con il tipo di filtro mittente utilizzato '" + fMittente.getClass().getName() + "' (atteso: " + FiltroMittenteIndirizzoIP.class.getName() + ")");
                        }
                        FiltroMittenteIndirizzoIP fIndirizzoIP = (FiltroMittenteIndirizzoIP)fMittente;
                        TransazioniHelper.overrideFiltroMittenteIndirizzoIP(fIndirizzoIP, search, env);
                        break block0;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ListaTransazioni searchTransazioni(TransazioniSearchForm search, Integer offset, Integer limit, String sort, MonitoraggioEnv env) throws UtilsException, InstantiationException, IllegalAccessException {
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionTracce();
            ServerProperties serverProperties = ServerProperties.getInstance();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesTracce();
            TransazioniService transazioniService = new TransazioniService(connection, true, smp, LoggerProperties.getLoggerDAO());
            transazioniService.setSearch(search);
            List listTransazioniDB = transazioniService.findAll(Converter.toOffset(offset).intValue(), Converter.toLimit(limit).intValue(), Converter.toSortOrder(sort), Converter.toSortField(sort));
            if (listTransazioniDB != null && !listTransazioniDB.isEmpty()) {
                for (TransazioneBean transazioneBean : listTransazioniDB) {
                    if (transazioneBean.getGruppiRawValue() != null && !"".equals(transazioneBean.getGruppiRawValue())) {
                        try {
                            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteGruppi(transazioneBean, (Transazione)transazioneBean);
                        }
                        catch (Exception e) {
                            throw new UtilsException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (transazioneBean.getTrasportoMittenteLabel() == null && transazioneBean.getTrasportoMittente() != null && !"".equals(transazioneBean.getTrasportoMittente())) {
                        try {
                            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTrasporto(transazioneBean, (Transazione)transazioneBean);
                        }
                        catch (Exception e) {
                            throw new UtilsException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (transazioneBean.getTokenUsernameLabel() == null && transazioneBean.getTokenUsername() != null && !"".equals(transazioneBean.getTokenUsername())) {
                        try {
                            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenUsername(transazioneBean, (Transazione)transazioneBean);
                        }
                        catch (Exception e) {
                            throw new UtilsException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (transazioneBean.getTokenClientIdLabel() == null && transazioneBean.getTokenClientId() != null && !"".equals(transazioneBean.getTokenClientId())) {
                        try {
                            transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteTokenClientID(transazioneBean, (Transazione)transazioneBean);
                        }
                        catch (Exception e) {
                            throw new UtilsException(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (transazioneBean.getTransportClientAddressLabel() != null || transazioneBean.getSocketClientAddressLabel() != null || transazioneBean.getClientAddress() == null || "".equals(transazioneBean.getClientAddress())) continue;
                    try {
                        transazioniService.normalizeInfoTransazioniFromCredenzialiMittenteClientAddress(transazioneBean, (Transazione)transazioneBean);
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            ListaTransazioni ret = (ListaTransazioni)ListaUtils.costruisciLista((UriInfo)env.context.getUriInfo(), (Integer)Converter.toOffset(offset), (Integer)Converter.toLimit(limit), (long)(listTransazioniDB != null ? (long)listTransazioniDB.size() : 0L), ListaTransazioni.class);
            if (serverProperties.isFindall404() && (listTransazioniDB == null || listTransazioniDB.isEmpty())) {
                throw FaultCode.NOT_FOUND.toException("Nessuna transazione trovata corrispondente ai criteri di ricerca");
            }
            if (listTransazioniDB != null && !listTransazioniDB.isEmpty()) {
                listTransazioniDB.forEach(transazioneDB -> {
                    try {
                        ret.addItemsItem(Converter.toItemTransazione(transazioneDB, env.log));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                });
            }
            env.context.getLogger().info("Invocazione completata con successo", new Object[0]);
            ListaTransazioni listaTransazioni = ret;
            return listaTransazioni;
        }
        finally {
            dbManager.releaseConnectionTracce(connection);
        }
    }

    public static final ListaTransazioni findAllTransazioniByIdApplicativo(RicercaIdApplicativo body, MonitoraggioEnv env) throws Exception {
        SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
        TransazioniSearchForm search = searchFormUtilities.getIdApplicativoSearchForm(env.context, env.profilo, env.nomeSoggettoLocale, body.getTipo(), body.getIntervalloTemporale().getDataInizio(), body.getIntervalloTemporale().getDataFine());
        TransazioniHelper.overrideRicercaBaseTransazione(body, search, env);
        FiltroRicercaId filtro = body.getIdApplicativo();
        search.setCorrelazioneApplicativaCaseSensitiveType((BooleanUtils.isTrue((Boolean)filtro.isCaseSensitive()) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
        search.setCorrelazioneApplicativaMatchingType((BooleanUtils.isTrue((Boolean)filtro.isRicercaEsatta()) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
        search.setIdCorrelazioneApplicativa(filtro.getId());
        ListaTransazioni ret = TransazioniHelper.searchTransazioni(search, body.getOffset(), body.getLimit(), body.getSort(), env);
        return ret;
    }

    public static final ListaTransazioni findAllTransazioni(RicercaIntervalloTemporale body, MonitoraggioEnv env) throws Exception {
        SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
        TransazioniSearchForm search = searchFormUtilities.getAndamentoTemporaleSearchForm(env.context, env.profilo, env.nomeSoggettoLocale, body.getTipo(), body.getIntervalloTemporale().getDataInizio(), body.getIntervalloTemporale().getDataFine());
        TransazioniHelper.overrideRicercaBaseTransazione(body, search, env);
        TransazioniHelper.overrideFiltroMittente(body, search, env);
        return TransazioniHelper.searchTransazioni(search, body.getOffset(), body.getLimit(), body.getSort(), env);
    }
}

