/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.UriInfo;
import java.sql.Connection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.DateTime;
import org.openspcoop2.core.monitor.rs.server.api.MonitoraggioApi;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Converter;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.Enums;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.MonitoraggioEnv;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.ReportisticaHelper;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.SearchFormUtilities;
import org.openspcoop2.core.monitor.rs.server.api.impl.utils.TransazioniHelper;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.monitor.rs.server.model.DetailTransazione;
import org.openspcoop2.core.monitor.rs.server.model.EsitoTransazioneFullSearchEnum;
import org.openspcoop2.core.monitor.rs.server.model.EsitoTransazioneSimpleSearchEnum;
import org.openspcoop2.core.monitor.rs.server.model.Evento;
import org.openspcoop2.core.monitor.rs.server.model.FiltroEsito;
import org.openspcoop2.core.monitor.rs.server.model.FiltroRicercaRuoloTransazioneEnum;
import org.openspcoop2.core.monitor.rs.server.model.FiltroTemporale;
import org.openspcoop2.core.monitor.rs.server.model.ListaEventi;
import org.openspcoop2.core.monitor.rs.server.model.ListaTransazioni;
import org.openspcoop2.core.monitor.rs.server.model.RicercaIdApplicativo;
import org.openspcoop2.core.monitor.rs.server.model.RicercaIntervalloTemporale;
import org.openspcoop2.core.monitor.rs.server.model.TipoIdApplicativoEnum;
import org.openspcoop2.core.monitor.rs.server.model.TipoMessaggioEnum;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.service.BaseImpl;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationManager;
import org.openspcoop2.utils.service.beans.DiagnosticoSeveritaEnum;
import org.openspcoop2.utils.service.beans.FiltroRicercaId;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.utils.BaseHelper;
import org.openspcoop2.utils.service.beans.utils.ListaUtils;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMessaggio;
import org.openspcoop2.web.monitor.eventi.bean.EventiSearchForm;
import org.openspcoop2.web.monitor.eventi.bean.EventoBean;
import org.openspcoop2.web.monitor.eventi.dao.EventiService;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.dao.TransazioniService;
import org.slf4j.LoggerFactory;

public class MonitoraggioApiServiceImpl
extends BaseImpl
implements MonitoraggioApi {
    public MonitoraggioApiServiceImpl() {
        super(LoggerFactory.getLogger(MonitoraggioApiServiceImpl.class));
    }

    private AuthorizationConfig getAuthorizationConfig() throws Exception {
        return new AuthorizationConfig(ServerProperties.getInstance().getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListaEventi findAllEventi(DateTime dataInizio, DateTime dataFine, Integer offset, Integer limit, DiagnosticoSeveritaEnum severita, String tipo, String codice, String origine, Boolean ricercaEsatta, Boolean caseSensitive) {
        IContext context = this.getContext();
        context.getLogger().info("Invocazione in corso ...", new Object[0]);
        AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
        context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionTracce();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesTracce();
            EventiService eventiService = new EventiService(connection, true, smp, LoggerProperties.getLoggerDAO());
            ServerProperties serverProperties = ServerProperties.getInstance();
            SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
            EventiSearchForm search = searchFormUtilities.getEventiSearchForm(context, dataInizio, dataFine);
            search.setCodice(codice);
            search.setTipo(tipo);
            search.setSeverita((String)BaseHelper.evalnull(() -> Enums.toTipoSeverita.get(severita).toString()));
            search.setCaseSensitiveType((BooleanUtils.isTrue((Boolean)caseSensitive) ? CaseSensitiveMatch.SENSITIVE : CaseSensitiveMatch.INSENSITIVE).toString());
            search.setMatchingType((BooleanUtils.isTrue((Boolean)ricercaEsatta) ? TipoMatch.EQUALS : TipoMatch.LIKE).toString());
            search.setIdConfigurazione(origine);
            eventiService.setSearch(search);
            List listEventiDB = eventiService.findAll(Converter.toOffset(offset).intValue(), Converter.toLimit(limit).intValue());
            ListaEventi ret = (ListaEventi)ListaUtils.costruisciLista((UriInfo)context.getUriInfo(), (Integer)Converter.toOffset(offset), (Integer)Converter.toLimit(limit), (long)(listEventiDB != null ? (long)listEventiDB.size() : 0L), ListaEventi.class);
            if (serverProperties.isFindall404() && (listEventiDB == null || listEventiDB.isEmpty())) {
                throw FaultCode.NOT_FOUND.toException("Nessun evento trovato corrispondente ai criteri di ricerca");
            }
            if (listEventiDB != null && !listEventiDB.isEmpty()) {
                listEventiDB.forEach(eventoDB -> {
                    try {
                        ret.addItemsItem(Converter.toEvento(eventoDB, this.log));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                });
            }
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            ListaEventi listaEventi = ret;
            dbManager.releaseConnectionTracce(connection);
            return listaEventi;
        }
        catch (Throwable throwable) {
            try {
                dbManager.releaseConnectionTracce(connection);
                throw throwable;
            }
            catch (WebApplicationException e) {
                context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
                throw e;
            }
            catch (Throwable e) {
                context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
                throw FaultCode.ERRORE_INTERNO.toException(e);
            }
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByIdApplicativo(TipoIdApplicativoEnum tipoIdentificativo, String id, ProfiloEnum profilo, String soggetto, Integer offset, Integer limit, String sort) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
            TransazioniSearchForm search = searchFormUtilities.getIdApplicativoBaseSearchForm(context, profilo, soggetto);
            MonitoraggioEnv env = new MonitoraggioEnv(context, profilo, soggetto, this.log);
            search.setIdCorrelazioneApplicativa(id);
            switch (tipoIdentificativo) {
                case RICHIESTA: {
                    search.setTipoIdMessaggio(TipoMessaggio.Richiesta.name());
                    break;
                }
                case RISPOSTA: {
                    search.setTipoIdMessaggio(TipoMessaggio.Risposta.name());
                }
            }
            ListaTransazioni ret = TransazioniHelper.searchTransazioni(search, offset, limit, sort, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByFullSearch(RicercaIntervalloTemporale body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            MonitoraggioEnv env = new MonitoraggioEnv(context, profilo, soggetto, this.log);
            ListaTransazioni ret = TransazioniHelper.findAllTransazioni(body, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByIdApplicativoFullSearch(RicercaIdApplicativo body, ProfiloEnum profilo, String soggetto) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            BaseHelper.throwIfNull((Object)body);
            MonitoraggioEnv env = new MonitoraggioEnv(context, profilo, soggetto, this.log);
            ListaTransazioni ret = TransazioniHelper.findAllTransazioniByIdApplicativo(body, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByIdApplicativoSimpleSearch(DateTime dataInizio, DateTime dataFine, FiltroRicercaRuoloTransazioneEnum tipo, String idApplicativo, ProfiloEnum profilo, String soggetto, Integer offset, Integer limit, String sort, String idCluster, String soggettoRemoto, String soggettoErogatore, String tag, String uriApiImplementata, String nomeServizio, String tipoServizio, Integer versioneServizio, String azione, EsitoTransazioneSimpleSearchEnum esito, Boolean escludiScartate, Boolean ricercaEsatta, Boolean caseSensitive) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            MonitoraggioEnv env = new MonitoraggioEnv(context, profilo, soggetto, this.log);
            RicercaIdApplicativo bodyRicerca = new RicercaIdApplicativo();
            bodyRicerca.setTipo(tipo);
            bodyRicerca.setApi(ReportisticaHelper.parseFiltroApiMap(tipo, nomeServizio, tipoServizio, versioneServizio, soggettoRemoto, soggettoErogatore, env, uriApiImplementata));
            FiltroTemporale iTemporale = new FiltroTemporale();
            iTemporale.setDataInizio(dataInizio);
            iTemporale.setDataFine(dataFine);
            bodyRicerca.setIntervalloTemporale(iTemporale);
            FiltroRicercaId filtroId = new FiltroRicercaId();
            filtroId.setId(idApplicativo);
            filtroId.setCaseSensitive(caseSensitive);
            filtroId.setRicercaEsatta(ricercaEsatta);
            bodyRicerca.setIdApplicativo(filtroId);
            bodyRicerca.setIdCluster(idCluster);
            bodyRicerca.setTag(tag);
            bodyRicerca.setAzione(azione);
            bodyRicerca.setLimit(limit);
            bodyRicerca.setOffset(offset);
            bodyRicerca.setSort(sort);
            if (esito != null || escludiScartate != null) {
                FiltroEsito filtroEsito = new FiltroEsito();
                if (esito != null) {
                    filtroEsito.setTipo(EsitoTransazioneFullSearchEnum.valueOf(esito.name()));
                } else {
                    filtroEsito.setTipo(EsitoTransazioneFullSearchEnum.QUALSIASI);
                }
                if (escludiScartate != null) {
                    filtroEsito.setEscludiScartate(escludiScartate);
                }
                bodyRicerca.setEsito(filtroEsito);
            }
            ListaTransazioni ret = TransazioniHelper.findAllTransazioniByIdApplicativo(bodyRicerca, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByIdMessaggio(TipoMessaggioEnum tipoMessaggio, String id, ProfiloEnum profilo, String soggetto, Integer offset, Integer limit, String sort) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
            TransazioniSearchForm search = searchFormUtilities.getIdMessaggioSearchForm(context, profilo, soggetto);
            MonitoraggioEnv env = new MonitoraggioEnv(context, profilo, soggetto, this.log);
            search.setIdEgov(id);
            switch (tipoMessaggio) {
                case RICHIESTA: {
                    search.setTipoIdMessaggio(TipoMessaggio.Richiesta.name());
                    break;
                }
                case RISPOSTA: {
                    search.setTipoIdMessaggio(TipoMessaggio.Risposta.name());
                    break;
                }
                case CONVERSAZIONE: {
                    search.setTipoIdMessaggio(TipoMessaggio.Collaborazione.name());
                    break;
                }
                case RIFERIMENTO_RICHIESTA: {
                    search.setTipoIdMessaggio(TipoMessaggio.RiferimentoRichiesta.name());
                }
            }
            ListaTransazioni ret = TransazioniHelper.searchTransazioni(search, offset, limit, sort, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByIdToken(String id, ProfiloEnum profilo, String soggetto, Integer offset, Integer limit, String sort) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
            TransazioniSearchForm search = searchFormUtilities.getIdTokenSearchForm(context, profilo, soggetto);
            MonitoraggioEnv env = new MonitoraggioEnv(context, ProfiloEnum.MODIPA, soggetto, this.log);
            search.setIdToken(id);
            ListaTransazioni ret = TransazioniHelper.searchTransazioni(search, offset, limit, sort, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniByPurposeId(String purposeId, String soggetto, Integer offset, Integer limit, String sort) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            SearchFormUtilities searchFormUtilities = new SearchFormUtilities();
            TransazioniSearchForm search = searchFormUtilities.getPurposeIdSearchForm(context, soggetto);
            MonitoraggioEnv env = new MonitoraggioEnv(context, ProfiloEnum.MODIPA, soggetto, this.log);
            search.setPurposeId(purposeId);
            ListaTransazioni ret = TransazioniHelper.searchTransazioni(search, offset, limit, sort, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    @Override
    public ListaTransazioni findAllTransazioniBySimpleSearch(DateTime dataInizio, DateTime dataFine, FiltroRicercaRuoloTransazioneEnum tipo, ProfiloEnum profilo, String soggetto, Integer offset, Integer limit, String sort, String idCluster, String soggettoRemoto, String soggettoErogatore, String tag, String uriApiImplementata, String nomeServizio, String tipoServizio, Integer versioneServizio, String azione, EsitoTransazioneSimpleSearchEnum esito, Boolean escludiScartate) {
        IContext context = this.getContext();
        try {
            context.getLogger().info("Invocazione in corso ...", new Object[0]);
            AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
            context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
            MonitoraggioEnv env = new MonitoraggioEnv(context, profilo, soggetto, this.log);
            RicercaIntervalloTemporale bodyRicerca = new RicercaIntervalloTemporale();
            FiltroTemporale intervalloTemporale = new FiltroTemporale();
            intervalloTemporale.setDataFine(dataFine);
            intervalloTemporale.setDataInizio(dataInizio);
            bodyRicerca.setIntervalloTemporale(intervalloTemporale);
            bodyRicerca.setTipo(tipo);
            bodyRicerca.setIdCluster(idCluster);
            bodyRicerca.setTag(tag);
            bodyRicerca.setAzione(azione);
            bodyRicerca.setSort(sort);
            bodyRicerca.setLimit(limit);
            bodyRicerca.setOffset(offset);
            if (esito != null || escludiScartate != null) {
                FiltroEsito filtroEsito = new FiltroEsito();
                if (esito != null) {
                    filtroEsito.setTipo(EsitoTransazioneFullSearchEnum.valueOf(esito.name()));
                } else {
                    filtroEsito.setTipo(EsitoTransazioneFullSearchEnum.QUALSIASI);
                }
                if (escludiScartate != null) {
                    filtroEsito.setEscludiScartate(escludiScartate);
                }
                bodyRicerca.setEsito(filtroEsito);
            }
            bodyRicerca.setApi(ReportisticaHelper.parseFiltroApiMap(tipo, nomeServizio, tipoServizio, versioneServizio, soggettoRemoto, soggettoErogatore, env, uriApiImplementata));
            ListaTransazioni ret = TransazioniHelper.findAllTransazioni(bodyRicerca, env);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            return ret;
        }
        catch (WebApplicationException e) {
            context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
            throw e;
        }
        catch (Throwable e) {
            context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
            throw FaultCode.ERRORE_INTERNO.toException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Evento getEvento(Long id) {
        IContext context = this.getContext();
        context.getLogger().info("Invocazione in corso ...", new Object[0]);
        AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
        context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
        if (id == null) {
            FaultCode.RICHIESTA_NON_VALIDA.throwException("Id undefined");
        }
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionTracce();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesTracce();
            EventiService eventiService = new EventiService(connection, true, smp, LoggerProperties.getLoggerDAO());
            EventoBean eventoDB = eventiService.findById(id);
            if (eventoDB == null) {
                FaultCode.NOT_FOUND.throwException("Evento con id '" + id + "' non esistente");
            }
            Evento evento = Converter.toEvento(eventoDB, this.log);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            Evento evento2 = evento;
            dbManager.releaseConnectionTracce(connection);
            return evento2;
        }
        catch (Throwable throwable) {
            try {
                dbManager.releaseConnectionTracce(connection);
                throw throwable;
            }
            catch (WebApplicationException e) {
                context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
                throw e;
            }
            catch (Throwable e) {
                context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
                throw FaultCode.ERRORE_INTERNO.toException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetailTransazione getTransazione(UUID id) {
        IContext context = this.getContext();
        context.getLogger().info("Invocazione in corso ...", new Object[0]);
        AuthorizationManager.authorize((IContext)context, (AuthorizationConfig)this.getAuthorizationConfig());
        context.getLogger().debug("Autorizzazione completata con successo", new Object[0]);
        String idSearch = null;
        if (id == null) {
            FaultCode.RICHIESTA_NON_VALIDA.throwException("Id undefined");
        } else {
            idSearch = id.toString();
        }
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionTracce();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesTracce();
            TransazioniService transazioniService = new TransazioniService(connection, true, smp, LoggerProperties.getLoggerDAO());
            TransazioneBean transazioneDB = transazioniService.findByIdTransazione(idSearch);
            if (transazioneDB == null) {
                FaultCode.NOT_FOUND.throwException("Traccia con id '" + String.valueOf(id) + "' non esistente");
            }
            DetailTransazione transazione = Converter.toTransazioneExt(transazioneDB, transazioniService, connection, smp, this.log);
            context.getLogger().info("Invocazione completata con successo", new Object[0]);
            DetailTransazione detailTransazione = transazione;
            dbManager.releaseConnectionTracce(connection);
            return detailTransazione;
        }
        catch (Throwable throwable) {
            try {
                dbManager.releaseConnectionTracce(connection);
                throw throwable;
            }
            catch (WebApplicationException e) {
                context.getLogger().error_except404("Invocazione terminata con errore '4xx': %s", (Throwable)e, new Object[]{e.getMessage()});
                throw e;
            }
            catch (Throwable e) {
                context.getLogger().error("Invocazione terminata con errore: %s", e, new Object[]{e.getMessage()});
                throw FaultCode.ERRORE_INTERNO.toException(e);
            }
        }
    }
}

