/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.batch;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.batch.AbstractGestore;
import org.openspcoop2.pdd.core.batch.TipoRuntimeRepository;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class GestoreMessaggi
extends AbstractGestore {
    private Integer scadenzaMessaggi;

    public GestoreMessaggi(boolean debug, boolean logQuery, Logger logCore, Logger logSql, int finestraSecondi, int refreshConnection, Integer scadenzaMessaggi, String tipoRepositoryBuste) throws UtilsException {
        super(TipoRuntimeRepository.MESSAGGI, debug, logQuery, logCore, logSql, finestraSecondi, refreshConnection, tipoRepositoryBuste);
        this.scadenzaMessaggi = scadenzaMessaggi;
    }

    @Override
    public void process() throws UtilsException {
        try {
            this.processEngine(false);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (this.scadenzaMessaggi != null && this.scadenzaMessaggi > 0) {
            try {
                this.processEngine(true);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void processEngine(boolean scaduti) throws Exception {
        try {
            Date minDate = org.openspcoop2.pdd.core.GestoreMessaggi.getOraRegistrazioneMinima((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql);
            if (minDate == null && this.debug) {
                this.logCoreDebug("Non esistono messaggi da eliminare");
                return;
            }
            Date now = DateManager.getDate();
            Date leftInterval = minDate;
            Date rightInterval = null;
            if (minDate != null) {
                rightInterval = new Date(minDate.getTime() + (long)(this.finestraSecondi * 1000));
                if (rightInterval.after(now)) {
                    rightInterval = now;
                }
            } else {
                rightInterval = now;
            }
            while (rightInterval.before(now)) {
                if (scaduti) {
                    this.cleanMessaggiScaduti(leftInterval, rightInterval);
                } else {
                    this.cleanMessaggiInutili(leftInterval, rightInterval);
                }
                if (!(rightInterval = new Date((leftInterval = rightInterval).getTime() + (long)(this.finestraSecondi * 1000))).after(now)) continue;
                rightInterval = now;
            }
            if (scaduti) {
                this.cleanMessaggiScaduti(leftInterval, rightInterval);
            } else {
                this.cleanMessaggiInutili(leftInterval, rightInterval);
            }
        }
        catch (Throwable e) {
            String msgErrore = "Errore durante la gestione del repository '" + this.tipoRuntimeRepository.getValue() + "': " + e.getMessage();
            this.logCoreError(msgErrore, e);
            throw new UtilsException(msgErrore, e);
        }
        finally {
            this.closeConnection();
        }
    }

    private void cleanMessaggiInutili(Date leftInterval, Date rightInterval) throws GestoreMessaggiException, SQLException {
        SortedMap eliminati;
        String periodo = null;
        if (this.debug) {
            periodo = leftInterval != null ? "[" + DateUtils.getSimpleDateFormatMs().format(leftInterval) + " - " + DateUtils.getSimpleDateFormatMs().format(rightInterval) + "] " : "[* - " + DateUtils.getSimpleDateFormatMs().format(rightInterval) + "] ";
        }
        if (this.debug) {
            this.logCoreDebug(periodo + "Ricerca messaggi da eliminare in 'INBOX' ...");
        }
        int count = org.openspcoop2.pdd.core.GestoreMessaggi.countMessaggiInutiliIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval);
        if (this.debug) {
            this.logCoreDebug(periodo + "Trovati " + count + " messaggi da eliminare in 'INBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi in 'INBOX' ...");
            }
            eliminati = org.openspcoop2.pdd.core.GestoreMessaggi.deleteMessaggiInutiliIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval, (IGestoreRepository)this.repository);
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi in 'INBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
        if (this.debug) {
            this.logCoreDebug(periodo + "Ricerca messaggi da eliminare in 'OUTBOX' ...");
        }
        count = org.openspcoop2.pdd.core.GestoreMessaggi.countMessaggiInutiliIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval);
        if (this.debug) {
            this.logCoreDebug(periodo + "Trovati " + count + " messaggi da eliminare in 'OUTBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi in 'OUTBOX' ...");
            }
            eliminati = org.openspcoop2.pdd.core.GestoreMessaggi.deleteMessaggiInutiliIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval, (IGestoreRepository)this.repository);
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi in 'OUTBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
    }

    private void cleanMessaggiScaduti(Date leftInterval, Date rightInterval) throws GestoreMessaggiException, SQLException {
        SortedMap eliminati;
        String periodo = null;
        if (this.debug) {
            periodo = leftInterval != null ? "[" + DateUtils.getSimpleDateFormatMs().format(leftInterval) + " - " + DateUtils.getSimpleDateFormatMs().format(rightInterval) + "] " : "[* - " + DateUtils.getSimpleDateFormatMs().format(rightInterval) + "] ";
        }
        if (this.debug) {
            this.logCoreDebug(periodo + "Ricerca messaggi scaduti in 'INBOX' ...");
        }
        int count = org.openspcoop2.pdd.core.GestoreMessaggi.countMessaggiScadutiIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval, (long)this.scadenzaMessaggi.intValue());
        if (this.debug) {
            this.logCoreDebug(periodo + "Trovati " + count + " messaggi scaduti in 'INBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi scaduti in 'INBOX' ...");
            }
            eliminati = org.openspcoop2.pdd.core.GestoreMessaggi.deleteMessaggiScadutiIntoInBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval, (long)this.scadenzaMessaggi.intValue(), (IGestoreRepository)this.repository);
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi scaduti in 'INBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
        if (this.debug) {
            this.logCoreDebug(periodo + "Ricerca messaggi scaduti in 'OUTBOX' ...");
        }
        count = org.openspcoop2.pdd.core.GestoreMessaggi.countMessaggiScadutiIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval, (long)this.scadenzaMessaggi.intValue());
        if (this.debug) {
            this.logCoreDebug(periodo + "Trovati " + count + " messaggi scaduti in 'OUTBOX'");
        }
        if (count > 0) {
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi scaduti in 'OUTBOX' ...");
            }
            eliminati = org.openspcoop2.pdd.core.GestoreMessaggi.deleteMessaggiScadutiIntoOutBox((Connection)this.refreshConnection(), (String)this.tipoDatabase, (boolean)this.logQuery, (Logger)this.logSql, (Date)leftInterval, (Date)rightInterval, (long)this.scadenzaMessaggi.intValue(), (IGestoreRepository)this.repository);
            if (this.debug) {
                this.logCoreDebug(periodo + "Eliminazione " + count + " messaggi scaduti in 'OUTBOX' completata (" + this.format((SortedMap<Integer>)eliminati) + ")");
            }
        }
    }
}

