/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.batch;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.pdd.core.batch.ProjectInfo;
import org.openspcoop2.pdd.core.batch.TipoRuntimeRepository;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryBitOrAndFunction;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryBytewise;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryDefault;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryFactory;
import org.openspcoop2.protocol.engine.driver.repository.GestoreRepositoryOracle;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public abstract class AbstractGestore {
    protected TipoRuntimeRepository tipoRuntimeRepository;
    protected IGestoreRepository repository;
    protected boolean debug;
    protected boolean logQuery;
    protected Logger logCore;
    protected Logger logSql;
    protected int finestraSecondi;
    protected String connectionUrl;
    protected String driverJdbc;
    protected String connectionUsername;
    protected String connectionPassword;
    protected String tipoDatabase;
    private int refreshConnection;
    private Date lastDate;
    private Connection connection;

    protected void logCoreDebug(String msg) {
        if (this.logCore != null) {
            this.logCore.debug(msg);
        }
    }

    protected void logCoreError(String msg) {
        if (this.logCore != null) {
            this.logCore.error(msg);
        }
    }

    protected void logCoreError(String msg, Throwable e) {
        if (this.logCore != null) {
            this.logCore.error(msg, e);
        }
    }

    protected AbstractGestore(TipoRuntimeRepository tipoRuntimeRepository, boolean debug, boolean logQuery, Logger logCore, Logger logSql, int finestraSecondi, int refreshConnection, String tipoRepositoryBuste) throws UtilsException {
        this.tipoRuntimeRepository = tipoRuntimeRepository;
        this.debug = debug;
        this.logQuery = logQuery;
        this.logCore = logCore;
        this.logSql = logSql;
        this.finestraSecondi = finestraSecondi;
        if (this.debug) {
            this.logCoreDebug("finestraSecondi: " + this.finestraSecondi);
        }
        this.refreshConnection = refreshConnection;
        if (this.debug) {
            this.logCoreDebug("refreshConnection: " + this.refreshConnection);
        }
        DAOFactoryProperties daoFactoryProperties = null;
        try {
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)logCore);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        ProjectInfo tipoDAO = new ProjectInfo();
        try {
            this.tipoDatabase = daoFactoryProperties.getTipoDatabase((IProjectInfo)tipoDAO);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        if (this.debug) {
            this.logCoreDebug("tipoDatabase: " + this.tipoDatabase);
        }
        try {
            if (daoFactoryProperties.isTipoAccessoTramiteConnection((IProjectInfo)tipoDAO)) {
                this.connectionUrl = daoFactoryProperties.getConnectionUrl((IProjectInfo)tipoDAO);
                this.driverJdbc = daoFactoryProperties.getConnectionDriverJDBC((IProjectInfo)tipoDAO);
                this.connectionUsername = daoFactoryProperties.getConnectionAuthUsername((IProjectInfo)tipoDAO);
                this.connectionPassword = daoFactoryProperties.getConnectionAuthPassword((IProjectInfo)tipoDAO);
                if (this.debug) {
                    this.logCoreDebug("connectionUrl: " + this.connectionUrl);
                    this.logCoreDebug("driverJdbc: " + this.driverJdbc);
                    this.logCoreDebug("connectionUsername: " + this.connectionUsername);
                }
            } else {
                throw new UtilsException("Tipo di configurazione (datasource) non supportata");
            }
            Class.forName(this.driverJdbc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        String tipoRealeRepositoryBuste = tipoRepositoryBuste;
        if ("auto-bytewise".equals(tipoRepositoryBuste)) {
            try {
                tipoRealeRepositoryBuste = GestoreRepositoryFactory.getTipoRepositoryBuste((String)this.tipoDatabase);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        if ("default".equalsIgnoreCase(tipoRealeRepositoryBuste)) {
            this.repository = new GestoreRepositoryDefault();
        } else if ("bytewise".equalsIgnoreCase(tipoRealeRepositoryBuste)) {
            this.repository = new GestoreRepositoryBytewise();
        } else if (CostantiConfigurazione.REPOSITORY_BUSTE_BYTEWISE_ORACLE.equalsIgnoreCase(tipoRealeRepositoryBuste)) {
            this.repository = new GestoreRepositoryOracle();
        } else if ("bitOrAndFunction".equalsIgnoreCase(tipoRealeRepositoryBuste)) {
            this.repository = new GestoreRepositoryBitOrAndFunction();
        } else {
            throw new UtilsException("Tipo di repository buste indicato '" + tipoRealeRepositoryBuste + "' sconosciuto");
        }
    }

    public abstract void process() throws UtilsException;

    protected String format(SortedMap<Integer> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && map.size() > 0) {
            for (String key : map.keys()) {
                if (sb.length() > 0) {
                    sb.append(" , ");
                }
                sb.append(key);
                sb.append(":");
                sb.append(map.get(key));
            }
        }
        return sb.toString();
    }

    protected Connection refreshConnection() throws SQLException {
        if (this.connection != null) {
            Date now;
            Date scaduta;
            if (this.refreshConnection > 0 && (scaduta = new Date((now = DateManager.getDate()).getTime() - (long)(this.refreshConnection * 1000))).after(this.lastDate)) {
                this.refresh(scaduta);
            }
        } else {
            if (this.debug) {
                this.logCoreDebug("Apertura nuova connessione ...");
            }
            this.connection = DriverManager.getConnection(this.connectionUrl, this.connectionUsername, this.connectionPassword);
            this.lastDate = DateManager.getDate();
            if (this.debug) {
                this.logCoreDebug("Apertura nuova connessione completata");
            }
        }
        return this.connection;
    }

    private void refresh(Date scaduta) throws SQLException {
        if (this.debug) {
            this.logCoreDebug("Rilevata connessione presa in data '" + DateUtils.getSimpleDateFormatMs().format(this.lastDate) + "' su cui effettuare il refresh (refresh time seconds: " + this.refreshConnection + ", scadenza:" + DateUtils.getSimpleDateFormatMs().format(scaduta) + ")");
            this.logCoreDebug("Chiusura connessione ...");
        }
        try {
            this.connection.close();
            if (this.debug) {
                this.logCoreDebug("Chiusura connessione completata");
            }
        }
        catch (Exception t) {
            this.logCoreError("Chiusura connessione fallita: " + t.getMessage(), t);
        }
        if (this.debug) {
            this.logCoreDebug("Apertura nuova connessione ...");
        }
        this.connection = DriverManager.getConnection(this.connectionUrl, this.connectionUsername, this.connectionPassword);
        this.lastDate = DateManager.getDate();
        if (this.debug) {
            this.logCoreDebug("Apertura nuova connessione completata");
        }
    }

    protected void closeConnection() throws SQLException {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
                this.lastDate = null;
                if (this.debug) {
                    this.logCoreDebug("Chiusura connessione completata");
                }
            } else if (this.debug) {
                this.logCoreDebug("Connessione non inizializzata; chiusura non necessaria");
            }
        }
        catch (Exception t) {
            this.logCoreError("Chiusura connessione fallita: " + t.getMessage(), t);
        }
    }
}

