/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.openspcoop2.web.monitor.core.validator.Utils;

public class EmailValidator
implements Validator {
    protected static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    Pattern emailPattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        EmailValidator.validaEMail(value, this.emailPattern, context);
    }

    private static String checkLenghtMail(String mail) {
        if (mail != null && mail.length() > 300) {
            return "La lunghezza massima permessa di un indirizzo mail sono 300 caratteri";
        }
        return null;
    }

    public static void validaEMail(Object value, Pattern emailPattern, FacesContext context) {
        String email;
        String errorLength;
        String errorMsg = null;
        if (value == null) {
            errorMsg = "Il campo Email non pu\u00f2 essere vuoto.";
        }
        if (value == null) {
            errorMsg = "Il campo Email non pu\u00f2 essere vuoto.";
        }
        if ((errorLength = EmailValidator.checkLenghtMail(email = (String)value)) != null) {
            Utils.throwValidatorException(context, errorLength);
        } else {
            Matcher matcher = emailPattern.matcher(email);
            if (!matcher.matches()) {
                errorMsg = "Il campo Email non contiene un valore valido.";
            }
            if (errorMsg != null) {
                Utils.throwValidatorException(context, errorMsg);
            }
        }
    }
}

