/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.mime.MimeTypes;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.lib.users.dao.RicercaUtente;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.bean.RicercaUtenteBean;
import org.openspcoop2.web.monitor.core.bean.RicercheUtenteSearchForm;
import org.openspcoop2.web.monitor.core.dao.IRicercheUtenteService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.ricerche.RicerchePersonalizzate;
import org.openspcoop2.web.monitor.core.utils.MimeTypeUtils;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RicercheExporter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();

    private static void logError(String msg, Exception e) {
        if (log != null) {
            if (e != null) {
                log.error(msg, (Throwable)e);
            } else {
                log.error(msg);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LoginBean lbInSession;
            WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            if (context == null) {
                throw new CoreException("Context is null");
            }
            IRicercheUtenteService service = (IRicercheUtenteService)context.getBean("ricercheUtenteService");
            RicercheUtenteSearchForm sfInSession = (RicercheUtenteSearchForm)context.getBean("searchFormRicercheUtente");
            RicercheUtenteSearchForm searchForm = (RicercheUtenteSearchForm)sfInSession.clone();
            User utente = null;
            Object olbInSession = context.getBean("loginBean");
            if (olbInSession instanceof LoginBean && (lbInSession = (LoginBean)olbInSession).isLoggedIn()) {
                utente = lbInSession.getUtente();
            }
            searchForm.setUser(utente);
            service.setSearch(searchForm);
            HttpServletResponse response = resp;
            String isAllString = req.getParameter("isAll");
            Boolean isAll = Boolean.parseBoolean(isAllString);
            String idRicerche = req.getParameter("ids");
            String[] ids = StringUtils.split((String)idRicerche, (String)",");
            HttpSession sessione = req.getSession();
            Boolean isAllFromSession = (Boolean)sessione.getAttribute("isAllOriginale");
            String idRicercheFromSession = (String)sessione.getAttribute("idsOriginali");
            sessione.removeAttribute("isAllOriginale");
            sessione.removeAttribute("idsOriginali");
            String[] idsFromSession = StringUtils.split((String)idRicercheFromSession, (String)",");
            boolean exportConsentito = RicercheExporter.checkParametri(isAll, isAllFromSession, ids, idsFromSession);
            if (!exportConsentito) {
                String msgErrore = "L'utente non dispone dei permessi necessari per effettuare l'export delle ricerche.";
                String redirectUrl = req.getContextPath() + "/public/error.jsf?msg_errore=" + msgErrore;
                response.sendRedirect(redirectUrl);
                return;
            }
            RicercheExporter.export(response, isAllFromSession, service, idsFromSession);
        }
        catch (Exception e) {
            RicercheExporter.logError(e.getMessage(), e);
        }
    }

    public static void export(HttpServletResponse response, Boolean isAll, IRicercheUtenteService service, String[] ids) throws ServletException, IOException {
        try {
            ArrayList<RicercaUtente> lst = new ArrayList<RicercaUtente>();
            if (isAll != null && isAll.booleanValue()) {
                int offset = 0;
                int letti = 0;
                int limit = 25;
                List lstTmp = null;
                do {
                    if ((letti = (lstTmp = service.findAll(offset, limit)).size()) <= 0) continue;
                    lst.addAll(lstTmp);
                } while (letti > 0);
            } else {
                for (String idString : ids) {
                    RicercaUtenteBean findById = (RicercaUtenteBean)((Object)service.findById(Long.parseLong(idString)));
                    lst.add(findById);
                }
            }
            if (!lst.isEmpty()) {
                String mimeType = MimeTypes.getInstance().getMimeType("json");
                String ext = MimeTypeUtils.fileExtensionForMIMEType(mimeType);
                String fileName = "ricerche_personalizzate." + ext;
                HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
                response.setStatus(200);
                response.flushBuffer();
                RicerchePersonalizzate ricerchePersonalizzate = new RicerchePersonalizzate();
                ricerchePersonalizzate.setRicerche(lst);
                JSONUtils jsonUtils = JSONUtils.getInstance();
                jsonUtils.writeTo((Object)ricerchePersonalizzate, (OutputStream)response.getOutputStream());
                response.setStatus(200);
                response.flushBuffer();
            } else {
                String fileName = "Errors.txt";
                HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
                response.setStatus(200);
                response.flushBuffer();
                String msgErrore = "La configurazione di export selezionata non ha prodotto nessun json valido";
                response.getWriter().write(msgErrore);
            }
        }
        catch (Exception e) {
            RicercheExporter.logError(e.getMessage(), e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean checkParametri(Boolean isAll, Boolean isAllFromSession, String[] ids, String[] idsFromSession) {
        if (isAll == null || isAllFromSession == null || isAll.booleanValue() != isAllFromSession.booleanValue()) {
            return false;
        }
        if (!(ids != null && ids.length != 0 && idsFromSession != null && idsFromSession.length != 0 || isAll.booleanValue())) {
            return false;
        }
        return RicercheExporter.checkParametriStep2(ids, idsFromSession);
    }

    private static boolean checkParametriStep2(String[] ids, String[] idsFromSession) {
        if (ids != null && idsFromSession != null && ids.length != idsFromSession.length) {
            return false;
        }
        if (ids != null) {
            for (String id : ids) {
                boolean found = false;
                for (String idFromSession : idsFromSession) {
                    if (!id.equals(idFromSession)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }
}

