/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.listener;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.slf4j.Logger;

public class IEFilter
implements Filter {
    private static Logger log = LoggerWrapperFactory.getLogger(IEFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String userAgent = ((HttpServletRequest)request).getHeader("User-Agent");
        if (userAgent != null) {
            try {
                log.debug("Decodifica Browser da Header UserAgent [{}]", (Object)userAgent);
                BrowserInfo browserInfo = BrowserInfo.getBrowserInfo(userAgent);
                String browsername = browserInfo.getBrowserName();
                Double browserversion = browserInfo.getVersion();
                log.debug("Browser Riconosciuto: Name [{}] Version [{}].", (Object)browsername, (Object)browserversion);
                if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.IE)) {
                    ((HttpServletResponse)response).setHeader("X-UA-Compatible", "IE=edge");
                    String accept = ((HttpServletRequest)request).getHeader("Accept");
                    if ("text/css".equals(accept)) {
                        chain.doFilter((ServletRequest)new IE9HttpServletRequestWrapper(this, (HttpServletRequest)request), response);
                    }
                }
            }
            catch (Exception e) {
                log.debug("Browser non riconosciuto.");
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public class IE9HttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        public IE9HttpServletRequestWrapper(IEFilter this$0, HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            String header = super.getHeader(name);
            if ("text/css".equalsIgnoreCase(header)) {
                header = "text/css, */*";
            }
            return header;
        }
    }
}

