/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.listener;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.listener.AbstractConsoleStartupListener;
import org.openspcoop2.web.monitor.core.listener.InitRuntimeConfigReader;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;

public class ConsoleStartupListener
extends AbstractConsoleStartupListener {
    public static volatile boolean initialized = false;
    private InitRuntimeConfigReader initRuntimeConfigReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextInitialized(ServletContextEvent evt) {
        String msgErrore;
        super.contextInitialized(evt);
        PddMonitorProperties govwayMonitorProperties = null;
        try {
            govwayMonitorProperties = PddMonitorProperties.getInstance(AbstractConsoleStartupListener.log);
        }
        catch (Exception e) {
            String msgErrore2 = "Errore durante l'inizializzazione delle propriet\u00e0 della govwayMonitor: " + e.getMessage();
            AbstractConsoleStartupListener.logError(msgErrore2, e);
            throw new UtilsRuntimeException(msgErrore2, (Throwable)e);
        }
        ServletContext servletContext = evt.getServletContext();
        InputStream isFont = null;
        try {
            String fontFileName = PddMonitorProperties.getInstance(log).getConsoleFont();
            ConsoleStartupListener.logDebug("Caricato Font dal file: [" + fontFileName + "] in corso... ");
            isFont = servletContext.getResourceAsStream("/fonts/" + fontFileName);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font fontCaricato = Font.createFont(0, isFont);
            ConsoleStartupListener.logDebug("Caricato Font: [" + fontCaricato.getName() + "] FontName: [" + fontCaricato.getFontName() + "] FontFamily: [" + fontCaricato.getFamily() + "] FontStyle: [" + fontCaricato.getStyle() + "]");
            ge.registerFont(fontCaricato);
            ConsoleStartupListener.logDebug("Check Graphics Environment: is HeadeLess [" + GraphicsEnvironment.isHeadless() + "]");
            ConsoleStartupListener.logDebug("Elenco Nomi Font disponibili: " + String.valueOf(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames())));
            PddMonitorProperties.getInstance(log).setConsoleFontName(fontCaricato.getName());
            PddMonitorProperties.getInstance(log).setConsoleFontFamilyName(fontCaricato.getFamily());
            PddMonitorProperties.getInstance(log).setConsoleFontStyle(fontCaricato.getStyle());
            ConsoleStartupListener.logDebug("Caricato Font dal file: [" + fontFileName + "] completato.");
        }
        catch (Exception e) {
            ConsoleStartupListener.logError(e.getMessage(), e);
        }
        finally {
            if (isFont != null) {
                try {
                    isFont.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            ThreadExecutorManager.setup();
        }
        catch (Exception e) {
            ConsoleStartupListener.logError(e.getMessage(), e);
            msgErrore = "Errore durante l'inizializzazione del ThreadExecutorManager: " + e.getMessage();
            throw new UtilsRuntimeException(msgErrore, (Throwable)e);
        }
        if (this.isReInitSecretMaps()) {
            try {
                this.initRuntimeConfigReader = new InitRuntimeConfigReader(govwayMonitorProperties, this.isReInitSecretMaps());
                this.initRuntimeConfigReader.start();
                ConsoleStartupListener.logInfo("RuntimeConfigReader avviato con successo.");
            }
            catch (Exception e) {
                msgErrore = "Errore durante l'inizializzazione del RuntimeConfigReader: " + e.getMessage();
                ConsoleStartupListener.logError(msgErrore, e);
            }
        }
        try {
            FailedAttempts.createInstance((String)govwayMonitorProperties.getLoginRetryDelays());
        }
        catch (UtilsException e) {
            msgErrore = "Errore durante l'inizializzazione del FailedAttempts: " + e.getMessage();
            ConsoleStartupListener.logError(msgErrore, e);
        }
        initialized = true;
        ConsoleStartupListener.logInfo("govwayMonitor inizializzato con successo.");
    }

    @Override
    public void contextDestroyed(ServletContextEvent arg0) {
        super.contextDestroyed(arg0);
        ConsoleStartupListener.logInfo("Shutdown pool thread ricerche ...");
        try {
            ThreadExecutorManager.shutdown();
            ConsoleStartupListener.logInfo("Shutdown pool thread ricerche completato.");
        }
        catch (InterruptedException e) {
            ConsoleStartupListener.logWarn("Shutdown pool thread ricerche fallito:" + String.valueOf(e));
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            ConsoleStartupListener.logWarn("Shutdown pool thread ricerche fallito:" + String.valueOf(e));
        }
        if (this.initRuntimeConfigReader != null) {
            this.initRuntimeConfigReader.setStop(true);
        }
    }
}

