/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Strings;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.ContentAuthorizationManager;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class ContentAuthorizationFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private FilterConfig filterConfig = null;
    private static final String msgErrorePre = "L'utente ";
    private static final String msgErrorePost = " non dispone delle autorizzazioni necessarie per visualizzare la pagina richiesta";
    public static final String MSG_AUTH_ERRORE = "Autenticazione richiesta.";
    public static final String jspErrore = "/commons/pages/welcome.jsf";
    public static final String jspLogin = "/public/login.jsf";
    public static final String msgErroreKey = "acclim";
    public static final String accLimKey = "acclimflag";
    private List<String> excludedPaths = null;
    private String jQueryVersion = null;
    private String jQueryUiVersion = null;

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: AuthorizationFilter");
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        String userName = "";
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            HttpSession session = request.getSession();
            String urlRichiesta = request.getServletPath();
            log.debug("Richiesta Risorsa [" + urlRichiesta + "]");
            Utility.setLoginBeanErrorMessage(session, ContentAuthorizationFilter.class.getName(), null, null);
            boolean controlloAccessoRichiesto = Utils.isContentAuthorizationRequiredForThisResource(request, this.excludedPaths);
            log.debug("Controllo Accesso per La risorsa richiesta [" + controlloAccessoRichiesto + "]");
            boolean effettuaRedirect = false;
            boolean utenteLoggato = true;
            if (controlloAccessoRichiesto) {
                lb = Utility.getLoginBeanFromSession(session);
                log.debug("Richiesto Accesso per La risorsa protetta [" + urlRichiesta + "]");
                if (lb != null) {
                    user = lb.getLoggedUser();
                    if (user != null) {
                        Map<String, Boolean> ruoliUtente = ApplicationBean.getInstance().getRuoliUtente(user);
                        log.debug("[Analisi attributi User: " + user.getUsername() + " ]");
                        ApplicationBean applicationBean = ApplicationBean.getInstance();
                        boolean bl = effettuaRedirect = !ContentAuthorizationManager.getInstance().isRisorsaRichiestaAbilitata(urlRichiesta, applicationBean);
                        if (!effettuaRedirect) {
                            effettuaRedirect = !ContentAuthorizationManager.getInstance().checkRuoloRichiestoPerLaRisorsa(ruoliUtente, urlRichiesta, applicationBean);
                        }
                        log.debug("[La risorsa richiesta " + (effettuaRedirect ? "non " : "") + "e' disponibile per l'utente.]");
                    } else {
                        effettuaRedirect = true;
                        utenteLoggato = false;
                    }
                } else {
                    effettuaRedirect = true;
                    utenteLoggato = false;
                }
            } else {
                if (Strings.CS.contains((CharSequence)request.getRequestURI(), (CharSequence)"public/login.jsf") || Strings.CS.contains((CharSequence)request.getRequestURI(), (CharSequence)"public/timeoutPage.jsf")) {
                    lb = Utility.getLoginBeanFromSession(session);
                    log.debug("Richiesto Accesso per La risorsa [" + urlRichiesta + "]");
                    if (lb != null && (user = lb.getLoggedUser()) != null) {
                        log.debug("[User: " + user.getUsername() + "] e' autenticato ma ha richiesto la pagina di login o di timeout, redirect verso [/commons/pages/welcome.jsf]");
                        effettuaRedirect = true;
                        utenteLoggato = true;
                    }
                }
                if (Strings.CS.contains((CharSequence)request.getRequestURI(), (CharSequence)"webjars") && !this.isValidJQueryResource(request)) {
                    effettuaRedirect = true;
                    utenteLoggato = true;
                }
            }
            if (effettuaRedirect) {
                StringBuilder sb = new StringBuilder(0);
                sb.append(msgErrorePre).append(userName).append(msgErrorePost);
                String msgErrore = sb.toString();
                session.setAttribute(accLimKey, (Object)true);
                if (utenteLoggato) {
                    log.debug("Redirect: " + request.getContextPath() + jspErrore);
                    session.setAttribute(msgErroreKey, (Object)msgErrore);
                    response.sendRedirect(request.getContextPath() + jspErrore);
                } else {
                    log.debug("Redirect: " + request.getContextPath() + jspLogin);
                    response.sendRedirect(request.getContextPath() + jspLogin);
                }
                return;
            }
            if (urlRichiesta.indexOf("/pages/welcome.jsf") != -1 || urlRichiesta.indexOf(jspLogin) != -1) {
                boolean used;
                boolean bl = used = session.getAttribute(accLimKey) != null ? (Boolean)session.getAttribute(accLimKey) : false;
                if (used) {
                    if (urlRichiesta.indexOf(jspLogin) != -1) {
                        Utility.setLoginBeanErrorMessage(session, ContentAuthorizationFilter.class.getName(), MSG_AUTH_ERRORE, HttpStatus.UNAUTHORIZED.value());
                    }
                    session.setAttribute(accLimKey, (Object)false);
                } else {
                    session.setAttribute(accLimKey, (Object)false);
                    session.setAttribute(msgErroreKey, null);
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        catch (ServletException e) {
            log.error(e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.jQueryVersion = this.filterConfig.getInitParameter("jquery_version");
        this.jQueryUiVersion = this.filterConfig.getInitParameter("jquery-ui_version");
        this.excludedPaths = new ArrayList<String>();
        try {
            this.excludedPaths.addAll(Arrays.asList(ContentAuthorizationManager.getInstance().getListaPathConsentiti()));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isValidJQueryResource(HttpServletRequest request) {
        String urlRichiesta = request.getRequestURI();
        return urlRichiesta.indexOf("/" + MessageFormat.format("webjars/jquery/{0}/jquery.min.js", this.jQueryVersion)) != -1 || urlRichiesta.indexOf("/" + MessageFormat.format("webjars/jquery-ui/{0}/jquery-ui.min.js", this.jQueryUiVersion)) != -1;
    }
}

