/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.listener.IEFilter;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.openspcoop2.web.monitor.core.utils.ContentAuthorizationManager;
import org.slf4j.Logger;

public class BrowserFilter
implements Filter {
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static Map<BrowserInfo.BrowserFamily, Double> mappaAbilitazioneGraficiSVG;
    private static Map<BrowserInfo.BrowserFamily, Double> mappaAbilitazioneVistaTransazioniCustom;
    private FilterConfig filterConfig = null;
    public static final String PARAMETRO_SVG = "usaSVG";
    private static final String PARAMETRO_SVG_FORM_STATS = "sf_usaSVG";
    private static final String PARAMETRO_SVG_FORM_MENU = "tf_usaSVG";
    private static final String PARAMETRO_SVG_POLL_STATO = "ps_usaSVG";
    private static final String PARAMETRO_GENERA_REPORT = "generaReport";
    private static final String PARAMETRO_ESITI_LIVE = "esiti_live";
    private static final String PARAMETRO_TIPO_REPORT = "tipoReportCombo";
    private static final String PARAMETRO_TIPO_REPORT_TABELLA = "Tabella";
    private List<String> listaPagineNoIE8 = null;

    private static synchronized void loadMappaBrowser() {
        if (mappaAbilitazioneGraficiSVG == null) {
            mappaAbilitazioneGraficiSVG = new EnumMap<BrowserInfo.BrowserFamily, Double>(BrowserInfo.BrowserFamily.class);
        }
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.CHROME, 4.0);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.FIREFOX, 3.0);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.IE, 9.0);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.OPERA, 10.1);
        mappaAbilitazioneGraficiSVG.put(BrowserInfo.BrowserFamily.SAFARI, 3.2);
        if (mappaAbilitazioneVistaTransazioniCustom == null) {
            mappaAbilitazioneVistaTransazioniCustom = new EnumMap<BrowserInfo.BrowserFamily, Double>(BrowserInfo.BrowserFamily.class);
        }
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.CHROME, 29.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.FIREFOX, 28.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.IE, 11.0);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.OPERA, 12.1);
        mappaAbilitazioneVistaTransazioniCustom.put(BrowserInfo.BrowserFamily.SAFARI, 9.0);
    }

    public static boolean disabilitaGraficiSVG(BrowserInfo browserInfo) {
        Double versione;
        boolean disabilita = false;
        if (mappaAbilitazioneGraficiSVG == null) {
            BrowserFilter.loadMappaBrowser();
        }
        if (browserInfo != null && (versione = mappaAbilitazioneGraficiSVG.get((Object)browserInfo.getBrowserFamily())) != null && browserInfo.getVersion() != null && versione >= browserInfo.getVersion()) {
            disabilita = true;
        }
        return disabilita;
    }

    public static boolean abilitaVisualizzazioneTransazioniCustom(BrowserInfo browserInfo) {
        Double versione;
        boolean abilita = false;
        if (mappaAbilitazioneVistaTransazioniCustom == null) {
            BrowserFilter.loadMappaBrowser();
        }
        if (browserInfo != null && (versione = mappaAbilitazioneVistaTransazioniCustom.get((Object)browserInfo.getBrowserFamily())) != null && browserInfo.getVersion() != null && browserInfo.getVersion() >= versione) {
            abilita = true;
        }
        return abilita;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            try {
                log.debug("Decodifica Browser da Header UserAgent [{}]", (Object)userAgent);
                String urlRichiesta = request.getServletPath();
                log.debug("Richiesta Risorsa [{}]", (Object)urlRichiesta);
                BrowserInfo browserInfo = BrowserInfo.getBrowserInfo(userAgent);
                String browsername = browserInfo.getBrowserName();
                Double browserversion = browserInfo.getVersion();
                log.debug("Browser Riconosciuto: Name [{}] Version [{}].", (Object)browsername, (Object)browserversion);
                boolean usaSVG = this.usaSVG(request);
                if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.IE)) {
                    boolean abilitaModalitaIE8 = true;
                    if (usaSVG) {
                        log.debug("Richiesto Accesso per La risorsa protetta.");
                        abilitaModalitaIE8 = BrowserFilter.disabilitaGraficiSVG(browserInfo);
                    }
                    log.debug("La risorsa richiesta {}verra' visualizzata in modalita compatibilita IE8.", (Object)(abilitaModalitaIE8 ? "" : "non "));
                    response.setHeader("X-UA-Compatible", "IE=edge");
                    String accept = request.getHeader("Accept");
                    if ("text/css".equals(accept)) {
                        chain.doFilter((ServletRequest)new IEFilter.IE9HttpServletRequestWrapper(new IEFilter(), request), (ServletResponse)response);
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else if (browserInfo.getBrowserFamily().equals((Object)BrowserInfo.BrowserFamily.FIREFOX)) {
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.add("/a4j/");
                    if (ContentAuthorizationManager.getInstance().contains(urlRichiesta, lst)) {
                        log.debug("Applico Fix per le risorse A4j in firefox.");
                        chain.doFilter((ServletRequest)new HttpServletRequestWrapper(this, request){

                            public String getRequestURI() {
                                try {
                                    return URLDecoder.decode(super.getRequestURI(), "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    throw new IllegalStateException("Cannot decode request URI.", e);
                                }
                            }
                        }, (ServletResponse)response);
                    } else {
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    }
                } else {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (Exception e) {
                log.debug("Browser non riconosciuto.");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    public void destroy() {
        log.debug("DISTRUIZIONE FILTRO: BrowserFilter");
        this.filterConfig = null;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        try {
            this.listaPagineNoIE8 = Arrays.asList(ContentAuthorizationManager.getInstance().getListaPagineNoIE8());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public boolean usaSVG(HttpServletRequest httpServletRequest) {
        int svgLength = 0;
        String svg = null;
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parName = (String)parameterNames.nextElement();
            String parValue = httpServletRequest.getParameter(parName);
            log.trace("Parametro [{}] con Valore [{}].", (Object)parName, (Object)parValue);
            if (parName == null || !parName.endsWith(PARAMETRO_SVG)) continue;
            svg = parValue;
            log.trace("Parametro [{}] con Valore [{}] Utilizzato per pilotare il disegno dei grafici.", (Object)parName, (Object)parValue);
            if (parName.endsWith(PARAMETRO_SVG_FORM_STATS)) {
                String paramGeneraReport = BrowserFilter.getParamValue(httpServletRequest, PARAMETRO_GENERA_REPORT);
                String paramTipoReport = BrowserFilter.getParamValue(httpServletRequest, PARAMETRO_TIPO_REPORT);
                log.trace("Caso speciale Form Statistiche: Parametro [{}] con Valore [{}] Utilizzato per pilotare il disegno dei grafici.", (Object)PARAMETRO_GENERA_REPORT, (Object)paramGeneraReport);
                if (StringUtils.isEmpty((CharSequence)paramGeneraReport)) {
                    svg = null;
                } else if (StringUtils.isNotEmpty((CharSequence)paramTipoReport) && paramTipoReport.equals(PARAMETRO_TIPO_REPORT_TABELLA)) {
                    log.trace("Caso speciale Form Statistiche: Parametro [{}] con Valore [{}] Visualizzazione del report in forma di tabella.", (Object)PARAMETRO_TIPO_REPORT, (Object)paramTipoReport);
                    svg = null;
                }
            }
            if (parName.endsWith(PARAMETRO_SVG_FORM_MENU)) {
                String paramEsitiLive = BrowserFilter.getParamValue(httpServletRequest, PARAMETRO_ESITI_LIVE);
                log.trace("Caso speciale Menu': Parametro [{}] con Valore [{}] Utilizzato per pilotare il disegno dei grafici.", (Object)PARAMETRO_ESITI_LIVE, (Object)paramEsitiLive);
                if (StringUtils.isEmpty((CharSequence)paramEsitiLive)) {
                    svg = null;
                }
            }
            if (!parName.endsWith(PARAMETRO_SVG_POLL_STATO)) break;
            boolean thisResource = !Utils.isContentAuthorizationRequiredForThisResource(httpServletRequest, this.listaPagineNoIE8);
            log.trace("Caso speciale Menu': Parametro [{}] con Valore [{}] Utilizzato per pilotare il disegno dei grafici.", (Object)PARAMETRO_SVG_POLL_STATO, (Object)thisResource);
            if (thisResource) break;
            svg = null;
            break;
        }
        if (svg != null) {
            svgLength = svg.length();
        }
        log.trace("Attivo controllo SVG [{}]", (Object)(svgLength > 0 ? "SI" : "NO"));
        return svgLength > 0;
    }

    public static String getParamValue(HttpServletRequest httpServletRequest, String paramName) {
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parName = (String)parameterNames.nextElement();
            if (parName == null || !parName.contains(paramName)) continue;
            String parameterValue = httpServletRequest.getParameter(parName);
            log.debug("Trovato Parametro [{}] con Valore [{}].", (Object)parName, (Object)parameterValue);
            return parameterValue;
        }
        return null;
    }
}

