/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.core.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.web.lib.users.DriverUsersDB;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.ProjectInfo;
import org.openspcoop2.web.lib.users.RicercaUtenteNotFoundException;
import org.openspcoop2.web.lib.users.dao.RicercaUtente;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.RicercaUtenteBean;
import org.openspcoop2.web.monitor.core.bean.RicercheUtenteSearchForm;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dao.IRicercheUtenteService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;
import org.slf4j.Logger;

public class RicercheUtenteService
implements IRicercheUtenteService {
    public static final int MAX_ITERATIONS = 50;
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private DriverUsersDB utenteDAO;
    private RicercheUtenteSearchForm searchForm = null;
    private boolean timeoutEvent = false;
    private Integer timeoutRicerche = null;

    public RicercheUtenteService() {
        try {
            this.utenteDAO = (DriverUsersDB)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance());
            this.timeoutRicerche = PddMonitorProperties.getInstance(log).getIntervalloTimeoutRicercaEventi();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public RicercheUtenteService(Connection con, boolean autoCommit) {
        this(con, autoCommit, null, log);
    }

    public RicercheUtenteService(Connection con, boolean autoCommit, Logger log) {
        this(con, autoCommit, null, log);
    }

    public RicercheUtenteService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties) {
        this(con, autoCommit, serviceManagerProperties, log);
    }

    public RicercheUtenteService(Connection con, boolean autoCommit, ServiceManagerProperties serviceManagerProperties, Logger log) {
        try {
            this.utenteDAO = (DriverUsersDB)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, serviceManagerProperties, log);
            this.timeoutRicerche = PddMonitorProperties.getInstance(RicercheUtenteService.log).getIntervalloTimeoutRicercaEventi();
        }
        catch (Exception e) {
            RicercheUtenteService.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setSearch(RicercheUtenteSearchForm searchForm) {
        this.searchForm = searchForm;
    }

    @Override
    public RicercheUtenteSearchForm getSearch() {
        return this.searchForm;
    }

    private void logErrorMsg(String message, Exception e) {
        log.error(message, (Throwable)e);
    }

    @Override
    public List<RicercaUtenteBean> findAll(int start, int limit) {
        log.debug("Metodo FindAll: start[{}], limit: [{}]", (Object)start, (Object)limit);
        User loggedUtente = this.searchForm.getUser();
        String login = loggedUtente.getLogin();
        try {
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.leggiListaRicerche(login, start, limit);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.leggiListaRicerche(login, start, limit)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return list;
        }
        catch (NotImplementedException | ServiceException e) {
            log.error(e.getMessage(), e);
            return new ArrayList<RicercaUtenteBean>();
        }
    }

    @Override
    public int totalCount() {
        log.debug("Metodo TotalCount");
        User loggedUtente = this.searchForm.getUser();
        String login = loggedUtente.getLogin();
        String label = null;
        String modulo = null;
        String modalitaRicerca = null;
        String visibilita = null;
        String protocollo = null;
        String soggetto = null;
        if (this.searchForm.getFiltroModulo() != null && !"--".equals(this.searchForm.getFiltroModulo())) {
            modulo = this.searchForm.getFiltroModulo();
        }
        if (this.searchForm.getFiltroModalitaRicerca() != null && !"--".equals(this.searchForm.getFiltroModalitaRicerca())) {
            modalitaRicerca = this.searchForm.getFiltroModalitaRicerca();
        }
        if (this.searchForm.getFiltroVisibilita() != null && !"--".equals(this.searchForm.getFiltroVisibilita())) {
            visibilita = this.searchForm.getFiltroVisibilita();
        }
        try {
            return this.utenteDAO.countRicerche(login, label, modulo, modalitaRicerca, visibilita, protocollo, soggetto);
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public int totaleRicercheUtente(String login) {
        log.debug("Metodo totaleRicercheUtente [{}]", (Object)login);
        try {
            return this.utenteDAO.countRicerche(login, null, null, null, null, null, null);
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public void store(RicercaUtenteBean ricercaPersonalizzata) throws Exception {
        this.insertRicerca(this.searchForm.getUser().getLogin(), ricercaPersonalizzata);
    }

    @Override
    public void insertRicerca(String login, RicercaUtente ricercaPersonalizzata) throws DriverUsersDBException {
        try {
            Long idRicerca = this.utenteDAO.insertRicerca(login, ricercaPersonalizzata);
            ricercaPersonalizzata.setId(idRicerca.longValue());
        }
        catch (DriverUsersDBException e) {
            this.logErrorMsg(e.getMessage(), (Exception)((Object)e));
            throw e;
        }
    }

    @Override
    public void updateRicerca(String login, RicercaUtente ricercaPersonalizzata) throws DriverUsersDBException {
        try {
            this.utenteDAO.updateRicerca(login, ricercaPersonalizzata);
        }
        catch (DriverUsersDBException e) {
            this.logErrorMsg(e.getMessage(), (Exception)((Object)e));
            throw e;
        }
    }

    @Override
    public void deleteById(Long key) {
        User loggedUtente = this.searchForm.getUser();
        String login = loggedUtente.getLogin();
        try {
            this.utenteDAO.cancellaRicerca(login, key.longValue());
        }
        catch (DriverUsersDBException e) {
            log.error("Errore durante la cancellazione della ricerca personalizzata " + key + " dell'utente " + login + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void delete(RicercaUtenteBean obj) throws Exception {
        this.deleteById(obj.getId());
    }

    @Override
    public void deleteAll() throws Exception {
        User loggedUtente = this.searchForm.getUser();
        String login = loggedUtente.getLogin();
        try {
            this.utenteDAO.cancellaRicerche(login);
        }
        catch (DriverUsersDBException e) {
            log.error("Errore durante la cancellazione delle ricerche personalizzate dell'utente " + login + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public RicercaUtenteBean findById(Long key) {
        RicercaUtenteBean bean = null;
        User loggedUtente = this.searchForm.getUser();
        String login = loggedUtente.getLogin();
        Long idUtente = loggedUtente.getId();
        try {
            return new RicercaUtenteBean(this.utenteDAO.leggiRicerca(idUtente.longValue(), key.longValue()));
        }
        catch (DriverUsersDBException e) {
            log.error("Errore durante la lettura della ricerca personalizzata dell'utente " + login + " con id " + key + ": " + e.getMessage(), (Throwable)e);
        }
        catch (RicercaUtenteNotFoundException e) {
            log.error("Ricerca personalizzata dell'utente " + idUtente + " con id " + key + " non trovata: " + e.getMessage(), (Throwable)e);
        }
        return bean;
    }

    @Override
    public RicercaUtenteBean leggiRicercaUtente(long idUtente, long idRicerca) {
        RicercaUtenteBean bean = null;
        try {
            return new RicercaUtenteBean(this.utenteDAO.leggiRicerca(idUtente, idRicerca));
        }
        catch (DriverUsersDBException e) {
            log.error("Errore durante la lettura della ricerca personalizzata dell'utente " + idUtente + " con id " + idRicerca + ": " + e.getMessage(), (Throwable)e);
        }
        catch (RicercaUtenteNotFoundException e) {
            log.error("Ricerca personalizzata dell'utente " + idUtente + " con id " + idRicerca + " non trovata: " + e.getMessage(), (Throwable)e);
        }
        return bean;
    }

    @Override
    public List<RicercaUtenteBean> findAll() {
        log.debug("Metodo FindAll");
        User loggedUtente = this.searchForm.getUser();
        String login = loggedUtente.getLogin();
        try {
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.leggiListaRicerche(login, null, null);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.leggiListaRicerche(login, null, null)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return list;
        }
        catch (NotImplementedException | ServiceException e) {
            log.error(e.getMessage(), e);
            return new ArrayList<RicercaUtenteBean>();
        }
    }

    @Override
    public List<RicercaUtenteBean> listaRicercheDisponibiliPerUtente(String login, String modulo, String modalitaRicerca, String protocollo, String soggetto) {
        log.debug("Metodo listaRicercheDisponibiliPerUtente login[{}], modulo[{}], modalitaricerca [{}], protocollo [{}], soggetto [{}]", new Object[]{login, modulo, modalitaRicerca, protocollo, soggetto});
        try {
            this.timeoutEvent = false;
            List list = null;
            if (this.timeoutRicerche == null) {
                list = this.listaRicercheDisponibiliPerUtenteEngine(login, modulo, modalitaRicerca, protocollo, soggetto);
            } else {
                try {
                    list = ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.listaRicercheDisponibiliPerUtenteEngine(login, modulo, modalitaRicerca, protocollo, soggetto)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return list;
        }
        catch (NotImplementedException | ServiceException e) {
            log.error(e.getMessage(), e);
            return new ArrayList<RicercaUtenteBean>();
        }
    }

    private List<RicercaUtenteBean> leggiListaRicerche(String login, Integer start, Integer limit) {
        String modulo = null;
        String modalitaRicerca = null;
        String visibilita = null;
        String protocollo = null;
        String soggetto = null;
        if (this.searchForm.getFiltroModulo() != null && !"--".equals(this.searchForm.getFiltroModulo())) {
            modulo = this.searchForm.getFiltroModulo();
        }
        if (this.searchForm.getFiltroModalitaRicerca() != null && !"--".equals(this.searchForm.getFiltroModalitaRicerca())) {
            modalitaRicerca = this.searchForm.getFiltroModalitaRicerca();
        }
        if (this.searchForm.getFiltroVisibilita() != null && !"--".equals(this.searchForm.getFiltroVisibilita())) {
            visibilita = this.searchForm.getFiltroVisibilita();
        }
        return this.leggiListaRicercheEngine(login, start, limit, modulo, modalitaRicerca, visibilita, soggetto, protocollo);
    }

    private List<RicercaUtenteBean> leggiListaRicercheEngine(String login, Integer start, Integer limit, String modulo, String modalitaRicerca, String visibilita, String protocollo, String soggetto) {
        ArrayList<RicercaUtenteBean> list = new ArrayList<RicercaUtenteBean>();
        try {
            List listaRicerche = this.utenteDAO.listaRicerche(login, start, limit, modulo, modalitaRicerca, visibilita, protocollo, soggetto);
            for (RicercaUtente ricercaUtente : listaRicerche) {
                list.add(new RicercaUtenteBean(ricercaUtente));
            }
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private List<RicercaUtenteBean> listaRicercheDisponibiliPerUtenteEngine(String login, String modulo, String modalitaRicerca, String protocollo, String soggetto) {
        ArrayList<RicercaUtenteBean> list = new ArrayList<RicercaUtenteBean>();
        try {
            List listaRicerche = this.utenteDAO.listaRicercheDisponibiliPerUtente(login, modulo, modalitaRicerca, protocollo, soggetto);
            for (RicercaUtente ricercaUtente : listaRicerche) {
                list.add(new RicercaUtenteBean(ricercaUtente));
            }
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public boolean isTimeoutEvent() {
        return this.timeoutEvent;
    }

    @Override
    public boolean esisteRicerca(String login, boolean escludiUtenteCorrente, String label, String modulo, String modalitaRicerca, String visibilita) {
        try {
            return this.utenteDAO.esisteRicerca(login, escludiUtenteCorrente, label, modulo, modalitaRicerca, visibilita);
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean esisteRicercaPubblicaAltroUtente(String login, String label, String modulo, String modalitaRicerca) {
        try {
            return this.utenteDAO.esisteRicercaPubblicaAltroUtente(login, label, modulo, modalitaRicerca);
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean esisteRicercaPrivataUtenteCorrente(String login, String label, String modulo, String modalitaRicerca) {
        try {
            return this.utenteDAO.esisteRicercaPrivataUtenteCorrente(login, label, modulo, modalitaRicerca);
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public String calcolaLabelRicerca(String login, String label, String modulo, String modalitaRicerca, String visibilita) {
        String newLabel = null;
        try {
            RicercaUtente r = null;
            int run = 0;
            do {
                newLabel = label + RicercheUtenteService.getSuffissoRicerca(run);
            } while ((r = visibilita.equals("privata") ? this.utenteDAO.leggiRicercaPrivata(login, newLabel, modulo, modalitaRicerca) : this.utenteDAO.leggiRicercaPubblica(newLabel, modulo, modalitaRicerca)) != null && ++run <= 50);
            if (run > 50) {
                return null;
            }
        }
        catch (DriverUsersDBException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (RicercaUtenteNotFoundException e) {
            return newLabel;
        }
        return newLabel;
    }

    private static String getSuffissoRicerca(int run) {
        if (run == 0) {
            return "";
        }
        return " (" + run + ")";
    }
}

